# Python imports
import threading

# Project imports
import task_defines
import cvmanager_task
import cvmanager_yaml


class Populate(threading.Thread):
    @property
    def manager(self):
        return self._manager

    @manager.setter
    def manager(self, value):
        self._manager = value

    def __init__(self, group=None, target=None, name=None,
                 args=(), kwargs=None, verbose=None):
        super(Populate, self).__init__()
        self.daemon = True

        # This manager is the main program upgrade manager.
        self._manager = kwargs['manager']

    def run(self):
        # This thread is responsible for finding the nodes and adding them as needed.  If a node goes down for reboot,
        # it's here that we monitor it, and add it back into the processing queue.
        try:
            self.manager.log.debug("Starting input processor thread.")

            if self.manager.args.task is not None:
                # Task is specified by name only; so built the yaml file with args for the processor thread.
                self.manager.log.debug("Task name was given on command line with -t/--task option.  Generating YAML.")
                yaml_template = cvmanager_yaml.get_template(self.manager.args.task,
                                                            **self.manager.args.command_line_kwargs)
                self.manager.args.yaml = yaml_template
                self.manager.log.debug("Successfully generated input yaml file [{0}].".format(yaml_template))

            tasks = cvmanager_yaml.load_yaml(self.manager.args.yaml, self.manager.args.command_line_kwargs)

            for item in tasks['tasks']:
                # Create a new instance of the TaskObject from the yaml input.
                new_task = cvmanager_task.TaskObject(item, self.manager)

                if (new_task is not None) and (
                        new_task.process.status_code in task_defines.StatusStates.READY.value):
                    self.manager.queue.put(new_task)

            # We've processed all user input tasks.  So we can stop processing yaml tasks.
            self.manager.quit_flag = True
            return
        except Exception, err:
            self.manager.log.exception(str(err))
