import os
import logging
import logging.config

# Project imports
import cvmanager_defines

# Dummy do nothing default.
d = logging.getLogger('foo')
d.addHandler(logging.NullHandler())
loggers = {
    'default': d
}


def get_log(name=cvmanager_defines.LOG_FILE_NAME):
    global loggers

    if loggers.get(name, False):
        # This logger has been setup by us.
        return loggers.get(name)
    else:
        # This logger has not been setup, so create default logger for it AND set it up.
        l = logging.getLogger(name.split('.')[0])
        l.addHandler(logging.NullHandler())
        loggers[name] = l

        return get_new_log(name)


def logging_configuration(log_file_name, specified_dir, verbose_mode):
    logging.addLevelName(cvmanager_defines.DEBUGV_LEVEL_NUM, "DEBUG")
    logging.addLevelName(logging.INFO, "INFO")
    logging.addLevelName(logging.WARNING, "WARNING")
    logging.addLevelName(logging.ERROR, "ERROR")

    def debugv(self, message, *args, **kws):
        # Use this for handling exceptions, in an exception log.debugv will log stack trace but print message to console
        if self.isEnabledFor(cvmanager_defines.DEBUGV_LEVEL_NUM):
            # Yes, logger takes its '*args' as 'args'.
            # Also include stack trace.
            self.critical(message)

            kws['exc_info'] = True
            self._log(cvmanager_defines.DEBUGV_LEVEL_NUM, message, args, **kws)
    logging.Logger.debugv = debugv

    if not(os.path.exists(specified_dir)):
        os.makedirs(specified_dir)

    log_file = os.path.join(specified_dir, log_file_name)

    if verbose_mode:
        l_format = 'debug'
    else:
        l_format = 'standard'

    log_conf = {
        'version': 1,
        'disable_existing_loggers': 0, # NEVER ROOM THIS, YOU WILL BREAK EVERYTHING!!!!!!!!!!
        'formatters': {
            'void': {
                'format': ''
            },
            'standard': {
                'format': cvmanager_defines.LOG_FORMAT
            },
            'debug': {
                'format': cvmanager_defines.DEBUG_LOG_FORMAT
            },
            'console': {
                'format': cvmanager_defines.CONSOLE_FORMAT
            },
        },
        'handlers': {
            'default': {
                'level': cvmanager_defines.LOG_FILE_LEVEL,
                'class': 'logging.handlers.RotatingFileHandler',
                'formatter': l_format,
                'filename': log_file,
                'maxBytes': 10485760,
                'backupCount': 5,
                'encoding': 'utf8'
            },
            'default_console': {
                'level': cvmanager_defines.CONSOLE_LOG_LEVEL,
                'class': 'logging.StreamHandler',
                'formatter': 'console',
                'stream': 'ext://sys.stdout'    # console
            },
        },
        'loggers': {
            log_file_name.split('.')[0]: {
                'handlers': ['default', 'default_console'],
                'level': cvmanager_defines.LOG_FILE_LEVEL
            },
        }
    }

    return log_conf


def get_new_log(log_file_name, log_location=cvmanager_defines.LOG_FILE_PATH, verbose=cvmanager_defines.LOG_VERBOSE):
    config = logging_configuration(log_file_name, log_location, verbose)
    logging.config.dictConfig(config)

    return get_log(log_file_name)

