import os
import sys
import cvmanager_utils


class DynamicDefines(object):
    @property
    def python_root_dir(self):
        return self.__PYTHON_ROOT_DIR

    @python_root_dir.setter
    def python_root_dir(self, value):
        self.__PYTHON_ROOT_DIR = value

    def __init__(self):
        self.__PYTHON_ROOT_DIR = r'/opt/commvault/MediaAgent'


DYNAMIC_DEFINE_NAME = 'DYNAMIC_DEFINES'
sys.modules[DYNAMIC_DEFINE_NAME] = DynamicDefines()

# Miscellaneous###############################################################
MAIN_PROGRAM_NAME = 'Commvault HyperScale Manager'
ROOT_FILE_LOC = os.path.dirname(os.path.realpath(sys.argv[0]))
QUEUE_SIZE = 21
WORKER_THREADS = 3  # These are for processing many tasks in parallel.
PROCESSOR_POLLING_TIME = 5
PID_FILE = os.path.join(ROOT_FILE_LOC, 'cvmanager_{0}.pid'.format(os.getpid()))
READABLE_TIME_FORMAT = '%Y-%m-%d %H:%M:%S'
DEFAULT_IMAGE_USER = r'root'
DEFAULT_IMAGE_PASSWORD = r'cvadmin'
DEFAULT_IMAGE_ADMIN_USER = r'admin'
MAX_REMOTE_NODE_SSH_CONNECTIONS = 10
NO_HASH_INPUT = 'no_hash'
DEFAULT_PERMISSIONS = 0o755  # Use this for calls like os.chmod(path, DEFAULT_PERMISSIONS)
DEFAULT_PERMISSION_STR = oct(DEFAULT_PERMISSIONS)   # String representation of 0o755 = '755'
DEFAULT_UMASK = int(str(777 - int(DEFAULT_PERMISSION_STR)).zfill(4), 8)  # Converts those permissions to a umask
##############################################################################


# Logging defines#############################################################
LOG_FILE_NAME = r'cvmanager.log'  # default name
LOG_FILE_PATH = os.path.join(ROOT_FILE_LOC, 'logs')     # Defaults current location without commvault instance.
#       FORMATS #
LOG_FORMAT = '%(process)d %(thread)d %(asctime)s %(levelname)-5s    %(message)s'
DEBUG_LOG_FORMAT = '%(process)d %(thread)d %(asctime)s %(module)s:%(funcName)s.%(lineno)d %(levelname)-5s  %(message)s'
# CONSOLE_FORMAT = '%(process)d %(asctime)s %(levelname)-5s  %(message)s'
CONSOLE_FORMAT = '%(levelname)-15s:\t%(message)s'
#       LEVELS #
LOG_FILE_LEVEL = 10  # logging.DEBUG
CONSOLE_LOG_LEVEL = 20  # logging.INFO; dont show debug messages on console.
DEBUGV_LEVEL_NUM = 10
#       DEFAULT MODE #
LOG_VERBOSE = False    #  True or False
##############################################################################


# NFS SHARE /REPO#############################################################
CV_MGR_ROOT = os.path.abspath(os.path.join(os.sep, 'ws', 'ddb', 'cvmanager'))
NFS_SHARE = os.path.abspath(os.path.join(CV_MGR_ROOT, 'share'))
DEFAULT_SW_CACHE = "/opt/commvault/SoftwareCache"
DEFAULT_TEMP_DIR = "/opt/commvault/MediaAgent/Temp"

TMP_REPONAME = "tmpcvrepo"
ACT_REPONAME = "cvrepo"

NFS_SHARE_TMP_REPO_DIR = os.path.join(NFS_SHARE, TMP_REPONAME)
NFS_SHARE_REPO_DIR = os.path.join(NFS_SHARE, ACT_REPONAME)

TMP_REPO_FILE = os.path.join(NFS_SHARE_TMP_REPO_DIR, TMP_REPONAME + '.repo')
ACT_REPO_FILE = os.path.join(NFS_SHARE_REPO_DIR, ACT_REPONAME + '.repo')

REPO_CLEANUP = [TMP_REPONAME + '.repo', ACT_REPONAME + '.repo']

CATALOG_DIR = os.path.join(CV_MGR_ROOT, 'catalog')
TASK_PID_DIR = os.path.join(CATALOG_DIR, 'active_tasks')
CVMANAGER_EXIT_CODE_STATUS = os.path.join(CATALOG_DIR, 'job_status.json')
##############################################################################


# Registry Paths For Upgrade - These are UNIX paths, no need to have OS specific paths
INSTANCE = 'Instance001'
CV_REG = "/etc/CommVaultRegistry/Galaxy/" + INSTANCE
REG_MA_KEY = CV_REG + "/MediaAgent/.properties"
REG_EVENT_KEY = CV_REG + "/EventManager/.properties"
REG_HS_KEY = CV_REG + "/HyperScale/.properties"
REG_REBOOT_VALUE = 'sHyperScaleManagerResumeAfterReboot'
REG_SHUTDOWN_NFS_VALUE = 'sStopNFSAfterUpgrade'
REG_ADD_NODES_READY = 'nAddNodesReady'
REG_V_DISK = 'sVDiskList'
REG_STORAGE_POOL_NAME = 'sHyperScaleStoragePoolName'
REG_HEDVIG_CID = 'sHedvigCID'
REG_HEDVIG_CLUSTER_VER = 'sHedvigClusterVers'
REG_EXIT_CODE_VALUE = 'nCVmanagerExitCode_{pid}_{{job_id}}'.format(pid=os.getpid())
##############################################################################


# TASKS#####################################################################
class TaskDirClass(object):
    # These are the directories Task() objects should all use.  No one should create/manipulate paths manually.
    @property
    def base(self):
        return self._base

    @base.setter
    def base(self, value):
        self._base = value

    @property
    def share(self):
        path = self._share.format(self.hostname)
        if not os.path.exists(path):
            os.makedirs(path)
        return path

    @share.setter
    def share(self, value):
        self._share = value

    @property
    def status(self):
        return self._status

    @status.setter
    def status(self, value):
        self._status = value

    @property
    def archive(self):
        return self._archive.format(self.hostname)

    @archive.setter
    def archive(self, value):
        self._archive = value

    @property
    def status_file(self):
        return self._sf

    @status_file.setter
    def status_file(self, value):
        self._sf = value

    @property
    def hostname(self):
        return self._hostname

    @hostname.setter
    def hostname(self, value):
        self._hostname = value

    def __init__(self):
        self.tmp = '/tmp'
        self.share_string = os.path.join(NFS_SHARE, '{0}')
        self._hostname = '{0}'
        self._status = ''
        self._archive = ''
        self._share = ''

        """All of these will require a hostname OR ip....will be figured out later.
        self.share: is the share location that local and remote nodes will access and use.  When running remote child
        tasks, they can read & write from TaskDir.share and the contolling node will also be able to access that.        
        """

        self.share = os.path.join(NFS_SHARE, self.hostname)
        self.status = os.path.join(CATALOG_DIR, 'status')
        self.archive = os.path.join(self.status, 'archive')

        self._base = 'Task_{0}'
        self._sf = '{0}.status'


TaskDir = TaskDirClass()

TASK_OUTPUT_FILE = os.path.join(ROOT_FILE_LOC, 'output')
TASK_PID_DELIM = '____'

TASK_PID_FILE = '{0}'+TASK_PID_DELIM+'{1}'+TASK_PID_DELIM+'{2}.pid'
TASK_REPO = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'tasks')
XML_REQUEST_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'xml_messages')
REMOTE_TASK_YAML = os.path.join(TASK_REPO, 'remote_task.yaml')
YAML_PREFIX = 'cvmanager_'
YAML_SUFFIX = '.yaml'
YAML_INPUT_FORMAT = '{0}*{1}'.format(YAML_PREFIX, YAML_SUFFIX)  # cvmanager_########.yaml.   This is a temp file.
##############################################################################

# Gluster info
VOLUME_FILE_PATH = r'/var/lib/glusterd/vols/{0}/trusted-{0}.tcp-fuse.vol'
KNOWN_TRANSLATORS = [
    "cluster/afr",
    "cluster/dht",
    "cluster/distribute",
    "cluster/replicate",
    "cluster/stripe",
    "debug/io-stats",
    "features/access-control",
    "features/locks",
    "features/marker",
    "features/uidmap",
    "performance/io-threads",
    "protocol/client",
    "protocol/server",
    "storage/posix",
]
TK_VOLUME = 'volume'
TK_TYPE = 'type'
TK_OPTION = 'option'
TK_SUBVOLUMES = 'subvolumes'
TK_END_VOL = 'end-volume'

# NFS DEFINES
EXPORTS_PATH = '/etc/exports'
EXPORTS_BACKUP = '/etc/exports.bak'

# Upgrade Defaults
UPGRADE_DEFAULTS = cvmanager_utils.factory('UPGRADE_DEFAULTS', ('is_rolling', 'resume_flag', 'get_status',
                                                                'manage_vms', 'nodes_outside_sp'))
UPGRADE_REPO_XML_PATH = os.path.join(NFS_SHARE)
UPGRADE_REPO_XML_FILE = 'upgrpms.xml'
UPGRADE_XML = os.path.join(UPGRADE_REPO_XML_PATH, UPGRADE_REPO_XML_FILE)
UPGRADE_REPO_XML_FOR_DOWNLOAD = "/ws/ddb/upgos/upgrpms.xml"

UPGRADE_REPO_NODE_RPM_LIST_FILE = 'rpmlist.txt'
UPGRADE_REPO_MASTER_RPM_LIST_FILE = 'master_rpm_list.txt'
UPGRADE_REPO_MASTER_RPM_LIST = os.path.join(UPGRADE_REPO_XML_PATH, UPGRADE_REPO_MASTER_RPM_LIST_FILE)

# Remote Task controls########################################################
RTC_REBOOT_AND_RESUME = '{0}.reboot_and_resume'
RTC_RESUME_TIMEOUT = 1200
CHILD_TASK_TIMEOUT_SECONDS = 1800
##############################################################################

# WORKFLOW####################################################################
WORKFLOW_DATA_INPUT_KEY = 'workflow_data'

# JOB OPERATIONS##############################################################
JOB_OP_TYPE_SUSPEND = 0
JOB_OP_TYPE_RESUME = 2

# HS 2.0
HV_CMD_PREFIX = 'hvcmd'
HV_CMD_SUFFIX = '.sh'
HV_LOG_SUFFIX = '.log'

