import cvupgrade_common
from task_manager import cvmanager_logging
import wrappers
import common
import getpass
import cvovirtsdk


class HSoVirt(object):
    @property
    def host(self):
        return self._ovirt_host

    @host.setter
    def host(self, value):
        if value is not None and value:
            self._ovirt_host = value
            common.setregistryentry(cvupgrade_common.maregistry, "sHyperScaleUpgradeHEName", value)

    @property
    def user(self):
        return self._ovirt_user

    @user.setter
    def user(self, value):
        self._ovirt_user = value

    @property
    def ename(self):
        return self._ovirt_pass

    @ename.setter
    def ename(self, value):
        if value is not None and value:
            self._ovirt_pass = value
            common.setregistryentry(cvupgrade_common.maregistry, "sHyperScaleUpgradeEname", value)

    def __init__(self):
        self._ovirt_host = None
        self._ovirt_user = "admin@internal"
        self._ovirt_pass = None
        self.log = cvmanager_logging.get_log()

        # Check to see if the registry already has the information; previous upgrades delete it.
        self.check_and_load_existing_info()

        if not self.is_initialized():
            self.get_ovirt_details()

    def is_initialized(self):
        if (self.host is not None) and (self.ename is not None):
            return True
        return False

    def get_node_for_he(self):
        nodes = cvcluster.get_remote_nodes()
        nodes.append(wrappers.get_hostname())
        for node in nodes:
            # Check if vm is running on node
            ret = cvovirtsdk.is_vm_on_host(ovirthost, user, passwd, "HostedEngine", node)
            if (ret == 0):
                return node

    def check_and_load_existing_info(self):
        self.host = common.getregistryentry(cvupgrade_common.maregistry, "sHyperScaleUpgradeHEName", False)
        self.ename = common.getregistryentry(cvupgrade_common.maregistry, "sHyperScaleUpgradeEname", False)

    def get_ovirt_details(self):
        self.host = cvupgrade_common.get_ovirt_hostname()
        if not self.host:
            # Check to see if it's already set in the registry, could be a resume op.
            self.host = raw_input("Please enter ovirt hostname: ")

        self.log.info("ovirt_host: " + self.host)
        self.log.info("ovirt_user: " + self.user)

        self.ename = cvupgrade_common.encp(getpass.getpass('\nEnter ovirt admin password:'))

        return True
