#!/bin/bash

CONTEXT="restore"

INSTANCE="Instance001"

. /common_funcs.sh
. /storage_enumeration_funcs.sh
. /storage_comparison_funcs.sh
Execute "mkdir -p $SYS_CONF"

initMpath

SaveDiskPartInfo $SRDIR

disks=`cat $SYS_CONF/disklist`
Log "Disks to validate:[$disks]"
for i in `echo $disks`
do
    ValidateDisks "$i"
    if [ $? -eq 1 ]
    then
        Log "Error in given disk[$i].Please check once!!validation fails!!"
    else
        Log "disk[$i] is validated"
    fi
done
SaveLVM
mkdir -p $SYS_CONF/mount_tree
SaveMountList

PrepareTree "/system_state/sysconf" "/tmp/sysconf"
ret=$?
if [ $ret -ne 0 ]; then
    Log "PrepareTree Failed!"
    exit 1
fi
. /common.sh #doing this here to avoid conflicts with common_funcs.sh - this is needed only for vm_percent
vm_percent 55
exit 0

