#!/bin/bash

###################### Linux 1-Touch recovery rev3 ##############################
# 
#
#
. /storage_comparison_funcs.sh


#Flow:
#   For all mountpoints marked to_restore, check if underlying disks exist.
#   Invoke IDM if needed
#   Return 0: success, 1: failure, 2: failure+need manuaal disk mapping


postCompare()
{
    #Now that all storage has been mapped, create internal mappings for partitions, LVM, etc.
    #'device' for each mountpoint selected for restore could be a DISK, PARTITION or LV
    #utilize recreation_info from each mount point subdirectory to identify this information
    #1. First dump all recreation info to a file (sort unique), and replace disk names with mapped disk name for each
    #2. For each listed disk, recreate partition table. for each listed VG/PV, recreate PV preserving uuid and recreate VG
    #3. Recreate filesystems and recreate new fstab
    #4. For all mountpoints that are exluded, set their names to skip FS restore

    Log "\npostCompare: Iterate over all selected mount_points and dump recreation info"
    dumpRecreationInfo $STORAGE_TREE/backup/mount_tree $STORAGE_TREE/recreate_info_all_premapping
    ret=$?
    if [ $ret -ne 0 ]; then
        Log "postCompare: Error: Failed to obtain sorted mount point recreation info file!"
        exit 1
    fi

    Log "\npostCompare: Debug: Stored mount point recreation info file to $STORAGE_TREE/recreate_info_all_premapping. Proceed with disk name rewrite"
    rewriteDiskNamesFromMap $STORAGE_TREE/recreate_info_all_premapping $STORAGE_TREE/recreate_info_all
    ret=$?
    if [ $ret -ne 0 ]; then
        Log "postCompare: Error: Failed to rewrite disk names from disk map in $STORAGE_TREE/recreate_info_all_premapping -> $STORAGE_TREE/recreate_info_all"
        exit 1
    fi
    Log "postCompare: Debug: rewrote all disk names from map and saved mount point recreation info to $STORAGE_TREE/recreate_info_all"
    cp $STORAGE_TREE/recreate_info_all $STORAGE_TREE/recreate_info_all_display
    sed -i 's/DISK##/Partition and Format <disk:partiton#> -/g' $STORAGE_TREE/recreate_info_all_display
    sed -i 's/LVM##/Re-create LVM -/g' $STORAGE_TREE/recreate_info_all_display

    Log "\npostCompare: Debug: Copy partition type/table from backed up disk to current disk for recreation"
    copyPartitions 
    ret=$?
    if [ $ret -ne 0 ]; then
        Log "postCompare: Error: Failed to copy partition type/table from backed up to current disks!"
        exit 1
    fi
    Log "postCompare: Debug: Copied all partition information from each backed up disk to current disk tree"

    Log "\npostCompare: Debug: Generate list of skipped mountpoints"
    genSkippedMountsList $SYS_CONF/mountpoints_to_exclude.lst
    ret=$?
    if [ $ret -ne 0 ]; then
        Log "postCompare: Errror: Failed to generate list of skipped mount points"
        exit 1
    fi
    Log "postCompare: Debug: Generated list of skipped mountpoints"

    exit 0
}

ARG=$1
if [ -n "$ARG" -a "$ARG" == "recheck" ]; then
    recheckManualMapping "postadm"
    ret=$?
    if [ $ret -ne 0 ]; then
        Log "\nError: Verification of manual disk mapping failed"
        exit 1
    else
        Log "\nDebug: Verification of manual disk mapping success"
        exit 0
    fi
fi

if [ ! -f /tmp/compare_invoked ]; then
    #First invokation. set to_restore for all mount points on backed up tree
    setToRestore "backup" "0"
    if [ $? -ne 0 ]; then
        Log "Error: Failed to set to_restore on all mountpoints within $STORAGE_TREE/backup"
    fi
    touch /tmp/compare_invoked
fi


#For some reason lvm commands like vgchange -ay hang if the right versions of libgcc/libstdc++ are missing
#we have these libraries in our Base directory and should copy them over if not found in the initrd
file="/etc/CommVaultRegistry/Galaxy/Instance001/Base/.properties"
basedir=`get_registry_value $file dBASEHOME`
if [ "a`uname -i`" == "ax86_64" ]; then
    if [ `ls /lib64/libgcc* | wc -l` -eq 0 -a ! -d /lib/x86_64-linux-gnu ]; then
        cp $basedir/libgcc* /lib64/
    elif [ -d /lib/x86_64-linux-gnu -a `ls /lib/x86_64-linux-gnu/libgcc* | wc -l` -eq 0 ]; then
        cp $basedir/libgcc* /lib/x86_64-linux-gnu/
    fi

    if [ `ls /lib64/libstdc++* | wc -l` -eq 0 -a ! -d /usr/lib/x86_64-linux-gnu ]; then
        cp $basedir/libstdc++* /lib64/
    elif [ -d /usr/lib/x86_64-linux-gnu -a `ls /usr/lib/x86_64-linux-gnu/libstdc++* | wc -l` -eq 0 ]; then
        cp $basedir/libstdc++* /usr/lib/x86_64-linux-gnu/
    fi
else
    if [ `ls /lib/libgcc* | wc -l` -eq 0 ]; then
        cp $basedir/libgcc* /lib/
    fi

    if [ `ls /lib/libstdc++* | wc -l` -eq 0 ]; then
        cp $basedir/libstdc++* /lib/
    fi
fi

#Alternate code flow for optimized disk storage for vME
if [ -e $YASTGUI/mtpt_main ]; then
    isopt=`cat $YASTGUI/mtpt_main | grep OPTIMIZE_STORAGE | cut -d'=' -f2`
    if [ "x$isopt" == "x1" ]; then
        Log "OPTIMIZE_STORAGE = 1, skip srdiskcompare, invoke prepsrmountcreate.sh"
        cd /
        ./prepsrmountcreate.sh
        if [ $? -ne 0 ]; then
            Log "1-Touch recovery failed because prepsrmountcreate returned error. OPTIMIZE_STORAGE is set, but could not prepare disks as required."
            exit 1
        else    
            RESTART_LEVEL=755
            vm_percent 60
            echo $RESTART_LEVEL>/tmp/restart_level
            Log "Succesfully completed prepsrmountcreate for automatic disk layout"
            c="s"  #scsi controller
            if [ -e "${YASTGUI}/VMeHyperVHookFile" ]; then
                c="h"  #ide controller
                if [ ! -e "/dev/hda" -a -e "/dev/sda" ]; then
                    c="s"
                fi
            fi
            echo "DISK## /dev/${c}da:1" > $STORAGE_TREE/recreate_info_all_display
            echo "LVM## VG=VolGroup00 PVs=/dev/${c}da:2" >> $STORAGE_TREE/recreate_info_all_display
            if [ -e "/dev/${c}db" ]; then
                echo "LVM## VG=VolGroup01 PVs=/dev/${c}db:1" >> $STORAGE_TREE/recreate_info_all_display
            fi
            exit 0
        fi
    else    
        Log "OPTIMIZE_STORAGE = [$isopt]. Resume with srcompare.sh"
    fi
fi

for disk in `cat $STORAGE_TREE/restore/disklist`
do
    DISKDIR=`DiskNodeForDiskName "restore" $disk`
    Log "Cleaning Disk[$disk]"
    Execute "rm -f $DISKDIR/resized"
    Execute "rm -f $DISKDIR/partinfo"
    Execute "rm -f $DISKDIR/used_size"
    Execute "rm -f $DISKDIR/last_part"
    Execute "rm -f $DISKDIR/ptype"
    Execute "rm -f $DISKDIR/has_extended"
    Execute "rm -rf $DISKDIR/[0-9]*"
done

Execute "rm -rf $STORAGE_TREE/AUTOSCALESTORAGE"
Execute "rm -rf $STORAGE_TREE/autoScale2/"

checkIdenticalStorage
ret=$?
if [ $ret == "2" ]; then
    Log "\nError: checkIdenticalStorage failed to execute."
    exit 1
elif [ $ret == "0" ]; then
    Log "\nDebug: checkIdenticalStorage identified IDENTICAL system"
    postCompare
elif [ $ret == "1" ]; then
    Log "\nDebug: checkIdenticalStorage could not identify this as an IDENTICAL system"
    autoMapStorage
    reta=$?
    if [ $reta == "0" ]; then
        Log "Debug: AutoMap of storage successful!"
        postCompare
    fi
    if [ $reta == "1" ]; then
        if [ -f /tmp/override/autoScale ]; then
            Log "AutoMap of storage failed, autoScale is enabled, trying disk mapping by autoScale1"

            if [ -f $SYS_CONF/autoScaleSupported ]; then
                autoScaleStorage1 
                reta=$?
        
                if [ "$reta" == "0" ]; then
                    Log "Debug: AutoScale of storage successful!"
                    postCompare
                fi

                if [ $reta == "1" ]; then
                    Log "autoScale1 is failed, trying restore by autoScale2"
                    autoScaleStorage2 
                    reta=$?
                fi
            
                if [ "$reta" == "0" ]; then
                    Log "Debug: AutoScale2 of storage successful!"
                    exit 0
                fi
            else
                Log "Debug: AutoScale is not supported since it is an older backup"
            fi
        fi
    fi
  
    if [ "$reta" == "1" ]; then
        Log "Error: Disk mapping of storage failed! set invoke_adm"
        touch $YASTGUI/invoke_adm
        setup_webadm
        exit 0
    else 
        Log "Error: DiskMapping returned error!"
        exit 1
    fi
else
    Log "\nError: checkIdenticalStorage returned unknown error code [$ret]"
    exit 1
fi    
vm_percent 60
return 0
