#!/bin/bash
. /common.sh
. /cmdline_netmap_redhat.sh
. /cmdline_netmap_suse.sh
. /cmdline_netmap_ubuntu.sh
update_field() {
    FILE="$1"
    PROP="$2"
    VAL="$3"
    TMPFILE=/tmp/tmpntwkfile
    rm -f $TMPFILE
    
    echo "update_field() Invoked with FILE[$1] PROP[$2] VAL[$3]" >> $LOG_FILE

    update_field_${distribution} $FILE "$PROP" "$VAL"
}
 
RESTART_LEVEL=0
if [ $RESTART_LEVEL -eq 0 ]
then
    #TBD:Currently we will just create ethX where X equals to number of interface user want.
    #first delete any ethX file present in /etc/network-scripts.

    get_distribution
    setup_${distribution}
    echo "distribution[$distribution], network config dir is $NETCFG" >> $LOG_FILE
    mkdir -p network_backup
    cp -ar $NETCFG/* /network_backup/*
    i=0
    count=`cat /tmp/yastgui/ifcount`
    if [ x"$count" == "x" ]
    then
        count=1
    fi
    TEMPFILE=/tmp/nettemp
    while [ "$i" -ne "$count" ]
    do
        if [ x"$distribution" == x"ubuntu" ]
        then
            FILE=$NETCFG/interfaces
        else
            FILE=$NETCFG/ifcfg-eth$i
        fi
        proto=dhcp
        hasvlan=""
        if=eth$i
        #Used by ubuntu
        master=eth$i
        if [ ! -f $FILE ]
        then
            touch $FILE
            create_template_${distribution}
        fi
        update_ntwkconfig_file_${distribution}
        i=$((i+1))
    done
fi
