#!/bin/bash

#   Assumptions:
#       This file contains OS specific functions. There *must* only be functions here, no code that will run if this file is sourced
#       This file *must* be sourced from a script that already sources common.sh

get_initrd_names_ubuntu()
{
    if [ -e /tmp/MOUNTDIR/boot/initramfs.img-${VERSION}.img ]; then
        orig_initrd="initramfs.img-${VERSION}"
        failsafe_initrd="initramfs.img-${VERSION}.1tch-Failsafe"
    else
        orig_initrd="initrd.img-${VERSION}"
        failsafe_initrd="initrd.img-${VERSION}.1tch-Failsafe"
    fi
}

recreate_initrd_ubuntu()
{
    echo "chroot /tmp/MOUNTDIR mkinitramfs -o /tmp/initrdnew" >> $LOG_FILE
    chroot /tmp/MOUNTDIR mkinitramfs -o /tmp/initrdnew 
    ret=$?
    if [ $ret -eq 0 ]; then
        cp -f /tmp/MOUNTDIR/tmp/initrdnew /tmp
        if [ -e /tmp/MOUNTDIR/boot/initramfs-${VERSION}.img ]; then
            cp -f /tmp/initrdnew /tmp/MOUNTDIR/boot/initramfs-${VERSION}.img
        else
            cp -f /tmp/initrdnew /tmp/MOUNTDIR/boot/initrd.img-${VERSION}
        fi                        
    else             
        Log "Failed to create initrd for the current system configuration" >> $LOG_FILE
        reset_last_error
        log_last_error "Failed to create initrd for the current system configuration"
        exit 1
    fi 
}

update_hostname_ubuntu()
{
    mv /tmp/MOUNTDIR/etc/HOSTNAME /tmp/MOUNTDIR/etc/HOSTNAME.1tch_save
    echo "$new_hname" > /tmp/MOUNTDIR/etc/HOSTNAME
}
