#!/bin/bash

#   Assumptions:
#       This file contains OS specific functions. There *must* only be functions here, no code that will run if this file is sourced
#       This file *must* be sourced from a script that already sources common.sh

get_initrd_names_suse()
{
    orig_initrd="initrd-${VERSION}"
    failsafe_initrd="initrd-${VERSION}.1tch-Failsafe"
}

recreate_initrd_suse()
{
    #Append all the modules loaded to /etc/sysconfig/kernel
    ROOT="/tmp/MOUNTDIR"
    cat $ROOT/etc/sysconfig/kernel | while read line
    do
        match=`echo $line | grep "^INITRD_MODULES="`
        if [ "x$match" == "x" ]; then
            echo "$line" >> /tmp/kernel
        else
            old_modules=`echo $line | cut -d'=' -f 2 | tr -d '"'`
            Log "old_modules:$old_modules" >> $LOG_FILE
            new_modules=`mod_list $SYS_CONFIG_DIR/initrd.list`
            Log "new_modules:$new_modules" >> $LOG_FILE
            echo 'INITRD_MODULES="'$new_modules $old_modules'"' >> /tmp/kernel 
        fi
    done
    cp -f $ROOT/etc/sysconfig/kernel $ROOT/etc/sysconfig/kernel.orig 
    cp -f $ROOT/tmp/kernel $ROOT/etc/sysconfig/kernel

    if [ ! -d $ROOT/var/tmp ]; then
        mkdir -p $ROOT/var/tmp
    else
        umount $ROOT/var/tmp
    fi                      
               
# removed old method.
#    #Create a 128 MB ram disk image and mount it under /var/tmp
#    if [ -e $ROOT/ramdisk.img ]; then
#        rm -f $ROOT/ramdisk.img                
#    fi
#
#    dd if=/dev/zero of=$ROOT/ramdisk.img bs=512 count=262144
#    mke2fs -F -q  $ROOT/ramdisk.img
#    chroot $ROOT mount -t ext2 ramdisk.img /var/tmp -o loop
#    echo "Mounted ramdisk.img to /var/tmp in /tmp/MOUNTDIR" >> $LOG_FILE
#    
#    #Create a phony update-bootloader file
#    echo "exit 0" > /sbin/update-bootloader

    #Create the initrd now
    features=""
    if [ -e /tmp/use_mpath_flag  ]; then
        features="multipath"
    fi
    lvc=`lvs --noheading 2>/dev/null | wc -l`
    if [ $lvc -gt 0 ]; then
        features="${features} lvm2"
    fi

    echo "Gathered features [$features] for SUSE mkinitrd" >> $LOG_FILE
  
    #Check the suse linux release
    is_suse11=`cat $ROOT/etc/*release | grep "SUSE Linux Enterprise Server 11"`
    if [ -n "$is_suse11" ]; then
        features="${features} block resume.userspace"
    fi
    if [ -n "${features}" ] ;then
        chroot $ROOT mkinitrd -f "${features}" -k vmlinuz-${VERSION} -i initrd-${VERSION} 2>> $LOG_FILE
    else
        chroot $ROOT mkinitrd -k vmlinuz-${VERSION} -i initrd-${VERSION} 2>> $LOG_FILE
    fi
    if [ $? -ne 0 ]; then
        Log "Failed to create initrd for the current system configuration[2]" >> $LOG_FILE
        reset_last_error
        log_last_error "Failed to create initrd for the current system configuration[2]"
        exit 1
    fi                
}

update_hostname_suse()
{
    mv /tmp/MOUNTDIR/etc/HOSTNAME /tmp/MOUNTDIR/etc/HOSTNAME.1tch_save
    echo "$new_hname" > /tmp/MOUNTDIR/etc/HOSTNAME
}
