#!/bin/bash

#   Assumptions:
#       This file contains OS specific functions. There *must* only be functions here, no code that will run if this file is sourced
#       This file *must* be sourced from a script that already sources common.sh

get_initrd_names_redhat()
{
    if [ -e /tmp/MOUNTDIR/boot/initramfs-${VERSION}.img ]; then
        orig_initrd="initramfs-${VERSION}.img"
        failsafe_initrd="initramfs-${VERSION}.img.1tch-Failsafe"
    else
        orig_initrd="initrd-${VERSION}.img"
        failsafe_initrd="initrd-${VERSION}.img.1tch-Failsafe"
    fi 
}

recreate_initrd_redhat()
{
    #mkinitrd /tmp/initrd --fstab=/tmp/MOUNTDIR/etc/fstab ${VERSION}
    rm -f /tmp/MOUNTDIR/tmp/initrdnew
    optarg=""
    if [ -e ${include_lvm_initrd}  ]; then
        #opts=`chroot /tmp/MOUNTDIR mkinitrd -h 2>&1`
        chroot /tmp/MOUNTDIR mkinitrd -h > /tmp/mkinitrd_opts 2>&1
        opts=`cat /tmp/mkinitrd_opts`
        if [ "x`echo $opts | grep lvm-probe`" != "x" ]; then
            optarg="--force-lvm-probe "
        else
            optarg="--with=lvm2"
        fi
        if [ "x`echo $opts | grep without-dmraid`" != "x" ]; then
            optarg="$optarg --without-dmraid "
        fi
    fi
    echo "chroot /tmp/MOUNTDIR mkinitrd $optarg /tmp/initrdnew --fstab=/etc/fstab ${VERSION}" >> $LOG_FILE
    chroot /tmp/MOUNTDIR mkinitrd $optarg /tmp/initrdnew --fstab=/etc/fstab ${VERSION}
    if [ $? -ne 0 ]; then
        Log "Command failed, try without optarg..." >> $LOG_FILE
        echo "chroot /tmp/MOUNTDIR mkinitrd /tmp/initrdnew --fstab=/etc/fstab ${VERSION}" >> $LOG_FILE
        chroot /tmp/MOUNTDIR mkinitrd  /tmp/initrdnew --fstab=/etc/fstab ${VERSION}
    fi
    if [ $? -eq 0 ]; then
        cp -f /tmp/MOUNTDIR/tmp/initrdnew /tmp
        if [ -e /tmp/MOUNTDIR/boot/initramfs-${VERSION}.img ]; then
            cp -f /tmp/initrdnew /tmp/MOUNTDIR/boot/initramfs-${VERSION}.img
        else
            cp -f /tmp/initrdnew /tmp/MOUNTDIR/boot/initrd-${VERSION}.img
        fi                        
    else             
        Log "Failed to create initrd for the current system configuration" >> $LOG_FILE
        reset_last_error
        log_last_error "Failed to create initrd for the current system configuration"
        exit 1
    fi 
}

update_hostname_redhat()
{
    mv /tmp/MOUNTDIR/etc/sysconfig/network /tmp/MOUNTDIR/etc/sysconfig/network.1tch_save
    cat /tmp/MOUNTDIR/etc/sysconfig/network.1tch_save | awk -F"=" '{ if ($1 == "HOSTNAME") { print "HOSTNAME='$new_hname'"; } else { print $0 } }' > /tmp/MOUNTDIR/etc/sysconfig/network

}
