#!/bin/bash
. common.sh

. postrestore_redhat.sh
. postrestore_suse.sh
. postrestore_ubuntu.sh

#For unified restore mode, these vars might still remain exported. qcommands will fail if these are, so unset in each script that invokes qcommands
unset CVFW_SA_CLIENT_PORT4
unset CVFW_SA_CLIENT_PORT6


distribution=""
get_distribution

mod_list()
{
     driver_list=$1
     cat $driver_list | while read module
     do
         echo $module | cut -d '.' -f 1
     done                      
}   

Fixethudev()
{
    udev_file=/tmp/udev_rules
    ver=$1
    if [ $ver -eq 1 ]; then 
         #This will fix the MAC address enetries in the udev rules for SUSE 10      
         echo "# This rules are autogenerated from /lib/udev/rename_netiface." > $udev_file
         echo "# But you can modify them, but make sure that you don't use an interface name" >> $udev_file
         echo "# twice. Also add such interface name rules only in this rules file. Otherwise" >> $udev_file
         echo "# rename_netiface will create wrong rules for new interfaces." >> $udev_file
         echo "# It is safe to delete a rule, as long as you did not disable automatic rule" >> $udev_file
         echo "# generation. Only if all interfaces get a rule the renaming will work" >> $udev_file
         echo "# flawlessly. See also /etc/udev/rules.d/31-net_create_names.rules." >> $udev_file
         echo "#" >> $udev_file
         echo "# Read /usr/share/doc/packages/sysconfig/README.Persistent_Interface_Names for" >> $udev_file
         echo "# further information." >> $udev_file
         echo "#" >> $udev_file
         echo "# Use only a-z, A-Z and 0-9 for interface names!" >> $udev_file
         echo "#" >> $udev_file

         ethlist=`ifconfig -a | grep HWaddr | awk '{print $1}'`
         for eth in $ethlist
         do
             str=`ifconfig -a | grep $eth`
             device=`echo $str | awk '{print $1}'`
             mac=`echo $str | awk '{print $5}'|  tr "[:upper:]" "[:lower:]"`
             origdev=`cat $YASTGUI/mac_map|grep "^$device "|head -n 1`
             if [ "x$origdev" != "x" ]
             then
                 echo "Rename name of [ $device ] with [ $origdev ] in $udev_file" >> $LOG_FILE
                 device=$origdev
             fi
             echo "SUBSYSTEM==\"net\", ACTION==\"add\", SYSFS{address}==\"$mac\", IMPORT=\"/lib/udev/rename_netiface %k $device\"" >> $udev_file
         done
    fi      
    if [ $ver -eq 2 ]; then
         #This will fix the MAC address enetries in the udev rules for SUSE 11  
         echo "# This file was automatically generated by the /lib/udev/write_net_rules" > $udev_file
         echo "# program run by the persistent-net-generator.rules rules file." >> $udev_file
         echo "#" >> $udev_file
         echo "# You can modify it,as long as you keep each rule on a single line." >> $udev_file
         echo "# PCI device 0x8086:0x100f (e1000)" >> $udev_file
         echo "# This file was automatically generated by the /lib/udev/write_net_rules" >> $udev_file
         echo "# program run by the persistent-net-generator.rules rules file." >> $udev_file
         echo "#" >> $udev_file
         echo "# You can modify it,as long as you keep each rule on a single line." >> $udev_file
         echo "# PCI device 0x8086:0x100f (e1000)" >> $udev_file
         ethlist=`ifconfig -a | grep HWaddr | awk '{print $1}'`
         for eth in $ethlist
         do
             str=`ifconfig -a | grep $eth`
             device=`echo $str | awk '{print $1}'`
             mac=`echo $str | awk '{print $5}'|  tr "[:upper:]" "[:lower:]"`
             origdev=`cat $YASTGUI/mac_map|grep "^$device "|head -n 1`
             if [ "x$origdev" != "x" ]
             then
                 echo "Rename name of [ $device ] with [ $origdev ] in $udev_file" >> $LOG_FILE
                 device=$origdev
             fi
             echo "SUBSYSTEM==\"net\", ACTION==\"add\", SYSFS{address}==\"$mac\", IMPORT=\"/lib/udev/rename_netiface %k $device\"" >> $udev_file
             echo "SUBSYSTEM==\"net\", ACTION==\"add\", DRIVERS==\"?*\", ATTR{address}==\"$mac\", ATTR{type}==\"1\", KERNEL==\"eth*\", NAME=\"$device\"" >> $udev_file
         done
    fi      

}

add_fs_to_grub_menu()
{
    FILESYSTEM=$1
    SOURCE=$2
    TARGET=$3
    if [ -e $TARGET ]; then
         rm -f $TARGET
    fi

    cat $SOURCE | while read line
    do
        str=`echo $line | grep "kernel"`
        if [ -z "$str" ]; then
             echo "$line" >> $TARGET
        else
             echo "$line rootfstype=$FILESYSTEM" >> $TARGET
        fi
    done
}

fix_grub_legacy()
{
     if [ -d /sys/firmware/efi/vars ]; then
         IGNORE_ERR=1
     else
         IGNORE_ERR=0
     fi
     #Correct menu.lst file if required...
     menufile="/tmp/MOUNTDIR/boot/grub/menu.lst"
     conffile="/tmp/MOUNTDIR/boot/grub/grub.conf"
     if [ $IGNORE_ERR -eq 1 ]; then
         efi_grub_loc=`cat /tmp/storage_tree/efi_grub_loc`
         menufile="/tmp/MOUNTDIR${efi_grub_loc}/grub.conf"
         conffile="/tmp/MOUNTDIR${efi_grub_loc}/grub.conf"
         if [ ! -e ${conffile} -a -e "/tmp/MOUNTDIR${efi_grub_loc}/grub.cfg" ]; then
             conffile="/tmp/MOUNTDIR${efi_grub_loc}/grub.cfg"
             menufile=${conffile}
         fi
     fi
     ret=`diff $menufile $conffile`
     if [ -e $menufile -a -e $conffile -a "x$ret" == "x" ]; then
        echo "$menufile and $conffile file both exist and are identical. skip correction" >> $LOG_FILE
     else
        if [ ! -e $conffile ]; then
            if [ "$distribution" == $REDHAT ]; then    
                echo "Unable to locate $conffile - Correct this manually!!!" >> $LOG_FILE
                if [ $IGNORE_ERR -eq 0 ]; then
                    reset_last_error
                    log_last_error "Unable to locate $conffile - Correct this manually"
                    exit 1
                else
                    echo "Ignoring this error, since this is a UEFI system" >> $LOG_FILE
                fi
            else
                if [ ! -e $menufile ]; then
                    echo "Both $conffile and $menufile do not exist! - Correct this manually!!!" >> $LOG_FILE
                    if [ $IGNORE_ERR -eq 0 ]; then
                        reset_last_error
                        log_last_error "Both $conffile and $menufile do not exist! - Correct this manually"
                        exit 1
                    else
                        echo "Ignoring this error, since this is a UEFI system" >> $LOG_FILE
                    fi
                else
                    echo "Copying $menufile -> $conffile" >> $LOG_FILE
                    cp $menufile $conffile
                fi
            fi
        fi
        if [ ! -e $menufile ]; then
            echo "Unable to locate $menufile - Will create a soft link to $conffile" >> $LOG_FILE
        else
            echo "$menufile and $conffile are not identical, delete $menufile and re-create softlink to $conffile" >> $LOG_FILE
            rm -f $menufile
     fi
        cd `dirname ${conffile}`
        unlink menu.lst
        rm -rf menu.lst
        ln -s ./grub.conf menu.lst
        cd -
     fi
     #Correct the GRUB entries inside GRUB menu.lst file
     root_bck_device=`cat $SYS_CONFIG_DIR/root_mnt`
     str=`SearchMountPoint /`
     if [ $? -ne 0 ]; then
          echo "Unable to search for / mount point in mount points list" >> $LOG_FILE
          if [ $IGNORE_ERR -eq 0 ]; then
              reset_last_error
              log_last_error "Unable to search for / mount point in mount points list"
              exit 1
          else
              echo "Ignoring this error, since this is a UEFI system" >> $LOG_FILE
          fi
     fi
     fstype=`echo $str | awk '{print $3}'`
     GRUB_DEVICE=`cat $grub_boot_device`
     GRUB_MNT=`cat $grub_boot_mnt_point`
     
     echo "Determined / mount point file system type as $fstype" >> $LOG_FILE
     echo "Determined ${GRUB_DEVICE} as the device in GRUB notation " >> $LOG_FILE
     echo "Determined ${GRUB_MNT} as the mount point containing GRUB " >> $LOG_FILE
     if [ ! -f /tmp/autolayout ]; then
         rm -rf $SYS_CONFIG_DIR/grub_cmdline_args
         #need to invoke moveLibs from storage_comparision_funcs, but that script is not sourced here, doing this manually for now
         echo "Move devmapper libraries from / to /libs" >> $LOG_FILE
         mkdir -p /libs
         mv /libdevmapper* /libs
         lv_list=""
         if [ -f "$SYS_STATE_LOC/SRV11used" ]; then
            for vg in `cat /tmp/storage_tree/recreate_info_all | grep "LVM##" | awk '{print $2}' | sed 's/VG=//g'`; 
            do 
                echo "Fetch LVs for VG $vg" >> $LOG_FILE 
                lv_list+=`lvdisplay $vg | grep "LV Path" | awk '{print $3}'`
                lv_list+=" "
            done
         else #for legacy code
             lv_list=`lvdisplay | grep "LV Path" | awk '{print $3}'`
         fi

         echo "Determined active LVs : [$lv_list]" >> $LOG_FILE

         for curlv in $lv_list;
         do
            #remove /dev from this LV name
            curlv_trim=`echo $curlv | sed 's/^\/dev\///g'`
            # Add only system related LVs to grub commandline
            lvname=$(echo "${curlv_trim}" | cut -f2 -d'/')
            if ! grep ${lvname} /tmp/storage_tree/non_sys_lvs 2>&1 > /dev/null; then
                echo "rd_LVM_LV=$curlv_trim" >> $SYS_CONFIG_DIR/grub_cmdline_args
                echo "Added rd_LVM_LV=$curlv_trim to $SYS_CONFIG_DIR/grub_cmdline_args" >> $LOG_FILE
            fi

         done
     else
         echo "Auto-disk layout detected, LVs already processed" >> $LOG_FILE
     fi
     if [ -f $SYS_CONFIG_DIR/grub_cmdline_args ]; then
        sed -i '{:q;N;s/\n/ /g;t q}' $SYS_CONFIG_DIR/grub_cmdline_args
        echo "Replaced newline with space in grub_cmdline_args : new file=[`cat $SYS_CONFIG_DIR/grub_cmdline_args`]" >> $LOG_FILE
     fi

     #Restartability requires this to be set
     get_initrd_names_${distribution}

     if [ ! -f /cloud_flag ]
     then
         cd ${BASEDIR}
         if [ ! -e ./onetouchutil ]; then
             cp /onetouchutil .
         fi
     fi
	 echo $VERSION > /tmp/version
     echo "./onetouchutil grub ${menufile} ${orig_initrd} ${failsafe_initrd} ${root_bck_device} rootfstype=${fstype} ${GRUB_DEVICE} ${GRUB_MNT}" >> $LOG_FILE
     ./onetouchutil "grub" "${menufile}" "${orig_initrd}" "${failsafe_initrd}" "${root_bck_device}" "rootfstype=${fstype}" "${GRUB_DEVICE}" "${GRUB_MNT}"
     if [ $? -ne 0 ]; then
          echo "960" > /tmp/restart_level
          echo "Unable to Modify GRUB config file" >> $LOG_FILE
          if [ $IGNORE_ERR -eq 0 ]; then
              reset_last_error
              log_last_error "Unable to modify GRUB config file"
              exit 1
          else
              echo "Ignoring this error, since this is a UEFI system" >> $LOG_FILE
          fi
     fi

    disklink=`readlink -f $GRUB_DEVICE`
    for i in `ls /dev/disk/by-uuid/`
    do
        if [ x`readlink -f /dev/disk/by-uuid/$i` == x$disklink ]
        then
            uuid=`basename $i`
            cat $menufile|sed "s%$GRUB_DEVICE%UUID=$uuid%g" > /tmp/g.conf
            cat /tmp/g.conf > $menufile
            break
        fi
    done


     cd -
}
fix_grub2()
{
    Log "fix_grub2 invoked" >> $LOG_FILE
    prepmount_cmd
    #if [ "$distribution" == "$REDHAT" ]; then
        local grub_orig grub_bkp grub_tmp prev lv_list new
        grub_orig="/tmp/MOUNTDIR/etc/default/grub"
        grub_bkp="/tmp/MOUNTDIR/etc/default/grub.bkp"
        grub_tmp="/tmp/MOUNTDIR/etc/default/grub.tmp"
        cp -f $grub_orig $grub_bkp
        cp -f $grub_orig $grub_tmp
        prev=`grep "^GRUB_CMDLINE_LINUX=" $grub_tmp | cut -d'"' -f2 | cut -d'"' -f1`

        lv_list=""
        if [ -f "$SYS_STATE_LOC/SRV11used" ]; then
            for vg in `cat /tmp/storage_tree/recreate_info_all | grep "LVM##" | awk '{print $2}' | sed 's/VG=//g'`; 
            do 
                echo "Fetch LVs for VG $vg" >> $LOG_FILE 
                lv_list+=`lvdisplay $vg | grep "LV Path" | awk '{print $3}'`
                lv_list+=" "
            done
        else #for legacy code
            lv_list=`lvdisplay | grep "LV Path" | awk '{print $3}'`
        fi

        echo "Determined active LVs : [$lv_list]" >> $LOG_FILE

        for curlv in $lv_list;
        do
            curlv_trim=`echo $curlv | sed 's/^\/dev\///g'`
            # Add only system related LVs to grub commandline
            lvname=$(echo "${curlv_trim}" | cut -f2 -d'/')
            if ! grep ${lvname} /tmp/storage_tree/non_sys_lvs 2>&1 > /dev/null; then
                echo "adding rd.lvm.lv=$curlv_trim to kernel cmd args" >> $LOG_FILE
                new="${new} rd.lvm.lv=${curlv_trim}"
            fi

        done
        for word in $prev;
        do
            echo $word | grep --quiet "rd.lvm.lv"
            if [ $? -ne 0 ]; then
                new="${new} ${word}"
            fi
        done
        sed -i "s;GRUB_CMDLINE_LINUX=.*;GRUB_CMDLINE_LINUX=\"$new\";" $grub_tmp
        mv -f $grub_tmp $grub_orig
    #fi
    grubbin=`chroot /tmp/MOUNTDIR which grub-mkconfig`
    if [ $? -ne 0 ]; then
        grubbin=`chroot /tmp/MOUNTDIR which grub2-mkconfig`
    fi
    if [ -x /tmp/MOUNTDIR/$grubbin ]; then
        bin=`echo $grubbin | awk -F"/" '{print $NF}'`
        if [ -d /tmp/MOUNTDIR/boot/grub2 ]; then
            Log "Executing: chroot /tmp/MOUNTDIR $bin -o /boot/grub2/grub.cfg" >> $LOG_FILE
            chroot /tmp/MOUNTDIR $bin -o /boot/grub2/grub.cfg
        elif [ -d /tmp/MOUNTDIR/boot/grub ]; then
            Log "Executing: chroot /tmp/MOUNTDIR $bin -o /boot/grub/grub.cfg" >> $LOG_FILE
            chroot /tmp/MOUNTDIR $bin -o /boot/grub/grub.cfg
        fi
    fi
    ret=$?
    if [ $ret -ne 0 ]; then
        Log "fix_grub2: grub-mkconfig returned error [$ret] !" >> $LOG_FILE
    else
        Log "fix_grub2: grub-mkconfig returned success" >> $LOG_FILE
    fi
    prepumount_cmd
}
                                       
if [ -e /tmp/restart_level ]; then
    RESTART_LEVEL=`cat /tmp/restart_level`
else
    RESTART_LEVEL=0
fi

cp /tmp/storage_tree/fstab $SYS_CONFIG_DIR
#create /tmp if it was not restored
ismounted=`mount -l | grep -w "/tmp/MOUNTDIR"`
if [ -n "$ismounted" ]; then
    if [ ! -d /tmp/MOUNTDIR/tmp ]; then
        mkdir /tmp/MOUNTDIR/tmp
        echo "Created /tmp/MOUNTDIR/tmp [$?]" >> $LOG_FILE
    else 
        echo "/tmp/MOUNTDIR/tmp already present" >> $LOG_FILE
    fi
    if [ ! -d /tmp/MOUNTDIR/var/tmp ]; then
        mkdir -p /tmp/MOUNTDIR/var/tmp
        echo "Created /tmp/MOUNTDIR/var/tmp [$?]" >> $LOG_FILE
    else
        echo "/tmp/MOUNTDIR/var/tmp already present" >> $LOG_FILE
    fi
else
    echo "/tmp/MOUNTDIR not mounted; this is an error!!" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 920 ]; then
     # We need to create the key to sync the registry of the restored system with that of the comm serve.
     cs_name=`cat /tmp/NETDETAILS | grep -w CSNAME | awk '{print $2}'`
     instance=`grep sCSHOSTNAME /tmp/MOUNTDIR/etc/CommVaultRegistry/ -rnw | grep $cs_name | awk -F "/" '{print $7}'`
     Log "For CS: [$cs_name] Instance==[$instance]" >> $LOG_FILE
     if [ ! -f /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties ]; then
     Log "invalid instance, fallback to Instance001" >> $LOG_FILE
         instance="Instance001"
     fi
     echo "sTouchRecoveryCompleted Y" >> /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties 
     RESTART_LEVEL=920
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Succesfully Created the key to sync registry contents" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 930 ]; then
     #Create the entry for proc file system on the restored system
     mkdir -p /tmp/MOUNTDIR/proc
     RESTART_LEVEL=930
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Created the /proc directory" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 940 ]; then
    #Sync the contents of the /etc/sysconfig/ to correspond to that of the new Adapters MAC address 
    eth_list=`ifconfig -a | grep "eth" | awk '{print $1}'`
    for eth in $eth_list; do
        #Sync the hwconf of the backed up system with that of the discovered hardware configuration.
        ETH_FOUND=0  
        cat /dev/null > /tmp/hwconf.$$ 
        cat /tmp/MOUNTDIR/etc/sysconfig/hwconf | while read line 
        do
            if [ $ETH_FOUND -eq 1 ]; then
                 hw_found=`echo $line | grep "network.hwaddr"`
                 if  [ x"$hw_found" != x ]; then
                       echo "network.hwaddr: $HWADDR" >> /tmp/hwconf.$$  
                 else 
                       echo "$line" >> /tmp/hwconf.$$ 
                 fi 
            else
                 found=`echo $line | grep "$eth"`
                 if [ x"$found" != x ]; then
                      ETH_FOUND=1
                 fi
                 echo "$line" >> /tmp/hwconf.$$
            fi
        done 
        cp -f /tmp/hwconf.$$ /tmp/MOUNTDIR/etc/sysconfig/hwconf  
    done
    RESTART_LEVEL=940
    echo $RESTART_LEVEL>/tmp/restart_level
    echo "RESTART_LEVEL:$RESTART_LEVEL Corrected the contents of /etc/sysconfig/network*" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 941 ]; then
     #Create swapfiles and add the entries to fstab
     if [ -e /python_dir/tmp/swapfile.lst ]; then
         cat /python_dir/tmp/swapfile.lst | while read line
         do
            swapfile_name=`echo $line | awk '{print $1}'`
            swapfiles_size=`echo $line | awk '{print $2}'` 
            if [ "$swapfile_name" = "" ]; then
                 continue
            fi
            
            if [ -e /tmp/MOUNTDIR/$swapfile_name ]; then
                 echo "$swapfile_name with size $swapfiles_size MB could not be created because such a file already exists" >> $LOG_FILE
                 continue
            fi

            #Note that a swap file must not contain any holes
            dd if=/dev/zero of=/tmp/MOUNTDIR/$swapfile_name bs=1M count=$swapfiles_size 2>>$LOG_FILE
            if [ $? -ne 0 ]; then
                 Log "$swapfile_name with size $swapfiles_size MB could not be created because dd could not create the file" >> $LOG_FILE
                 continue
            fi  
            
            mkswap /tmp/MOUNTDIR/$swapfile_name >> $LOG_FILE 
            echo "$swapfile_name    swap                    swap    defaults        0 0" >> $SYS_CONFIG_DIR/fstab
            Log "$swapfile_name with size $swapfiles_size MB created successfully" >> $LOG_FILE
         done
     fi
     RESTART_LEVEL=941
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Created swapfiles and changed /etc/fstab" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 950 ]; then
     #Correct the contents of /etc/fstab, so that the device will be mounted properly after restore.
     cp -f /tmp/MOUNTDIR/etc/fstab /tmp/MOUNTDIR/etc/fstab.onetouch.bck
     if [ -e $AUTOLAYOUTFILE -o -f "$SYS_STATE_LOC/SRV11used" ]; then
        cat /tmp/MOUNTDIR/etc/fstab | grep -w devpts > $SYS_CONFIG_DIR/fstab_fixed
        cat /tmp/MOUNTDIR/etc/fstab | grep -w sysfs >> $SYS_CONFIG_DIR/fstab_fixed
        cat /tmp/MOUNTDIR/etc/fstab | grep -w proc >> $SYS_CONFIG_DIR/fstab_fixed
        cat /tmp/MOUNTDIR/etc/fstab | grep -w shm >> $SYS_CONFIG_DIR/fstab_fixed
        if [ -e $SYS_STATE_LOC/skipped_mountpoint_list ]
        then
            while read mpentry
            do
                cat /tmp/MOUNTDIR/etc/fstab | grep -w $mpentry >> $SYS_CONFIG_DIR/fstab_fixed
            done < $SYS_STATE_LOC/skipped_mountpoint_list
        fi
        cat $SYS_CONFIG_DIR/fstab >> $SYS_CONFIG_DIR/fstab_fixed
        cp -f $SYS_CONFIG_DIR/fstab_fixed $SYS_CONFIG_DIR/fstab
     fi
     cp -f $SYS_CONFIG_DIR/fstab /tmp/MOUNTDIR/etc/fstab
     while read fsentry
     do
          echo ${fsentry} | grep -w none | grep -w bind 
          ret=$?
          if [ $ret -eq 0 ]; then
              #If its a bind mount, check if the original mount is marked as Skip for restore
              bindorg=`echo ${fsentry} | awk '{print $1}'`
              isFiltered=0
              while read filterentry
              do
                  echo ${bindorg} | grep -qw "^${filterentry}"
                  if [ $? -eq 0 ]; then
                      isFiltered=1
                      break
                  fi
              done < $SYS_CONFIG_DIR/mountpoints_to_exclude.lst
              if [ ${isFiltered} -eq 0 ]; then
                  echo ${fsentry} >> /tmp/MOUNTDIR/etc/fstab
              fi
          fi
     done < /tmp/MOUNTDIR/etc/fstab.onetouch.bck

     #Append entries for nfs,gpfs like filesystems to fstab
     ofslist="nfs gpfs"
     while read fsentry
     do
         for fstype in $ofslist
         do
             echo $fsentry | awk -v fs="$fstype" '{ if(fs==$3) print $0 }' >> /tmp/MOUNTDIR/etc/fstab
         done
     done < /tmp/MOUNTDIR/etc/fstab.onetouch.bck
     RESTART_LEVEL=950
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Corrected the contents of /etc/fstab" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 960 ]; then
     #Determine whether the initrd needs to be recreated. For this purpose create the list of drivers and dependent 
     #modules for each PCI mass storage device present on the current system.The for each driver in this file check whether
     #it existed within the driver list file in the system state.If any of the files are missing then the initrd needs to be
     #recreated.
     if [ -e /tmp/modprobe.conf ]; then
          rm -f /tmp/modprobe.conf
     fi

     cd ${BASEDIR}
     if [ ! -e ./load ]; then
         cp /load .
     fi
     ./load -pcimap ${MODULES_PATH}/modules.pcimap -log $LOG_FILE  -modlist $SYS_CONFIG_DIR/initrd.list -usbmap ${MODULES_PATH}/modules.usbmap -mode LOAD_NO_DRIVER
     if [ $? -ne 0 ]; then
          Log "Unable to enumerate the mass storage PCI device drivers" >> $LOG_FILE
          reset_last_error
          log_last_error "Unable to enumerate the mass storage PCI device drivers"
          exit 1
     fi
     cd -

     #force initrd recreation for RHEL7.x; optimise it later for only dis-similar systems
     if [ -e /etc/redhat-release ]; then
          cat /etc/redhat-release | grep "7."
          if [ $? -eq 0 ]; then
               Log "Detected Redhat OS with version 7 .. force initrd recreation" >> $LOG_FILE
               touch /tmp/force_initrd
          fi
     fi

     #for P2V, force initrd recreation
     if [ -f /tmp/recovery_jobid ]; then
          touch /tmp/force_initrd
     fi

     #create the file /etc/modprobe.conf from /tmp/modprobe.conf file that was created in srdriverenumerate
     cp -f /tmp/modprobe.conf /etc/modprobe.conf
 
     if [ -e /tmp/initrd ]; then
          rm -f /tmp/initrd
     fi

     #Make a copy of the /etc/modprobe.conf that has been restored through File system restore. That will be containing the
     #hardware details about the backed up machine which are stale. Replace that with the modprobe.conf  file that has been
     #generated as part of 1-Touch restore.
     cp -f /tmp/MOUNTDIR/etc/modprobe.conf /tmp/MOUNTDIR/etc/modprobe.conf.onetouch.bck
     cp -f /etc/modprobe.conf  /tmp/MOUNTDIR/etc/modprobe.conf       

     #Make sure any bonding related lines from modprobe.conf are captured
     cat /tmp/MOUNTDIR/etc/modprobe.conf.onetouch.bck | grep bond >> /tmp/MOUNTDIR/etc/modprobe.conf
     
     cat $SYS_CONFIG_DIR/initrd.list | while read line
     do 
         Log "Will check whether the driver $line was present in the initrd image of the backed up system" >> $LOG_FILE 
         #On SUSE 11 the driver pata_cpi.ko is having a very generic PCI signature  of 0xffff,0xffff,0xffff and 0xffff.
         #Hence we seem to be loading the driver on all SUSE11 boxes irrespective of whether it is required or not.
         #So we will try to unload the driver. if it unloads succesfully it means that no device is using the driver.
         #Then we can remove the driver from list of required MST drivers.
         if [ "x$line" == "xpata_acpi.ko" ]; then
              rmmod pata_acpi.ko
              if [ $? -eq 0 ]; then
                   continue
              fi
         fi
         pattern=`grep "^$line" $SYS_STATE_LOC/initrd.list` 
         if [ "x$pattern" == "x" ]; then
              Log "INITRD will have to be recreated as $line is not found in the backed up system initrd.list file" >> $LOG_FILE
              touch /tmp/initrd
              cp -f /tmp/modprobe.conf /tmp/MOUNTDIR/etc/
         fi
     done
     if [ ! -f $SYS_CONFIG_DIR/initrd.list ]; then
        Log "$SYS_CONFIG_DIR/initrd.list is not found.. force initrd recreation" >> $LOG_FILE
        touch /tmp/force_initrd
     elif [ "x`cat $SYS_CONFIG_DIR/initrd.list`" == "x" ]; then
        Log "$SYS_CONFIG_DIR/initrd.list is empty.. force initrd recreation" >> $LOG_FILE
        touch /tmp/force_initrd
     fi
     RESTART_LEVEL=960
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Determined whether initrd needs to be recreated or not" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 965 ]; then
     get_initrd_names_${distribution}

     cp -f  /tmp/MOUNTDIR/boot/${orig_initrd} /tmp/MOUNTDIR/boot/${failsafe_initrd}
     RESTART_LEVEL=965
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL set initrd names" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 970 ]; then
    #Recreate the initrd to contain the drivers for all the devices on the restored system.
    #The initrd recreation code will be different for SUSE and Redhat.
    if [[ -e /tmp/initrd ]] || [[ -e /tmp/adm_invoked ]] || [[ -e /tmp/force_initrd ]]; then
         echo "Will attempt to create the initrd for the current system configuration"       
         Log "Will attempt to create the initrd for the current system configuration" >> $LOG_FILE       
         rm -f /tmp/initrd

        prepmount_cmd

        recreate_initrd_${distribution}

        prepumount_cmd

        #recreate LILO since initrd has been updated
        grep -q "LILO" $SYS_STATE_LOC/BOOTLOADER
        isLILO=$?
        if [ $isLILO -eq 0 ]; then
            Log "invoke installbootloader.sh : to re-create LILO" >> $LOG_FILE
            /installbootloader.sh
            #ignore errors?
            if [ $? -ne 0 ]; then
                Log "installbootloader.sh failed during postrestore" >> $LOG_FILE
                exit 1
            else
                Log "installbootloader.sh success during postrestore" >> $LOG_FILE
            fi
        fi
    fi
    RESTART_LEVEL=970
    echo $RESTART_LEVEL>/tmp/restart_level
    Log "RESTART_LEVEL:$RESTART_LEVEL Succesfully created initrd" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 980 ]; then
     RESTART_LEVEL=980
     #Correct menu.lst file if required...
     if [ -f /tmp/no_grub ]; then
         echo "no_grub flagged. skip updating grub.conf!" >> $LOG_FILE
     else
         ver="1"
         get_grub_version
         if [ "$ver" == "1" ]; then
            fix_grub_legacy
         else
            fix_grub2
         fi

         # if we are migrating XEN guest VMs to non-xen hypervisors, we need to set this up to boot xen first and run this restored kernel as a module
         if [ "$ver" == "1" -a -f /tmp/migrate_xenguest ]; then
             uname -r | grep --quiet xen
             ret=$?
             if [ $ret -eq 0 ]; then
                 Log "Detected xen kernel, check to see if xen.gz* exists in restored /boot" >> $LOG_FILE
                 xenfound=`ls /tmp/MOUNTDIR/boot/xen.gz* 2>/dev/null | wc -l`
                 if [ $xenfound -eq 0 ]; then
                     Log "Could not find the xen.gz kernel, copy from DVD and update the config" >> $LOG_FILE
                     cp -f /cdrom/isolinux/xen /tmp/MOUNTDIR/boot/xen.gz
                 fi

                 rm -f /tmp/grub_xen.conf
                 while read line;
                 do
                     echo $line | grep --quiet "kernel "
                     ret1=$?
                     echo $line | grep --quiet "initrd "
                     ret2=$?
                     if [ $ret1 -eq 0 ]; then
                         echo "kernel /boot/xen.gz dom0_mem=3940M,max:3840M" >> /tmp/grub_xen.conf
                         echo $line | awk '{$1=""; print "module"$0}' >> /tmp/grub_xen.conf
                     elif [ $ret2 -eq 0 ]; then
                         echo $line | awk '{$1=""; print "module"$0}' >> /tmp/grub_xen.conf
                     else
                         echo $line >> /tmp/grub_xen.conf
                     fi
                 done < /tmp/MOUNTDIR/boot/grub/grub.conf
                 Log "Fixed xen config" >> $LOG_FILE
                 cat /tmp/grub_xen.conf >> $LOG_FILE

                 cp /tmp/MOUNTDIR/boot/grub/grub.conf /tmp/MOUNTDIR/boot/grub/grub.conf.onetouch.bck
                 cp /tmp/grub_xen.conf /tmp/MOUNTDIR/boot/grub/grub.conf
             fi
         fi
     fi
     #For Suse12, copy the content of /boot/grub2 mountpoint files on same disk having /boot/.
     #this may have already been fixed for some cases through installbootloader.sh, so check first
     if [ ! -f /tmp/boot_multimount_fixed ]; then
         fix_boot_multimount /tmp/MOUNTDIR/etc/fstab 0
         fix_boot_multimount /tmp/MOUNTDIR/etc/fstab 1
     fi

     Log "RESTART_LEVEL:$RESTART_LEVEL Corrected the entries of GRUB menu.lst file" >> $LOG_FILE
     echo $RESTART_LEVEL>/tmp/restart_level
fi

if [ $RESTART_LEVEL -lt 990 ]; then
    #Create all the mount point directories that were skipped/excluded.
    cat $SYS_CONFIG_DIR/mountpoints_to_exclude.lst | while read line
    do
       str=`echo $line | grep ^/`
       if [ "x$str" != "x" ]; then
            echo "Creating skipped mount point: $line"
            Log "Creating skipped mount point: $line" >> $LOG_FILE
            mkdir -p /tmp/MOUNTDIR/$line
       fi
    done
    RESTART_LEVEL=990
    echo $RESTART_LEVEL>/tmp/restart_level
    Log "RESTART_LEVEL:$RESTART_LEVEL Created the mount point entries that were skipped" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 1000 ]; then
    #Fix the udev ruls file for Network interfaces for SUSE10
    if [ -e /tmp/MOUNTDIR/etc/udev/rules.d/30-net_persistent_names.rules ] && [ -f /tmp/netmap_flag ]; then
         if [ -e /tmp/udev_rules ]; then
              rm -f /tmp/udev_rules
         fi
         Fixethudev 1
         if [ -e /tmp/udev_rules ]; then
              cp -f /tmp/MOUNTDIR/etc/udev/rules.d/30-net_persistent_names.rules /tmp/MOUNTDIR/etc/udev/rules.d/30-net_persistent_names.rules.onetouch.bck
              cp -f /tmp/udev_rules /tmp/MOUNTDIR/etc/udev/rules.d/30-net_persistent_names.rules
         fi
           
    fi
    RESTART_LEVEL=1000
    echo $RESTART_LEVEL>/tmp/restart_level
    Log "RESTART_LEVEL:$RESTART_LEVEL Corrected the udev rules for Network interface for SUSE10" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 1010 ]; then
    #Fix the udev ruls file for Network interfaces for SUSE11
    if [ -e /tmp/MOUNTDIR/etc/udev/rules.d/70-persistent-net.rules ] && [ -f /tmp/netmap_flag ]; then
         if [ -e /tmp/udev_rules ]; then
              rm -f /tmp/udev_rules
         fi
         Fixethudev 2
         if [ -e /tmp/udev_rules ]; then
              cp -f /tmp/MOUNTDIR/etc/udev/rules.d/70-persistent-net.rules /tmp/MOUNTDIR/etc/udev/rules.d/70-persistent-net.rules.onetouch.bck
              cp -f /tmp/udev_rules /tmp/MOUNTDIR/etc/udev/rules.d/70-persistent-net.rules
         fi
    fi
    RESTART_LEVEL=1010
    echo $RESTART_LEVEL>/tmp/restart_level
    Log "RESTART_LEVEL:$RESTART_LEVEL Corrected the udev rules for Network interface for SUSE11" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 1020 ]; then
     #Replace the hwconf file on the backed up system with the one that we generated
     if [ -e /tmp/MOUNTDIR/etc/sysconfig/hwconf ]; then
          cp -f /tmp/MOUNTDIR/etc/sysconfig/hwconf /tmp/MOUNTDIR/etc/sysconfig/hwconf.onetouch.bck
          cp -f /tmp/1tch.hwconf /tmp/MOUNTDIR/etc/sysconfig/hwconf  
     fi
     RESTART_LEVEL=1020
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Corrected the /etc/sysconfig/hwconf file" >> $LOG_FILE
fi

if [ $RESTART_LEVEL -lt 1030 ]; then
     # Fix for suse12,create a run directory if does not exist
     mkdir -p /tmp/MOUNTDIR/run
     # Fix selinux, apparmor
     selinux=`cat /tmp/MOUNTDIR/etc/selinux/config 2>/dev/null | grep -v "#" | grep -w SELINUX | awk -F "=" '{print $2}'`
     if [ "x$selinux" != "x" ]; then
         `echo $selinux | grep -i disabled 1>&2 > /dev/null`
         if [ ! $? -eq 0 ]; then
            Log "SELinux was configured on the machine. Force relabeling on next reboot" >> $LOG_FILE
            touch /tmp/MOUNTDIR/.autorelabel
         else   
            Log "SELinux was configured, but disabled on the machine" >> $LOG_FILE
         fi   
     else    
         Log "SELinux was not configured on the machine" >> $LOG_FILE
     fi
     if [ -e $SYS_STATE_LOC/selinuxfsmountpt ]; then
         sedir=`cat $SYS_STATE_LOC/selinuxfsmountpt`
         if [ -n "$sedir" ]; then
             mkdir -p "/tmp/MOUNTDIR/$sedir"
             Log "SELinuxfs mount directory recreated $sedir" >> $LOG_FILE
         else
             mkdir -p /tmp/MOUNTDIR/selinux
         fi
     else
         mkdir -p /tmp/MOUNTDIR/selinux
     fi
     RESTART_LEVEL=1030
     echo $RESTART_LEVEL>/tmp/restart_level
fi

if [ $RESTART_LEVEL -lt 1035 ]
then
    Log "Copy override key file in /root"
    while read line
    do
        isFile=`echo $line|awk '{print $2}'`
        if [ "x$isFile" != "xf" ]
        then
            continue
        fi
        dev=`echo $line|awk '{print $1}'`
        dev=`basename $dev`
        if  [ -f $SYS_STATE_LOC/crypt_metadata/$dev/keycontent ]
        then
            file=`echo $SYS_STATE_LOC/crypt_metadata/$dev/keyfile`
            cp $SYS_STATE_LOC/crypt_metadata/$dev/keycontent /tmp/MOUNTDIR/$file
            cp /tmp/MOUNTDIR/etc/cryytab /tmp/MOUNTDIR/etc/cryttab.1tchback
            grep -v "^[/dev/mapper/]?$dev" /tmp/MOUNTDIR/etc/cryttab > /tmp/cryttab.tmp
            mv /tmp/cryttab.tmp /tmp/MOUNTDIR/etc/cryttab
            rdisk=`$SYS_STATE_LOC/crypt_metadata/$dev/restoreDisk`
            echo "$dev $rdisk $file luks" >> /tmp/MOUNTDIR/etc/cryttab
        else
            Log "Did not find $SYS_STATE_LOC/crypt_metadata/$dev ! please check backup!"
            exit 1
        fi
    done < /tmp/override/cryptFile.key
    Log "Set mdadm.conf file if mdadm device is present!"
    if [ -f /tmp/md_found ]
    then
        mdadm --detail --scan > /tmp/MOUNTDIR/etc/mdadm.conf
    fi
    RESTART_LEVEL=1035
    echo $RESTART_LEVEL > /tmp/restart_level
fi

if [ -f /cloud_flag ]
then
    Log "VMe Cloud P2V Setting found!!Exiting postrestore.sh"
    exit 0
fi

if [ $RESTART_LEVEL -lt 1036 ]; then

    if [ -f /etc/multipath/bindings ]; then
        Log "Found /etc/multipath/bindings - update on restored machine" >> $LOG_FILE
        if [ -f /tmp/MOUNTDIR/etc/multipath/bindings -o -d /tmp/MOUNTDIR/etc/multipath ]; then
            Log "Found /etc/multipath/bindings - update /etc/multipath/bindings on restored machine" >> $LOG_FILE
            \cp -f /etc/multipath/bindings /tmp/MOUNTDIR/etc/multipath/bindings
        elif [ -f /tmp/MOUNTDIR/var/lib/multipath/bindings -o -d /tmp/MOUNTDIR/var/lib/multipath ]; then
            Log "Found /etc/multipath/bindings - update /var/lib/multipath/bindings on restored machine" >> $LOG_FILE
            \cp -f /etc/multipath/bindings /tmp/MOUNTDIR/var/lib/multipath/bindings 
        fi
    else
        Log "No /etc/multipath/bindings - skip update" >> $LOG_FILE
    fi
    RESTART_LEVEL=1036
    echo $RESTART_LEVEL > /tmp/restart_level
fi

if [ $RESTART_LEVEL -lt 1040 ]; then
    # determine if client needs to be cloned, and clone if required.
    new_client=`cat /tmp/NETDETAILS | grep -w NEWCLIENTNAME | awk '{print $2}'` 
    new_hname=`cat /tmp/NETDETAILS | grep -w NEWCLIENTHOSTNAME | awk '{print $2}'`      
    org_client=`cat /tmp/NETDETAILS | grep -w CLIENTNAME | awk '{print $2}'` 
    org_hname=`cat /tmp/NETDETAILS | grep -w CLIENTHOSTNAME | awk '{print $2}'`      
    cs_name=`cat /tmp/NETDETAILS | grep -w CSDISPLAYNAME | awk '{print $2}'`
    cs_hname=`cat /tmp/NETDETAILS | grep -w CSNAME | awk '{print $2}'`

    #There could be multiple instances and as seen in '180301-50 CVLT::0154063109' innstances pointing to the same CS. 
    #The only differentiating factor was one of the 2 instances had CS disabled. 
    for instdir in `ls -d /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/Inst*`; 
    do
        instance=`grep sCSCLIENTNAME $instdir -rnw | grep $cs_name | awk -F "/" '{print $7}'` 
        if [ -z "$instance" ]; then
            echo "Skipping instance [$instance] as it points to a different CS" >> $LOG_FILE
            continue #instance points to a different CS
        fi
        cshostentry=`grep sCSHOSTNAME $instdir -rnw | grep "_Disabled"`
        if [ -n "$cshostentry" ]; then #CS is disabled. look for another instance
            echo "Skipping instance [$instance] as it seems disabled!" >> $LOG_FILE
            instance=""
            continue
        else
            break
        fi
    done
    if [ -z "$instance" ]; then
        echo "Failed to find a suitable instance on restored client!" >> $LOG_FILE
        exit 1
    else
        echo "Detected instance [$instance] on restored machine" >> $LOG_FILE
    fi

    #instance=`grep sCSCLIENTNAME /tmp/MOUNTDIR/etc/CommVaultRegistry/ -rnw | grep $cs_name | awk -F "/" '{print $7}'`
    Log "For CS: [$cs_name] Instance==[$instance]" >> $LOG_FILE
    if [ ! -f /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties ]; then
        Log "invalid instance, fallback to Instance001" >> $LOG_FILE
        instance="Instance001"
    fi
    basedir=`cat /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties | grep dBASEHOME | awk '{print $2}'`
    galaxyhome=`cat /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties | grep dGALAXYHOME | awk '{print $2}'`
    xmlfile="/tmp/MOUNTDIR/$galaxyhome/Base/PreImageModeFile.xml"
    localbdir="${GALAXY}/Base"
    if [ ! -e $xmlfile ]; then
        # If the PreImageModeFile is not present, we should pick it from from what we generated in system state. From v11 SP9, unix installer deletes the file after client has been registered
        cp $SYS_STATE_LOC/PreImageModeFile.xml $xmlfile
        if [ -e $xmlfile ]; then
            echo "Found PreImageModeFile in system state" >> $LOG_FILE
        else
            echo "Did not find PreImageModeFile in system state" >> $LOG_FILE

            # For older backups if generation of PreImageModeFile fails, let us see if an older name style file exists and use it
            if [ -e "/tmp/MOUNTDIR/$galaxyhome/ic.xml" ]; then
                cp /tmp/MOUNTDIR/$galaxyhome/ic.xml /tmp/MOUNTDIR/$galaxyhome/Base/PreImageModeFile.xml
            fi
        fi
    fi

    if [ -z "$new_hname" ]; then
        echo "NEWCLIENTHOSTNAME is not set. Find out a IP used during silent install" >> $LOG_FILE
        new_hname=`cat /tmp/NETDETAILS | grep -w IPFORINSTALL | awk '{print $2}'` 
        echo "Use hostname [$new_hname]" >> $LOG_FILE
    else
        echo "Use hostname [$new_hname]" >> $LOG_FILE
    fi

    echo "Extracted: basedir=[$basedir] galaxyhome=[$galaxyhome] xmlfile=[$xmlfile]" >> $LOG_FILE
    echo "Copy reg instance from /tmp/MOUNTDIR to current registry if its differnt" >> $LOG_FILE
    if [ "x$instance" != "xInstance001" ]; then
        #echo "cmd: cp -a /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance /etc/CommVaultRegistry/Galaxy" >> $LOG_FILE
        #cp -a /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance /etc/CommVaultRegistry/Galaxy
        echo "Update Instance# in xml file for registration purpose.." >>$LOG_FILE
        sed -i "s/$instance/Instance001/" /tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
    fi

    rm -rf /tmp/sessionkey_clone
    while read line
    do
        key=`echo $line | awk '{print $1}'`
        val=`echo $line | awk '{print $2}'`
        if [ "x$key" == "xsPreImageFile" ]; then
            echo "Found and replaced sPreImageFile with [$basedir/PreImageModeFile.xml] in local registry before calling SIMCallWrapper" >> $LOG_FILE
            echo "sPreImageFile $basedir/PreImageModeFile.xml" >> /tmp/sessionkey_clone
        else
            echo $line >> /tmp/sessionkey_clone
        fi
    done < /etc/CommVaultRegistry/Galaxy/Instance001/Session/.properties
    cp -f /tmp/sessionkey_clone /etc/CommVaultRegistry/Galaxy/Instance001/Session/.properties

    CSUSER=`cat /tmp/NETDETAILS | grep "CSUSER" | awk '{print $2}'`
    CSPASS=`cat /tmp/NETDETAILS | grep "CSPASSWD" | awk '{print $2}'`
    ENCPASSWD=`cat /tmp/NETDETAILS | grep "ENCPASSWD" | awk '{print $2}'`
    PASS=""
    if [ "x$ENCPASSWD" != "x" ]; then
        PASS=$ENCPASSWD
    elif [ "x$CSPASS" != "x" ]; then
        cd $BASEDIR
        if [ ! -e ./onetouchutil ]; then
            cp /onetouchutil .
        fi
        PASS=`./onetouchutil encrypt "$CSPASS"`
        if [ $? -ne 0 ]; then
            echo "Failed to encrypt password field CSPASSWD from /tmp/NETDETAILS"
            exit 1
        fi
        cd -
    fi    
    if [ "x$PASS" != "x" ]; then
        ARG=" -password $PASS -passwordEncrypted"
    else    
        ARG=""
    fi    
    if [ -f /tmp/yastgui/clientgroup ] && [ "x`cat /tmp/yastgui/clientgroup`" != "x" ] 
    then
        ARG="$ARG -ClientGroup `cat /tmp/yastgui/clientgroup`"
    fi
    fwfile="/tmp/yastgui/firewall-configblob"
    FWON=`get_field_value $CSDETAILS "FWON"`

    if [ -e /tmp/yastgui/cloneclient ]; then
        echo "/tmp/yastgui/cloneclient IS present. Proceed with clone operation..." >> $LOG_FILE
        echo "Clone : new client name [$new_client] new hostname [$new_hname]" >> $LOG_FILE
        #find install dir
        if [ ! -e $xmlfile ]; then
            echo "Package xml file not found! Cannot proceed with cloning...!!!" >> $LOG_FILE
        else
            gstr=""
            for i in `cat $xmlfile`
            do
                echo $i|grep "^GUID="
                if [ $? -eq 0 ]
                then
                    echo "found $i" >> $LOG_FILE
                    gstr=$i
                fi
            done
            if [ "x$gstr" == "x" ]
            then
                echo "Error: Not able to find GUID.Failing.Pass [$xmlfile] file also with logs to support" > $LOG_FILE
                exit 1
            fi
            sed -i "s/$gstr/GUID=\"\"/g" $xmlfile
            mv /tmp/MOUNTDIR/$basedir/certificates /tmp/MOUNTDIR/$basedir/certificates.orig
            cp -a $localbdir/certificates /tmp/MOUNTDIR/$basedir
            echo "sPreImageFile $basedir/PreImageModeFile.xml" >> /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Session/.properties
            echo "CMD: $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $new_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath /tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF" >> $LOG_FILE 
            $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $new_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath /tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF
            if [ $? -ne 0 ]; then
                reset_last_error
                log_last_error "SIMCallWrapper failed! Could not clone client!"
                echo "SIMCallWrapper failed! Could not clone client!!!" >> $LOG_FILE
                sed -i "s/Instance001/$instance/" /tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
                exit 1
            else
                echo "SIMCallWrapper succeess! Cloned client..." >> $LOG_FILE
                sed -i "s/Instance001/$instance/" /tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
                #Do not delete certificates. they will not be re-generated due to some new code logic
                newPassword=`cat /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Session/.properties | grep -w pCntInfo | awk '{print $2}'`
                rm -f /tmp/sessionkey_clone2
                while read line
                do
                    key=`echo $line | awk '{print $1}'`
                    val=`echo $line | awk '{print $2}'`
                    if [ "x$key" == "xpCntInfo" ]; then
                        echo "Found pCntInfo in current registry[$val] replace with [$newPassword]" >> $LOG_FILE
                        echo "pCntInfo $newPassword" >> /tmp/sessionkey_clone2
                    else
                        echo $line >> /tmp/sessionkey_clone2
                    fi
                done < /etc/CommVaultRegistry/Galaxy/Instance001/Session/.properties
                cp -f /tmp/sessionkey_clone2 /etc/CommVaultRegistry/Galaxy/Instance001/Session/.properties
                mv /tmp/MOUNTDIR/$basedir/certificates /tmp/MOUNTDIR/$basedir/certificates.beforeClone
                cp -a $localbdir/certificates /tmp/MOUNTDIR/$basedir
                if [ -e $fwfile ]
                then
                    mv /tmp/MOUNTDIR/$basedir/FwConfig.txt /tmp/MOUNTDIR/$basedir/orig_FwConfig.txt
                    cp $fwfile /tmp/MOUNTDIR/$basedir/FwConfig.txt
                fi
                sed -i "s/${org_client}_recovery/$new_client/g" /tmp/MOUNTDIR/$basedir/FwConfig.txt
                sed -i "s/${org_client}_recovery/$new_client/g" /tmp/MOUNTDIR/$basedir/FwConfigLocal.txt
                sed -i "s/${org_client}_recovery/$new_client/g" /tmp/MOUNTDIR/$basedir/FwConfigInstall.txt
                    Log "FwConfig file is updated!"
            fi
        fi
        umount /tmp/MOUNTDIR/sys 2>/dev/null
        umount /tmp/MOUNTDIR/proc 2>/dev/null

        #Update hostname
        update_hostname_${distribution}
    else
        echo "" >> $LOG_FILE
        echo "/tmp/yastgui/cloneclient NOT present. No clone operation performed!" >> $LOG_FILE
        echo "Need to register original client again, after revoking original client's certificates" >> $LOG_FILE
        echo "Register : client name [$org_client] hostname [$new_hname]" >> $LOG_FILE
        if [ ! -e $xmlfile ]; then
            echo "Package xml file not found! Cannot proceed with registration of original client...!!!" >> $LOG_FILE
        else
            #revoke
            cp /cdrom/revoke.xml /
            sed -i "s/<clientName>/<clientName>$org_client/" /revoke.xml 
            echo "revoke.xml modified to.." >> $LOG_FILE
            cat /revoke.xml >> $LOG_FILE
            echo "---" >> $LOG_FILE
            $localbdir/qoperation execute -af /revoke.xml
            if [ $? -ne 0 ]; then
                echo "Error! Failed to revoke certificate for [$org_client]" >> $LOG_FILE
                reset_last_error
                log_last_error "Failed to revoke certificate for $org_client"
                exit 1
            else    
                echo "Revoked certificates for [$org_client]" >> $LOG_FILE
            fi
            if [ -e $fwfile -o "$FWON" == "true" ]; then
                echo "Since F/W is enabled, we'll stop services to allow tunnel to go down properly before new registration, and wait 60 seconds" >> $LOG_FILE
                simpana stop
                sleep 60
            fi
            echo "CMD: $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $org_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath /tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF" >> $LOG_FILE 
            $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $org_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath /tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF
            ret=$?
            if [ $ret -ne 0 ] ; then
                if [ -e $fwfile -o "$FWON" == "true" ]; then
                    echo "registration failed, attempt again after starting services" >> $LOG_FILE
                    simpana start
                    sleep 10
                    $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $org_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath /tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF
                    ret=$?
                fi
            fi
            if [ $? -ne 0 ]; then
                reset_last_error
                log_last_error "SIMCallWrapper failed! Could not re-register client!"
                echo "SIMCallWrapper failed! Could not re-register client!!!" >> $LOG_FILE
                sed -i "s/Instance001/$instance/" /tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
                exit 1
            else
                echo "SIMCallWrapper succeess! re-registered client..." >> $LOG_FILE
                sed -i "s/Instance001/$instance/" /tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
            fi
        fi
    fi
     cp -a $localbdir/certificates* /tmp

     # complete recovery job
     vm_percent 100

     RESTART_LEVEL=1040
     echo $RESTART_LEVEL>/tmp/restart_level
fi

if [ $RESTART_LEVEL -lt 1050 ]; then
     Log "Restarting services after SIMCallWrapper - will wait 60 seconds after this..." >> $LOG_FILE
     simpana restart
     sleep 60
     org_client=`cat /tmp/NETDETAILS | grep -w CLIENTNAME | awk '{print $2}'`      
     new_client="${org_client}_recovery"
	 Log "org_client[$org_client] new_client[$new_client]. Deleteing new_client" >> $LOG_FILE
	 file="/etc/CommVaultRegistry/Galaxy/Instance001/Base/.properties"
	 GALAXY=`get_registry_value $file "dGALAXYHOME"`

	 #services have been started by SIMCallWrapper just now
	 fwfile="/tmp/yastgui/firewall-configblob"
	 FWON=`get_field_value $CSDETAILS "FWON"`
	 retryCt=1
	 if [ -e "$fwfile" -o "$FWON" == "true" ]; then
		 retryCt=3
		 Log "firewall setup detected. Set qdelete retry Ct to $retryCt"  >> $LOG_FILE
	 fi
	 qdeleteSuccess=0
	 while [ $retryCt -ge 0 ];
	 do
		 echo "${GALAXY}/Base/qdelete client -c $new_client -y" >> $LOG_FILE
		 ${GALAXY}/Base/qdelete client -c $new_client -y
		 if [ $? -eq 0 ]; then
			 qdeleteSuccess=1
			 break
		 else
			 retryCt=$((retryCt-1))
			 Log "qdelete failed. retryCt = [$retryCt]" >> $LOG_FILE
			 sleep 60
		 fi
	 done
	 if [ $qdeleteSuccess -eq 1 ]; then
		 echo "Recovery client deleted successfully." >> $LOG_FILE
	 else
		 echo "Recovery client could *not* be deleted!" >> $LOG_FILE
	 fi
     RESTART_LEVEL=1050
     echo $RESTART_LEVEL>/tmp/restart_level
fi

if [ $RESTART_LEVEL -lt 1060 ]; then
     #Copy all the log files that were generated during 1Touch restore to the backed up system.
     file="/etc/CommVaultRegistry/Galaxy/Instance001/EventManager/.properties"
     ldir=`get_registry_value $file "dEVLOGDIR"`

     mkdir -p /tmp/MOUNTDIR/tmp/1tchrestore_logs
     rm -rf /tmp/MOUNTDIR/tmp/1tchrestore_logs/*
     cd /tmp/MOUNTDIR/tmp/1tchrestore_logs
     tar  --exclude "/tmp/MOUNTDIR" --exclude "/tmp/yastgui/nfsmount" -zcvf tmp.tgz /tmp
     tar -zcvf system_state.tgz /system_state 
     tar -zcvf registry.tgz /etc/CommVaultRegistry
     tar -zcvf python_dir.tgz /python_dir
     tar -zcvf simpanalogs.tgz $ldir
     tar -zcvf var.tgz /var/log/messages /var/log/YaST2 /chroot/var/log
     tar -zcvf jobResults.tgz $GALAXY/iDataAgent/jobResults/CV_JobResults 
     cd -
     file="/etc/CommVaultRegistry/Galaxy/Instance001/EventManager/.properties"
     LOGDIR=`get_registry_value $file "dEVLOGDIR"`
     nLOGDIR="/tmp/MOUNTDIR/$LOGDIR"
     if [ -d $LOGDIR ]; then
        tLOGDIR="$nLOGDIR/`date +%d%m%y%H%M`"
        mkdir -p $tLOGDIR
        cp -a /tmp/MOUNTDIR/tmp/1tchrestore_logs $tLOGDIR
     fi

     RESTART_LEVEL=1060
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Copied all the logs file corresponding to restore" >> $LOG_FILE
fi


if [ $RESTART_LEVEL -lt 1070 ]; then
     UnmountRestoredDevs
     RESTART_LEVEL=1050
     echo $RESTART_LEVEL>/tmp/restart_level
     Log "RESTART_LEVEL:$RESTART_LEVEL Unmounted all the mount points" >> $LOG_FILE
fi

exit
