#!/bin/bash
. common.sh
CONTEXT="restore"
LOGDIR="/tmp"
INSTANCE="Instance001"
SRDIR="/"
SYS_CONF="/tmp/sysconf"
LOGFILE="/tmp/cvrestore.log"
STORAGE_TREE="/tmp/storage_tree"
. /common_funcs.sh

DEVICE_MAP_FILE="/tmp/MOUNTDIR/boot/grub/device.map"
DEVICE_MAP_FILE_COPY="/tmp/MOUNTDIR/boot/grub/device.map.1tch_save"
#
#The supplied device name may be of the following form
#/dev/hda,/dev/hda2,/dev/sda,/dev/sda2
#/dev/mapper/mpath0,/dev/mapper/mpath0-part1,/dev/mapper/mpath0p1
#/dev/mapper/mpatha,/dev/mapper/mpatha-part1
#
searchdevicemap()
{
     local device map_file

     device=$1
     map_file=$2

     echo "search [$device] in [$map_file] pid[$$]" >> $LOG_FILE

     echo "$device">/tmp/device.$$
     if [ -e /tmp/found.$$ ]; then
          rm -f /tmp/found.$$ 
     fi
     cat $map_file | while read line
     do
         #Skip comments in device.map file
         cmnt=`echo $line | grep "#"`
         if [ "x$cmnt" != "x" ]; then
               echo "found comment line [$line]" >> $LOG_FILE    
              continue
         fi
         device=`cat /tmp/device.$$`
         cur_device=`echo $line | awk '{print $2}'` 
         echo "extract cur_device [$cur_device] from line [$line]" >> $LOG_FILE
         if [ "$device" == "$cur_device" ]; then
              touch /tmp/found.$$
              grub_device=`echo $line | awk '{print $1}'` 
              echo $grub_device
              echo "MATCH! grub_device=[$grub_device] touch [/tmp/found.$$]" >> $LOG_FILE
              break 
         fi
     done
     if [ -e /tmp/found.$$ ]; then
           echo "return success!" >>$LOG_FILE
          return 0
     else
           echo "return missing!" >>$LOG_FILE
          echo "MISSING"
          return 1
     fi
}

get_disk_name()
{
    dev_name=$1
    str=`echo $dev_name | grep "mapper" 2>/dev/null`
    if [ -n "$str" ]; then
         vg=`lvm lvs --noheadings $str|awk '{print $2}'|head -n 1`
         if [ -n "$vg" ]
         then
             echo "Looks like given disk is lvm[$str]" >> $LOG_FILE
             pv=`lvm pvs --noheadings|grep $vg|awk '{print $1}'|head -n 1`
             disk=`get_disk_name $pv`
             echo $disk
             return
         fi
         SaveKpartxDelimiter
         var=`cat /tmp/kpartx_delim`
         var="$var[0-9]+"
         disk=`echo $dev_name | awk  '{sub(/'"$var"'/,"")};1'`
         if [ -n "$disk" ]; then
              echo $disk
              return
         fi
    else 
         str=`echo $dev_name | grep "/dev/cciss" 2>/dev/null`
         if [ -n "$str" ]; then
             disk=`echo $dev_name | awk -F 'p' '{print $1}'`
             if [ -n "$disk" ]; then
                  echo $disk
                  return                  
             fi
         else          
             disk=`echo $dev_name | awk '{print $1}' | tr -d '[:digit:]'`
             if [ -n "$disk" ]; then
                  echo $disk
                  return
             fi
         fi              
    fi
    echo "invalid"
    return
}

get_part_num()
{
    dev_name=$1
    str=`echo $dev_name | grep "mapper" 2>/dev/null`
    if [ -n "$str" ]; then
         part_num=0  
         disk_name=`get_disk_name $dev_name`
         part=`echo $dev_name | awk  -F "$disk_name" '{print $2}'`
         if [ -n "$part" ]; then
              delim=`cat /tmp/kpartx_delim`
              part_num=`echo $part | awk  '{sub(/'"$delim"'/,"")};1'` 
         fi
         echo $part_num
         return
    else
        part_num=0
        str=`echo $dev_name | grep "/dev/cciss" 2>/dev/null`
        if [ -n "$str" ]; then
             disk=`echo $dev_name | awk -F 'p' '{print $2}'`
             if [ -n "$disk" ]; then
                  part_num=`echo $disk`
             fi
        else             
             disk=`basename $dev_name | tr -d "[:alpha:]"`
             if [ -n "$disk" ]; then
                  part_num=`echo $disk`
             fi
        fi             
        echo $part_num
        return

    fi
}

CreateGRUBMap()
{
     local map_file1 map_file2 target_map device
     local bckup_grub_dev res_grub_dev

     map_file1=$1
     map_file2=$2
     target_map=$3
   
     if [ -e $target_map ]; then
          rm -f $target_map
     fi

     device_list=`grep -v "#" $map_file1 | awk '{print $2}'`
     for device in $device_list
     do
         res_grub_dev=`searchdevicemap $device $map_file1`
         bckup_grub_dev=`searchdevicemap $device $map_file2`
         echo "$device $bckup_grub_dev $res_grub_dev" >> $target_map  
     done
}

SearchGRUBMap()
{
     local grub_device bckup_grub_name res_grub_name
    
     grub_device=$1
     grub_map_file=$2

     echo "$grub_device" >/tmp/grub.$$
     if [ -e /tmp/found.$$ ]; then
          rm -f /tmp/found.$$
     fi
     cat $grub_map_file | while read line
     do
         grub_device=`cat /tmp/grub.$$`
         bckup_grub_name=`echo $line | awk '{print $2}' | tr -d '()'`   
         res_grub_name=`echo $line | awk '{print $3}' | tr -d '()'`   
         if [ $grub_device == $bckup_grub_name ]; then
              touch /tmp/found.$$
              echo $res_grub_name
              break
         fi
     done
     if [ -e /tmp/found.$$ ]; then
          return 0
     else
          return 1
     fi
}

FixGRUBconf()
{
    local grub_conf grub_map new_grub_conf grub_dev res_grub_dev

     grub_conf=$1
     grub_map=$2
     new_grub_conf=$3

     if [ -e $new_grub_conf ]; then
          rm -f $new_grub_conf
     fi

     while read line
     do
        rawline=`echo $line | tr -d ' '`
        str=`echo $rawline | grep "^root"`
        if [ "x$str" == x ]; then
             echo "$line">>$new_grub_conf  
        else
             #The given line contains the string root@ start of line.
             #Modify the device name to correct grub device name. 
             #Extract the name of the device in GRUB notation.
             grub_dev=`echo $line | awk '{print $2}' | cut -d ',' -f 1 | tr -d '('`
             grub_part=`echo $line | awk '{print $2}' | cut -d ',' -f 2`
             res_grub_dev=`SearchGRUBMap $grub_dev $grub_map`
             if [[ $? -eq 0 ]] && [[ $res_grub_dev != MISSING ]]; then
                 echo "root ($res_grub_dev,$grub_part">>$new_grub_conf
             else
                 echo "$line">>$new_grub_conf  
             fi
        fi
     done <$grub_conf

     mv $new_grub_conf /tmp/grub.conf.2
     while read line
     do
         rawline=`echo $line | tr -d ' '`
     
         #Check for gfxmenu
         str=`echo $rawline | grep "^gfxmenu"`
         if [ "x$str" == "x" ]; then
             str=`echo $rawline | grep "^splashimage"`
             if [ "x$str" == "x" ]; then
                 #Copy this line as it is to the new grub.conf 
                 echo "$line">>$new_grub_conf
             else
                 bootm=`echo $line | awk -F"=" '{print $2}' | cut -d')' -f2`
                 echo "Extracted splashimage bootm = [$bootm]" >> $LOG_FILE
                 res_grub_dev=`cat $grub_boot_device`
                 if [ -n "$res_grub_dev" ]; then
                     echo "Extracted res_grub_dev [$res_grub_dev]" >> $LOG_FILE
                     echo "splashimage=${res_grub_dev}$bootm" >>$new_grub_conf
                 else
                     echo "error... res_grub_dev empty" >> $LOG_FILE
                     echo "$line">>$new_grub_conf  
                 fi        
             fi
         else
             bootm=`echo $line | awk '{print $2}' | cut -d')' -f2`
             echo "Extracted gfxmenu bootm = [$bootm]" >> $LOG_FILE
             res_grub_dev=`cat $grub_boot_device`
             if [ -n "$res_grub_dev" ]; then
                 echo "Extracted res_grub_dev [$res_grub_dev]" >> $LOG_FILE
                 echo "gfxmenu ${res_grub_dev}$bootm" >>$new_grub_conf
             else
                 echo "error... res_grub_dev empty[2]" >> $LOG_FILE
                 echo "$line">>$new_grub_conf  
             fi        
         fi        
     done < /tmp/grub.conf.2
}

searchprimarydisk()
{
    map_file=$1
    echo "Look for primary disk in map : $map_file" >> $LOG_FILE
    if [ -e /tmp/found.$$ ]; then
        rm -f /tmp/found.$$ 
    fi

    cat $map_file | while read line
    do
        #Skip comments in device.map file
        cmnt=`echo $line | grep "#"`
        if [ "x$cmnt" != "x" ]; then
             continue
        fi
        gdev=`echo $line | awk '{print $1}'`
        if [ "x$gdev" == "x(hd0)" ]; then
            dev=`echo $line | awk '{print $2}'`
            echo "Found disk for (hd0) : $dev" >> $LOG_FILE
            dev=`get_disk_name $dev`
            echo "Found disk_name for (hd0) : $dev" >> $LOG_FILE
            echo $dev
            touch /tmp/found.$$
            break
        fi    
    done
    if [ -e /tmp/found.$$ ]; then
       return 0
    else        
       echo "MISSING"
       return 1
    fi    
}

# In the following cases, we cannot rely on hd# -> diskname returned by grub via device.map
#   1. when the system has multipath disks (boot from mpath or otherwise)
#   2. multiple (type) of controller exist (raid/hbas/scsi,etc)
#   3. cciss disks on SLES (device.map is empty)
# In such cases, just install grub on (hd0, <actual_partition>). If this order is incorrect, the admin will need to change BIOS boot order
# function takes arguments : 1: partition# 2: device name
SetupGrubNoDeviceMap()
{
    PART=$1
    DEV=$2
    if [ -z "$DEV" ]; then
        Log "SetupGrubNoDeviceMap invoked with empty DEV" >> $LOG_FILE
        echo "-1"
    fi
    if [ -z "$PART" ]; then
        Log "SetupGrubNoDeviceMap invoked with empty PART#" >> $LOG_FILE
        echo "-1"
    fi
    Log "Set up grub without installing device.map" >> $LOG_FILE

    echo "device (hd0)  $DEV" > /tmp/grub.setup
    if [ "$PART" = "-1" ]; then
        echo "root (hd0,0)" >> /tmp/grub.setup
    else
        echo "root (hd0,$PART)" >> /tmp/grub.setup
    fi
    echo "setup (hd0)" >> /tmp/grub.setup
    echo "quit" >> /tmp/grub.setup
    Log "Trying with grub batch file /tmp/grub.setup" >> $LOG_FILE
    cat /tmp/grub.setup >> $LOG_FILE

    echo "ORIG MAP" >> $LOG_FILE
    cat $DEVICE_MAP_FILE >> $LOG_FILE
    if [ -n "`cat $DEVICE_MAP_FILE`" ]; then
        mv $DEVICE_MAP_FILE $DEVICE_MAP_FILE_COPY
    fi
    echo "DONE" >> $LOG_FILE

    echo "Sleep for 10 seconds..." >> $LOG_FILE
    sleep 10

    echo "(hd0) $DEV" > $DEVICE_MAP_FILE
    echo "Update device.map" >> $LOG_FILE
    cat $DEVICE_MAP_FILE >> $LOG_FILE
    echo "DONE" >> $LOG_FILE

    grub --no-floppy --batch --device-map=$DEVICE_MAP_FILE < /tmp/grub.setup > /tmp/grub.log 2>&1
    ret=$?
    echo "Sleep for 10 seconds..." >> $LOG_FILE
    sleep 10
    echo "(hd0,$PART)" > ${grub_boot_device}

    echo "SetupGrubNoDeviceMap returns [$ret]" >> $LOG_FILE
    echo "$ret"
}

GrubLegacy()
{
    #We follow the following approach for determining the mapping from Linux device names to GRUB device names.
    #Install grub to the first partition on the disk. This will create the device.map file. 
    #Next use this device.map file and install GRUB to the proper disk as per device.map file.

    # If /boot is on a mpath device, we cannot rely on the device.map generated by grub. Assume that the mpath device
    # on which /boot is installed is (hd0) based on SAN boot best practices
    GRUBINSTALLED=0
    if [ -f /tmp/use_mpath_flag ]; then
        if [ "$MPATH_MBR_DEV" != "$MBR_DEV" ]; then
            ret=`SetupGrubNoDeviceMap $BOOT_PART_NUM $MPATH_MBR_DEV`
            if [ -z "$ret" -o "$ret" == "0" ]; then
                GRUBINSTALLED=1
            else
                echo "Failed to install GRUB with multipath disks present"
                Log "Failed to install GRUB with multipath disks present" >>$LOG_FILE
                exit 2
            fi
        fi
        if [ "$ROOT_CCISS" == "true" ]; then
            ret=`SetupGrubNoDeviceMap $BOOT_PART_NUM $MPATH_MBR_DEV`
            if [ -z "$ret" -o "$ret" == "0" ]; then
                GRUBINSTALLED=1
            else
                echo "Failed to install GRUB with cciss+multipath disks present"
                Log "Failed to install GRUB with cciss+multipath disks present" >>$LOG_FILE
                exit 2
            fi
        fi
    fi
    
    if [ $GRUBINSTALLED == 0 ]; then
        echo "Trying GRUB Install in batch mode to guess the GRUB to Linux device name mapping."
        Log "Trying GRUB Install in batch mode to guess the GRUB to Linux device name mapping." >> $LOG_FILE
        echo "device (hd$BOOT_DISK_NUM)  $MBR_DEV" > /tmp/grub.setup
        if [ "$BOOT_PART_NUM" = "-1" ]; then
             echo "root (hd$BOOT_DISK_NUM,0)" >> /tmp/grub.setup
        else
            echo "root (hd$BOOT_DISK_NUM,$BOOT_PART_NUM)" >> /tmp/grub.setup
        fi
        echo "setup (hd$BOOT_DISK_NUM)" >> /tmp/grub.setup
        echo "quit" >> /tmp/grub.setup
        echo "Trying with grub batch file /tmp/grub.setup"
        cat /tmp/grub.setup >> $LOG_FILE

        echo "Sleep for 10 seconds..." >> $LOG_FILE
        sleep 10

        echo "ORIG MAP" >> $LOG_FILE
        cat $DEVICE_MAP_FILE >> $LOG_FILE
        cp $DEVICE_MAP_FILE $DEVICE_MAP_FILE_COPY
        echo "DONE" >> $LOG_FILE

        #Remove the file device.map if it already exists
        if [ -e $DEVICE_MAP_FILE ]; then
             rm -f $DEVICE_MAP_FILE
        fi

        grub --no-floppy --batch --device-map=$DEVICE_MAP_FILE < /tmp/grub.setup > /tmp/grub.log 2>&1

        echo "Sleep for 10 seconds..." >> $LOG_FILE
        sleep 10

        echo "MAP after first install" >> $LOG_FILE
        cat $DEVICE_MAP_FILE >> $LOG_FILE
        echo "DONE" >> $LOG_FILE

        #Even if a device map file has been generated, some devices like VIRTIOBLK may not show up in the file. if we need to install grub to such a device, we need to not rely on the generated file
        testgrub_dev=`searchdevicemap $MBR_DEV $DEVICE_MAP_FILE`
        Log "Check if $MBR_DEV is present in generated $DEVICE_MAP_FILE -- $testgrub_dev" >> $LOG_FILE

        if [ ! -e $DEVICE_MAP_FILE -o -z "`cat $DEVICE_MAP_FILE`" -o "$testgrub_dev" == "MISSING" ]; then
            echo "GRUB did not generate device.map or device not found in generated file! Assume $MBR_DEV --> (hd0)"
            Log "GRUB did not generate device.map or device not found in generated file! Assume $MBR_DEV --> (hd0)" >> $LOG_FILE
            ret=`SetupGrubNoDeviceMap $BOOT_PART_NUM $MBR_DEV`
            Log "SetupGrubNoDeviceMap returned [$ret]" >> $LOG_FILE
            if [ -z "$ret" -o "$ret" == "0" ]; then
                GRUBINSTALLED=1
            else
                echo "Failed to install GRUB with assumed device.map"
                Log "Failed to install GRUB with assumed device.map" >>$LOG_FILE
                exit 2
            fi
        fi

        if [ $GRUBINSTALLED == 0 ]; then
            #Now that the device.map file has been generated use this to determine the proper GRUB name of the 
            #boot device.
            grub_dev=`searchdevicemap $MBR_DEV $DEVICE_MAP_FILE`
            primary_dev=`searchprimarydisk $DEVICE_MAP_FILE`

            echo "MBR_DEV[$MBR_DEV] grub_dev [$grub_dev] primary_dev [$primary_dev]" >> $LOG_FILE

            echo "trying GRUB install using the proper GRUB device map"
            Log "trying GRUB install using the proper GRUB device map" >> $LOG_FILE
            trunc_grub_dev=`echo $grub_dev | tr -d '()'`   
            #install bootloader on MBR of primary disk - pointing to correct root
            #echo "device $grub_dev $MBR_DEV" > /tmp/grub.setup
            echo "device (hd$BOOT_DISK_NUM) $primary_dev" > /tmp/grub.setup
            echo "root ($trunc_grub_dev,$BOOT_PART_NUM)" >> /tmp/grub.setup
            #echo "setup $grub_dev" >> /tmp/grub.setup
            echo "setup (hd$BOOT_DISK_NUM)" >> /tmp/grub.setup
            echo "quit" >> /tmp/grub.setup
            echo "Trying with grub batch file /tmp/grub.setup"
            cat /tmp/grub.setup >> $LOG_FILE

            grub --no-floppy --batch --device-map=$DEVICE_MAP_FILE < /tmp/grub.setup > /tmp/grub.log 2>&1
            retCode=$?

            echo "MAP after second install" >> $LOG_FILE
            cat $DEVICE_MAP_FILE >> $LOG_FILE
            echo "DONE" >> $LOG_FILE

            echo "The return code of grub is : $retCode"
            Log "The return code of grub is : $retCode" >> $LOG_FILE
            ERR=`cat  /tmp/grub.log | grep "Error [0-9]*: "`
            if [ "$ERR" != "" -o $retCode -ne 0 ]; then
                 cat /tmp/grub.log
                 Log "GRUB install failed. retcode[$retcode]" >> $LOG_FILE
                 reset_last_error
                 log_last_error "GRUB install failed. retcode[$retcode]"
                 log_dmesg
                 exit 2
            else
                 cat /tmp/grub.log >> /tmp/cvsrrestore.log
                 echo "GRUB Install in batch mode succeeded"
                 Log "GRUB Install in batch mode succeeded" >> $LOG_FILE
                 echo "($trunc_grub_dev,$BOOT_PART_NUM)" > ${grub_boot_device}
            fi
        fi
    fi
    
    #Compare the device.map from backed up system and current system and 
    #Fix the device references in grub.conf 
    CreateGRUBMap $DEVICE_MAP_FILE $SYS_STATE_LOC/device.map /tmp/grub.map
    if [ ! -e /tmp/MOUNTDIR/boot/grub/grub.conf ]; then
        cp -f /tmp/MOUNTDIR/boot/grub/menu.lst /tmp/MOUNTDIR/boot/grub/grub.conf
    fi
    if [ -e /tmp/MOUNTDIR/boot/grub/grub.conf ]; then
         FixGRUBconf /tmp/MOUNTDIR/boot/grub/grub.conf /tmp/grub.map /tmp/grub.conf 
         cp -f /tmp/grub.conf /tmp/MOUNTDIR/boot/grub/grub.conf
    fi
}

Grub2()
{
    prepmount_cmd
    grubbin=`chroot /tmp/MOUNTDIR which grub-install`
    if [ $? -ne 0 ]; then
        grubbin=`chroot /tmp/MOUNTDIR which grub2-install`
    fi

    # For vME of a UEFI machine, the source might not have the grub files for this target. we have on our bootcd, centos7 grub files. let's use these 
    if [ -e /tmp/recovery_jobid ]; then
        is_mtpt=`cat $YASTGUI/mtpt_main | grep OPTIMIZE_STORAGE | cut -d'=' -f2`
        if [ "x$is_mtpt" != "x1" ]; then
            # FIXME: currently vME (non ADL) of UEFI machines will work for RHEL based machines only - SLES might work but debian/ubuntu will need a change here.
            grub2rpmFound=`chroot /tmp/MOUNTDIR rpm -qa grub2`
            if [ -z "$grub2rpmFound" ]; then # use the grub from our DVD
                cd /tmp/MOUNTDIR; tar zxf /cdrom/usr_lib_grub.tgz; cd -
            fi
        fi
    fi

    if [ -x /tmp/MOUNTDIR/$grubbin ]; then
        bin=`echo $grubbin | awk -F"/" '{print $NF}'`
        chroot /tmp/MOUNTDIR $bin $MBR_DEV
    fi
    ret=$?
    if [ $ret -ne 0 ]; then
        chroot /tmp/MOUNTDIR $bin --force $MBR_DEV
        ret=$?
    fi
    prepumount_cmd
    Log "Grub2 install ret code [$ret]" >> $LOG_FILE
    if [ $ret -ne 0 ]; then
        Log "Returning error. Please install grub manually. Follow this by invovking /postrestore.sh and a reboot" >> $LOG_FILE 
        exit 1
    fi
}

if [ -e /tmp/restart_level ]; then
    RESTART_LEVEL=`cat /tmp/restart_level`
else
    RESTART_LEVEL=0
fi
#update job percentage now that FS restore is complete
vm_percent 85

if [ -d /sys/firmware/efi/vars ]; then
    /installbootloader_uefi.sh
    ret=$?
    exit $ret
fi


#currently, we support GRUB and LILO boot loaders.
#For grub, we do the following.
# 1. run grub --batch
#    with root (boot partition)
#         setup (hd0), install on the first hard disk's MBR.


#Read the boot loader name and partition to install it.
BOOTLOADER_INFO=`cat $SYS_STATE_LOC/BOOTLOADER`
set $BOOTLOADER_INFO
BOOTLOADER=$1
BOOT_PART_NUM=-1
BOOT_DISK_NUM=0

#Determine the disk on which the /boot mount point exists.
str=`SearchMountPoint /boot`
if [ $? -ne 0 ]; then
     echo "/boot mount point does not exist on the system. Will try to install GRUB on /"
     Log "/boot mount point does not exist on the system. Will try to install GRUB on /" >> $LOG_FILE
     str=`SearchMountPoint /`
     if [ $? -ne 0 ]; then
          echo "/ mount point does not exist on the system. Restore will fail."
          Log "/ mount point does not exist on the system. Restore will fail." >> $LOG_FILE
          reset_last_error
          log_last_error "Mountpoint /boot and / do not exist in $SYS_CONFIG_DIR/mountpoints.lst"
          exit 1
     else 
          echo "/" > ${grub_boot_mnt_point}     
     fi
else 
     echo "/boot" > ${grub_boot_mnt_point}     
fi
str=`echo $str | awk '{print $1}'`
Log "/boot is on disk:$str" >> $LOG_FILE
MBR_DEV=`get_disk_name $str`
if [ "x$MBR_DEV" == "xinvalid" ]; then
     echo "Could not determine the device containing MBR.Restore will fail."
     Log "Failed to determine the device containing MBR [get_disk_name failed on $str]!" >> $LOG_FILE
     reset_last_error
     log_last_error "Failed to determine the device containing MBR\n[get_disk_name failed on $str]"
     exit 1
fi
PART_NUM=`get_part_num $str`
#Check whether the underlying device is a mpath device. If so then get the underltying disk  name
disk_name=`basename $MBR_DEV`
MPATH_MBR_DEV=$MBR_DEV
if [ -e /python_dir/disk_tree/disk_config/disk/mpath/$disk_name ]; then
     disk=`ls /python_dir/disk_tree/disk_config/disk/mpath/$disk_name/devices | head -n 1 | awk '{print $1}'`
     Log "for $disk_name underlying disk is $disk" >> $LOG_FILE
     if [[ -z "$disk" ]] || [[ ! -e /dev/$disk ]]; then
           echo "Could not determine the underlying device for $disk_name.Restore will fail."
           Log "Failed to determine the underlying device for $disk_name !" >> $LOG_FILE
           reset_last_error
           log_last_error "Failed to determine the underlying device for $disk_name"
           exit 1
     fi
     MBR_DEV=/dev/$disk
fi
ROOT_CCISS="false"
if [ -e /python_dir/disk_tree/disk_config/disk/cciss/$disk_name ]; then
    ROOT_CCISS="true"
fi
BOOT_PART_NUM=$((PART_NUM-1))
Log "Boot device Name@cvsrrestore.sh: $MBR_DEV" >> $LOG_FILE
Log "Boot partition Number@cvsrrestore.sh: $BOOT_PART_NUM" >> $LOG_FILE

Log "BOOTLOADER@cvsrrestore.sh: $BOOTLOADER" >> $LOG_FILE
#Now, we have the boot loader information.

case $BOOTLOADER in
GRUB)
    #Find the grub version we are working on
    ver=""
    get_grub_version


    fix_boot_multimount /tmp/MOUNTDIR/etc/fstab 0

    if [ "$ver" == "1" ]; then
        GrubLegacy
    else
        Grub2
    fi

    fix_boot_multimount /tmp/MOUNTDIR/etc/fstab 1

    ;;
ELILO)
    Log "Installing ELILO boot loader. Make sure elilo.conf exists ..." >> $LOG_FILE
    cp $SYS_STATE_LOC/efimenu.sh  / | tee -a $LOG_FILE
    chmod +x /efimenu.sh
    cd /
    ./efimenu.sh  > /tmp/efi.log 2>&1
    if [ $? -ne 0 ]; then
       Log "Failed to update efiboot manager menu. Please update the menu items manually." >> $LOG_FILE
       cat /tmp/efi.log | tee -a $LOG_FILE /tmp/cvsrrestore.log
    else
       Log "Successfully updated EFI bootmanager menu." >> $LOG_FILE
    fi
    ;;
LILO)
    Log "Installing LILO boot loader using default config file /etc/lilo.conf" >> $LOG_FILE
    touch /tmp/no_grub
    prepmount_cmd
    chroot /tmp/MOUNTDIR /sbin/lilo -M $MBR_DEV
    if [ $? -ne 0 ]; then
        Log "Not able to install boot loader LILO. Please try installing LILO manually by typing" >> $LOG_FILE
        Log "/sbin/lilo" >> $LOG_FILE
    else
        Log "Installed LILO MBR by running /sbin/lilo -M $MBR_DEV" >> $LOG_FILE
        chroot /tmp/MOUNTDIR /sbin/lilo -A $PART_NUM
        if [ $? -ne 0 ]; then
            Log "lilo activation via PART [$PART_NUM] of [$MBR_DEV] failed. ignore error" >> $LOG_FILE
        else
            Log "lilo activated PART [$PART_NUM] of [$MBR_DEV]" >> $LOG_FILE
        fi
        echo $str | sed 's/\//\\\//g' > /tmp/dl
        str2=`cat /tmp/dl`
        Log "update boot = [$str] delim[$str2]" >> $LOG_FILE
        sed -i "s/boot[ \t]*=.*/boot = $str2/g" /etc/lilo.conf

        chroot /tmp/MOUNTDIR /sbin/lilo 
        if [ $? -ne 0 ]; then
            Log "lilo activation via config file failed" >> $LOG_FILE
        else
            Log "lilo activated via config file" >> $LOG_FILE
        fi
    fi
    prepumount_cmd
    ;;
esac

vm_percent 90
exit 0
