#!/bin/bash

#   Assumptions:
#       This file contains OS specific functions. There *must* only be functions here, no code that will run if this file is sourced
#       This file *must* be sourced from a script that already sources common.sh

setup_ubuntu()
{
    NETCFG="/tmp/MOUNTDIR/etc/network/"
}

backup_file_ubuntu()
{
    ORIG_NTWK_FILE="$NETCFG/interfaces"
    NEW_NTWK_FILE="$NETCFG/bak_interfaces"
}

create_template_ubuntu()
{
    ORIGFILE="$1"

    FILE="$NETCFG/interfaces"

    of=$ORIGFILE
    if [ ! -f "$of" ]; then
        of=$ORIG_NTWK_FILE
    fi
    if [ -f "$of" ]; then
        cat $of | grep -v "#" | grep "source " >> $FILE
    fi

    cat > $FILE <<EOF
# The loopback network interface
auto lo inet loopback

EOF

}

update_slave_ubuntu()
{
    SLAVE=$1
    MASTER=$2
    FILEOVS="$NETCFG/interfaces-$SLAVE"

    if [ -f $FILEOVS ]; then
        rm -f $FILEOVS
    fi
    cat > $FILEOVS << EOF
auto $SLAVE
iface $SLAVE inet manual
    bond-master $MASTER
EOF

}

backup_create_template_master_ubuntu()
{
    echo "backup and/or create template bonding master ubuntu" >> $LOG_FILE
    MASTER=$1
    CFG_SLAVE=$2
    MASTERFILE="$NETCFG/interfaces-$MASTER"

    echo "create a template for [$MASTER] -> [$MASTERFILE]" >> $LOG_FILE

    cat > $MASTERFILE <<EOF
# The loopback network interface
auto $MASTER

EOF
}

update_bondingfiles_ubuntu()
{
    echo "Process slaves [$slaves] for [$master]" >> $LOG_FILE
    for slave in $slaves
    do
        echo "$slave" >> $skip_interface_names
        update_slave $slave $master
    done    
}

update_ntwkconfig_file_ubuntu()
{
    if [ "$FLAG" == "NOBOND" ]; then
        FILEOV="$NETCFG/interfaces-$if"
        if [ -f $FILEOV ]; then
            rm -f $FILEOV
        fi
        oif=$if
    else
        FILEOV=$FILE
        oif=$master
    fi

    cat > $FILEOV << EOF
auto $oif
EOF
    if [ "$proto" != "dhcp" ]; then
    cat >> $FILEOV << EOF
iface $oif inet static
EOF
        if [ -n "$gw" ]; then
            update_field $FILEOV gateway $gw
        fi
        if [ -n "$ip" ]; then
            update_field $FILEOV address $ip
        fi
        if [ -n "$mask" ]; then
            update_field $FILEOV netmask $mask
        fi
        update_field $FILEOV "hwaddress ether" $mac
    else
        cat >> $FILEOV << EOF
iface $oif inet dhcp
EOF
        update_field $FILEOV "hwaddress ether" $mac
    fi

    if [ "$FLAG" == "BOND" ]; then
        update_field $FILEOV "bond-slaves" "none"
    fi
}

update_ntwkconfig_file_wrapper_ubuntu()
{
    ORGFILE="$NETCFG/interfaces"
    #Remove this file, so the caller will create a new template file
    rm -f $ORGFILE
}

update_ntwkconfig_file_wrapper_finish_ubuntu()
{
    Log "update_ntwkconfig_file_wrapper_finish_ubuntu: NOP" >> $LOG_FILE
}

create_ntwkconfig_file_ubuntu()
{
    FILE="$NETCFG/interfaces"
    update_ntwkconfig_file "NOBOND" $FILE $r_if $r_ifmac
}

finalise_config_ubuntu()
{
    FILE="$NETCFG/interfaces"
    create_template_ubuntu
    files=`ls $NETCFG/interfaces-*`
    for file in $files
    do
        cat $file >> $FILE
        echo -e "\n" >> $FILE 
        #rm -f $file
    done
}

update_field_ubuntu()
{
    FILE="$1"
    PROP="$2"
    VAL="$3"
    echo "update_field_ubuntu $FILE $PROP $VAL" >> $LOG_FILE

    found=`grep -w "$PROP" $FILE`
    if [ -z "$found" ]; then
        echo "$PROP $VAL" >> $FILE
    else
        prop1=`echo $PROP | cut -d' ' -f1`
        prop2=`echo $PROP | cut -d' ' -f2`
        if [ "$prop1" == "$prop2" ]; then
            prop2=""
        fi
        cat $FILE | awk -v prop1=$prop1 -v prop2=$prop2 -v val=$VAL '{if (prop2!="") { if ($1==prop1 && $2==prop2) {print prop1 " " prop2 " " val} else {print $0} } else { if ($1==prop1) {print prop1 " " val} else {print $0 }}}' > $tmpfile   
        mv $tmpfile $FILE
    fi
}

#update_field_ubuntu()
#{
#    FILE=$1
#    PROP=$2
#    VAL=$3
#    
#    echo "update_field_ubuntu $FILE $PROP $VAL" >> $LOG_FILE
#
#    case $PROP in
#        "HWADDR")
#            found=`grep "^hwaddress" testfile`
#            if [ "$found" = "" ]; then
#                echo "hwaddress ether $VAL" >> $FILE
#            else
#                sed "s/hwaddress.*/hwaddress ether $VAL/g" $FILE > $FILE.tmp
#            fi
#            mv $FILE.tmp $FILE
#            ;;
#        "GATEWAY")
#            found=`grep "^gateway" testfile`
#            if [ "$found" = "" ]; then
#                echo "gateway $VAL" >> $FILE
#            else
#                sed "s/gateway.*/gateway $VAL/g" $FILE > $FILE.tmp
#            fi
#            mv $FILE.tmp $FILE
#            ;;
#        "IPADDR")
#            found=`grep "^address" testfile`
#            if [ "$found" = "" ]; then
#                echo "address $VAL" >> $FILE
#            else
#                sed "s/address.*/address $VAL/g" $FILE > $FILE.tmp
#            fi
#            mv $FILE.tmp $FILE
#            ;;
#        "NETMASK")
#            found=`grep "^netmask" testfile`
#            if [ "$found" = "" ]; then
#                echo "netmask $VAL" >> $FILE
#            else
#                sed "s/netmask.*/netmask $VAL/g" $FILE > $FILE.tmp
#            fi
#            mv $FILE.tmp $FILE
#            ;;
#        "BROADCAST")
#            found=`grep "^broadcast" testfile`
#            if [ "$found" = "" ]; then
#                echo "broadcast $VAL" >> $FILE
#            else
#                sed "s/broadcast.*/broadcast $VAL/g" $FILE > $FILE.tmp
#            fi
#            mv $FILE.tmp $FILE
#            ;;
#        *)
#            echo "Invalid property" >> $LOG_FILE
#            ;;
#    esac
#}
