#!/bin/bash

routefile=""

setup_suse()
{
    Log "Setup netmap SUSE" >> $LOG_FILE

    suse_version=`cat /etc/SuSE-release | grep -w VERSION | awk -F"=" '{print $2}' | tr -d [:space:]`
    suse_patchlevel=`cat /etc/SuSE-release | grep -w PATCHLEVEL | awk -F"=" '{print $2}' | tr -d [:space:]`
    echo "OS type SUSE. version [$suse_version] patchlevel [$suse_patchlevel]" >> $LOG_FILE
    NETCFG="/tmp/MOUNTDIR/etc/sysconfig/network"
    if [ $suse_version -le 10 ]; then
        echo "Determined 10 or lower SUSE version. use ifcfg-eth-id-* style network config files" >> $LOG_FILE
        USE_ETH_ID=1
        routefile="$NETCFG/routes"
        mv $routefile ${routefile}_bak
        touch $routefile
    else
        echo "Determined 10 or greater SUSE. use ifcfg-eth# style network config files" >> $LOG_FILE
    fi
}

set_filenames_suse()
{
    ib_if=$1
    ib_ifmac=$2
    ir_if=$3
    ir_ifmac=$4
    ir_vlanid=$5

    if [ -n "$ir_vlanid" -o "$ir_vlanid" == "0" ]; then
        if [ $suse_version -le 10 ]; then
            ORIG_NTWK_FILE="$NETCFG/ifcfg-eth-id-$ib_ifmac"
            BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-eth-id-$ir_ifmac"
            NEW_NTWK_FILE="$NETCFG/ifcfg-eth-id-$ir_ifmac"
        else    
            ORIG_NTWK_FILE="$NETCFG/ifcfg-$ib_if"
            BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-$ir_if"
            NEW_NTWK_FILE="$NETCFG/ifcfg-$ir_if"
        fi    
    else
        case $vlan_name_type in
            "VLAN_NAME_TYPE_RAW_PLUS_VID_NO_PAD")
                ORIG_NTWK_FILE="$NETCFG/ifcfg-${ib_if}.$ir_vlanid"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-${ir_if}.$ir_vlanid"
                NEW_NTWK_FILE="$NETCFG/ifcfg-${ir_if}.$ir_vlanid"
                ;;
            "VLAN_NAME_TYPE_RAW_PLUS_VID")
                ifvlanid_pad=`printf %04d $ir_vlanid`
                ORIG_NTWK_FILE="$NETCFG/ifcfg-${ib_if}.$ifvlanid_pad"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-${ir_if}.$ifvlanid_pad"
                NEW_NTWK_FILE="$NETCFG/ifcfg-${ir_if}.$ifvlanid_pad"
                ;;
            "VLAN_NAME_TYPE_PLUS_VID_NO_PAD")
                ORIG_NTWK_FILE="$NETCFG/ifcfg-vlan$ir_vlanid"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-vlan$ir_vlanid"
                NEW_NTWK_FILE="$NETCFG/ifcfg-vlan$ir_vlanid"
                ;;
            "VLAN_NAME_TYPE_PLUS_VID")
                ifvlanid_pad=`printf %04d $ir_vlanid`
                ORIG_NTWK_FILE="$NETCFG/ifcfg-vlan$ifvlanid_pad"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-vlan$ifvlanid_pad"
                NEW_NTWK_FILE="$NETCFG/ifcfg-vlan$ifvlanid_pad"
                ;;
        esac
    fi
}


backup_file_suse()
{
    ORIG_NTWK_FILE=""
    NEW_NTWK_FILE=""
    BAK_NEW_NTWK_FILE=""
    set_filenames_suse $if $ifmac $if $ifmac $ifvlanid
    NEW_NTWK_FILE=$BAK_NEW_NTWK_FILE
}

create_template_suse()
{
    echo "create_template_suse: FILE=[$FILE]" >>$LOG_FILE
    cat > $FILE <<EOF
ETHTOOL_OPTIONS=''
MTU=''
STARTMODE='auto'
USERCONTROL='no'
EOF
    echo "created: `cat $FILE`" >> $LOG_FILE
}

update_slave_suse()
{
    SLAVE=$1
    MASTER=$2
    SLAVEMAC=`cat $RES_NTWK_TREE/$SLAVE/mac`
    ORIG_NTWK_FILE=""
    set_filenames_suse $SLAVE $SLAVEMAC $SLAVE $SLAVEMAC "0"

    Log "update_bondingfiles_suse: SLAVE[$SLAVE] MASTER[$MASTER] SLAVEMAC[$SLAVEMAC] - ORIG_NTWK_FILE[$ORIG_NTWK_FILE]" >> $LOG_FILE
    create_template $ORIG_NTWK_FILE $SLAVE

}

update_field_suse()
{
    FILE="$1"
    PROP="$2"
    VAL="$3"
    echo "update_field_suse() Invoked with FILE[$FILE] PROP[$PROP] VAL[$VAL]" >> $LOG_FILE

    if [ "x`cat $FILE | grep -w $PROP`" != "x" ]; then
        echo "PROP [$PROP] found in [$FILE]. Update it" >> $LOG_FILE
        cat $FILE | awk -v PROP=$PROP -v VAL=$VAL -v q="'" -F"=" '{if ($1==PROP) {print PROP "=" q VAL q} else {print $0}}' > $TMPFILE           
        mv $TMPFILE $FILE
    else
        echo "PROP [$PROP] not found in [$FILE]. Add it" >> $LOG_FILE
        echo "$PROP='$VAL'" >> $FILE
    fi
    echo "FILE = [`cat $FILE`]" >> $LOG_FILE
}

backup_create_template_master_suse()
{
    echo "backup and/or create template bonding master suse" >> $LOG_FILE
    MASTER=$1
    CFG_SLAVE=$2
    MASTERFILE="$NETCFG/ifcfg-$MASTER"
    TMPFILE="$NETCFG/bak_ifcfg-$MASTER"

    if [ -f $MASTERFILE ]; then
        echo "copy [$MASTERFILE] -> [$TMPFILE]" >> $LOG_FILE
        cp -vf $MASTERFILE $TMPFILE
    else
        echo "[$MASTERFILE] NOT found. create a template for [$MASTER]" >> $LOG_FILE
        create_template $MASTERFILE $MASTER 
    fi    
}

update_bondingfiles_suse()
{
    update_field $FILE BONDING_MASTER yes
    n=0
    echo "Process slaves [$slaves] for [$master]" >> $LOG_FILE
    for slave in $slaves
    do
        echo "$slave" >> $skip_interface_names
        cslave=$slave
        while read line
        do
            if [ "x$slave" == "x`echo $line | awk '{print $1}'`" ]; then
                #mapping found, use backed up interface script and modify accordingly
                cslave=`echo $line | awk '{print $2}'`
                echo "Map entry found for $slave(backup) maps with $cslave(current)" >> $LOG_FILE
            fi    
        done <$YASTGUI/net_map 
        if [ $suse_version -le 10 ]; then
            ethpci=`readlink /sys/class/net/$slave/device | awk -F "/" '{print $NF}'` 
            remove_field $FILE BONDING_SLAVE$n
            update_field $FILE BONDING_SLAVE_$n bus-pci-$ethpci
        else
            remove_field $FILE BONDING_SLAVE$n
            update_field $FILE BONDING_SLAVE_$n $cslave
        fi
        n=$(($n+1))
        update_slave $cslave $master
    done    
}

update_ntwkconfig_file_suse()
{
    if [ -n "$hasvlan" ]; then
        #this is base nic for a vlan-tagged interface. 
        update_field $FILE BOOTPROTO none
    else
        if [ "$proto" != "dhcp" ]; then
                update_field $FILE BOOTPROTO static
                if [ -n "$gw" -a "x$gw" != "x" ]; then
                    if [ -n "$routefile" ]; then
                        echo "Update [$routefile] with: default $gw - -" >> $LOG_FILE
                        echo "default $gw - -" >> $routefile 
                    fi
                fi        
                update_field $FILE IPADDR $ip
                update_field $FILE NETMASK $mask
        else
            update_field $FILE BOOTPROTO dhcp
            update_field $FILE IPADDR ""
            update_field $FILE NETMASK ""
            update_field $FILE GATEWAY ""
        fi    
    fi
    #this is a deprecated field. just make it empty, so it wont have an old incorrect value
    update_field $FILE BROADCAST ""

    if [ $FLAG == "NOBOND" ]; then
        if [ $suse_version -le 10 ]; then
            update_field $FILE "_nm_name" "bus-pci-$pci"
        fi    
    fi    

	update_field $FILE STARTMODE auto
	if [ -n "$vlanid" ]; then
		update_field $FILE ETHERDEVICE $TRANS_ACTNIC
        update_field $FILE VLAN_ID $vlanid
	fi
}

update_ntwkconfig_file_wrapper_suse()
{
    ORGFILE=""
    NEWFILE=""
    set_filenames_suse $b_if $b_ifmac $r_if $r_ifmac $r_vlanid
    ORGFILE=$ORIG_NTWK_FILE
    NEWFILE=$NEW_NTWK_FILE
}

update_ntwkconfig_file_wrapper_finish_suse()
{
    mv $ORGFILE $NEWFILE
}

create_ntwkconfig_file_suse()
{
    ORGFILE=""
    set_filenames_suse $r_if $r_ifmac $r_if $r_ifmac $r_vlanid
    ORGFILE=$ORIG_NTWK_FILE
    update_ntwkconfig_file "NOBOND" $ORGFILE $r_if $r_ifmac
    update_field $ORGFILE STARTMODE auto
    update_field $ORGFILE USERCONTROL no
}

finalise_config_suse()
{
    Log "finalise_config_suse - NOP" >> $LOG_FILE
}
