#!/bin/bash

#   Assumptions:
#       This file contains OS specific functions. There *must* only be functions here, no code that will run if this file is sourced
#       This file *must* be sourced from a script that already sources common.sh

setup_redhat()
{
    Log "Setup netmap RedHat" >> $LOG_FILE
    NETCFG="/tmp/MOUNTDIR/etc/sysconfig/network-scripts"
}

set_filenames_redhat()
{
    ib_if=$1
    ir_if=$2
    ir_vlanid=$3

    if [ -n "$ir_vlanid" -o "$ir_vlanid" == "0" ]; then
            ORIG_NTWK_FILE="$NETCFG/ifcfg-$ib_if"
            BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-$ir_if"
            NEW_NTWK_FILE="$NETCFG/ifcfg-$ir_if"
    else
        case $vlan_name_type in
            "VLAN_NAME_TYPE_RAW_PLUS_VID_NO_PAD")
                ORIG_NTWK_FILE="$NETCFG/ifcfg-${ib_if}.$ir_vlanid"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-${ir_if}.$ir_vlanid"
                NEW_NTWK_FILE="$NETCFG/ifcfg-${ir_if}.$ir_vlanid"
                ;;
            "VLAN_NAME_TYPE_RAW_PLUS_VID")
                ifvlanid_pad=`printf %04d $ir_vlanid`
                ORIG_NTWK_FILE="$NETCFG/ifcfg-${ib_if}.$ifvlanid_pad"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-${ir_if}.$ifvlanid_pad"
                NEW_NTWK_FILE="$NETCFG/ifcfg-${ir_if}.$ifvlanid_pad"
                ;;
            "VLAN_NAME_TYPE_PLUS_VID_NO_PAD")
                ORIG_NTWK_FILE="$NETCFG/ifcfg-vlan$ir_vlanid"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-vlan$ir_vlanid"
                NEW_NTWK_FILE="$NETCFG/ifcfg-vlan$ir_vlanid"
                ;;
            "VLAN_NAME_TYPE_PLUS_VID")
                ifvlanid_pad=`printf %04d $ir_vlanid`
                ORIG_NTWK_FILE="$NETCFG/ifcfg-vlan$ifvlanid_pad"
                BAK_NEW_NTWK_FILE="$NETCFG/bak_ifcfg-vlan$ifvlanid_pad"
                NEW_NTWK_FILE="$NETCFG/ifcfg-vlan$ifvlanid_pad"
                ;;
        esac
    fi
}

backup_file_redhat()
{
    ORIG_NTWK_FILE=""
    NEW_NTWK_FILE=""
    BAK_NEW_NTWK_FILE=""
    set_filenames_redhat $if $if $ifvlanid
    NEW_NTWK_FILE=$BAK_NEW_NTWK_FILE
}

create_template_redhat()
{
    cat > $FILE <<EOF
DEVICE=$if
ONBOOT=yes
USERCTL=no
EOF
}

update_slave_redhat()
{
    SLAVE=$1
    MASTER=$2    
    FILE="$NETCFG/ifcfg-$SLAVE"
    BAK_FILE="`dirname $FILE`/bak_ifcfg-$SLAVE"
    if [ -f $FILE ]; then
        mv $FILE $BAK_FILE
    fi        
    cat > $FILE <<EOF
DEVICE=$SLAVE
BOOTPROTO=none
ONBOOT=yes
HWADDR=`cat /sys/class/net/$SLAVE/address`
NM_CONTROLLED=no
MASTER=$MASTER
SLAVE=yes
USERCTL=no
EOF

}

backup_create_template_master_redhat()
{
    echo "backup and/or create template bonding master redhat" >> $LOG_FILE
    MASTER=$1
    CFG_SLAVE=$2
    MASTERFILE="$NETCFG/ifcfg-$MASTER"
    TMPFILE="$NETCFG/bak_ifcfg-$MASTER"

    if [ -f $MASTERFILE ]; then
        echo "copy [$MASTERFILE] -> [$TMPFILE]" >> $LOG_FILE
        cp -vf $MASTERFILE $TMPFILE
    else
        echo "[$MASTERFILE] NOT found. create a template for [$MASTER]" >> $LOG_FILE
        create_template $MASTERFILE $MASTER 
    fi    
}

update_bondingfiles_redhat()
{
    #update slave config files    
    echo "Process slaves [$slaves] for [$master]" >> $LOG_FILE
    for slave in $slaves
    do
        echo "$slave" >> $skip_interface_names
        cslave=$slave
        while read line
        do
            if [ "x$slave" == "x`echo $line | awk '{print $1}'`" ]; then
                #mapping found, use backed up interface script and modify accordingly
                cslave=`echo $line | awk '{print $2}'`
                echo "Map entry found for $slave(backup) maps with $cslave(current)" >> $LOG_FILE
            fi    
        done <$YASTGUI/net_map 
        update_slave $cslave $master
    done    
}

update_field_redhat()
{
    FILE="$1"
    PROP="$2"
    VAL="$3"
    echo "update_field_redhat() Invoked with FILE[$1] PROP[$2] VAL[$3]" >> $LOG_FILE

    #skip comment lines
    tmpfile="/tmp/tmpfile.$$"
    rm -f $tmpfile
    found=0
    while read line
    do
        echo $line | grep --quiet '^[[:blank:]]#'
        ret=$?
        if [ $ret -eq 0 ]; then
            echo $line >> $tmpfile
            continue
        fi
        echo $line | grep -w "$PROP"
        ret=$?
        if [ $ret -ne 0 ]; then
            echo $line >> $tmpfile
            continue
        fi
        #PROP matches
        echo "$PROP=$VAL" >> $tmpfile
        found=1
    done < $FILE
    mv $tmpfile $FILE
    if [ $found -eq 0 ]; then
        echo "$PROP=$VAL" >> $FILE
    fi

#    if [ "x`cat $FILE | grep -w $PROP`" != "x" ]; then
#        echo "PROP [$PROP] found in [$FILE]. Update it" >> $LOG_FILE
#        cat $FILE | awk -v PROP=$PROP -v VAL=$VAL -F"=" '{if ($1==PROP) {print PROP "=" VAL} else {print $0}}' > $TMPFILE           
#        mv $TMPFILE $FILE
#    else
#        echo "PROP [$PROP] not found in [$FILE]. Add it" >> $LOG_FILE
#        echo "$PROP=$VAL" >> $FILE
#    fi
}

update_ntwkconfig_file_redhat()
{
    if [ -n "$hasvlan" ]; then
        update_field $FILE BOOTPROTO none
    else
        if [ "$proto" != "dhcp" ]; then
            if [ "x$proto" == "xstatic" ]
            then
                update_field $FILE BOOTPROTO $proto
            else
                update_field $FILE BOOTPROTO none
            fi
            update_field $FILE GATEWAY $gw
            update_field $FILE NETWORK ""
            update_field $FILE IPADDR $ip
            update_field $FILE NETMASK $mask
        else
            update_field $FILE BOOTPROTO dhcp
            update_field $FILE IPADDR ""
            update_field $FILE NETMASK ""
            update_field $FILE GATEWAY ""
        fi    
    fi
    #In any case lets remove prefix.
    sed -i '/^PREFIX/d' $FILE
    #this is a deprecated field. just make it empty, so it wont have an old incorrect value
    update_field $FILE BROADCAST ""

    if [ $FLAG == "NOBOND" ]; then
        update_field $FILE HWADDR $mac
        update_field $FILE DEVICE $if
    fi    

	update_field $FILE ONBOOT yes
    if [ -n "$vlanid" ]; then
        update_field $FILE VLAN yes
        update_field $FILE PHYSDEV $TRANS_ACTNIC
        update_field $FILE VLAN_ID $vlanid
    fi
    #For RHEL, common network config file exists in /etc/sysconfig/network
    #Here is the catch - we need to do this only for the first avaialble NIC that has gw configured.
    #If this step is never done, then outside the script, just make sure to empty out this field 
    FILE=/tmp/MOUNTDIR/etc/sysconfig/network
    if [ "$proto" != "dhcp" -a "x$gw" != "x" ]; then
        echo "GATEWAY updated to [$gw] in [$FILE] for [$if] with proto[$proto]" >> $LOG_FILE
        update_field $FILE GATEWAY $gw
        GATEWAY_UPDATED=1
        export $GATEWAY_UPDATED
    fi
}

update_ntwkconfig_file_wrapper_redhat()
{
    #$ORGFILE="$NETCFG/ifcfg-$b_if"
    #NEWFILE="$NETCFG/ifcfg-$r_if"
    ORGFILE=""
    NEWFILE=""
    set_filenames_redhat $b_if $r_if $ifvlanid
    ORGFILE=$ORIG_NTWK_FILE
    NEWFILE=$NEW_NTWK_FILE
}

update_ntwkconfig_file_wrapper_finish_redhat()
{
    mv $ORGFILE $NEWFILE
}

create_ntwkconfig_file_redhat()
{
    #FILE="$NETCFG/ifcfg-$r_if"
    ORGFILE=""
    set_filenames_redhat $r_if $r_if $ifvlanid
    ORGFILE=$ORIG_NTWK_FILE

    update_ntwkconfig_file "NOBOND" $ORGFILE $r_if $r_ifmac
    update_field $ORGFILE ONBOOT yes
    update_field $ORGFILE USERCTL no
    if [ -z $ifvlanid -o x"$ifvlanid" == "x0" ]
    then
        update_field $ORGFILE TYPE Ethernet
    fi
}

finalise_config_redhat()
{
    FILE=/tmp/MOUNTDIR/etc/sysconfig/network
    if [ $GATEWAY_UPDATED -eq 0 ]; then
        echo "GATEWAY was NOT updated for any of the NICs - empty it out" >> $LOG_FILE
        update_field $FILE GATEWAY ""
    else
        echo "GATEWAY was updated for one of the NICs" >> $LOG_FILE
    fi
}
