#!/bin/bash

#Script Name: cloudp2v.sh
#Developer: Shivam Garg(shivamgarg)
#Goal: Enable 1-touch using proxy machine.


get_field_value()
{
    cat $1 | while read line
    do
        key=`echo $line | cut -d'=' -f1`
        value=`echo $line | cut -d'=' -f2-`
        if [ "$key" = "$2" ]; then
             echo $value
             Log "Extracted [$2] = [$value] from [$1]"
             break
        fi
    done
    echo""
}


#Mount all required mountpoints.
prepmount_cmd(){
   if [ -d $1 ]
   then
       mkdir -p $1/proc $1/sys $1/dev
       mount --bind /proc $1/proc
       mount --bind /sys $1/sys
       mount --bind /dev $1/dev
       if [ $? -ne 0 ]
       then
           mount -t devtmpfs devtmpfs $1/dev
           if [ $? -ne 0 ]
           then
               cp -a /dev $1
           fi
       fi
   fi

}

prepumount_cmd(){
   if [ -d $1 ]
   then
       umount $1/proc
       umount $1/sys
       umount $1/dev
   fi

}

Log(){

    DATE=`date +%D' '%H:%M:%S`
    echo "$DATE ${FUNCNAME[1]}@${BASH_SOURCE[0]} ${BASH_LINENO[0]}: $*" >> $LOG_FILE
}

Execute(){
    $*
    if [ $? -ne 0 ]
    then
        Log "Error:execution of '$*' failed" 
        exit 1
    fi
}

get_registry_value()
{
    cat $1| while read line
    do
       key=`echo $line| cut -d' ' -f1`
       if [ "$key" = "$2" ]
       then
           echo $line| awk '{print $2}'
           break
       fi
    done
}



invoke_monitor_restore()
{
    JOB_ID=`cat /tmp/JOBDETAILS-ID.$jobid`
    while [ 1 ];
    do
        jrstatus=`$GALAXY/Base/qlist job -co s -j $JOB_ID | tail -n 1`
        jstatus=`echo $jrstatus | tr -d [:blank:]`
        Log "status = [$jstatus]"
        pstatus=`$GALAXY/Base/qlist job -j $JOB_ID`
        Log "$pstatus"
        if [ "$jstatus" == "Running" -o "$jstatus" == "Pending" -o "$jstatus" == "Restore" ]; then
            sleep 10
        else
            echo $jstatus | grep -qi "fail"
            if [ $? -eq 0 ]; then
                Log "Job Failed [$jstatus]!"
                exit 3
            fi
            echo $jstatus | grep -qi "kill"
            if [ $? -eq 0 ]; then
                Log "Job Killed [$jstatus]!"
                exit 3
            fi
            echo $jstatus | grep -qi "suspend"
            if [ $? -eq 0 ]; then
                Log "Job Suspended [$jstatus]!"
                exit 3
            fi
            echo $jstatus | grep -qi "complete"
            if [ $? -eq 0 ]; then
                Log "Job Completed [$jstatus]"
                break
            fi
        fi
    done
}


JOBDIR=$1
proxy=$2
INSTANCE=$3
jobid=`basename $JOBDIR`
LOG_FILE="/tmp/cloudrestore.log"
#echo "/dev/xvdc /dev/sda" > $JOBDIR/cloudp2v_diskmap.txt

#INSTANCE=""
#JOBDIR=""
#jobid=""
#proxy=""
#LOG_FILE="/tmp/cloudrestore.log"
#while getopts ":i:d:j:p:" opt
#do
#    case $opt in
#        i)
#        INSTANCE=$OPTARG
#        ;;
#        d)
#        JOBDIR=$OPTARG
#        ;;
#        j)
#        jobid=$OPTARG
#        ;;
#        p)
#        proxy=$OPTARG
#        ;;
#    esac
#done


Log "Instance[$INSTANCE],JOBDIR[$JOBDIR],jobid[$jobid],proxy[$proxy]"
if [ -z $INSTANCE -o -z $JOBDIR -o -z $jobid -o -z $proxy ]
then
    Log "Error:Check arguments"
fi

mkdir -p $JOBDIR/tmp
echo "====CLOUDP2V STARTS====[`date`]=====" >> $JOBDIR/tmp/cvrestore.log

RESTART_LEVEL=`cat $JOBDIR/tmp/cloud_restart_level`
if [ x"$RESTART_LEVEL" == "x" ]
then
    RESTART_LEVEL=0
fi

file="/etc/CommVaultRegistry/Galaxy/$INSTANCE/Base/.properties"
if [ -f $file ]
then
    GALAXY=`get_registry_value $file "dGALAXYHOME"`
    BASEDIR=`get_registry_value $file "dBASEHOME"`
else
    Log "Could not find Registry file for Instance[$INSTANCE]"
    exit 1
fi
SYSDIR=$GALAXY/iDataAgent/systemrecovery
LOGDIR=`get_registry_value /etc/CommVaultRegistry/Galaxy/$INSTANCE/EventManager/.properties "dEVLOGDIR"`
LOG_FILE=$LOGDIR/srp2v.log
mkdir -p $JOBDIR

if [ ! -f $JOBDIR/onetouchresponse.xml ]
then
    Log "$JOBDIR/onetouchresponse.xml does not exist!"
    exit 1
fi

cp -r $SYSDIR/bootimage/INITRD/* $JOBDIR/.
cp $SYSDIR/partinfo $JOBDIR/.
cp $SYSDIR/common_funcs.sh $JOBDIR/.
cp $SYSDIR/storage_enumeration_funcs.sh $JOBDIR/.
#For load binary we need two libraries ./libCvCxx.so and ./libstdc++.so.6 from base folder
cp $BASEDIR/libCvCxx.so $JOBDIR/.
cp $BASEDIR/libstdc++.so.6 $JOBDIR/.
#for onetouchutil we need following libraries:
cp $BASEDIR/libQiNetwork.so $JOBDIR/.
cp $BASEDIR/libcv_xerces-c-26.so $JOBDIR/.
cp $BASEDIR/libQiUtils.so $JOBDIR/.
cp $BASEDIR/libCvLib.so $JOBDIR/.
Execute "chmod +x $JOBDIR/*"
#Create Flag to know that it is cloud VME
touch $JOBDIR/cloud_flag

#Use onetouchresponse.xml to create folder /tmp/yastgui and then copy it in $JOBDIR
rm -rf /tmp/yastgui
Execute "python $JOBDIR/response.py $JOBDIR/onetouchresponse.xml"

mkdir -p $JOBDIR/tmp/yastgui
rm -rf $JOBDIR/tmp/yastgui/*
cp -r /tmp/yastgui/* $JOBDIR/tmp/yastgui/

YASTGUI="$JOBDIR/tmp/yastgui"
CLIENTDETAILS="$YASTGUI/client"
CSDETAILS="$YASTGUI/csdetails"

CFG_FILE=$JOBDIR/tmp/NETDETAILS

if [ $RESTART_LEVEL -lt 1 ]
then

    if [ -e $CSDETAILS ]; then
        csname=`get_field_value ${CSDETAILS} CSHOST`
        cs_display_name=`get_field_value ${CSDETAILS} CSNAME`
        csip=`get_field_value ${CSDETAILS} CSIP`
        maname=`get_field_value ${CSDETAILS} MA`
        maip=`get_field_value ${CSDETAILS} MAIP`
        fwon=`get_field_value ${CSDETAILS} FWON`
        cuname=`cat ${CSDETAILS} | grep CSUSER | cut -d '=' -f 2`
        cpasswd=`cat ${CSDETAILS} | grep CSPASS | cut -d '=' -f 2-`
        cencpasswd=`get_field_value ${CSDETAILS} CSENCPASS`
        cname=`get_field_value ${CLIENTDETAILS} CNAME`
        chname=`get_field_value ${CLIENTDETAILS} HOSTNAME`
        newcname=`get_field_value ${CLIENTDETAILS} NEWCNAME`
        newchname=`get_field_value ${CLIENTDETAILS} NEWHOSTNAME`
    fi


    #Create the file /tmp/NETDETAILS to be used by first stage as well as second stage of recovery
    echo "CSNAME $csname">$CFG_FILE
    echo "CLIENTNAME $cname" >>$CFG_FILE
    echo "CLIENTHOSTNAME $chname">>$CFG_FILE
    echo "NEWCLIENTNAME $newcname">>$CFG_FILE
    echo "NEWCLIENTHOSTNAME $newchname">>$CFG_FILE
    echo "CSUSER $cuname">>$CFG_FILE
    echo "CSPASSWD $cpasswd">>$CFG_FILE
    echo "ENCPASSWD $cencpasswd">>$CFG_FILE
    echo "CSDISPLAYNAME $cs_display_name">>$CFG_FILE
    echo "FWON $fwon">>$CFG_FILE

# Phase 1 Recovery(Recover bootcd.tar.gz from client machine)

    cd $JOBDIR
    CSUSER=`cat $CFG_FILE | grep "CSUSER" | awk '{print $2}'`
    PASSWD=`cat $CFG_FILE | grep "CSPASSWD" | awk '{print $2}'`
    ENCPASSWD=`cat $CFG_FILE | grep "ENCPASSWD" | awk '{print $2}'`
    CSPASSWD=""
    if [ "x$ENCPASSWD" ==  "x" ]; then
        if [ "x$PASSWD" == "x" ]; then
            PARG=" -p "
        else
            if [ ! -e ./onetouchutil ]; then
                cp -r SYSDIR/bootimage/INITRD/onetouchutil .
            fi
            CSPASSWD=`./onetouchutil encrypt "$PASSWD"`
        fi
    else
        CSPASSWD=$ENCPASSWD
    fi
    if [ -n "$CSPASSWD" ]; then
        PARG=" -ps $CSPASSWD"
    fi
    #If the password conatins " then add a escape sequence to that.
    CSPASSWD=`echo $CSPASSWD | sed 's/"/\\\"/g'`

    #FIXME:
    retryCt=2
    ${GALAXY}/Base/qlogout
    qloginSuccess=0
    while [ $retryCt -ge 0 ];
    do
        Log "qlogin -u $CSUSER -ps $CSPASSWD"
        ${GALAXY}/Base/qlogin -u "$CSUSER" -ps "$CSPASSWD"
        ret=$?
        if [ $ret -eq 0 ]; then
            Log "Succesfully logged in to Comm server"
            qloginSuccess=1
            break
        else
            retryCt=$((retryCt-1))
            Log "qlogin failed. retryCt = [$retryCt]"
            sleep 60
        fi
    done

    #exit 1

    #qlogin Done


    #Create fullsys.xml now for bootcd.tar.gz
    Log "Now restore /tmp/bootcd.tar.gz from client"
    echo "/tmp/bootcd.tar.gz" > $JOBDIR/tmp/srcpaths

    COPYPRECFILE=$YASTGUI/copyprecendence
    CLIENT_NAME=$(cat $CFG_FILE | grep -w "CLIENTNAME" | awk '{print $2}')
    #NEWCLIENT_NAME=`cat $CFG_FILE | grep -w "NEWCLIENTNAME" | awk '{print $2}'`
    NEWCLIENT_NAME=$proxy
    CS_NAME=`cat $CFG_FILE | grep -w "CSNAME" | awk '{print $2}'`
    if [ -f $COPYPRECFILE ]
    then
        COPYPREC=`cat $COPYPRECFILE`
    fi
    Log "CLIENT_NAME: $CLIENT_NAME,CS_NAME: $CS_NAME"
    if [ "x$COPYPREC" == "x" ]; then
        COPYPREC=-1
    fi

    if [ -e $YASTGUI/backupsetname ]; then
        bsn=`cat $YASTGUI/backupsetname`
        echo "Extract backupsetname[$bsn] from [$YASTGUI/backupsetname]" >> $LOG_FILE
    fi
    if [ -e "$bsn" ]; then
        bsn="defaultBackupSet"
    fi    
    DESTDIR=$JOBDIR
    #FIXME: How to get time and proxy client name!!
    cd $JOBDIR

    browseTimeFile=$YASTGUI/browseTime
    if [ ! -f $YASTGUI/browseTime ]
    then
        Log " Obtaining list of system state backup job. Please Wait!!"
        Log "qlist jobhistory -c $CLIENT_NAME -b $bsn -a Q_LINUX_FS -optype SystemState -dispJobTime"
        ${GALAXY}/Base/qlist jobhistory -c $CLIENT_NAME -b $bsn -a Q_LINUX_FS -optype SystemState -dispJobTime > /$JOBDIR/tmp/joblist01
        Log "`cat /$JOBDIR/tmp/joblist01`"
        if [ $? -ne 0 ]; then
            Log "Failed to retrieve list of system state jobs!"
            exit 1
        fi

        Log "Obtained list of system state backup jobs. Processing them now..."
        cat $JOBDIR/tmp/joblist01 | grep ^[0-9] | grep Completed | grep -iv error | tr -s / - | awk '{print $6,$7,$1,$8,$9}' > $JOBDIR/tmp/joblist02
        sort -nr $JOBDIR/tmp/joblist02 > $JOBDIR/tmp/joblist03
        totime=`head -n 1 $JOBDIR/tmp/joblist03|cut -d' ' -f4-5| tr -s - /`
        d=`echo $totime|cut -f1 -d' '|cut -f3 -d'/'`
        m=`echo $totime|cut -f1 -d' '|cut -f2 -d'/'`
        y=`echo $totime|cut -f1 -d' '|cut -f1 -d'/'`
        echo "[browseto]\n" > $YASTGUI/browseTime
        echo "$m/$d/$y `echo $totime|cut -f2 -d' '`" > $YASTGUI/browseTime
    fi

    Log "LD_LIBRARY_PATH=$BASEDIR $JOBDIR/createqcmd_xml -n 0 -s $CLIENT_NAME -d $NEWCLIENT_NAME -c $CS_NAME -p $COPYPREC -i $JOBDIR/tmp/srcpaths -o $DESTDIR -b $bsn -t \"`cat $YASTGUI/browseTime|tail -n 1`\""
    LD_LIBRARY_PATH=$BASEDIR $JOBDIR/createqcmd_xml -n 0 -s $CLIENT_NAME -d $NEWCLIENT_NAME -c $CS_NAME -p $COPYPREC -i $JOBDIR/tmp/srcpaths -o $DESTDIR -b $bsn -t "`cat $YASTGUI/browseTime|tail -n 1`"
    if [ $? -ne 0 ]
    then
        Log " createqcmdxml failed!!"
        exit 1
    fi
    mv /qcmd_xml $JOBDIR/fullsys.xml

    #FIXME:
    retryCt=2

    if [ -f $JOBDIR/fullsys.xml ]; then
        echo "Using XML fullsys.xml to invoke restore of bootcd!" >> $LOG_FILE
        ${GALAXY}/Base/qoperation execute -af "$JOBDIR/fullsys.xml" > /tmp/qcmd_resp.$jobid
        retcode=$?
    fi    
    if [ $retcode -ne 0 ]; then
        echo "FS restore failed.1-Touch restore cannot proceed"
        echo "FS restore failed. qoperation returned [$retcode]. 1-Touch restore cannot proceed" >> $LOG_FILE
        exit 10 
    fi 

    cat /tmp/qcmd_resp.$jobid | grep "jobIds val" | head -n 1 | cut -d'"' -f2 >/tmp/JOBDETAILS-ID.$jobid

    echo "Will pause for the full system restore to complete" >> $LOG_FILE
    invoke_monitor_restore
    #cat /tmp/qcmd_resp | grep "jobIds" | head -n 1 | cut -d'>' -f2 | cut -d'<' -f1 >/tmp/JOBDETAILS-ID.$jobid


    #Hoping bootcd.tar.gz is copied!

    Execute "tar -zxvf $JOBDIR/bootcd.tar.gz"

    initrd_path=$JOBDIR/initrd.img
    if [ ! -f $initrd_path ]
    then
        initrd_path=$JOBDIR/tmp/initrd.img
    fi
    Log "Arch[`cat $JOBDIR/tmp/ARCH`]"
    mkdir -p $JOBDIR/backup_kernel
    cp -f $initrd_path $JOBDIR/initrd.img
    cd $JOBDIR
    mv $initrd_path $JOBDIR/initrd.cpio.gz
    gunzip initrd.cpio.gz
    cpio -dui < initrd.cpio
    if [ $? -ne 0 ]
    then
        Log "Extraction of initrd content from cpio archieve failed!!"
        exit 1
    fi
    rm -f initrd.cpio
    Log "Sucessfully extracted the content from backup system"

    #done with stage 1 and my patience!!!
    RESTART_LEVEL=4
    echo $RESTART_LEVEL > $JOBDIR/tmp/cloud_restart_level
fi

if [ $RESTART_LEVEL -lt 5 ]
then
    prepmount_cmd $JOBDIR

    #Addition Phase 1.5

        which vgs
        if [ $? -eq 0 ]
        then
            vgs --noheadings|awk '{print $1}' >  $JOBDIR/proxyvg
        fi

    #Phase 2 starts

    chroot $JOBDIR /bin/bash -c "PATH=$PATH:/bin:/sbin;./srprecompare.sh"
    if [ $? -ne 0 ]
    then
        Log "srprecompare failed!!"
        exit 1
    fi
    chroot $JOBDIR ./bin/bash -c "PATH=$PATH:/bin:/sbin;./srcompare.sh"
    if [ $? -ne 0 ]
    then
        Log "srcompare failed!!"
        exit 1
    fi
    chroot $JOBDIR ./bin/bash -c "PATH=$PATH:/bin:/sbin;ln -s /proc/mounts /etc/mtab;./storage_recreate.sh"
    if [ $? -ne 0 ]
    then
        Log "storage_recreate failed!!"
        exit 1
    fi
    RESTART_LEVEL=5
    echo $RESTART_LEVEL > $JOBDIR/tmp/cloud_restart_level
fi

if [ $RESTART_LEVEL -lt 6 ]
then
    echo "/" > $JOBDIR/tmp/srcpaths
    cat $JOBDIR/disk_lvm_files/snapmnt.lst >> $JOBDIR/tmp/mountpoints_to_exclude.lst


    COPYPRECFILE=$YASTGUI/copyprecendence
    CLIENT_NAME=$(cat $CFG_FILE | grep -w "CLIENTNAME" | awk '{print $2}')
    #NEWCLIENT_NAME=`cat $CFG_FILE | grep -w "NEWCLIENTNAME" | awk '{print $2}'`
    NEWCLIENT_NAME=$proxy
    CS_NAME=`cat $CFG_FILE | grep -w "CSNAME" | awk '{print $2}'`
    if [ -f $COPYPRECFILE ]
    then
        COPYPREC=`cat $COPYPRECFILE`
    fi
    Log "CLIENT_NAME: $CLIENT_NAME,CS_NAME: $CS_NAME"
    if [ "x$COPYPREC" == "x" ]; then
        COPYPREC=-1
    fi

    if [ -e $YASTGUI/backupsetname ]; then
        bsn=`cat $YASTGUI/backupsetname`
        echo "Extract backupsetname[$bsn] from [$YASTGUI/backupsetname]" >> $LOG_FILE
    fi
    if [ -e "$bsn" ]; then
        bsn="defaultBackupSet"
    fi


    DESTDIR=$JOBDIR/tmp/MOUNTDIR
    Log "LD_LIBRARY_PATH=$BASEDIR ./createqcmd_xml -n 1 -s $CLIENT_NAME -d $NEWCLIENT_NAME -c $CS_NAME -p $COPYPREC -i $JOBDIR/tmp/srcpaths -x $JOBDIR/tmp/mountpoints_to_exclude.lst -o $DESTDIR -b $bsn -t `cat $YASTGUI/browseTime|tail -n 1`"
    LD_LIBRARY_PATH=$BASEDIR $JOBDIR/createqcmd_xml -n 1 -s $CLIENT_NAME -d $NEWCLIENT_NAME -c $CS_NAME -p $COPYPREC -i $JOBDIR/tmp/srcpaths -x $JOBDIR/tmp/mountpoints_to_exclude.lst -o $DESTDIR -b $bsn -t "`cat $YASTGUI/browseTime|tail -n 1`"
    if [ $? -ne 0 ]
    then
        Log "createqcmd_xml failed!!!"
        exit 1
    fi
    mv /qcmd_xml $JOBDIR/fullsys.xml

    #FIXME:
    retryCt=2

    if [ -f $JOBDIR/fullsys.xml ]; then
        echo "Using XML fullsys.xml to invoke restore" >> $LOG_FILE
        ${GALAXY}/Base/qoperation execute -af "$JOBDIR/fullsys.xml" > /tmp/qcmd_resp.$jobid
        retcode=$?
    fi    
    if [ $retcode -ne 0 ]; then
        echo "FS restore failed.1-Touch restore cannot proceed"
        echo "FS restore failed. qoperation returned [$retcode]. 1-Touch restore cannot proceed" >> $LOG_FILE
        exit 10 
    fi 

    cat /tmp/qcmd_resp.$jobid | grep "jobIds val" | head -n 1 | cut -d'"' -f2 >/tmp/JOBDETAILS-ID.$jobid

    echo "Will pause for the full system restore to complete" >> $LOG_FILE
    invoke_monitor_restore
    #cat /tmp/qcmd_resp | grep "jobIds" | head -n 1 | cut -d'>' -f2 | cut -d'<' -f1 >/tmp/JOBDETAILS-ID.$jobid

    chroot $JOBDIR /bin/bash -c "PATH=$PATH:/bin:/sbin;./installbootloader.sh"
    if [ $? -ne 0 ]
    then
        Log "installbootloader failed!Check cvrestore.log for more details"
        exit 1
    fi

    chroot $JOBDIR /bin/bash -c "PATH=$PATH:/bin:/sbin;./postrestore.sh"
    if [ $? -ne 0 ]
    then
        Log "postrestore failed!Check cvrestore.log for more details"
        exit 1
    fi
    prepumount_cmd $JOBDIR

    RESTART_LEVEL=7
    echo $RESTART_LEVEL > $JOB_DIR/tmp/cloud_restart_level
fi

if [ $RESTART_LEVEL -lt 8 ]
then
    chroot $JOBDIR /bin/bash -c "PATH=$PATH:/bin:/sbin;./set_net_cloud.sh"
    RESTART_LEVEL=8
    echo $RESTART_LEVEL > $JOB_DIR/tmp/cloud_restart_level
fi
 
if [ $RESTART_LEVEL -lt 10 ]
then
    SYS_STATE_LOC=$JOBDIR/system_state/sysconf/
    new_client=`cat $JOBDIR/tmp/NETDETAILS | grep -w NEWCLIENTNAME | awk '{print $2}'`
    new_hname=`cat $JOBDIR/tmp/NETDETAILS | grep -w NEWCLIENTHOSTNAME | awk '{print $2}'`
    org_client=`cat $JOBDIR/tmp/NETDETAILS | grep -w CLIENTNAME | awk '{print $2}'`
    org_hname=`cat $JOBDIR/tmp/NETDETAILS | grep -w CLIENTHOSTNAME | awk '{print $2}'`
    cs_name=`cat $JOBDIR/tmp/NETDETAILS | grep -w CSDISPLAYNAME | awk '{print $2}'`
    cs_hname=`cat $JOBDIR/tmp/NETDETAILS | grep -w CSNAME | awk '{print $2}'`
    instance=`grep sCSCLIENTNAME $JOBDIR/tmp/MOUNTDIR/etc/CommVaultRegistry/ -rnw | grep $cs_name | awk -F"MOUNTDIR" '{print $2}' |awk -F "/" '{print $5}'`
    echo "For CS: [$cs_name] Instance: [$instance] New_CLIENT [$new_client] new_hname [$new_hname] org_client[$org_client] org_hname[$org_hname] cs_name[$cs_name] cs_hname[$cs_hname]" >> $LOG_FILE
    if [ ! -f $JOBDIR/tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties ]; then
        Log "invalid instance, fallback to Instance001" >> $LOG_FILE
        instance="Instance001"
    fi
    basedir=`cat $JOBDIR/tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties | grep dBASEHOME | awk '{print $2}'`
    galaxyhome=`cat $JOBDIR/tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Base/.properties | grep dGALAXYHOME | awk '{print $2}'`
    xmlfile="$JOBDIR/tmp/MOUNTDIR/$galaxyhome/Base/PreImageModeFile.xml"
    localbdir="${GALAXY}/Base"
    if [ ! -e $xmlfile ]; then
        # If the PreImageModeFile is not present, we should pick it from from what we generated in system state. From v11 SP9, unix installer deletes the file after client has been registered
        cp $SYS_STATE_LOC/PreImageModeFile.xml $xmlfile
        if [ -e $xmlfile ]; then
            echo "Found PreImageModeFile in system state" >> $LOG_FILE
        else
            echo "Did not find PreImageModeFile in system state" >> $LOG_FILE

            # For older backups if generation of PreImageModeFile fails, let us see if an older name style file exists and use it
            if [ -e "$JOBDIR/tmp/MOUNTDIR/$galaxyhome/ic.xml" ]; then
                cp $JOBDIR/tmp/MOUNTDIR/$galaxyhome/ic.xml $JOBDIR/tmp/MOUNTDIR/$galaxyhome/Base/PreImageModeFile.xml
            fi
        fi
    fi

    if [ -z "$new_hname" ]; then
        echo "NEWCLIENTHOSTNAME is not set. Use old host name" >> $LOG_FILE
        new_hname=$org_hname
        echo "Use hostname [$new_hname]" >> $LOG_FILE
    else
        echo "Use hostname [$new_hname]" >> $LOG_FILE
    fi

    echo "Extracted: basedir=[$basedir] galaxyhome=[$galaxyhome] xmlfile=[$xmlfile]" >> $LOG_FILE
#    echo "Copy reg instance from /tmp/MOUNTDIR to current registry if its differnt" >> $LOG_FILE
#    if [ "x$instance" != "xInstance001" ]; then
#        #echo "cmd: cp -a /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance /etc/CommVaultRegistry/Galaxy" >> $LOG_FILE
#        #cp -a /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance /etc/CommVaultRegistry/Galaxy
#        echo "Update Instance# [$instance] in xml file for registration purpose.." >>$LOG_FILE
#        sed -i "s/$instance/Instance001/" $JOBDIR/tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
#        fi

    CSUSER=`cat $JOBDIR/tmp/NETDETAILS | grep "CSUSER" | awk '{print $2}'`
    CSPASS=`cat $JOBDIR/tmp/NETDETAILS | grep "CSPASSWD" | awk '{print $2}'`
    ENCPASSWD=`cat $JOBDIR/tmp/NETDETAILS | grep "ENCPASSWD" | awk '{print $2}'`
    PASS=""
    if [ "x$ENCPASSWD" != "x" ]; then
        PASS=$ENCPASSWD
    elif [ "x$CSPASS" != "x" ]; then
        cd $BASEDIR
        if [ ! -e ./onetouchutil ]; then
            cp /onetouchutil .
        fi
        PASS=`./onetouchutil encrypt "$CSPASS"`
        if [ $? -ne 0 ]; then
            echo "Failed to encrypt password field CSPASSWD from /tmp/NETDETAILS"
            exit 1
        fi
        cd -
    fi
    if [ "x$PASS" != "x" ]; then
        ARG=" -password $PASS -passwordEncrypted"
    else
        ARG=""
    fi
    fwfile="/tmp/yastgui/firewall-configblob"
    FWON=`get_field_value $CSDETAILS "FWON"`

    if [ -f $YASTGUI/clientgroup ]
    then
        cg=`cat $YASTGUI/clientgroup`
        echo "Will attempt to add client to group[$cg]" >> $LOG_FILE
        cgarg=" -ClientGroup $cg "
    fi
    if [ ! -e $JOBDIR/tmp/yastgui/cloneclient ]
    then
       echo "" >> $LOG_FILE
       echo "/tmp/yastgui/cloneclient NOT present. No clone operation performed!" >> $LOG_FILE
        echo "Need to register original client again, after revoking original client's certificates" >> $LOG_FILE
        echo "Register : client name [$org_client] hostname [$new_hname]" >> $LOG_FILE
        if [ ! -e $xmlfile ]; then
            echo "Package xml file not found! Cannot proceed with registration of original client...!!!" >> $LOG_FILE
            exit 1
        else
            #revoke
          cat > $JOBDIR/revoke.xml << EOF
<App_RevokeClientCertificateRequest>
    <client>
        <GUID></GUID>
        <clientName></clientName>
    </client>
</App_RevokeClientCertificateRequest>

EOF
            sed -i "s#<clientName></clientName>#<clientName>$org_client</clientName>#" $JOBDIR/revoke.xml
            echo "revoke.xml modified to.." >> $LOG_FILE
            cat $JOBDIR/revoke.xml >> $LOG_FILE
            echo "---" >> $LOG_FILE
            $localbdir/qoperation execute -af $JOBDIR/revoke.xml
            if [ $? -ne 0 ]; then
                echo "Error! Failed to revoke certificate for [$org_client]" >> $LOG_FILE
                exit 1
            else
                echo "Revoked certificates for [$org_client]" >> $LOG_FILE
            fi

            echo "CMD: $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $org_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath /tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF" >> $LOG_FILE
            $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $org_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output $JOBDIR/tmp/Output_cloning.xml -sourceClient $org_client -regpath $JOBDIR/tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF
            ret=$?
            if [ $ret -ne 0 ] ; then
                if [ -e $fwfile -o "$FWON" == "true" ]; then
                    echo "registration failed, attempt again after starting services" >> $LOG_FILE
                    simpana start
                    sleep 10
                    $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $org_client -ClientHostName $new_hname -overwriteClientInfo -resetNetworkPassword -output $JOBDIR/tmp/Output_cloning.xml -sourceClient $proxy -regpath /tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF
                    ret=$?
                fi
            fi
            if [ $? -ne 0 ]; then
                echo "SIMCallWrapper failed! Could not re-register client!!!" >> $LOG_FILE
                sed -i "s/Instance001/$instance/" /tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
                exit 1
            else
                echo "SIMCallWrapper succeess! re-registered client..." >> $LOG_FILE
                sed -i "s/Instance001/$instance/" /tmp/MOUNTDIR/$basedir/PreImageModeFile.xml
            fi
        fi
    else
        Log "Clone client is called!Create a new client with name[$new_client] and hostname[$new_hname]!!"
        echo "sPreImageFile $basedir/PreImageModeFile.xml" >> /tmp/MOUNTDIR/etc/CommVaultRegistry/Galaxy/$instance/Session/.properties
        echo "CMD: $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $new_client -ClientHostName $new_hname $cgarg -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath $JOBDIR/tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF" >> $LOG_FILE 
        if [ -n $cg ]
        then
            $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $new_client -ClientHostName $new_hname -ClientGroup "$cg" -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath $JOBDIR/tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF
        else
            $localbdir/SIMCallWrapper -OpType 1000 -user $CSUSER $ARG -instanceFor1Touch $instance -CSName $cs_name -CSHost $cs_hname -ClientName $new_client -ClientHostName $new_hname -ClientGroup -overwriteClientInfo -resetNetworkPassword -output /tmp/Output_cloning.xml -sourceClient $org_client -regpath $JOBDIR/tmp/MOUNTDIR/ -skipCertificateRevoke -enc 2GCGBFFGnFF6AFF6eFFGSFFGYFFG2FFGhFF6ZFFh9FF6AFFGBFFGCFFh9FFGSFFGeFFGCFFGBFFGnFF
        fi
       
        if [ $? -ne 0 ]; then
            echo "SIMCallWrapper failed! Could not clone client!!!" >> $LOG_FILE
            exit 1
        else
            echo "SIMCallWrapper succeess! Cloned client..." >> $LOG_FILE
        fi   
    fi

     # complete recovery job
     vm_percent 100

     RESTART_LEVEL=10
     echo $RESTART_LEVEL>$JOBDIR/tmp/cloud_restart_level
fi

if [ $RESTART_LEVEL -eq 10 ]
then

#    Temprary deactivate all swap and vgs
#    swapoff -a > /tmp/abc
#    vgchange -an >> /tmp/abc
    if [ -f $JOBDIR/tmp/storage_tree/VOL_MAP ]
    then
        while read line
        do
            vgname=`echo $line|awk '{print $2}'`
            vgname1=`echo $line|awk '{print $1}'`
            sed -i "s/$vgname1/$vgname/g" $JOBDIR/tmp/MOUNTDIR/etc/fstab
       done < $JOBDIR/tmp/storage_tree/VOL_MAP
    fi
    Log "1-Touch Recovery completed!!"
    Log "umounting all disks"
    mount |awk '{print $3}'|grep "/tmp/MOUNTDIR"|sort -nr>$JOBDIR/tmp/mountdir
    while read line
    do
        umount $line
    done < $JOBDIR/tmp/mountdir

    if [ -f $JOBDIR/destswap ]
    then
        while read line
        do
            swapoff $line
        done < $JOBDIR/destswap
    fi

    if [ -f $JOBDIR/tmp/storage_tree/VOL_MAP ]
    then
        while read line
        do
            vgname=`echo $line|awk '{print $2}'`
            vgname1=`echo $line|awk '{print $1}'`
            chroot $JOBDIR /bin/bash -c "PATH=$PATH:/bin/:/sbin;vgchange -an $vgname1"
#            chroot $JOBDIR /bin/bash -c "PATH=$PATH:/bin/:/sbin;vgrename $vgname1 $vgname"
#            if [ $? -ne 0 ]
#            then
#                Log "Volume group did not change properly($vgname1 --> $vgname)"
#                exit 1
#            fi
       done < $JOBDIR/tmp/storage_tree/VOL_MAP
    fi
fi
