/*
 * Decompiled with CFR 0.152.
 */
package net.bitform.oilink;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import net.bitform.oilink.BasicIO;
import net.bitform.oilink.FileChannelToBasicIO;
import net.bitform.oilink.FileToBasicIO;
import net.bitform.oilink.OILink;
import net.bitform.oilink.OILinkException;
import net.bitform.oilink.OILinkMessages;

public class OILinkCallback {
    private OILink oil = null;

    void setOILink(OILink oILink) {
        this.oil = oILink;
    }

    public void newFileInfo(int n, int n2, OILinkMessages.Association association, String string, String string2) throws IOException {
    }

    public CreateNewFileResponse createNewFile(int n, int n2, OILinkMessages.Association association, String string) throws IOException {
        return null;
    }

    public CreateTempFileResponse createTempFile() throws IOException {
        return null;
    }

    public OpenFileResponse openFile(OILinkMessages.OpenFileCallback.FileType fileType, String string) throws IOException {
        switch (fileType) {
            case INPUT: {
                File file;
                if (this.oil == null || this.oil.getInputDiectory() == null || !(file = new File(this.oil.getInputDiectory(), string)).exists()) break;
                return new OpenFileResponse(file);
            }
            case TEMPLATE: {
                File file;
                if (this.oil == null || this.oil.getTemplateDiectory() == null || !(file = new File(this.oil.getTemplateDiectory(), string)).exists()) break;
                return new OpenFileResponse(file);
            }
            case PATH: {
                File file = new File(string);
                if (!file.exists()) break;
                return new OpenFileResponse(file);
            }
            case OTHER: {
                break;
            }
        }
        return null;
    }

    public OILinkMessages.MarginText newPageResponse(long l) {
        return null;
    }

    public void pageInfoSlideNotes(long l, String[] stringArray) {
    }

    public void pageInfoVisibility(long l, Boolean bl) {
    }

    public class OpenFileResponse {
        private final BasicIO sink;

        public OpenFileResponse(BasicIO basicIO) {
            this.sink = basicIO;
        }

        public OpenFileResponse(FileChannel fileChannel) {
            this.sink = new FileChannelToBasicIO(fileChannel);
        }

        public OpenFileResponse(File file) throws IOException {
            if (!file.exists()) {
                throw new OILinkException("File passed to OpenFileResponse must exist");
            }
            this.sink = new FileToBasicIO(file, true);
        }

        public BasicIO getSink() {
            return this.sink;
        }
    }

    public class CreateTempFileResponse {
        private final BasicIO sink;

        public CreateTempFileResponse(BasicIO basicIO) {
            this.sink = basicIO;
        }

        public BasicIO getSink() {
            return this.sink;
        }
    }

    public class CreateNewFileResponse {
        private final BasicIO sink;
        private final String url;

        public CreateNewFileResponse(BasicIO basicIO, String string) {
            this.sink = basicIO;
            this.url = string;
        }

        public CreateNewFileResponse(FileChannel fileChannel, String string) {
            this.sink = new FileChannelToBasicIO(fileChannel);
            this.url = string;
        }

        public CreateNewFileResponse(File file, String string) throws IOException {
            this.sink = new FileToBasicIO(file, true);
            this.url = string;
        }

        public String getUrl() {
            return this.url;
        }

        public BasicIO getSink() {
            return this.sink;
        }
    }
}

