/*
 * Decompiled with CFR 0.152.
 */
package net.bitform.oilink;

import com.google.protobuf.ByteString;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bitform.oilink.BasicIO;
import net.bitform.oilink.ByteBufferToBasicIO;
import net.bitform.oilink.FileChannelToBasicIO;
import net.bitform.oilink.FileToBasicIO;
import net.bitform.oilink.OIHandle;
import net.bitform.oilink.OILinkCallback;
import net.bitform.oilink.OILinkErrorCode;
import net.bitform.oilink.OILinkException;
import net.bitform.oilink.OILinkFileIdResult;
import net.bitform.oilink.OILinkMessages;
import net.bitform.oilink.OILinkMonitor;
import net.bitform.oilink.OILinkSccErr;
import net.bitform.oilink.OILinkStatus;
import net.bitform.oilink.OILinkTimeoutException;
import net.bitform.oilink.OITVersion;

public class OILink
implements OILinkMonitor.ProcessOwner {
    public static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private Process nativeProcess;
    private int nativeProcessId;
    private OutputStream nativeCin;
    InputStream nativeCout;
    private boolean hasCredentials;
    private String username;
    private String password;
    Map<Integer, BasicIO> files = new HashMap<Integer, BasicIO>();
    int maxFileId = 0;
    OILinkCallback defaultCallback;
    OILinkCallback callback = null;
    static OILinkStatus status = null;
    static boolean printDebug = false;
    static boolean printDebugIo = false;
    static boolean noSourceCache = false;
    static boolean noSinkCache = false;
    static boolean redirectStdErr = false;
    static String[] additionalEnv = null;
    File outputDirectory = null;
    File inputDirectory = null;
    File templateDirectory = null;
    private long blockingReadTracker;
    private int age = 0;

    public OILink() throws IOException {
        this.hasCredentials = false;
        this.initInstance();
    }

    public OILink(String string, String string2) throws IOException {
        this.hasCredentials = true;
        this.username = string;
        this.password = string2;
        this.initInstance();
    }

    private void initInstance() throws IOException {
        this.nativeProcess = null;
        this.defaultCallback = new OILinkCallback();
        this.defaultCallback.setOILink(this);
        this.startProcess();
    }

    public static OILinkStatus init() {
        return OILink.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OILinkStatus init(String string) {
        File file;
        File file2;
        if (status != null && status.isAvailable()) {
            return status;
        }
        status = new OILinkStatus();
        redirectStdErr = System.getProperty("OILinkRedirectStderr") != null;
        printDebugIo = System.getProperty("OILinkPrintDebugIo") != null;
        boolean bl = printDebug = System.getProperty("OILinkPrintDebug") != null;
        if (printDebug) {
            redirectStdErr = true;
        }
        noSourceCache = System.getProperty("OILinkNoSourceCache") != null;
        boolean bl2 = noSinkCache = System.getProperty("OILinkNoSinkCache") != null;
        if (null == string) {
            string = System.getProperty("OILinkLocation");
        }
        File file3 = null;
        if (string == null) {
            try {
                file2 = new File(OILink.class.getProtectionDomain().getCodeSource().getLocation().toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException uRISyntaxException) {
                status.setProblem("The syntax of the URI to Outside In's JAR (" + OILink.class.getProtectionDomain().getCodeSource().getLocation() + ") is invalid");
                status.setAvailable(false);
                return status;
            }
            file3 = file2.getParentFile();
            file = new File(file3, "oit");
        } else {
            file = new File(string);
        }
        if (!file.exists() || !file.isDirectory()) {
            if (file3 == null) {
                status.setProblem("The default Outside In directory (" + file + ") does not exist");
                status.setAvailable(false);
                return status;
            }
            file = file3;
        }
        if (!(file2 = new File(file, isWindows ? "OILink.exe" : "oilink")).exists() || !file2.isFile()) {
            status.setProblem("The Outside In executable (" + file2 + ") does not exist");
            status.setAvailable(false);
            return status;
        }
        status.setExecutable(file2);
        OILink oILink = null;
        try {
            oILink = new OILink();
            if (oILink.nativeProcess != null) {
                status.setAvailable(true);
                status.setVersionInfo(oILink.getVersionInfo());
                OILinkStatus oILinkStatus = status;
                return oILinkStatus;
            }
            status.setProblem("Failed to start OILink executable");
        }
        catch (IOException iOException) {
            status.setProblem(iOException.getMessage());
        }
        finally {
            if (oILink != null) {
                oILink.endProcess();
            }
        }
        status.setAvailable(false);
        return status;
    }

    public static OILinkStatus getStatus() {
        return status;
    }

    public static synchronized void setAdditionalEnv(String[] stringArray) {
        additionalEnv = stringArray;
    }

    public void increaseAge(int n) {
        this.age += n;
    }

    public int getAge() {
        return this.age;
    }

    public boolean isAlive() {
        if (this.nativeProcess == null) {
            return false;
        }
        try {
            this.nativeProcess.exitValue();
            this.nativeProcess = null;
            this.closeNativeIO();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    @Override
    public void endProcess() {
        if (printDebug) {
            System.out.println("endProcess begin");
        }
        if (this.nativeProcess == null) {
            if (printDebug) {
                System.out.println("endProcess nativeProcess == null");
            }
            return;
        }
        try {
            this.nativeProcess.exitValue();
            this.nativeProcess = null;
            this.closeNativeIO();
            if (printDebug) {
                System.out.println("endProcess nativeProcess has exited");
            }
            return;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            block16: {
                block15: {
                    if (printDebug) {
                        System.out.println("endProcess sending Exit message");
                    }
                    try {
                        OILinkMessages.ToNative toNative = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXIT).build();
                        this.sendPBMessage(toNative);
                    }
                    catch (IOException iOException) {
                        if (!printDebug) break block15;
                        System.out.println("endProcess Exit send got exception " + iOException);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                try {
                    if (printDebug) {
                        System.out.println("endProcess checking exit value");
                    }
                    this.nativeProcess.exitValue();
                    if (printDebug) {
                        System.out.println("endProcess nativeProcess has exited");
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException2) {
                    this.nativeProcess.destroy();
                    if (!printDebug) break block16;
                    System.out.println("endProcess nativeProcess was destroyed");
                }
            }
            this.nativeProcess = null;
            this.closeNativeIO();
            return;
        }
    }

    private boolean checkReady() throws IOException {
        OILinkMessages.ToNative toNative = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.READY).build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.readPBMessage();
        if (toClient.getType() != OILinkMessages.ToClient.Type.READY) {
            if (printDebug) {
                System.out.println("OILink not ready");
            }
            throw new OILinkException("Ready message did not produce Ready response from native process, instead received " + toClient);
        }
        return true;
    }

    void startProcess() throws IOException {
        block19: {
            if (printDebug) {
                System.out.println("startProcess begin");
            }
            if (this.nativeProcess != null) {
                try {
                    this.nativeProcess.exitValue();
                    this.nativeProcess = null;
                    this.closeNativeIO();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (!printDebug) break block19;
                    System.out.println("OILink process still running, ok");
                }
            }
        }
        if (this.nativeProcess != null) {
            try {
                if (this.checkReady()) {
                    return;
                }
            }
            catch (IOException iOException) {
                if (printDebug) {
                    System.out.println("Killing OILink");
                }
                this.endProcess();
            }
        }
        if (this.nativeProcess == null) {
            this.startExe();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                OILinkMessages.ToClient toClient;
                int n = this.nativeProcess.exitValue();
                this.nativeProcess = null;
                if (this.hasCredentials && 1 == n) {
                    this.closeNativeIO();
                    throw new OILinkException("There was an error running oilink with sudo. This could be a configuration/permission problem or sudo cannot execute the oilink command");
                }
                if (!this.hasCredentials && 0 != n && (toClient = this.readPBMessage()).getType() == OILinkMessages.ToClient.Type.ERRORRESPONSE) {
                    this.closeNativeIO();
                    this.handleErrorMessage(toClient.getErrorResponse(), "startProcess");
                }
                this.closeNativeIO();
                throw new OILinkException("Failed to start the OILink native process " + status.getExecutable().getAbsolutePath() + " returned " + n);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                OILinkMessages.ToClient toClient = this.readPBMessage();
                if (toClient.getType() != OILinkMessages.ToClient.Type.IMHERE) {
                    if (toClient.getType() == OILinkMessages.ToClient.Type.ERRORRESPONSE) {
                        this.closeNativeIO();
                        this.handleErrorMessage(toClient.getErrorResponse(), "startProcess");
                    }
                    throw new OILinkException("Expected message " + OILinkMessages.ToClient.Type.IMHERE + " but received " + toClient + "from OILink native process");
                }
                this.nativeProcessId = toClient.getImHere().getProcessId();
            }
        }
        if (this.nativeProcess == null) {
            throw new OILinkException("Failed to start the OILink native process");
        }
        this.checkReady();
    }

    private void startExe() throws OILinkException {
        this.nativeCin = null;
        this.nativeCout = null;
        try {
            if (printDebug) {
                System.out.println("starting OILink");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.hasCredentials && !isWindows) {
                arrayList.add("sudo");
                arrayList.add("-n");
                arrayList.add("-k");
                arrayList.add("-u");
                arrayList.add(this.username);
            }
            arrayList.add(status.getExecutable().getAbsolutePath());
            if (printDebug) {
                arrayList.add("DEBUG");
            }
            if (printDebugIo) {
                arrayList.add("DEBUGIO");
            }
            if (noSourceCache) {
                arrayList.add("NOSOURCECACHE");
            }
            if (noSinkCache) {
                arrayList.add("NOSINKCACHE");
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Map<String, String> map = processBuilder.environment();
            if (!isWindows) {
                map.put("MALLOC_CHECK_", "2");
            }
            if (additionalEnv != null) {
                for (int i = 0; i < additionalEnv.length / 2; ++i) {
                    String string = additionalEnv[i * 2];
                    String string2 = additionalEnv[i * 2 + 1];
                    if (printDebug) {
                        System.out.println("Adding to OILink environment " + string + "=" + string2);
                    }
                    map.put(string, string2);
                }
            }
            this.nativeProcess = processBuilder.start();
            this.nativeCin = this.nativeProcess.getOutputStream();
            this.nativeCout = this.nativeProcess.getInputStream();
            if (redirectStdErr) {
                final InputStream inputStream = this.nativeProcess.getErrorStream();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StringBuilder stringBuilder = new StringBuilder();
                            int n = inputStream.read();
                            while (n != -1) {
                                if (n == 10) {
                                    System.err.println(stringBuilder.toString());
                                    stringBuilder.setLength(0);
                                } else if (n != 0 && n != 13) {
                                    stringBuilder.append((char)n);
                                }
                                n = inputStream.read();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }, "OILink stderr redirector").start();
            }
        }
        catch (IOException iOException) {
            throw new OILinkException("Cannot start the OILink process", iOException);
        }
        catch (SecurityException securityException) {
            throw new OILinkException("Cannot start the OILink process", securityException);
        }
    }

    void closeNativeIO() {
        if (this.nativeCin != null) {
            try {
                this.nativeCin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nativeCin = null;
        }
        if (this.nativeCout != null) {
            try {
                this.nativeCout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nativeCout = null;
        }
    }

    public int getIoIdForFile(BasicIO basicIO) throws IOException {
        int n = this.maxFileId++;
        this.files.put(n, basicIO);
        return n;
    }

    private OITVersion getVersionInfo() throws IOException {
        OITVersion oITVersion = null;
        OILinkMessages.ToNative toNative = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.COREVERSIONINFO).build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.readPBMessage();
        if (toClient.getType() == OILinkMessages.ToClient.Type.COREVERSIONRESPONSE) {
            OILinkMessages.CoreVersionInfo coreVersionInfo = toClient.getVersionInformation();
            oITVersion = new OITVersion(coreVersionInfo.getStrVersion(), coreVersionInfo.getBuildDate(), coreVersionInfo.getBuildTime());
        }
        return oITVersion;
    }

    private void respondToRead(OILinkMessages.IOReadBytes iOReadBytes) throws IOException {
        int n;
        int n2;
        if (printDebug) {
            System.out.println("Received Read message position:" + iOReadBytes.getPosition() + " count:" + iOReadBytes.getCount() + " id:" + iOReadBytes.getIoId());
        }
        if ((n2 = iOReadBytes.getIoId()) < 0 || !this.files.containsKey(n2)) {
            throw new IOException("ioId of " + n2 + " is out of range");
        }
        BasicIO basicIO = this.files.get(n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iOReadBytes.getCount());
        byteBuffer.order(ByteOrder.nativeOrder());
        try {
            n = basicIO.readAt(iOReadBytes.getPosition(), byteBuffer);
            if (n == -1) {
                n = 0;
            }
        }
        catch (EOFException eOFException) {
            n = 0;
        }
        byteBuffer.position(0);
        byteBuffer.limit(n);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.IODATA);
        builder.setIoData(OILinkMessages.IOData.newBuilder().setCount(n).setIoId(iOReadBytes.getIoId()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.sendBytes(byteBuffer);
    }

    private void respondToGetFileSize(OILinkMessages.JustIoId justIoId) throws IOException {
        int n = justIoId.getIoId();
        if (!this.files.containsKey(n)) {
            throw new IOException("ioId of " + n + " is out of range");
        }
        BasicIO basicIO = this.files.get(n);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.IOGETFILESIZERESPONSE);
        builder.setIoGetFileSizeResponse(OILinkMessages.IOGetFileSizeResponse.newBuilder().setSize(basicIO.getSize()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
    }

    private void handleNewFileInfo(OILinkMessages.NewFileInfoCallback newFileInfoCallback) throws IOException {
        block3: {
            if (printDebug) {
                System.out.println(newFileInfoCallback);
            }
            try {
                this.callback.newFileInfo(newFileInfoCallback.getParentOutputId(), newFileInfoCallback.getOutputId(), newFileInfoCallback.getAssociation(), newFileInfoCallback.hasPath() ? newFileInfoCallback.getPath() : null, newFileInfoCallback.hasUrl() ? newFileInfoCallback.getUrl() : null);
            }
            catch (IOException iOException) {
                if (!printDebug) break block3;
                iOException.printStackTrace();
            }
        }
    }

    private void respondToCreateNewFile(OILinkMessages.CreateNewFileCallback createNewFileCallback) throws IOException {
        OILinkCallback.CreateNewFileResponse createNewFileResponse;
        if (printDebug) {
            System.out.println(createNewFileCallback);
        }
        try {
            createNewFileResponse = this.callback.createNewFile(createNewFileCallback.getParentOutputId(), createNewFileCallback.getOutputId(), createNewFileCallback.getAssociation(), createNewFileCallback.hasPath() ? createNewFileCallback.getPath() : null);
        }
        catch (IOException iOException) {
            if (printDebug) {
                iOException.printStackTrace();
            }
            createNewFileResponse = null;
        }
        switch (createNewFileCallback.getAssociation()) {
            case COPY: {
                if (createNewFileResponse == null) break;
                throw new OILinkException("createNewFile with association of COPY is informational only and must return null");
            }
            case REQUIREDNAME: {
                if (createNewFileResponse != null) break;
                throw new OILinkException("createNewFile with association of REQUIREDNAME must return a CreateNewFileResponse object");
            }
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.CREATENEWFILERESPONSE);
        if (createNewFileResponse != null) {
            int n = this.maxFileId++;
            this.files.put(n, createNewFileResponse.getSink());
            builder.setCreateNewFileResponse(OILinkMessages.CreateNewFileResponse.newBuilder().setUseDefaults(false).setIoId(n).setUrl(createNewFileResponse.getUrl()));
        } else {
            builder.setCreateNewFileResponse(OILinkMessages.CreateNewFileResponse.newBuilder().setUseDefaults(true));
        }
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
    }

    private void respondToOpenFile(OILinkMessages.OpenFileCallback openFileCallback) throws IOException {
        OILinkCallback.OpenFileResponse openFileResponse;
        if (printDebug) {
            System.out.println(openFileCallback);
        }
        try {
            openFileResponse = this.callback.openFile(openFileCallback.getFileType(), openFileCallback.getFileName());
        }
        catch (IOException iOException) {
            if (printDebug) {
                iOException.printStackTrace();
            }
            openFileResponse = null;
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.OPENFILERESPONSE);
        if (openFileResponse != null) {
            int n = this.maxFileId++;
            this.files.put(n, openFileResponse.getSink());
            if (printDebug) {
                System.out.println("OPENFILECALLBACK returning ioId " + n);
            }
            builder.setOpenFileResponse(OILinkMessages.OpenFileResponse.newBuilder().setWasHandled(true).setIoId(n));
        } else {
            builder.setOpenFileResponse(OILinkMessages.OpenFileResponse.newBuilder().setWasHandled(false));
        }
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
    }

    private void respondToNewPage(OILinkMessages.NewPageCallback newPageCallback) {
        block5: {
            if (printDebug) {
                System.out.println(newPageCallback);
            }
            try {
                OILinkMessages.MarginText marginText = null;
                marginText = this.callback.newPageResponse(newPageCallback.getDwPageNumber());
                OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.NEWPAGECALLBACKRESPONSE);
                if (marginText != null) {
                    builder.setNewPageCallbackResponse(marginText);
                } else {
                    builder.setNewPageCallbackResponse(OILinkMessages.MarginText.newBuilder());
                }
                OILinkMessages.ToNative toNative = builder.build();
                this.sendPBMessage(toNative);
            }
            catch (IOException iOException) {
                if (!printDebug) break block5;
                iOException.printStackTrace();
            }
        }
    }

    private void respondToPageInfo(OILinkMessages.PageInfoCallback pageInfoCallback) {
        if (printDebug) {
            System.out.println(pageInfoCallback);
        }
        if (pageInfoCallback.hasSlidenotes()) {
            this.callback.pageInfoSlideNotes(pageInfoCallback.getDwPageNumber(), pageInfoCallback.getSlidenotes().split("\n"));
        }
        if (pageInfoCallback.hasBHidden()) {
            this.callback.pageInfoVisibility(pageInfoCallback.getDwPageNumber(), !pageInfoCallback.getBHidden());
        }
    }

    private void respondToCreateTempFile() throws IOException {
        OILinkCallback.CreateTempFileResponse createTempFileResponse;
        try {
            createTempFileResponse = this.callback.createTempFile();
        }
        catch (IOException iOException) {
            createTempFileResponse = null;
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.CREATENEWTEMPFILERESPONSE);
        if (createTempFileResponse != null) {
            int n = this.maxFileId++;
            this.files.put(n, createTempFileResponse.getSink());
            builder.setCreateNewTempFileResponse(OILinkMessages.CreateNewTempFileResponse.newBuilder().setIoId(n));
        } else {
            builder.setCreateNewTempFileResponse(OILinkMessages.CreateNewTempFileResponse.newBuilder());
        }
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
    }

    private void respondToGetFileInfo(OILinkMessages.JustIoId justIoId) throws IOException {
        Object object;
        int n = justIoId.getIoId();
        if (!this.files.containsKey(n)) {
            throw new IOException("ioId of " + n + " is out of range");
        }
        BasicIO basicIO = this.files.get(n);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.IOGETFILEINFORESPONSE);
        File file = basicIO.getUnderlyingFile();
        if (file != null) {
            builder.setIoGetFileInfoResponse(OILinkMessages.IOGetFileInfoResponse.newBuilder().setContainsPath(true).setPath(file.getCanonicalPath()).setContainsName(true).setName(file.getName()));
        } else {
            object = basicIO.getUnderlyingFileName();
            if (object != null) {
                builder.setIoGetFileInfoResponse(OILinkMessages.IOGetFileInfoResponse.newBuilder().setContainsPath(false).setContainsName(true).setName((String)object));
            } else {
                builder.setIoGetFileInfoResponse(OILinkMessages.IOGetFileInfoResponse.newBuilder().setContainsPath(false).setContainsName(false));
            }
        }
        object = builder.build();
        this.sendPBMessage((OILinkMessages.ToNative)object);
    }

    OILinkMessages.ToClient waitForMessage(OILinkMessages.ToClient.Type type, String string) throws IOException {
        if (printDebug) {
            System.out.println("waitForMessage BEGINS, waiting for " + type);
        }
        boolean bl = false;
        OILinkMessages.ToClient toClient = null;
        block15: while (!bl) {
            toClient = this.readPBMessage();
            if (printDebug) {
                System.out.println("waitForMessage receives " + toClient.getType());
            }
            if (toClient.getType() == type || type == OILinkMessages.ToClient.Type.IOWRITEBYTES && toClient.getType() == OILinkMessages.ToClient.Type.IODATAEOF) {
                bl = true;
                continue;
            }
            switch (toClient.getType()) {
                case IOWRITEBYTES: {
                    Object object;
                    OILinkMessages.IOWriteBytes iOWriteBytes = toClient.getIoWriteBytes();
                    if (!this.files.isEmpty() && this.files.containsKey(iOWriteBytes.getIoId())) {
                        if (printDebug) {
                            System.out.println("   received " + iOWriteBytes.getCount() + " bytes for position " + iOWriteBytes.getPosition() + " to ioId " + iOWriteBytes.getIoId());
                        }
                        object = this.readBytes(iOWriteBytes.getCount());
                        this.files.get(iOWriteBytes.getIoId()).writeAt(iOWriteBytes.getPosition(), (ByteBuffer)object);
                        continue block15;
                    }
                    throw new IllegalArgumentException("IO id of " + iOWriteBytes.getIoId() + " is invalid");
                }
                case IODATAEOF: {
                    Object object = toClient.getIoDataEof();
                    if (!this.files.isEmpty() && this.files.containsKey(((OILinkMessages.IODataEof)object).getIoId())) {
                        this.files.get(((OILinkMessages.IODataEof)object).getIoId()).close();
                        this.files.remove(((OILinkMessages.IODataEof)object).getIoId());
                        continue block15;
                    }
                    throw new IllegalArgumentException("IO id of " + ((OILinkMessages.IODataEof)object).getIoId() + " is invalid");
                }
                case IOOPEN: {
                    OILinkMessages.JustIoId justIoId = toClient.getJustIoId();
                    if (this.files.containsKey(justIoId.getIoId())) {
                        this.files.get(justIoId.getIoId()).open();
                        continue block15;
                    }
                    throw new IllegalArgumentException("IO id of " + justIoId.getIoId() + " is invalid");
                }
                case IOREADBYTES: {
                    OILinkMessages.IOReadBytes iOReadBytes = toClient.getIoReadBytes();
                    this.respondToRead(iOReadBytes);
                    continue block15;
                }
                case IOGETFILESIZE: {
                    this.respondToGetFileSize(toClient.getJustIoId());
                    continue block15;
                }
                case IOGETFILEINFO: {
                    this.respondToGetFileInfo(toClient.getJustIoId());
                    continue block15;
                }
                case NEWFILEINFOCALLBACK: {
                    this.handleNewFileInfo(toClient.getNewFileInfoCallback());
                    continue block15;
                }
                case CREATENEWFILECALLBACK: {
                    this.respondToCreateNewFile(toClient.getCreateNewFileCallback());
                    continue block15;
                }
                case CREATENEWTEMPFILECALLBACK: {
                    this.respondToCreateTempFile();
                    continue block15;
                }
                case OPENFILECALLBACK: {
                    this.respondToOpenFile(toClient.getOpenFileCallback());
                    continue block15;
                }
                case NEWPAGECALLBACK: {
                    this.respondToNewPage(toClient.getNewPageCallback());
                    continue block15;
                }
                case PAGEINFOCALLBACK: {
                    this.respondToPageInfo(toClient.getPageInfoCallback());
                    continue block15;
                }
                case ERRORRESPONSE: {
                    this.handleErrorMessage(toClient.getErrorResponse(), string);
                    continue block15;
                }
            }
            throw new OILinkException("waitForMessage received unexpected message -" + toClient.getType());
        }
        if (printDebug) {
            System.out.println("waitForMessage ENDS");
        }
        return toClient;
    }

    private void handleErrorMessage(OILinkMessages.ErrorResponse errorResponse, String string) throws OILinkException {
        if (errorResponse.getCode() == 65537) {
            if (printDebug) {
                System.out.println("Uncaught exception in OILINK, OILINK is exiting");
            }
            this.nativeProcess = null;
        }
        OILinkSccErr oILinkSccErr = OILinkSccErr.forId(errorResponse.getCode());
        throw new OILinkErrorCode("OI " + errorResponse.getMessage() + " - " + errorResponse.getError() + " [" + errorResponse.getCode() + "]", oILinkSccErr);
    }

    public ByteBuffer blockingRead() throws IOException {
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.IOWRITEBYTES, "blockingRead");
        if (toClient.getType() == OILinkMessages.ToClient.Type.IODATAEOF) {
            return null;
        }
        if (toClient.getType() != OILinkMessages.ToClient.Type.IOWRITEBYTES) {
            throw new OILinkException("Unexpected message '" + toClient.getType() + "'");
        }
        OILinkMessages.IOWriteBytes iOWriteBytes = toClient.getIoWriteBytes();
        if (iOWriteBytes.getPosition() != this.blockingReadTracker) {
            throw new OILinkException("Bytes received by blockingRead method not in order");
        }
        this.blockingReadTracker += (long)iOWriteBytes.getCount();
        if (!this.files.isEmpty() && this.files.containsKey(iOWriteBytes.getIoId())) {
            if (printDebug) {
                System.out.println("   received " + iOWriteBytes.getCount() + " bytes for position " + iOWriteBytes.getPosition() + " to ioId " + iOWriteBytes.getIoId());
            }
            return this.readBytes(iOWriteBytes.getCount());
        }
        throw new IllegalArgumentException("IO id of " + iOWriteBytes.getIoId() + " is invalid");
    }

    public OILinkMessages.DAGetObjectInfoResponse DAGetObjectInfo(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("DAGetObjectInfo BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("object parameter may not be null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAGETOBJECTINFO);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAGETOBJECTINFORESPONSE, "DAGetObjectInfo");
        if (printDebug) {
            System.out.println("DAGetObjectInfo END");
        }
        return toClient.getDaGetObjectInfoResponse();
    }

    public OIHandle DAOpenDocumentObject(OIHandle oIHandle, long l, long l2, long l3, long l4, long l5) throws IOException {
        if (printDebug) {
            System.out.println("DAOpenDocumentObject BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("parent parameter may not be null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAOPENDOCUMENTOBJECT);
        builder.setDaOpenDocumentObject(OILinkMessages.DAOpenDocumentObject.newBuilder().setParent(oIHandle.getHandle()).setType(l).setData1(l2).setData2(l3).setData3(l4).setData4(l5));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAOPENDOCUMENTRESPONSE, "DAOpenDocumentObject");
        if (printDebug) {
            System.out.println("DAOpenDocumentObject END");
        }
        return new OIHandle(toClient.getJustHandle().getHandle());
    }

    public OIHandle DAOpenDocument(ByteBuffer byteBuffer) throws IOException {
        return this.DAOpenDocument(new ByteBufferToBasicIO(byteBuffer), 0);
    }

    public OIHandle DAOpenDocument(FileChannel fileChannel) throws IOException {
        return this.DAOpenDocument(new FileChannelToBasicIO(fileChannel), 0);
    }

    public OIHandle DAOpenDocument(File file) throws IOException {
        return this.DAOpenDocument(new FileToBasicIO(file, false), 0);
    }

    public OIHandle DAOpenDocument(BasicIO basicIO) throws IOException {
        return this.DAOpenDocument(basicIO, 0);
    }

    public OIHandle DAOpenDocument(ByteBuffer byteBuffer, int n) throws IOException {
        return this.DAOpenDocument(new ByteBufferToBasicIO(byteBuffer), n);
    }

    public OIHandle DAOpenDocument(FileChannel fileChannel, int n) throws IOException {
        return this.DAOpenDocument(new FileChannelToBasicIO(fileChannel), n);
    }

    public OIHandle DAOpenDocument(File file, int n) throws IOException {
        return this.DAOpenDocument(new FileToBasicIO(file, false), n);
    }

    public OIHandle DAOpenDocument(BasicIO basicIO, int n) throws IOException {
        if (printDebug) {
            System.out.println("DAOpenDocument BEGIN");
        }
        if (basicIO == null) {
            throw new OILinkException("source parameter may not be null");
        }
        if (!basicIO.canRead()) {
            throw new OILinkException("source must be readable");
        }
        this.inputDirectory = basicIO.getUnderlyingFile();
        if (this.inputDirectory != null) {
            this.inputDirectory = this.inputDirectory.getParentFile();
        }
        int n2 = this.maxFileId++;
        this.files.put(n2, basicIO);
        if (printDebug) {
            System.out.println("Process: " + this.nativeProcessId + " File: " + basicIO);
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAOPENDOCUMENT);
        builder.setDaOpenDocument(OILinkMessages.DAOpenDocument.newBuilder().setIoId(n2).setFiId(n));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAOPENDOCUMENTRESPONSE, "DAOpenDocument");
        if (printDebug) {
            System.out.println("DAOpenDocument END");
        }
        return new OIHandle(toClient.getJustHandle().getHandle());
    }

    public void DAOpenNextDocument(OIHandle oIHandle, ByteBuffer byteBuffer) throws IOException {
        this.DAOpenNextDocument(oIHandle, new ByteBufferToBasicIO(byteBuffer), 0);
    }

    public void DAOpenNextDocument(OIHandle oIHandle, FileChannel fileChannel) throws IOException {
        this.DAOpenNextDocument(oIHandle, new FileChannelToBasicIO(fileChannel), 0);
    }

    public void DAOpenNextDocument(OIHandle oIHandle, File file) throws IOException {
        this.DAOpenNextDocument(oIHandle, new FileToBasicIO(file, false), 0);
    }

    public void DAOpenNextDocument(OIHandle oIHandle, BasicIO basicIO) throws IOException {
        this.DAOpenNextDocument(oIHandle, basicIO, 0);
    }

    public void DAOpenNextDocument(OIHandle oIHandle, ByteBuffer byteBuffer, int n) throws IOException {
        this.DAOpenNextDocument(oIHandle, new ByteBufferToBasicIO(byteBuffer), n);
    }

    public void DAOpenNextDocument(OIHandle oIHandle, FileChannel fileChannel, int n) throws IOException {
        this.DAOpenNextDocument(oIHandle, new FileChannelToBasicIO(fileChannel), n);
    }

    public void DAOpenNextDocument(OIHandle oIHandle, File file, int n) throws IOException {
        this.DAOpenNextDocument(oIHandle, new FileToBasicIO(file, false), n);
    }

    public void DAOpenNextDocument(OIHandle oIHandle, BasicIO basicIO, int n) throws IOException {
        if (printDebug) {
            System.out.println("DAOpenNextDocument BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("hdoc parameter may not be null");
        }
        if (basicIO == null) {
            throw new OILinkException("source parameter may not be null");
        }
        if (!basicIO.canRead()) {
            throw new OILinkException("source must be readable");
        }
        this.inputDirectory = basicIO.getUnderlyingFile();
        if (this.inputDirectory != null) {
            this.inputDirectory = this.inputDirectory.getParentFile();
        }
        int n2 = this.maxFileId++;
        this.files.put(n2, basicIO);
        if (printDebug) {
            System.out.println("Process: " + this.nativeProcessId + " File: " + basicIO);
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAOPENNEXTDOCUMENT);
        builder.setDaOpenNextDocument(OILinkMessages.DAOpenNextDocument.newBuilder().setHandle(oIHandle.getHandle()).setIoId(n2).setFiId(n));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DAOpenNextDocument");
        if (printDebug) {
            System.out.println("DAOpenNextDocument END");
        }
    }

    public OIHandle DAOpenSubdocumentById(OIHandle oIHandle, int n, int n2) throws IOException {
        if (printDebug) {
            System.out.println("DAOpenSubdocumentById BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DAOpenSubdocumentById called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAOPENSUBDOCUMENTBYID);
        builder.setDaOpenSubdocumentById(OILinkMessages.DAOpenSubdocumentById.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setFlags(n2));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAOPENSUBDOCUMENTBYIDRESPONSE, "DAOpenSubdocumentById");
        if (printDebug) {
            System.out.println("DAOpenSubdocumentById END");
        }
        return new OIHandle(toClient.getJustHandle().getHandle());
    }

    public void DASaveInputObject(OIHandle oIHandle, BasicIO basicIO) throws IOException {
        if (printDebug) {
            System.out.println("DASaveInputObject BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASaveInputObject called with hdoc == null");
        }
        int n = this.maxFileId++;
        this.files.put(n, basicIO);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASAVEINPUTOBJECT);
        builder.setDaSaveInputObject(OILinkMessages.DASaveInputObject.newBuilder().setHandle(oIHandle.getHandle()).setIoId(n));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASaveInputObject");
    }

    public void DACloseDocument(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("DACloseDocument BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DACloseDocument called with hdoc == null");
        }
        this.inputDirectory = null;
        this.templateDirectory = null;
        this.outputDirectory = null;
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DACLOSEDOCUMENT);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DACloseDocument");
        if (printDebug) {
            System.out.println("DACloseDocument END");
        }
        if (printDebug) {
            System.out.println("Closing " + this.files.size() + " items in the files list");
        }
        for (BasicIO basicIO : this.files.values()) {
            basicIO.close();
        }
        this.files.clear();
    }

    public OILinkFileIdResult DAGetFileId(OIHandle oIHandle) throws IOException {
        if (oIHandle == null) {
            throw new OILinkException("DAGetFileId called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAGETFILEID);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAGETFILEIDRESPONSE, "DAGetFileId");
        OILinkFileIdResult oILinkFileIdResult = new OILinkFileIdResult(toClient.getDaGetFileIdResponse().getRawFileId(), toClient.getDaGetFileIdResponse().getFileId());
        return oILinkFileIdResult;
    }

    public void DASetOption(OIHandle oIHandle, int n, FileChannel fileChannel) throws IOException {
        if (fileChannel == null) {
            throw new OILinkException("DASetOption called with fc == null");
        }
        this.DASetOption(oIHandle, n, new FileChannelToBasicIO(fileChannel));
    }

    public void DASetOption(OIHandle oIHandle, int n, File file) throws IOException {
        this.DASetOption(oIHandle, n, new FileToBasicIO(file, false));
    }

    public void DASetOption(OIHandle oIHandle, int n, BasicIO basicIO) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (basicIO == null) {
            throw new OILinkException("DASetOption called with basicIO == null");
        }
        if (n == 3) {
            this.templateDirectory = basicIO.getUnderlyingFile();
            if (this.templateDirectory != null) {
                this.templateDirectory = this.templateDirectory.getParentFile();
            }
        }
        int n2 = this.maxFileId++;
        this.files.put(n2, basicIO);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.FILE).setIoId(n2));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
        if (printDebug) {
            System.out.println("DASetOption END");
        }
    }

    public void DASetOption(OIHandle oIHandle, int n, boolean bl) throws IOException {
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(null == oIHandle ? 0L : oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.BOOL).setBoolData(bl));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, int n2) throws IOException {
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(null == oIHandle ? 0L : oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.WORD).setWordData(n2));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, float f) throws IOException {
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(null == oIHandle ? 0L : oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.FLOAT).setFloatData(f));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, long l) throws IOException {
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(null == oIHandle ? 0L : oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.DWORD).setDwordData(l));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, String string) throws IOException {
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        OILinkMessages.DASetOption.Builder builder2 = OILinkMessages.DASetOption.newBuilder().setHandle(null == oIHandle ? 0L : oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.STRING);
        if (string != null) {
            builder2.setStringData(string);
        }
        builder.setDaSetOption(builder2);
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, ByteBuffer byteBuffer) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (byteBuffer == null) {
            throw new OILinkException("DASetOption called with stringData == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.BYTES).setByteData(ByteString.copyFrom(byteBuffer)));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.TiffOptions tiffOptions) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (tiffOptions == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.TIFFOPTIONS).setTiffOptions(tiffOptions));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.DefaultPageSize defaultPageSize) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (defaultPageSize == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.DEFAULTPAGESIZE).setDefaultPageSize(defaultPageSize));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.DefaultPrintMargins defaultPrintMargins) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (defaultPrintMargins == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.DEFAULTPRINTMARGINS).setDefaultPrintMargins(defaultPrintMargins));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.MailHeaderInfo mailHeaderInfo) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (mailHeaderInfo == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.MAILHEADERINFO).setMailHeaderInfo(mailHeaderInfo));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.DefaultPrintFont defaultPrintFont) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (defaultPrintFont == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.DEFAULTPRINTFONT).setDefaultPrintFont(defaultPrintFont));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.PrintFontAlias printFontAlias) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (printFontAlias == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.PRINTFONTALIAS).setPrintFontAlias(printFontAlias));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.FontFilter fontFilter) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (fontFilter == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.FONTFILTER).setFontFilter(fontFilter));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.DASetOption.StringList stringList) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (stringList == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(null == oIHandle ? 0L : oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.STRINGLIST).setStringList(stringList));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public void DASetOption(OIHandle oIHandle, int n, OILinkMessages.MarginText marginText) throws IOException {
        if (printDebug) {
            System.out.println("DASetOption BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASetOption called with hdoc == null");
        }
        if (marginText == null) {
            throw new OILinkException("DASetOption called with data == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASETOPTION);
        builder.setDaSetOption(OILinkMessages.DASetOption.newBuilder().setHandle(oIHandle.getHandle()).setId(n).setType(OILinkMessages.DASetOption.OptionType.MARGINTEXT).setMarginText(marginText));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASetOption");
    }

    public OIHandle EXOpenExport(OIHandle oIHandle, int n, File file, OILinkCallback oILinkCallback) throws IOException {
        return this.EXOpenExport(oIHandle, n, new FileToBasicIO(file, true), oILinkCallback);
    }

    public OIHandle EXOpenExport(OIHandle oIHandle, int n, FileChannel fileChannel, OILinkCallback oILinkCallback) throws IOException {
        return this.EXOpenExport(oIHandle, n, new FileChannelToBasicIO(fileChannel), oILinkCallback);
    }

    public OIHandle EXOpenExport(OIHandle oIHandle, int n, BasicIO basicIO, OILinkCallback oILinkCallback) throws IOException {
        if (printDebug) {
            System.out.println("EXOpenExport BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("EXOpenExport called with hdoc == null");
        }
        this.outputDirectory = basicIO.getUnderlyingFile();
        if (this.outputDirectory != null) {
            this.outputDirectory = this.outputDirectory.getParentFile();
        }
        this.callback = oILinkCallback == null ? this.defaultCallback : oILinkCallback;
        int n2 = this.maxFileId++;
        this.files.put(n2, basicIO);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXOPENEXPORT);
        builder.setExOpenExport(OILinkMessages.EXOpenExport.newBuilder().setHandle(oIHandle.getHandle()).setFormat(n).setIoId(n2));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.EXOPENEXPORTRESPONSE, "EXOpenExport");
        if (printDebug) {
            System.out.println("EXOpenExport END");
        }
        return new OIHandle(toClient.getJustHandle().getHandle());
    }

    public OILinkMessages.EXRunExportResponse EXRunExport(OIHandle oIHandle) throws IOException {
        return this.EXRunExport(oIHandle, false);
    }

    public OILinkMessages.EXRunExportResponse EXRunExport(OIHandle oIHandle, boolean bl) throws IOException {
        if (printDebug) {
            System.out.println("EXRunExport BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("EXRunExport called with hexport == null");
        }
        this.blockingReadTracker = 0L;
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXRUNEXPORT);
        builder.setExRunExport(OILinkMessages.EXRunExport.newBuilder().setHandle(oIHandle.getHandle()).setRunAndClose(bl));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = null;
        if (!bl) {
            toClient = this.waitForMessage(OILinkMessages.ToClient.Type.EXRUNEXPORTRESPONSE, "EXRunExport");
        }
        if (printDebug) {
            System.out.println("EXRunExport END");
        }
        if (toClient == null) {
            return null;
        }
        return toClient.getExRunExportResponse();
    }

    public void EXCloseExport(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("EXCloseExport BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("EXCloseExport called with hexport == null");
        }
        this.outputDirectory = null;
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXCLOSEEXPORT);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "EXCloseExport");
        if (printDebug) {
            System.out.println("EXCloseExport END");
        }
    }

    public OIHandle CAOpenContent(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("CAOpenContent BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("CAOpenContent called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.CAOPENCONTENT);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.CAOPENCONTENTRESPONSE, "CAOpenContent");
        if (printDebug) {
            System.out.println("CAOpenContent END");
        }
        return new OIHandle(toClient.getJustHandle().getHandle());
    }

    public void CACloseContent(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("CACloseContent BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("CACloseContent called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.CACLOSECONTENT);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "CACloseContent");
        if (printDebug) {
            System.out.println("CACloseContent END");
        }
    }

    public OILinkMessages.CAContent CAReadFirst(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("CAReadFirst BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("CAReadFirst called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.CAREADFIRST);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.CACONTENT, "CAReadFirst");
        if (printDebug) {
            System.out.println("CAReadFirst END");
        }
        return toClient.getCaContent();
    }

    public OILinkMessages.CAContent CAReadNext(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("CAReadNext BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("CAReadNext called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.CAREADNEXT);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.CACONTENT, "CAReadNext");
        if (printDebug) {
            System.out.println("CAReadNext END");
        }
        return toClient.getCaContent();
    }

    public OILinkMessages.DAGetTreeResponse DAGetTree(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("DAGetTree BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DAGetTree called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAGETTREE);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAGETTREERESPONSE, "DAGetTree");
        if (printDebug) {
            System.out.println("DAGetTree END");
        }
        OILinkMessages.DAGetTreeResponse dAGetTreeResponse = toClient.getDaGetTreeResponse();
        return dAGetTreeResponse;
    }

    public OILinkMessages.DATreeNode DASaveTreeRecord(OIHandle oIHandle, int n, File file) throws IOException {
        return this.DASaveTreeRecord(oIHandle, n, new FileToBasicIO(file, true));
    }

    public OILinkMessages.DATreeNode DASaveTreeRecord(OIHandle oIHandle, int n, FileChannel fileChannel) throws IOException {
        return this.DASaveTreeRecord(oIHandle, n, new FileChannelToBasicIO(fileChannel));
    }

    public OILinkMessages.DATreeNode DASaveTreeRecord(OIHandle oIHandle, int n, int n2, int n3, File file) throws IOException {
        return this.DASaveTreeRecord(oIHandle, n, n2, n3, new FileToBasicIO(file, true));
    }

    public OILinkMessages.DATreeNode DASaveTreeRecord(OIHandle oIHandle, int n, int n2, int n3, FileChannel fileChannel) throws IOException {
        return this.DASaveTreeRecord(oIHandle, n, n2, n3, new FileChannelToBasicIO(fileChannel));
    }

    public OILinkMessages.DATreeNode DASaveTreeRecord(OIHandle oIHandle, int n, BasicIO basicIO) throws IOException {
        if (printDebug) {
            System.out.println("DASaveTreeRecord BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASaveTreeRecord called with hdoc == null");
        }
        if (basicIO == null) {
            throw new OILinkException("DASaveTreeRecord called with sink == null");
        }
        int n2 = this.maxFileId++;
        this.files.put(n2, basicIO);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASAVETREERECORD);
        builder.setDaSaveTreeRecord(OILinkMessages.DASaveTreeRecord.newBuilder().setHandle(oIHandle.getHandle()).setIsRandom(false).setRecord(n).setIoId(n2));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASaveTreeRecord");
        if (printDebug) {
            System.out.println("DASaveTreeRecord END");
        }
        return toClient.getDaTreeNode();
    }

    public OILinkMessages.DATreeNode DASaveTreeRecord(OIHandle oIHandle, int n, int n2, int n3, BasicIO basicIO) throws IOException {
        if (printDebug) {
            System.out.println("DASaveTreeRecord BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASaveTreeRecord called with hdoc == null");
        }
        if (basicIO == null) {
            throw new OILinkException("DASaveTreeRecord called with sink == null");
        }
        int n4 = this.maxFileId++;
        this.files.put(n4, basicIO);
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DASAVETREERECORD);
        builder.setDaSaveTreeRecord(OILinkMessages.DASaveTreeRecord.newBuilder().setHandle(oIHandle.getHandle()).setIsRandom(true).setFlags(n).setData1(n2).setData2(n3).setIoId(n4));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DASaveTreeRecord");
        if (printDebug) {
            System.out.println("DASaveTreeRecord END");
        }
        return toClient.getDaTreeNode();
    }

    public OIHandle DAOpenTreeRecord(OIHandle oIHandle, int n) throws IOException {
        if (printDebug) {
            System.out.println("DAOpenTreeRecord BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASaveTreeRecord called with hdoc == null");
        }
        if (n < 0) {
            throw new OILinkException("DASaveTreeRecord called with index < 0");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAOPENTREERECORD);
        builder.setDaOpenTreeRecord(OILinkMessages.DAOpenTreeRecord.newBuilder().setHandle(oIHandle.getHandle()).setIsRandom(false).setRecord(n));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAOPENTREERECORDRESPONSE, "DAOpenTreeRecord");
        if (printDebug) {
            System.out.println("DAOpenTreeRecord END");
        }
        return new OIHandle(toClient.getJustHandle().getHandle());
    }

    public OIHandle DAOpenTreeRecord(OIHandle oIHandle, int n, int n2, int n3) throws IOException {
        if (printDebug) {
            System.out.println("DAOpenTreeRecord BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DASaveTreeRecord called with hdoc == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DAOPENTREERECORD);
        builder.setDaOpenTreeRecord(OILinkMessages.DAOpenTreeRecord.newBuilder().setHandle(oIHandle.getHandle()).setIsRandom(true).setFlags(n).setData1(n2).setData2(n3));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.DAOPENTREERECORDRESPONSE, "DAOpenTreeRecord");
        if (printDebug) {
            System.out.println("DAOpenTreeRecord END");
        }
        return new OIHandle(toClient.getJustHandle().getHandle());
    }

    public void DACloseTreeRecord(OIHandle oIHandle) throws IOException {
        if (printDebug) {
            System.out.println("DACloseTreeRecord BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("DACloseTreeRecord called with handle == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.DACLOSETREERECORD);
        builder.setJustHandle(OILinkMessages.JustHandle.newBuilder().setHandle(oIHandle.getHandle()));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "DACloseTreeRecord");
        if (printDebug) {
            System.out.println("DACloseTreeRecord END");
        }
    }

    public void SetHiliteStampImages(OIHandle oIHandle, List<OILinkMessages.HiliteStampImage> list) throws IOException {
        if (printDebug) {
            System.out.println("SetHiliteStampImages BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("SetHiliteStampImages called with handle == null");
        }
        if (list == null) {
            throw new OILinkException("SetHiliteStampImages called with images == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.SETHILITESTAMPIMAGES);
        builder.setHiliteStampImages(OILinkMessages.HiliteStampImages.newBuilder().setHandle(oIHandle.getHandle()).addAllImageList(list));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "SetHiliteStampImages");
        if (printDebug) {
            System.out.println("SetHiliteStampImages END");
        }
    }

    public void SetHilites(OIHandle oIHandle, List<OILinkMessages.Hilite> list) throws IOException {
        if (printDebug) {
            System.out.println("SetHilites BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("SetHilites called with handle == null");
        }
        if (list == null) {
            throw new OILinkException("SetHilites called with images == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.SETHILITES);
        builder.setHilites(OILinkMessages.Hilites.newBuilder().setHandle(oIHandle.getHandle()).addAllHiliteList(list));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "SetHilites");
        if (printDebug) {
            System.out.println("SetHilites END");
        }
    }

    public void EXApplyHilites(OIHandle oIHandle, String string) throws IOException {
        if (printDebug) {
            System.out.println("EXApplyHilites BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("EXApplyHilites called with handle == null");
        }
        if (string == null) {
            throw new OILinkException("EXApplyHilites called with json == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXAPPLYHILITES);
        builder.setExApplyHilites(OILinkMessages.EXApplyHilites.newBuilder().setHandle(oIHandle.getHandle()).setJson(string));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "EXApplyHilites");
        if (printDebug) {
            System.out.println("EXApplyHilites END");
        }
    }

    public void EXAddKeyValuePairs(OIHandle oIHandle, Map<String, String> map) throws IOException {
        Map.Entry<String, String> entry2;
        if (printDebug) {
            System.out.println("EXAddKeyValuePairs BEGIN");
        }
        if (map == null) {
            throw new OILinkException("EXAddKeyValuePairs called with stringPairs == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXADDKEYVALUEPAIRS);
        OILinkMessages.EXAddKeyValuePairs.Builder builder2 = OILinkMessages.EXAddKeyValuePairs.newBuilder();
        builder2.setHandle(oIHandle.getHandle());
        for (Map.Entry<String, String> entry2 : map.entrySet()) {
            if (entry2.getKey() == null || entry2.getValue() == null) continue;
            OILinkMessages.StringKeyValuePair.Builder builder3 = OILinkMessages.StringKeyValuePair.newBuilder();
            builder3.setKey((String)entry2.getKey());
            builder3.setValue((String)entry2.getValue());
            builder2.addStringPairs(builder3.build());
        }
        builder.setExAddKeyValuePairs(builder2.build());
        entry2 = builder.build();
        this.sendPBMessage((OILinkMessages.ToNative)((Object)entry2));
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "EXAddKeyValuePairs");
    }

    public void EXRedactText(OIHandle oIHandle, long l, long l2, String string) throws IOException {
        if (printDebug) {
            System.out.println("EXRedactText BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("EXRedactText called with handle == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXREDACTTEXT);
        builder.setExRedactText(OILinkMessages.EXRedactText.newBuilder().setHandle(oIHandle.getHandle()).setStartACC(l).setEndACC(l2).setLabel(string));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        this.waitForMessage(OILinkMessages.ToClient.Type.OK, "EXRedactText");
        if (printDebug) {
            System.out.println("EXRedactText END");
        }
    }

    public long EXCountPages(OIHandle oIHandle, int n) throws IOException {
        if (printDebug) {
            System.out.println("EXCountPages BEGIN");
        }
        if (oIHandle == null) {
            throw new OILinkException("EXCountPages called with handle == null");
        }
        OILinkMessages.ToNative.Builder builder = OILinkMessages.ToNative.newBuilder().setType(OILinkMessages.ToNative.Type.EXCOUNTPAGES);
        builder.setExCountPages(OILinkMessages.EXCountPages.newBuilder().setHandle(oIHandle.getHandle()).setFormat(n));
        OILinkMessages.ToNative toNative = builder.build();
        this.sendPBMessage(toNative);
        OILinkMessages.ToClient toClient = this.waitForMessage(OILinkMessages.ToClient.Type.EXCOUNTPAGESRESPONSE, "EXCountPages");
        if (printDebug) {
            System.out.println("EXCountPages END");
        }
        return toClient.getExCountPagesResponse().getDwPageCount();
    }

    OILinkMessages.ToClient readPBMessage() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.order(ByteOrder.nativeOrder());
        if (null == this.nativeCout) {
            throw new OILinkException("Attempt to read from a null nativeCout stream");
        }
        int n = this.readBytes(this.nativeCout, 5, byteBuffer.array());
        if (n != 5) {
            throw new OILinkException("Bytes read from nativeCout not equal 5");
        }
        byte by = byteBuffer.get();
        int n2 = byteBuffer.getInt();
        if (by != -65) {
            throw new OILinkException("Check byte on size is not 0xBF");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
        byteBuffer2.order(ByteOrder.nativeOrder());
        int n3 = this.readBytes(this.nativeCout, n2, byteBuffer2.array());
        if (n3 != n2) {
            throw new OILinkException("Read of message did not return expected number of bytes");
        }
        return OILinkMessages.ToClient.parseFrom(byteBuffer2.array());
    }

    void sendPBMessage(OILinkMessages.ToNative toNative) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.order(ByteOrder.nativeOrder());
        int n = toNative.getSerializedSize();
        byteBuffer.put((byte)-65);
        byteBuffer.putInt(n);
        if (null == this.nativeCin) {
            throw new OILinkException("Attempt to write to a null nativeCin stream");
        }
        this.nativeCin.write(byteBuffer.array());
        toNative.writeTo(this.nativeCin);
        this.nativeCin.flush();
    }

    void sendBytes(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasRemaining()) {
            if (null == this.nativeCin) {
                throw new OILinkException("Attempt to write to a null nativeCin stream");
            }
            this.nativeCin.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
            this.nativeCin.flush();
        }
    }

    ByteBuffer readBytes(int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        if (n > 0) {
            if (null == this.nativeCout) {
                throw new OILinkException("Attempt to read from a null nativeCout stream");
            }
            this.readBytes(this.nativeCout, n, byteBuffer.array());
        }
        byteBuffer.clear();
        return byteBuffer;
    }

    int readBytes(InputStream inputStream, int n, byte[] byArray) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.available();
            int n4 = 0;
            while (n3 == 0) {
                if (++n4 % 2000 == 0 && !this.isAlive()) {
                    throw new OILinkException("OILink process died");
                }
                if (Thread.interrupted()) {
                    throw new OILinkTimeoutException("The transform was interrupted");
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new OILinkTimeoutException("The transform was interrupted");
                }
                n3 = inputStream.available();
            }
            if (n3 >= n - n2) {
                n2 += inputStream.read(byArray, n2, n - n2);
                continue;
            }
            n2 += inputStream.read(byArray, n2, n3);
        }
        return n2;
    }

    File getOutputDiectory() {
        return this.outputDirectory;
    }

    File getInputDiectory() {
        return this.inputDirectory;
    }

    File getTemplateDiectory() {
        return this.templateDirectory;
    }

    public void setCallback(OILinkCallback oILinkCallback) {
        this.callback = null == oILinkCallback ? this.defaultCallback : oILinkCallback;
    }
}

