/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.options;

import java.util.HashMap;
import java.util.Map;

public class FontAliases {
    private Map<String, String> m_AliasList;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static final Map<String, String> defaultAliases = new HashMap<String, String>();

    public Map<String, String> getAliasList() {
        if (this.m_AliasList != null) {
            return new HashMap<String, String>(this.m_AliasList);
        }
        return null;
    }

    public FontAliases(boolean bl, Map<String, String> map) {
        if (bl) {
            this.m_AliasList = new HashMap<String, String>(defaultAliases);
            if (map != null) {
                this.m_AliasList.putAll(map);
            }
        } else {
            this.m_AliasList = map != null ? new HashMap<String, String>(map) : null;
        }
    }

    public static Map<String, String> getDefaultAliases() {
        return new HashMap<String, String>(defaultAliases);
    }

    static {
        if (isWindows) {
            defaultAliases.put("Chicago", "Arial");
            defaultAliases.put("Geneva", "Arial");
            defaultAliases.put("New York", "Times New Roman");
            defaultAliases.put("Helvetica", "Arial");
            defaultAliases.put("Helv", "Arial");
            defaultAliases.put("times", "Times New Roman");
            defaultAliases.put("Times", "Times New Roman");
            defaultAliases.put("Tms Roman", "Times New Roman");
            defaultAliases.put("itc zapfdingbats", "Zapfdingbats");
            defaultAliases.put("itc zapf dingbats", "Zapfdingbats");
        } else {
            defaultAliases.put("61", "Liberation Sans");
            defaultAliases.put("Andale Mono", "Liberation Sans");
            defaultAliases.put("Courier", "Liberation Sans");
            defaultAliases.put("Courier New", "Liberation Sans");
            defaultAliases.put("Lucida Console", "Liberation Sans");
            defaultAliases.put("MS Gothic", "Liberation Sans");
            defaultAliases.put("MS Mincho", "Liberation Sans");
            defaultAliases.put("OCR A Extended", "Liberation Sans");
            defaultAliases.put("OCR B", "Liberation Sans");
            defaultAliases.put("Agency FB", "Liberation Sans");
            defaultAliases.put("Arial", "Liberation Sans");
            defaultAliases.put("Arial Black", "Liberation Sans");
            defaultAliases.put("Arial Narrow", "Liberation Sans");
            defaultAliases.put("Arial Rounded MT", "Liberation Sans");
            defaultAliases.put("Arial Unicode MS", "Liberation Sans");
            defaultAliases.put("Berline Sans FB", "Liberation Sans");
            defaultAliases.put("Calibri", "Liberation Sans");
            defaultAliases.put("Frank Gothic Demi", "Liberation Sans");
            defaultAliases.put("Frank Gothic Medium Cond", "Liberation Sans");
            defaultAliases.put("Franklin Gothic Book", "Liberation Sans");
            defaultAliases.put("Futura", "Liberation Sans");
            defaultAliases.put("Geneva", "Liberation Sans");
            defaultAliases.put("Gill Sans", "Liberation Sans");
            defaultAliases.put("Gill Sans MT", "Liberation Sans");
            defaultAliases.put("Lucida Sans Regular", "Liberation Sans");
            defaultAliases.put("Lucida Sans Unicode", "Liberation Sans");
            defaultAliases.put("Modern No. 20", "Liberation Sans");
            defaultAliases.put("Tahoma", "Liberation Sans");
            defaultAliases.put("Trebuchet MS", "Liberation Sans");
            defaultAliases.put("Tw Cen MT", "Liberation Sans");
            defaultAliases.put("Verdana", "Liberation Sans");
            defaultAliases.put("Albany", "Liberation Sans");
            defaultAliases.put("Franklin Gothic", "Liberation Sans");
            defaultAliases.put("Franklin Demi", "Liberation Sans");
            defaultAliases.put("Franklin Demi Cond", "Liberation Sans");
            defaultAliases.put("Franklin Gothic Heavy", "Liberation Sans");
            defaultAliases.put("Algerian", "Liberation Serif");
            defaultAliases.put("Baskerville", "Liberation Serif");
            defaultAliases.put("Bell MT", "Liberation Serif");
            defaultAliases.put("Bodoni MT", "Liberation Serif");
            defaultAliases.put("Bodoni MT Black", "Liberation Serif");
            defaultAliases.put("Book Antiqua", "Liberation Serif");
            defaultAliases.put("Bookman Old Style", "Liberation Serif");
            defaultAliases.put("Calisto MT", "Liberation Serif");
            defaultAliases.put("Cambria", "Liberation Serif");
            defaultAliases.put("Centaur", "Liberation Serif");
            defaultAliases.put("Century", "Liberation Serif");
            defaultAliases.put("Century Gothic", "Liberation Serif");
            defaultAliases.put("Century Schoolbook", "Liberation Serif");
            defaultAliases.put("Elephant", "Liberation Serif");
            defaultAliases.put("Footlight MT Light", "Liberation Serif");
            defaultAliases.put("Garamond", "Liberation Serif");
            defaultAliases.put("Georgia", "Liberation Serif");
            defaultAliases.put("Goudy Old Style", "Liberation Serif");
            defaultAliases.put("Lucida Bright", "Liberation Serif");
            defaultAliases.put("MS Serif", "Liberation Serif");
            defaultAliases.put("New York", "Liberation Serif");
            defaultAliases.put("Palatino", "Liberation Serif");
            defaultAliases.put("Perpetua", "Liberation Serif");
            defaultAliases.put("Times", "Liberation Serif");
            defaultAliases.put("times", "Liberation Serif");
            defaultAliases.put("Times New Roman", "Liberation Serif");
        }
    }
}

