/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import com.oracle.outsidein.Exporter;
import com.oracle.outsidein.ExporterImpl;
import com.oracle.outsidein.OutsideInException;
import com.oracle.outsidein.OutsideInVersion;
import java.io.File;
import java.io.IOException;
import net.bitform.oilink.OILink;
import net.bitform.oilink.OILinkStatus;

public class OutsideIn {
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    private OutsideIn() {
    }

    public static Exporter newLocalExporter() throws OutsideInException {
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        return new ExporterImpl();
    }

    public static Exporter newLocalExporter(String string) throws OutsideInException {
        if (isWindows) {
            throw new OutsideInException("Running oilink as a different user is only supported on unix platforms");
        }
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        return new ExporterImpl(string, null);
    }

    public static Exporter newLocalExporter(Exporter exporter) throws OutsideInException {
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        return new ExporterImpl(exporter);
    }

    public static OutsideInVersion getCoreVersion() {
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            return null;
        }
        return new OutsideInVersion(oILinkStatus.getVersionInfo());
    }

    public static void setLocation(File file) throws OutsideInException {
        OILinkStatus oILinkStatus = OILink.getStatus();
        if (oILinkStatus != null && oILinkStatus.isAvailable()) {
            throw new OutsideInException("The location has already been set.");
        }
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("The directory (" + string + ") does not exist.");
        }
        OILinkStatus oILinkStatus2 = OILink.init(string);
        if (!oILinkStatus2.isAvailable()) {
            throw new OutsideInException(oILinkStatus2.getProblem());
        }
    }
}

