/*
 * Decompiled with CFR 0.152.
 */
package com.outsideinsdk;

import com.outsideinsdk.ExportShutdownHook;
import com.outsideinsdk.ExportStatusCode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class Export {
    private static final String INPUTPATH_U = "inputpath_u";
    private static final String OUTPUTPATH_U = "outputpath_u";
    private static final String OUTPUTFORMAT = "outputid";
    private static final String FORMAT_HTMLWCA = "fi_htmlwca";
    private static final String FORMAT_HTMLAG = "fi_htmlag";
    private static final byte[] BASE64_MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final String COMMAND_NAME = "exporter.exe";
    private static final String COMMAND_NAME_UNIX = "exporter";
    private static final long defaultTimeout = 0L;
    private Properties properties = null;
    private String[] execParams = new String[4];
    private String workDir = null;
    private boolean unix = true;

    public Export() {
        URL url = Export.class.getResource("Export.class");
        char[] buf = url.toString().toCharArray();
        String osName = System.getProperty("os.name");
        this.unix = !osName.startsWith("Windows");
        block0: for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != '!') continue;
            while (i >= 0 && buf[i] != '/') {
                --i;
            }
            for (int j = ++i; j >= 0; --j) {
                if (buf[j] != ':') continue;
                j = this.unix ? ++j : --j;
                this.workDir = new String(buf, j, i - j);
                break block0;
            }
            break;
        }
    }

    public Export(Properties properties) {
        this();
        this.setRuntimeProperties(properties);
    }

    public Properties getRuntimeProperties() {
        if (this.properties == null) {
            return null;
        }
        return (Properties)this.properties.clone();
    }

    public void setRuntimeProperties(Properties properties) {
        this.properties = properties != null ? (Properties)properties.clone() : null;
        this.parseProperties();
    }

    public ExportStatusCode convert(String inputPath, String outputPath, String outputFormat) {
        return this.convert(inputPath, outputPath, outputFormat, 0L);
    }

    public ExportStatusCode convert(String inputPath, String outputPath, String outputFormat, long timeout) {
        if (this.properties != null && this.properties.getProperty("exepath") != null) {
            this.execParams[0] = this.properties.getProperty("exepath");
            if (this.unix) {
                if (this.execParams[0].endsWith(".exe")) {
                    this.execParams[0] = this.execParams[0].substring(0, this.execParams[0].length() - 4);
                }
            } else if (!this.execParams[0].endsWith(".exe")) {
                this.execParams[0] = this.execParams[0] + ".exe";
            }
        } else {
            this.execParams[0] = this.unix ? COMMAND_NAME_UNIX : COMMAND_NAME;
        }
        if (!this.unix) {
            this.execParams[1] = "\"inputpath_u=" + this.base64Encode(inputPath) + "\"";
            this.execParams[2] = "\"outputpath_u=" + this.base64Encode(outputPath) + "\"";
            this.execParams[3] = "\"outputid=" + outputFormat + "\"";
        } else {
            this.execParams[1] = "inputpath_u=\"" + this.base64Encode(inputPath) + "\"";
            this.execParams[2] = "outputpath_u=\"" + this.base64Encode(outputPath) + "\"";
            this.execParams[3] = "outputid=" + outputFormat;
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        ExportStatusCode statusCode = null;
        ExportShutdownHook shutdownHook = null;
        int exitValue = 0;
        if (timeout <= 0L) {
            try {
                process = runtime.exec(this.execParams);
                shutdownHook = new ExportShutdownHook(process);
                runtime.addShutdownHook(shutdownHook);
                process.waitFor();
                exitValue = this.getExitValue(process);
                runtime.removeShutdownHook(shutdownHook);
                shutdownHook.finished();
                statusCode = new ExportStatusCode(exitValue);
            }
            catch (IOException ex) {
                if (shutdownHook != null) {
                    runtime.removeShutdownHook(shutdownHook);
                    shutdownHook.finished();
                }
                statusCode = ExportStatusCode.SCCERR_JAVA_IO_ERROR;
            }
            catch (InterruptedException ex) {
                runtime.removeShutdownHook(shutdownHook);
                shutdownHook.finished();
                process.destroy();
                statusCode = ExportStatusCode.SCCERR_JAVA_INTERRUPTED;
            }
        } else {
            long[] waitIntervals = new long[]{50L, 100L, 250L, 250L, 500L, 500L, 500L, 500L, 1000L};
            int waitIndex = 0;
            long totalWait = 0L;
            try {
                process = runtime.exec(this.execParams);
                shutdownHook = new ExportShutdownHook(process);
                runtime.addShutdownHook(shutdownHook);
                boolean done = false;
                while (!done) {
                    Thread.sleep(waitIntervals[waitIndex]);
                    totalWait += waitIntervals[waitIndex];
                    try {
                        exitValue = this.getExitValue(process);
                        runtime.removeShutdownHook(shutdownHook);
                        shutdownHook.finished();
                        statusCode = new ExportStatusCode(exitValue);
                        done = true;
                    }
                    catch (IllegalThreadStateException ex) {
                        if (totalWait > timeout) {
                            runtime.removeShutdownHook(shutdownHook);
                            shutdownHook.finished();
                            process.destroy();
                            statusCode = ExportStatusCode.SCCERR_JAVA_TIMEDOUT;
                            done = true;
                            continue;
                        }
                        if (waitIndex + 1 >= waitIntervals.length) continue;
                        ++waitIndex;
                    }
                }
            }
            catch (IOException ex) {
                if (shutdownHook != null) {
                    runtime.removeShutdownHook(shutdownHook);
                    shutdownHook.finished();
                }
                statusCode = ExportStatusCode.SCCERR_JAVA_IO_ERROR;
            }
            catch (InterruptedException ex) {
                runtime.removeShutdownHook(shutdownHook);
                shutdownHook.finished();
                process.destroy();
                statusCode = ExportStatusCode.SCCERR_JAVA_INTERRUPTED;
            }
        }
        return statusCode;
    }

    private int getExitValue(Process process) {
        int exitCode = 0;
        if (process != null && (exitCode = process.exitValue()) != 0) {
            InputStream err = process.getErrorStream();
            try {
                byte[] errBuf = new byte[err.available()];
                err.read(errBuf);
                String errStr = new String(errBuf);
                exitCode = Integer.parseInt(errStr);
            }
            catch (IOException ex) {
                exitCode = ExportStatusCode.SCCERR_JAVA_IO_ERROR.getCode();
            }
        }
        return exitCode;
    }

    private void parseProperties() {
        String value;
        String key;
        if (this.properties == null) {
            this.execParams = new String[4];
            return;
        }
        int count = 0;
        Enumeration<?> propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            key = (String)propertyNames.nextElement();
            value = this.properties.getProperty(key);
            if (value == "default" || key == "exepath") continue;
            ++count;
        }
        this.execParams = new String[count + 4];
        count = 4;
        propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            key = (String)propertyNames.nextElement();
            value = this.properties.getProperty(key);
            if (value == "default" || key == "exepath") continue;
            this.execParams[count] = key == "template" ? "template_u=" + this.base64Encode(value) : (key == "tempdir" ? "tempdir_u=" + this.base64Encode(value) : key + "=" + value);
            if (!this.unix) {
                this.execParams[count] = "\"" + this.execParams[count] + "\"";
            }
            ++count;
        }
    }

    private String base64Encode(String src) {
        char[] srcChars = src.toCharArray();
        short[] srcBytes = new short[srcChars.length * 2];
        int index = 0;
        for (int i = 0; i < srcChars.length; ++i) {
            srcBytes[index++] = (short)(srcChars[i] >> 8);
            srcBytes[index++] = (short)(srcChars[i] & 0xFF);
        }
        int newLength = srcBytes.length * 4 / 3;
        if (newLength % 4 != 0) {
            newLength = (1 + newLength / 4) * 4;
        }
        char[] destChars = new char[newLength];
        index = 0;
        int i = 0;
        while (i + 2 < srcBytes.length) {
            this.encode(srcBytes[i] << 16 | srcBytes[i + 1] << 8 | srcBytes[i + 2], destChars, index);
            i += 3;
            index += 4;
        }
        switch (srcBytes.length % 3) {
            case 1: {
                this.encode(srcBytes[i] << 16, destChars, index);
                index += 2;
                destChars[index++] = 61;
                destChars[index++] = 61;
                break;
            }
            case 2: {
                this.encode(srcBytes[i] << 16 | srcBytes[i + 1] << 8, destChars, index);
                index += 3;
                destChars[index++] = 61;
            }
        }
        return new String(destChars);
    }

    private void encode(int val, char[] dest, int index) {
        dest[index] = (char)BASE64_MAP[(val & 0xFC0000) >> 18];
        dest[index + 1] = (char)BASE64_MAP[(val & 0x3F000) >> 12];
        dest[index + 2] = (char)BASE64_MAP[(val & 0xFC0) >> 6];
        dest[index + 3] = (char)BASE64_MAP[val & 0x3F];
    }
}

