/*
 * Decompiled with CFR 0.152.
 */
import com.oracle.outsidein.Callback;
import com.oracle.outsidein.Document;
import com.oracle.outsidein.Exporter;
import com.oracle.outsidein.FileFormat;
import com.oracle.outsidein.OutsideIn;
import com.oracle.outsidein.OutsideInException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class OITSample {
    private static void put_usage() {
        System.out.println("Usage: OITSample <file> <outputfile> <outputtype> [fontpath]");
        System.out.println("  outputtype = [tiff|jpeg|bmp|png|gif|j2k|HTML|SearchML|SearchHTML|HTML5|SearchText|PageML|FlexionDoc|MHTML|PDF|PDFA|PDFA_2] - case insensitive");
        System.out.println("  fontpath = Location of fonts to use when creating output. Required argument for pdf outputtypes on unix.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            OITSample.put_usage();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        FileFormat fileFormat = null;
        String string3 = stringArray[2].toUpperCase();
        if (string3.equals("HTML")) {
            fileFormat = FileFormat.FI_HTML;
        } else if (string3.equals("SEARCHML")) {
            fileFormat = FileFormat.FI_SEARCHML_LATEST;
        } else if (string3.equals("SEARCHHTML")) {
            fileFormat = FileFormat.FI_SEARCHHTML;
        } else if (string3.equals("HTML5")) {
            fileFormat = FileFormat.FI_HTML5;
        } else if (string3.equals("SEARCHTEXT")) {
            fileFormat = FileFormat.FI_SEARCHTEXT;
        } else if (string3.equals("PAGEML")) {
            fileFormat = FileFormat.FI_PAGEML;
        } else if (string3.equals("FLEXIONDOC")) {
            fileFormat = FileFormat.FI_XML_FLEXIONDOC_LATEST;
        } else if (string3.equals("GIF")) {
            fileFormat = FileFormat.FI_GIF;
        } else if (string3.equals("JPEG")) {
            fileFormat = FileFormat.FI_JPEGFIF;
        } else if (string3.equals("BMP")) {
            fileFormat = FileFormat.FI_BMP;
        } else if (string3.equals("PNG")) {
            fileFormat = FileFormat.FI_PNG;
        } else if (string3.equals("TIFF")) {
            fileFormat = FileFormat.FI_TIFF;
        } else if (string3.equals("J2K")) {
            fileFormat = FileFormat.FI_JPEG2000;
        } else if (string3.equals("MHTML")) {
            fileFormat = FileFormat.FI_MHTML;
        } else if (string3.equals("PDF")) {
            fileFormat = FileFormat.FI_PDF;
        } else if (string3.equals("PDFA")) {
            fileFormat = FileFormat.FI_PDFA;
        } else if (string3.equals("PDFA_2")) {
            fileFormat = FileFormat.FI_PDFA_2;
        } else {
            OITSample.put_usage();
            return;
        }
        Exporter exporter = null;
        try {
            FileFormat fileFormat2;
            exporter = OutsideIn.newLocalExporter();
            File file = new File(string2);
            SampleCallback sampleCallback = new SampleCallback(file);
            exporter.setSourceFile(new File(string)).setDestinationFile(file).setDestinationFormat(fileFormat).setCallbackHandler((Callback)sampleCallback);
            if (stringArray.length > 3) {
                fileFormat2 = new LinkedList();
                fileFormat2.add(new File(stringArray[3]));
                exporter.setFontDirectories((List)fileFormat2);
            }
            fileFormat2 = exporter.getFileId(Document.FileIdInfoFlagValue.NORMAL);
            System.out.println("File Identifier : " + fileFormat2.getDescription() + "(" + fileFormat2.getId() + ")");
            FileFormat fileFormat3 = exporter.getFileId(Document.FileIdInfoFlagValue.RAWFI);
            System.out.println("File Identifier (Raw): " + fileFormat3.getDescription() + "(" + fileFormat3.getId() + ")");
            exporter.export();
            System.out.println("Export Successful");
        }
        catch (OutsideInException outsideInException) {
            System.out.println(outsideInException.getMessage());
        }
        finally {
            if (null != exporter) {
                try {
                    exporter.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
        }
    }

    public static class SampleCallback
    extends Callback {
        private int m_imageFileCount = 0;
        private File m_ParentFile;
        private static final HashMap<FileFormat, String> m_extensions = new HashMap();

        public SampleCallback(File file) {
            this.m_ParentFile = file;
        }

        private File getNextImageFile(String string) {
            String string2 = this.m_ParentFile.getName();
            int n = string2.lastIndexOf(46);
            String string3 = string2.substring(0, n);
            if (null == string) {
                string = string2.length() > n + 1 ? string2.substring(n + 1) : "";
            }
            ++this.m_imageFileCount;
            string3 = string3 + String.format("%04x", this.m_imageFileCount) + "." + string;
            File file = new File(this.m_ParentFile.getParent(), string3);
            return file;
        }

        public Callback.CreateNewFileResponse createNewFile(FileFormat fileFormat, FileFormat fileFormat2, Callback.AssociationValue associationValue, String string) throws IOException {
            File file = this.getNextImageFile(m_extensions.get(fileFormat2));
            return new Callback.CreateNewFileResponse((Callback)this, file, file.getName());
        }

        public void newFileInfo(FileFormat fileFormat, FileFormat fileFormat2, Callback.AssociationValue associationValue, String string, String string2) throws IOException {
            System.out.println("Creating file: " + string);
        }

        static {
            m_extensions.put(FileFormat.FI_PDF, "pdf");
            m_extensions.put(FileFormat.FI_PNG, "png");
            m_extensions.put(FileFormat.FI_BMP, "bmp");
            m_extensions.put(FileFormat.FI_GIF, "gif");
            m_extensions.put(FileFormat.FI_TIFF, "tiff");
            m_extensions.put(FileFormat.FI_HTML, "html");
            m_extensions.put(FileFormat.FI_JPEGFIF, "jpg");
            m_extensions.put(FileFormat.FI_XML, "xml");
            m_extensions.put(FileFormat.FI_HTMLWCA, "html");
            m_extensions.put(FileFormat.FI_XHTMLB, "html");
            m_extensions.put(FileFormat.FI_HTMLAG, "html");
            m_extensions.put(FileFormat.FI_WIRELESSHTML, "html");
            m_extensions.put(FileFormat.FI_HTML5, "html");
            m_extensions.put(FileFormat.FI_JAVASCRIPT, "js");
            m_extensions.put(FileFormat.FI_HTML_CSS, "css");
            m_extensions.put(FileFormat.FI_TRUETYPEFONT, "ttf");
        }
    }
}

