/*
 * Decompiled with CFR 0.152.
 */
import com.outsideinsdk.Export;
import com.outsideinsdk.ExportStatusCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Properties;
import java.util.StringTokenizer;

public class ExportTest {
    private static final String INPUTPATHKEY = "inputpath";
    private static final String OUTPUTPATHKEY = "outputpath";
    private static final String OUTPUTIDKEY = "outputid";
    Properties configProps = new Properties();

    public ExportTest(String cfp) throws FileNotFoundException, IOException {
        this.parseConfig(cfp);
    }

    public void parseConfig(String cfp) throws FileNotFoundException, IOException {
        String line;
        File cff = new File(cfp);
        if (!(cff.exists() && cff.isFile() && cff.canRead())) {
            throw new InvalidParameterException("Configuration file unreadable.");
        }
        BufferedReader cfr = new BufferedReader(new FileReader(cff));
        while ((line = cfr.readLine()) != null) {
            this.processLine(line);
        }
    }

    private void processLine(String l) {
        String line;
        int indPound = l.indexOf(35);
        String string = line = indPound == -1 ? l.trim() : l.substring(0, indPound).trim();
        if (line.length() != 0) {
            StringTokenizer stl = new StringTokenizer(line);
            String key = stl.nextToken();
            String value = stl.nextToken();
            while (stl.hasMoreTokens()) {
                value = value + " " + stl.nextToken();
            }
            this.configProps.setProperty(key, value);
        }
    }

    public void convert(String ifp, String ofp, long timeout) {
        String oid = this.configProps.getProperty(OUTPUTIDKEY);
        System.out.println("Input Path: " + ifp + " Output Path: " + ofp + " Output ID: " + oid);
        this.configProps.remove(INPUTPATHKEY);
        this.configProps.remove(OUTPUTPATHKEY);
        File iff = new File(ifp);
        File[] iffa = iff.isDirectory() ? iff.listFiles() : new File[]{iff};
        File off = new File(ofp);
        if (iff.isDirectory() && !off.exists()) {
            off.mkdir();
        }
        Export e = new Export(this.configProps);
        if (off.isDirectory()) {
            String ext = "." + oid.substring(3);
            for (int i = 0; i < iffa.length; ++i) {
                String ifn = iffa[i].toString();
                String ofn = ofp + File.separator + iffa[i].getName() + ext;
                System.out.println("Converting " + ifn + " to " + ofn);
                ExportStatusCode result = e.convert(ifn, ofn, oid, timeout);
                if (result.getCode() == ExportStatusCode.SCCERR_OK.getCode()) {
                    System.out.println("Conversion Successful!");
                    continue;
                }
                System.out.println("Conversion Error: " + result);
            }
        } else {
            for (int i = 0; i < iffa.length; ++i) {
                ExportStatusCode result = e.convert(iffa[i].toString(), ofp, oid, timeout);
                if (result.getCode() == ExportStatusCode.SCCERR_OK.getCode()) {
                    System.out.println("Conversion Successful!");
                    continue;
                }
                System.out.println("Conversion Error: " + result);
            }
        }
    }

    public static void main(String[] args) {
        int count = args.length;
        if (count != 3 && count != 4) {
            System.out.println("Input path, output path and configuration file are required.");
            System.out.println("Usage: ExportTest InputPath OutputPath ConfigurationFile [Timeout(in milliseconds)]");
            System.out.println();
        } else {
            ExportTest ct = null;
            try {
                ct = new ExportTest(args[2]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            long timeout = 0L;
            if (count == 4) {
                timeout = Integer.decode(args[3]).longValue();
            }
            ct.convert(args[0], args[1], timeout);
        }
    }
}

