/*
 * Decompiled with CFR 0.152.
 */
import com.oracle.outsidein.Callback;
import com.oracle.outsidein.Document;
import com.oracle.outsidein.Exporter;
import com.oracle.outsidein.FileFormat;
import com.oracle.outsidein.OutsideIn;
import com.oracle.outsidein.SeekableByteChannel6;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class OITRedirectSample {
    private static void put_usage() {
        System.out.println("Usage: OITRedirectedSample <file> <outputfile> <outputtype> [fontpath]");
        System.out.println("  outputtype = [tiff|jpeg|bmp|png|gif|j2k|HTML|SearchML|SearchHTML|HTML5|SearchText|PageML|FlexionDoc|MHTML|PDF|PDFA|PDFA_2] - case insensitive");
        System.out.println("  fontpath = Location of fonts to use when creating output. Required argument for pdf outputtypes on unix.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            OITRedirectSample.put_usage();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        FileFormat fileFormat = null;
        String string3 = stringArray[2].toUpperCase();
        if (string3.equals("HTML")) {
            fileFormat = FileFormat.FI_HTML;
        } else if (string3.equals("SEARCHML")) {
            fileFormat = FileFormat.FI_SEARCHML_LATEST;
        } else if (string3.equals("SEARCHHTML")) {
            fileFormat = FileFormat.FI_SEARCHHTML;
        } else if (string3.equals("HTML5")) {
            fileFormat = FileFormat.FI_HTML5;
        } else if (string3.equals("SEARCHTEXT")) {
            fileFormat = FileFormat.FI_SEARCHTEXT;
        } else if (string3.equals("PAGEML")) {
            fileFormat = FileFormat.FI_PAGEML;
        } else if (string3.equals("FLEXIONDOC")) {
            fileFormat = FileFormat.FI_XML_FLEXIONDOC_LATEST;
        } else if (string3.equals("GIF")) {
            fileFormat = FileFormat.FI_GIF;
        } else if (string3.equals("JPEG")) {
            fileFormat = FileFormat.FI_JPEGFIF;
        } else if (string3.equals("BMP")) {
            fileFormat = FileFormat.FI_BMP;
        } else if (string3.equals("PNG")) {
            fileFormat = FileFormat.FI_PNG;
        } else if (string3.equals("TIFF")) {
            fileFormat = FileFormat.FI_TIFF;
        } else if (string3.equals("J2K")) {
            fileFormat = FileFormat.FI_JPEG2000;
        } else if (string3.equals("MHTML")) {
            fileFormat = FileFormat.FI_MHTML;
        } else if (string3.equals("PDF")) {
            fileFormat = FileFormat.FI_PDF;
        } else if (string3.equals("PDFA")) {
            fileFormat = FileFormat.FI_PDFA;
        } else if (string3.equals("PDFA_2")) {
            fileFormat = FileFormat.FI_PDFA_2;
        } else {
            OITRedirectSample.put_usage();
            return;
        }
        MyCallbackHandler myCallbackHandler = null;
        MyRedirectedIO myRedirectedIO = null;
        MyRedirectedIO myRedirectedIO2 = null;
        Exporter exporter = null;
        try {
            FileFormat fileFormat2;
            exporter = OutsideIn.newLocalExporter();
            myCallbackHandler = new MyCallbackHandler(new File(string), new File(string2));
            myRedirectedIO = new MyRedirectedIO(new File(string), "r");
            myRedirectedIO2 = new MyRedirectedIO(new File(string2), "rw");
            exporter.setSourceFile((SeekableByteChannel6)myRedirectedIO).setDestinationFile((SeekableByteChannel6)myRedirectedIO2).setDestinationFormat(fileFormat).setCallbackHandler((Callback)myCallbackHandler);
            if (stringArray.length > 3) {
                fileFormat2 = new LinkedList();
                fileFormat2.add(new File(stringArray[3]));
                exporter.setFontDirectories((List)fileFormat2);
            }
            fileFormat2 = exporter.getFileId(Document.FileIdInfoFlagValue.NORMAL);
            System.out.println("File Identifier : " + fileFormat2.getDescription() + "(" + fileFormat2.getId() + ")");
            FileFormat fileFormat3 = exporter.getFileId(Document.FileIdInfoFlagValue.RAWFI);
            System.out.println("File Identifier (Raw): " + fileFormat3.getDescription() + "(" + fileFormat3.getId() + ")");
            exporter.export();
            System.out.println("Export Successful");
            int n = myCallbackHandler.getFilesCreatedCount();
            if (n > 0) {
                System.out.println("Number of files created = " + n);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            if (exporter != null) {
                try {
                    exporter.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
        }
    }

    public static class MyCallbackHandler
    extends Callback {
        private int m_filesCreatedCount = 0;
        private int m_imageFileCount = 0;
        private File m_parentFile;
        private File m_sourceFile;
        private static final HashMap<FileFormat, String> m_extensions = new HashMap();

        public MyCallbackHandler(File file, File file2) {
            this.m_parentFile = file2;
            this.m_sourceFile = file;
        }

        public int getFilesCreatedCount() {
            return this.m_filesCreatedCount;
        }

        private File getNextImageFile(String string) {
            String string2 = this.m_parentFile.getName();
            int n = string2.lastIndexOf(46);
            String string3 = string2.substring(0, n);
            if (null == string) {
                string = string2.length() > n + 1 ? string2.substring(n + 1) : "";
            }
            ++this.m_imageFileCount;
            string3 = string3 + String.format("%04x", this.m_imageFileCount) + "." + string;
            File file = new File(this.m_parentFile.getParent(), string3);
            return file;
        }

        public Callback.CreateNewFileResponse createNewFile(FileFormat fileFormat, FileFormat fileFormat2, Callback.AssociationValue associationValue, String string) throws IOException {
            File file = this.getNextImageFile(m_extensions.get(fileFormat2));
            MyRedirectedIO myRedirectedIO = new MyRedirectedIO(file, "rw");
            return new Callback.CreateNewFileResponse((Callback)this, (SeekableByteChannel6)myRedirectedIO, file.getName());
        }

        public void newFileInfo(FileFormat fileFormat, FileFormat fileFormat2, Callback.AssociationValue associationValue, String string, String string2) throws IOException {
            ++this.m_filesCreatedCount;
        }

        public Callback.OpenFileResponse openFile(Callback.FileTypeValue fileTypeValue, String string) throws IOException {
            Callback.OpenFileResponse openFileResponse = null;
            MyRedirectedIO myRedirectedIO = null;
            try {
                File file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File(this.m_sourceFile.getCanonicalFile().getParent(), string);
                }
                myRedirectedIO = new MyRedirectedIO(file, "r");
                openFileResponse = new Callback.OpenFileResponse((Callback)this, (SeekableByteChannel6)myRedirectedIO);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return openFileResponse;
        }

        static {
            m_extensions.put(FileFormat.FI_PDF, "pdf");
            m_extensions.put(FileFormat.FI_PNG, "png");
            m_extensions.put(FileFormat.FI_BMP, "bmp");
            m_extensions.put(FileFormat.FI_GIF, "gif");
            m_extensions.put(FileFormat.FI_TIFF, "tiff");
            m_extensions.put(FileFormat.FI_HTML, "html");
            m_extensions.put(FileFormat.FI_JPEGFIF, "jpg");
            m_extensions.put(FileFormat.FI_XML, "xml");
            m_extensions.put(FileFormat.FI_HTMLWCA, "html");
            m_extensions.put(FileFormat.FI_XHTMLB, "html");
            m_extensions.put(FileFormat.FI_HTMLAG, "html");
            m_extensions.put(FileFormat.FI_WIRELESSHTML, "html");
            m_extensions.put(FileFormat.FI_HTML5, "html");
            m_extensions.put(FileFormat.FI_JAVASCRIPT, "js");
            m_extensions.put(FileFormat.FI_HTML_CSS, "css");
            m_extensions.put(FileFormat.FI_TRUETYPEFONT, "ttf");
        }
    }

    public static class MyRedirectedIO
    implements SeekableByteChannel6 {
        RandomAccessFile raf;
        FileChannel fc;

        public MyRedirectedIO(File file, String string) throws FileNotFoundException {
            this.raf = new RandomAccessFile(file, string);
            this.fc = this.raf.getChannel();
        }

        public void close() {
            try {
                if (this.fc != null) {
                    this.fc.close();
                    this.fc = null;
                }
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public long position() throws IOException {
            return this.fc.position();
        }

        public SeekableByteChannel6 position(long l) throws IOException {
            this.fc.position(l);
            return this;
        }

        public int read(ByteBuffer byteBuffer) throws IOException {
            return this.fc.read(byteBuffer);
        }

        public long size() throws IOException {
            return this.fc.size();
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            return this.fc.write(byteBuffer);
        }

        public SeekableByteChannel6 truncate(long l) throws IOException {
            this.fc.truncate(l);
            return this;
        }

        public boolean isOpen() {
            return this.fc.isOpen();
        }
    }
}

