<jsp:include page="header.jsp" />

            <div class="row">
            <div class="col-lg-4 col-lg-offset-4" style="padding:10px 30px 10px 30px" id="content">
                <h2>Request Upgrade to v11</h2>
                <div>
                    <p>Please fill this form to request an upgrade of your CommCell to V11.</p>
                    <p>You will need to upload your CommServ database which will be used for testing your upgrade to V11. The test will check for all pre requisites and any inconsistencies in the database that could cause the upgrade to fail.</p>

                </div>
                <form ENCtype="multipart/form-data" action="../handleUpload.do" method="post" role="form" novalidate>

                    <div class="row">
                        <div class="col-lg-6 form-group">
                            <label for="firstname">First Name: <strong style="color:#FF2222; font-size:1.2em">*</strong></label>
                            <input type="text"  class="form-control" data-err="First Name is required" id="firstname" name = "firstname" placeholder="Enter First Name" data-validation="^[A-Za-z0-9 ^_]+" required/>
                        </div>
                        <div class="col-lg-6 form-group">
                            <label for="lastname">Last Name: <strong style="color:#FF2222; font-size:1.2em">*</strong></label>
                            <input type="text"  class="form-control" data-err="Last Name is required" id="lastname" name="lastname" placeholder="Enter Last Name" data-validation="^[A-Za-z0-9 ^_]+" required/>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-6 form-group">
                            <label for="primary_email">Email: <strong style="color:#FF2222; font-size:1.2em">*</strong></label>
                            <input type="email" data-err="Please enter a valid email" class="form-control" id="primary_email" name = "primary_email" placeholder="Enter e-mail ID" required/>
                            <p class="help-block" style="font-size:0.8em">(The above person will receive all upgrade related information such as upgrade test reports, etc.)</p>
                        </div>
                        <div class="col-lg-6 form-group">
                            <label for="company">Also Notify:</label>
                            <input type="text" data-err="Please enter valid emails" class="form-control validateMultipleEmails" id="also_notify" name="also_notify" placeholder="Enter e-mail ID's" validateMultipleEmails/>
                            <p class="help-block" style="font-size:0.8em">(comma separated list of email addresses that should also be notified)</p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-6 form-group">
                            <label for="commcell_id">CommCell ID: <strong style="color:#FF2222; font-size:1.2em">*</strong></label>
                            <input type="text" data-err="CommCell ID is invalid"  class="form-control validateCommCellId" id="commcell_id" name="commcell_id" placeholder = "Enter CommCell ID" validateCommCellId/>
                           <!--  <input type="button" class="btn btn-primary" name="Check Upgrade Eligibility" id="CheckUpgradeEligibility" value="Check Upgrade Eligibility" style="margin-top: 20px;"></input> -->
                        </div>

                        <div class="col-lg-6 form-group uploadgroup" >
                            <label for="request_type">Request Type: <strong style="color:#FF2222; font-size:1.2em">*</strong></label>
                            <select class="form-control" name="request_type" id="request_type" required data-err="Request Type is required">
                                <option disabled selected="selected">Select One</option>
                                <option value="Partner assisted upgrade">Partner assisted Upgrade</option>
                                <option value="Professional Services assisted upgrade">Professional Services assisted Upgrade (Fees will be incurred)</option>
                                <option value="Self-upgrade with Support Contact">Self-upgrade with Support Contact</option>

                            </select>
                    	</div>

						<label id="upgradeerrorlabel" style="display:none;color: red;margin-top: 10px;">Thank you for inquiring about the next generation of Commvault software: Version 11. Upgrades are currently regulated; please email maint_desk@commvault.com for next steps to upgrade. Thank you for being patient with this process.</label>

                    </div>
				<div class="uploadgroup" >

					<div class="form-group">
                        <label for="partner_email_id">Commvault/Partner Contact Email:</label>
                        <input type="email"  class="form-control" id = "partner_email_id" name = "partner_email_id" placeholder="Enter CommVault/Partner e-mail"/>
                    </div>

                    <div class="form-group">
                        <label for="features_enabled">Please describe any new V11 features.</label>
                        <textarea class="form-control" rows="3" id="features_enabled" name="features_enabled"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="commants">Comments: </label>
                        <textarea class="form-control" rows="3" id="comments" name = "comments"></textarea>
                        <p class="help-block">(you can include details like how soon you plan to upgrade)</p>
                    </div>

                    <div class="form-group">
                        <label for="file">Choose file to upload <strong style="color:#FF2222; font-size:1.2em">*</strong></label>
                        <input type="file" id="file" name="file" required data-err="File is required"/>
                        <p class="help-block">Choose the dump file or the logs bundle generated.</p>
                    </div>

                        <div class="form-group">
                            <label for="answer">To prevent spam, please solve the following Math problem.</label>
                            <img src="../getCaptcha.do" style="padding:20px"/>
                            <input name="answer" id="answer" class="form-control" data-err="Captcha is required" placeholder="Please solve above math." required/>
                        </div>

                        <div id="status"><h4 class='text-failure text-center'></h4></div>
                        <div id="progressDialog" style="display:none">
	                        <div class="progress">
						        <div class="bar"></div >
						        <div class="percent">0%</div >
						    </div>
						    <div class="unsupported" style="display: none">
						    	Your browser doesn't support reporting of Upload progress.
						    </div>
					    </div>

                    <div class="text-right submit_btn">
                        <input type="submit" class="btn btn-primary" name="submit" id="submit" value="Submit"></input>
                    </div>
                  </div>
                </form>
            </div>
        </div>
        <div class="row" style="padding:20px"/>

        <script nonce="${sessionScope.cspNonce}">
            (function() {
            	function isEmailValid(email) {
            		var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
            		return re.test(email);
            	}

            	$.validator.addMethod("validateCommCellId", function (value, element) {
            		if($.trim(value) == ''){
            			return false;
            		}
            		return /(^[0-9A-F]{1,6}$)/i.test(value);
                }, 'Invalid CommCell ID');

            	$.validator.addMethod("validateMultipleEmails", function (value, element) {
            		if($.trim(value) == ''){
            			return true;
            		}
            		var emails = value.split(",");
            		var allEmailsValid = true;
            		$.each(emails, function(){
            			if(!isEmailValid(this)){
            				allEmailsValid = false;
            				return false;
            			}
            		});
                    return allEmailsValid;
                }, 'Invalid email');

            	$('form').validate({ // initialize the plugin
                    rules: {
                    	also_notify: {
                        	validateMultipleEmails: true
                        }
                    },
                    errorPlacement: function(error, element) {
                    	element.popover('show');
                      },
                      onkeyup: false,
                      onclick: false,
                      onfocusout: false
                });

            	var bar = $('.bar');
            	var percent = $('.percent');
            	var status = $('#status h4');

            	$("[data-err]").each(function(){
            		var ele = $(this);
            		ele.popover({content:ele.data("err"), placement:'bottom', trigger: 'manual', delay: {show: 200, hide:5000}});
            		ele.on("blur", function(){
            			ele.popover('hide');
            		});
            		ele.on("focus", function(){
            			ele.popover('hide');
            		});
            	});

            	$("#CheckUpgradeEligibility").on("click", function(){
            		$.ajax({
 	    		        url : CONTEXT_PATH+"/validatecommcellid.do",
 	    		        type : "GET",
 	    		        success : function(data, status, xhr) {
   		        			if(xhr.getResponseHeader("success") == "true"){
   		        				$("#CheckUpgradeEligibility").hide();
   		        				$("#upgradeerrorlabel").hide();
   		        				$('#commcell_id').attr("readonly","readonly")
   		        				$(".uploadgroup").show();
   		        			}else{
   		        				$("#upgradeerrorlabel").show();
   		        				$(".uploadgroup").hide();
   		        			}
 	    		        },
 	    		        data : {ccid:$("#commcell_id").val()},
 	    		        async : false
 	    		    });
            	});

            	$("#submit").on("click", function(){
            		$("#submit").focus();
            		if(!$("form").valid()) {
            			console.debug("Form is not valid");
            			return false;
            		}
            		var success = false;
            		 $.ajax({
            		        url : CONTEXT_PATH+"/handleCheckCaptcha.do",
            		        type : "GET",
            		        success : function(data, status, xhr) {
            		        	success = xhr.getResponseHeader("success") == "true";
            		        },
            		        data : {captcha:$("#answer").val()},
            		        async : false
            		    });
            		 if(success) {
            			 return true;
            		 }
            		status.text("Incorrect value for Captcha.");
         			status.dialog({height: 125,
             	            width:450,
             	            autoOpen:true,
             	            closeOnEscape: false,
             	            modal: true,
             	            draggable: false,
             	            resizable: false});
            		 return false;
            	});

            	$('form').ajaxForm({
            	    beforeSend: function() {
            	        status.empty();
            	        var percentVal = '0%';
            	        bar.width(percentVal)
            	        percent.html(percentVal);
            	        if(!new XMLHttpRequest().upload){
            	        	$(".unsupported").show();
            	        	$(".progress").hide();
            	        } else {
            	        	$(".unsupported").hide();
            	        	$(".progress").show();
            	        }
            	        $("#progressDialog").dialog({
            	            height: 125,
            	            width:450,
            	            autoOpen:true,
            	            title: 'Uploading...',
            	            closeOnEscape: false,
            	            modal: true,
            	            draggable: false,
            	            resizable: false,
            	            beforeClose: function(){
            	            	return false;
            	            }
            	        });
            	    },
            	    uploadProgress: function(event, position, total, percentComplete) {
            	        var percentVal = percentComplete + '%';
            	        bar.width(percentVal)
            	        percent.html(percentVal);
            	    },
            	    success: function() {
            	        var percentVal = '100%';
            	        bar.width(percentVal)
            	        percent.html(percentVal);
            	    },
            	    error: function(){
            	    	$("#progressDialog").hide();
            	    	$("#progressDialog").dialog("destroy");
            	    	status.text("We're sorry, something went wrong. Please try again.");
            			status.dialog({height: 125,
                	            width:450,
                	            autoOpen:true,
                	            closeOnEscape: false,
                	            modal: true,
                	            draggable: false,
                	            resizable: false});
            	    },
            		complete: function(xhr) {
            			if("true" == xhr.getResponseHeader("success")){
            				window.location.href = "handleUploadResponse.do?errCode=" + xhr.getResponseHeader("errCode") + "&commcellId=" + xhr.getResponseHeader("commcellId") + "&reqId=" + xhr.getResponseHeader("reqId") + "&username=" +  xhr.getResponseHeader("username");
            			} else {
	            			status.text(xhr.responseText);
	            			$("#progressDialog").hide();
	            			$("#progressDialog").dialog("destroy");
	            			status.dialog({height: 125,
	                	            width:450,
	                	            autoOpen:true,
	                	            closeOnEscape: false,
	                	            modal: true,
	                	            draggable: false,
	                	            resizable: false});
            			}
            		}
            	});

            	})();
        </script>
<jsp:include page="footer.jsp" />