var applianceRegister = applianceRegister || {};
applianceRegister.vendor = 2;

applianceRegister.registerAppliance = function() {
	if (applianceRegister.validateInputs()) {
		var data = {};
		$(".textbox").each(function() {
			data[$(this).attr("name").toLowerCase()] = $(this).val();
		});
		data.vendortype = applianceRegister.vendor;
		if (window.cvCustomMask) {
			$("#content").mask("");
		}
		cvUtil
				.loadPage(
						commonUtil.CONTEXT_PATH
								+ applianceRegister.statesInfo[applianceRegister.currentstate].appdata.url,
						data, applianceRegister.registrationSuccess,
						applianceRegister.serverError);
	}

};

applianceRegister.registrationSuccess = function(data) {
	if (!$.isPlainObject(data)) {
		data = $.parseJSON(data);
	}
	var err = 0;
	var showOP = true;
	title = "Thank You";
	if (data.code != 0) {
		title = "Error";
		if (data.code == 5) {
			// show start over button.
			showOP = false;
			applianceRegister
					.showPageErrorMsg("There are some error happened, please start over by clicking top right corner button.");
		} else if (data.code == 4) {
			// show info like you will be redirected to a page in some secs.
			showOP = false;
			applianceRegister
					.showPageErrorMsg("It seems you missed a step, you will be redirected to that page in 30 sec.");
			applianceRegister.setTimeoutToPageLoad(commonUtil.CONTEXT_PATH
					+ data.data.nextpage);
		} else {
			err = -1;
		}
	}
	if (showOP) {
		timeout = 30000;
		if (cvUtil.showModal) {
			cvUtil.showModal({
				width : 220,
				height : 100,
				title : title,
				href : "registrationOP.jsp?code=" + err,
				iframe : true
			});
		} else {
			if (err == 0) {
				$("#nextBtn").addClass("disabled");
				$("#bckBtn").addClass("disabled");
				applianceRegister
						.showPageSuccessMsg("Thank you for your interest. The information you provided is being verified.<br>You will be notified via email once the account is created.");
			} else {

				applianceRegister
						.showPageErrorMsg("Your request cannot be processed at this time.<br>Check your inputs or Please contact <a href='mailto:cloudservices@commvault.com'>Cloud Services</a> for further details.");
			}
		}
		setTimeout(function() {
			applianceRegister.closeSession();
		}, timeout);
	}

};

applianceRegister.getCompanyInfo = function() {
	if (applianceRegister.validateInputs()) {
		var data = {};
		$(".textbox").each(function() {
			data[$(this).attr("name").toLowerCase()] = $(this).val();
		});
		data.vendortype = applianceRegister.vendor;
		if (window.cvCustomMask) {
			$("#content").mask("");
		}
		cvUtil
				.loadPage(
						commonUtil.CONTEXT_PATH
								+ applianceRegister.statesInfo[applianceRegister.currentstate].appdata.url,
						data, applianceRegister.checkSerialSuccess,
						applianceRegister.serverError);
	}
};

applianceRegister.checkSerialNumber = function() {
	if (applianceRegister.validateInputs()) {
		var data = {};
		data.applianceserial = $("#appSeNum").val();
		data.vendortype = applianceRegister.vendor;
		data.commcelltype = $('input[name="commtype"]:checked').val();
		if (window.cvCustomMask) {
			$("#content").mask("");
		}
		cvUtil.loadPage(commonUtil.CONTEXT_PATH
				+ applianceRegister.checkSerialUrl, data,
				applianceRegister.checkSerialSuccess,
				applianceRegister.serverError);
	}
};

applianceRegister.checkSerialSuccess = function(data) {
	if (!$.isPlainObject(data)) {
		data = $.parseJSON(data);
	}
	if (data.code != 0) {
		if (data.code == 2) {
			applianceRegister.showErrorMsgLabel("appSeNum");
			//$("#nextBtn").removeClass("disabled");
		} else {
			applianceRegister.showPageErrorMsg(data.msg);
			//$("#nextBtn").addClass("disabled");
		}
	} else {
		window.location = commonUtil.CONTEXT_PATH + data.data.nextpage;
	}
};

applianceRegister.serverError = function() {
	applianceRegister
			.showPageErrorMsg("Something unexpected happened, please try again or contact administrator.");
};

applianceRegister.sendApplianceInformation = function() {
	var data = {};
	data["applianceserial"] = applianceRegister.data.serials;
	data["commcells"] = applianceRegister.data.commcells;
	data["ips"] = applianceRegister.data.ips;
	data["serials"] = applianceRegister.data.softserials;
	data["regcodes"] = applianceRegister.data.regcodes;
	data.vendortype = applianceRegister.vendor;
	if (window.cvCustomMask) {
		$("#content").mask("");
	}
	cvUtil
			.loadPage(
					commonUtil.CONTEXT_PATH
							+ applianceRegister.statesInfo[applianceRegister.currentstate].appdata.url,
					data, applianceRegister.checkSerialSuccess,
					applianceRegister.serverError);
};

applianceRegister.getApplianceInformation = function() {
	if (applianceRegister.validateInputs()) {
		applianceRegister.data.serials = [];
		applianceRegister.data.commcells = [];
		applianceRegister.data.ips = [];
		applianceRegister.data.softserials = [];
		applianceRegister.data.regcodes = [];
		$(".serialtr").each(
				function(id) {
					$(this).find(".inp").each(function(i){
						var d = $(this).data("inpname");
						var v = $(this).val();
						if(typeof v === "undefined" || v === ""){
							v = $(this).text();
						}
						applianceRegister.data[d].push(v);
					});

				});
		if (applianceRegister.data.serials.length > 0
				&& (applianceRegister.data.serials.length == applianceRegister.data.commcells.length)
				&& (applianceRegister.data.serials.length == applianceRegister.data.ips.length)) {
			var trs = "";
			var tr = '<tr class="serialtr"><td> {#serial#} </td><td> {#commcell#} </td><td> {#ip#} </td><td> {#sws#} </td><td> {#regc#} </td></tr>';
			for (var i = 0; i < applianceRegister.data.serials.length; i++) {
				tr1 = tr.replace("{#serial#}",
						applianceRegister.data.serials[i]);
				tr1 = tr1.replace("{#commcell#}",
						applianceRegister.data.commcells[i]);
				tr1 = tr1.replace("{#ip#}", applianceRegister.data.ips[i]);
				tr1 = tr1.replace("{#sws#}", applianceRegister.data.softserials[i]);
				tr1 = tr1.replace("{#regc#}", applianceRegister.data.regcodes[i]);
				trs += tr1;
			}
			applianceRegister.statesInfo[applianceRegister.currentstate].appdata.tablehtml = $(
					"#appinfotbl").html();
			$("#appinfotbl").html(trs);

			applianceRegister.statesInfo[applianceRegister.currentstate].appdata.title = $(
					".logintitle").html();
			applianceRegister.statesInfo[applianceRegister.currentstate].appdata.subtitle = $(
					".subtitle").html();
			$("#nextBtn").data("state", 3);
			$("#nextBtn").text("Confirm");
			$("#bckBtn").removeClass("hideit");
			$(".logintitle")
					.html(applianceRegister.statesInfo[3].appdata.title);
			$(".subtitle").html(
					applianceRegister.statesInfo[3].appdata.subtitle);
		}
	}
};

applianceRegister.getCountries = function() {
	cvUtil
	.loadPage(
			commonUtil.CONTEXT_PATH
					+ applianceRegister.allcountriesurl,
			"", applianceRegister.populateCountries,
			applianceRegister.serverError, {
				callType : "GET"
			});
};

applianceRegister.populateCountries = function(data){
	console.log(data);
	if(data.code == 0){
		$.each(data.data.countries, function (i, item) {
			//console.log(item);
            $('#companyCountry').append($('<option>', {
                value: item.name,
                text : item.name
            }));

        });
		$('#companyCountry').chosen();
	}
};

applianceRegister.backClicked = function() {
	$("#nextBtn").data("state", 2).text("Next");
	$("#bckBtn").addClass("hideit");
	$(".logintitle").html(applianceRegister.statesInfo[2].appdata.title);
	$(".subtitle").html(applianceRegister.statesInfo[2].appdata.subtitle);
	$("#appinfotbl").html(applianceRegister.statesInfo[2].appdata.tablehtml);
	$(".serialtr").each(
			function(id) {
				$(this).find(".inp").each(function(i){
					var d = $(this).data("inpname");
					if(!$(this).is("p")){
						var v = applianceRegister.data[d][id];
						$(this).val(v);
					}
				});

			});
	/*$(".serialtr")
			.each(
					function(id) {
						$(this)
								.children()
								.each(
										function() {
											if ($(this).children(":first")
													.hasClass("commcell")) {
												$(this)
														.children(":first")
														.val(
																applianceRegister.data.commcells[id]);
											} else if ($(this).children(
													":first").hasClass("ip")) {
												$(this)
														.children(":first")
														.val(
																applianceRegister.data.ips[id]);
											}
										});
					});*/
};

applianceRegister.statesInfo = {
	1 : {
		divid : "serailNumDiv",
		controller : applianceRegister.checkSerialNumber
	},
	2 : {
		divid : "appInfoDiv",
		controller : applianceRegister.getApplianceInformation,
		appdata : {
			title : "",
			subtitle : ""
		}
	},
	3 : {
		divid : "appInfoDiv",
		controller : applianceRegister.sendApplianceInformation,
		appdata : {
			url : "/saveapplianceinfo.do",
			title : "Review Information",
			subtitle : "Kindly review information you provided and confirm or go back to make more changes"
		}
	},
	4 : {
		divid : "companyInfoDiv",
		controller : applianceRegister.getCompanyInfo,
		appdata : {
			url : "/saveappliancecompanyinfo.do"
		}
	},
	5 : {
		divid : "userContactDiv",
		controller : applianceRegister.registerAppliance,
		appdata : {
			url : "/appliancergistration.do"
		}
	}
};