<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<jsp:include page="../common/header.jsp">
	<jsp:param value="New Security Incident Report" name="title" />
	<jsp:param value="psirt.css" name="css"/>
</jsp:include>


	  <div id="psirtForm" class="commcellErrorForm"   >

		<div id="dataEntry">
			<p class="psirtTitle">Report Security Vulnerabilities</p>
			<p class="subtitle">Submit vulnerability information <a href="https://cloud.commvault.com/webconsole/reportsplus/reportViewer.jsp?reportId=Security Vulnerability Fixes" style="float:right">Current fixes</a></p>
			<div class="psirtMsg">&nbsp;</div>

			<label for="Name_label" id="Name_label" class="label">Name</label>
			<label class="mandatory">*</label>
			<input id="Name"  type="text" value=""  data-validation="^[^\/\\@]{1,40}$" data-msg="Please enter your name (may not contain / \ @)" class="textbox workflow-input"  name="Name">
			<label for="Name" class="error">&nbsp;</label>

			<label for="Email_label" id="Email_label" class="label">Email</label>
			<label class="mandatory">*</label>
			<input  id="Email" type="text" value=""  data-validation="^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$" data-msg="Please use a valid email address." class="textbox workflow-input" name="Email">
			<label for="Email" class="error">&nbsp;</label>

			<label for="Phone_label" id="Phone_label" class="label">Phone Number</label>
			<label class="mandatory">*</label>
			<input id="Phone" type="text" value=""  data-validation="^([\w-]{1,})$" data-msg="Please enter a valid phone number." class="textbox workflow-input" name="Phone"  autocomplete="off">
			<label for="Phone" class="error">&nbsp;</label>

			<label for="Company_label" id="Company_label" class="label">Company Name</label>
			<label class="mandatory">*</label>
			<input id="Company" type="text" value=""  data-validation="(?=.{1,}).*" data-msg="Please enter a company name." class="textbox workflow-input" name="Company"  autocomplete="off">
			<label for="Company" class="error">&nbsp;</label>

			<label for="CommvaultRelease_label" id="CommvaultRelease_label" class="label">Commvault Release that is Affected</label>
			<label class="mandatory">*</label>
			<select style="width:355px" name="CommvaultRelease" class="textbox" id="CommvaultRelease">
 				 <option value="V10">V10</option>
 				 <option value="V11" selected>V11</option>
			</select>
			<label for="CommvaultRelease" class="error">&nbsp;</label>

			<label for="ServicePack_label" id="ServicePack_label" class="label">Service Pack</label>
			<label class="mandatory">*</label>
			<input id="ServicePack" type="text" value=""  data-validation="^([\w-]{1,})$" data-msg="Please enter a valid service pack." class="textbox workflow-input" name="ServicePack"  autocomplete="off">
			<label for="ServicePack" class="error">&nbsp;</label>

			<label for="VulnerabilityType_label" id="VulnerabilityType_label" class="label">Vulnerability Type</label>
			<label class="mandatory">*</label>
			<input id="VulnerabilityType" type="text" value="" data-validation="(?=.{1,}).*" data-msg="Please enter a vulnerability type." class="textbox workflow-input" name="VulnerabilityType"  autocomplete="off">
			<label for="VulnerabilityType" class="error">&nbsp;</label>

			<label for="VulnerabilityName_label" id="VulnerabilityName_label" class="label">Vulnerability Name</label>
			<label class="mandatory">*</label>
			<input id="VulnerabilityName"  type="text" value="" data-validation="(?=.{1,}).*" data-msg="Please enter a vulnerability name." class="textbox workflow-input" name="VulnerabilityName" autocomplete="off">
			<label for="VulnerabilityName" class="error">&nbsp;</label>

			<label for="VulnerabilityDescription_label" id="VulnerabilityDescription_label" class="label">Vulnerability Description</label>
			<label class="mandatory">*</label>
			<input id="VulnerabilityDescription" type="text" value=""  data-validation="(?=.{1,}).*" data-msg="Please enter vulnerability description." class="textbox workflow-input" data-xmlencode="true" name="VulnerabilityDescription" autocomplete="off">
			<label for="VulnerabilityDescription" class="error">&nbsp;</label>

			<label for="Steps_label" id="Steps_label" class="label">Steps to Reproduce the Issue</label>
			<label class="mandatory">*</label>
			<textarea rows="5" cols="41" id="Steps" value="" data-validation="(?=.{1,}).*" data-msg="Enter the steps to reproduce the issue." class="textbox workflow-input" data-xmlencode="true" name="Steps" style="resize:none; " autocomplete="off"></textarea>
			<label for="Steps" class="error">&nbsp; </label>

			<input name="VulnerabilityExistsInDefault" type="checkbox" class="checkbox workflow-input" checked="checked" id="VulnerabilityExistsInDefault">
			<span class="inputTextCommonCls">Vulnerability Exists in the Default Configuration</span>
			<span class="mandatory">*</span>
			<br/>

			<input name="RequestPublicRecognition" type="checkbox" class="checkbox workflow-input" checked="checked" id="RequestPublicRecognition" >
			<span class="inputTextCommonCls">Requesting Public Recognition</span>
			<span class="mandatory">*</span>
			<br/>

			<input name="ExternalPublicDisclosurePlanned" type="checkbox" class="checkbox workflow-input" checked="checked" id="ExternalPublicDisclosurePlanned">
			<span class="inputTextCommonCls">External Public Disclosure Planned</span>
			<span class="mandatory">*</span>
			<br/>

			<div class="psirtMsg">&nbsp;</div>
			<label class="label" id="lblCaptcha1" for="captcha">Please solve the following Math problem</label>
			<label class="mandatory">*</label>
			<div id="newusrDynamicDiv" class="dynaImgDiv">

			</div>
			<input type="text" id="captcha" name="captcha" class="textbox workflow-input" data-validation="^([\d]{1,})$"  data-msg="Incorrect answer." autocomplete="off"/>
			<label class="captchaError error" id="captchaError" for="captcha">&nbsp;</label>

			<a id="okButton"  class="okSaveButton  nonCustomAction" href="#" data-action="" data-validate="true">OK</a>

		</div>


		<div id="disclose_Date">
			<p class="psirtTitle">New Security IncidentReport</p>
			<p class="subtitle">Please enter the planned date for external public disclosure</p>
			<div class="psirtMsg">&nbsp;</div>

			<div id="div_date" >
				<div class="psirtMsg">&nbsp;</div>
				<label for="date_label" id="date_label" class="label">Date for External Public Disclosure</label>
				 <label class="mandatory">*</label>
				<input id="disclosureDate" type="date" class="hasDatepicker workflow-input" style="width: 150px;"name="disclosureDate" value="">
				<div class="psirtMsg">&nbsp;</div>
				<label for="disclosureDate" class="error">&nbsp;</label>

			</div>
			<div class="psirtMsg">&nbsp;</div>
			<a id="okButton"  class="okSaveButtonDate  nonCustomAction" href="#" data-action="" data-validate="true">OK</a>

		</div>

		<div id="summary">
			<p class="psirtTitle">New Security Incident Report</p>
			<div id="div_summary">
				<div class="psirtMsg">&nbsp;</div>
				<p>A new security incident report with the following details will be submitted:</p>
				<br><br>
				<p id="Name_summ"><b>Name</b>: </p>
				<p id="Email_summ"><b>Email</b>: </p>
				<p id="Phone_summ"><b>Phone Number</b>: </p>
				<p id="Company_summ"><b>Company</b>: </p>
				<p id="CommvaultRelease_summ"><b>Commvault Release</b>: </p>
				<p id="ServicePack_summ"><b>Service Pack</b>: </p>
				<p id="VulnerabilityType_summ"><b>Vulnerability Type</b>: </p>
				<p id="VulnerabilityName_summ"><b>Vulnerability Name</b>: </p>
				<p id="VulnerabilityDescription_summ"><b>Vulnerability Description</b>: </p>
				<p id="VulnerabilityExistsInDefault_summ"><b>Vulnerability Exists in Default Configuration</b>: </p>
				<p id="RequestPublicRecognition_summ"><b>Requesting Public Recognition</b>: </p>
				<p id="ExternalPublicDisclosurePlanned_summ"><b>External Public Disclosure Planned</b>: </p>
				<p id="dateDisclose_summ"><b>Date for External Public Disclosure</b>: </p>
				<p id="Steps_summ"><b>Steps to Reproduce the issue</b>: </p>
				<div class="psirtMsg">&nbsp;</div>
			</div>
			<div class="workflowmsg hidden">&nbsp;</div>
				<button type="button" id="okButton" data-workname="PSIRT Reporting" class="workflowSbmtBtn mainBtn">Submit</button>
		</div>
	  </div>

<script nonce="${sessionScope.cspNonce}">
var localMsg = localMsg || {};
</script>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="../common/js/workflowhandler.js" name="js"/>
	<jsp:param value="psirt.js" name="js"/>
</jsp:include>