var cvUtil = cvUtil || {};
cvUtil.SESSION_TIMEOUT = 1800000
cvUtil.isSessionAlive = function (){};
cvUtil.setSessionTimeTask = function(){};
if(! cvUtil.loadPage){
	cvUtil.loadPage = function(tgtUrl, params, successFunc, errorFunc, options) {
		if (typeof (errorFunc) == 'undefined' || errorFunc == null) {
			errorFunc = cvUtil.handleError;
		}
		var callType = "POST";
		var timeout = cvUtil.DEFAULT_TIMEOUT;
		var async = true;

		if (!(typeof (options) == 'undefined' || options == null)) {
			if ("callType" in options) {
				callType = options.callType;
			}
			if ("timeout" in options) {
				timeout = options.timeout;
			}
			if ("async" in options) {
				async = options.async;
			}
		}

		return $.ajax({
			url : tgtUrl,
			type : callType,
			success : successFunc,
			error : function(xhr, ajaxOptions, thrownError){
				if (xhr.status == 401) {
					cvUtil.getTopWindow().location.href = cvUtil.getTopWindow().location.origin + cvUtil.CONTEXT_PATH + "/login/?relogin";
				} 
				else { 
				  errorFunc(xhr, ajaxOptions, thrownError);
				}
			},
			data : params,
			beforeSend: cvUtil.addCsrf,
			timeout : timeout,
			contentType : "application/x-www-form-urlencoded; charset=UTF-8",
			async : async
		});
	}
}
var commonUtil = commonUtil || {};