<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvcloudappstaglib.tld" prefix="cv" %>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">
<meta content="width=device-width, initial-scale=1.0" name="viewport">
<meta content="" name="description">
<c:if test="${param.title != null}">
	<c:set var="title" value="${param.title}" scope="page" />
</c:if>
<title>${title}</title>
<link rel="shortcut icon" href="../home/img/favicon.png" />


<link rel="stylesheet" href="../common/css/jquery-ui.css" />
<link rel="stylesheet" href="/webconsole/login/css/login.css" />
<link rel="stylesheet" href="../common/css/templatestyles.css" />

<link rel="stylesheet" href="/webconsole/common/css/jquery.loadmask.css?" />
<c:if test="${paramValues.css != null}">
	<c:forEach items="${paramValues.css}" var="cssFile">
		<c:if test="${(empty fn:trim(pageContext.request.contextPath)) || !fn:startsWith(cssFile, pageContext.request.contextPath)}">
			<c:set var="cssFile" value="${pageContext.request.contextPath}${pageContext.request.servletPath}/../${cssFile}" />
		</c:if>
		<c:if test="${cv:isSafeInclude(fn:escapeXml(cssFile))}" >
			<link rel="stylesheet" href="${fn:escapeXml(cssFile)}" />
		</c:if>
	</c:forEach>
</c:if>

<script nonce="${sessionScope.cspNonce}" src="../common/js/jquery-1.7.1.js"></script>
<script nonce="${sessionScope.cspNonce}" src="../common/js/jquery-ui-min.js"></script>
<script nonce="${sessionScope.cspNonce}" src="/webconsole/common/js/localforage.min.js"></script>
<script nonce="${sessionScope.cspNonce}" src="/webconsole/common/js/custom-modal.js"></script>
<script nonce="${sessionScope.cspNonce}" src="/webconsole/common/js/notification.js"></script>
<script nonce="${sessionScope.cspNonce}" src="/webconsole/common/js/notificationHistory.js"></script>
<script nonce="${sessionScope.cspNonce}" src="/webconsole/common/js/cvutil.js"></script>
<script nonce="${sessionScope.cspNonce}" src="/webconsole/common/js/logUtil.js"></script>
<script nonce="${sessionScope.cspNonce}" src="/webconsole/common/js/jquery.loadmask.min.js"></script>
<script nonce="${sessionScope.cspNonce}" src="../common/js/commonutil.js"></script>
 <script nonce="${sessionScope.cspNonce}">
 	commonUtil.CONTEXT_PATH = '${pageContext.request.contextPath}';
 </script>

</head>

<body>
<div id="container">
	<div id="header">
		<a href="/webconsole/applications"><img alt="CV Logo" id="pglogo"></a>

	</div>
	<div id="content">


