<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@ page import="java.io.BufferedReader,
				 java.io.File,
				 java.io.FileReader,
                 java.io.IOException,
                 java.io.InputStream,
                 java.io.InputStreamReader,
                 java.io.OutputStreamWriter,
                 java.net.HttpURLConnection,
                 java.lang.Thread,
                 java.net.URL,
                 java.net.URLEncoder,
				 java.io.*" %>
<%@ page import="org.apache.commons.lang3.StringEscapeUtils"%>
<%@ page import="com.google.gson.JsonObject"%>
<%@ page import="commvault.web.core.util.CVCoreUtil"%>
<%@ page import="org.apache.log4j.Logger"%>
<%@ page import="org.apache.log4j.LogManager"%>
<%!
	final Logger logger = LogManager.getLogger("commvault.web");
	String post_request(String uri, String method, String content) {
		// Verify all fields are provided
		logger.info("Content:"+content);
		if (uri == null) return "Error 500: URI not provided.";
		if (method == null) method = "GET";
		if (content == null) content = "";
		//if (!uri.substring(0, BASE_URI.length()).equals(BASE_URI)) return "Error 500: External URL requested";

		try {
			// Create HTTP Connection
		    HttpURLConnection con = (HttpURLConnection) new URL(uri).openConnection();
		    con.setRequestMethod(method);
		    con.setRequestProperty("Accept", "application/xml");

		    if (method.equals("POST") || method.equals("PUT")) {
		        //con.setRequestProperty("Content-type", "application/json");
		        con.setDoOutput(true);
		        OutputStreamWriter postBody = new OutputStreamWriter(con.getOutputStream());
		        postBody.write(content);
		        postBody.close();
		    }

		    // Read response into String
		    String responseBody = "";
		    InputStream is = con.getInputStream();
		    BufferedReader in = new BufferedReader(new InputStreamReader(is));
		    String line;
		    while ((line = in.readLine()) != null) responseBody += line + "\n";
		    in.close();
		    con.disconnect();

		    return responseBody;
		} catch (IOException e) {
			// Handle connection errors
		    if (e.getMessage().indexOf("Server returned HTTP response code: 401") == 0) {
		        return "Error 401: " + e.getMessage();
		    } else {
		        return "Error 503: " +  e.getMessage();
		    }
		}
	}
%>
<%
	URL aUrl = new URL(request.getScheme(),
		request.getServerName(),
		request.getServerPort(),
		request.getContextPath());
	final String BASE_URI = aUrl.toString();
	final Logger logger = LogManager.getLogger("commvault.web");



	// Fill string with workflow info from GET/POST data

	String commcellID = "", seNum = "", regCode="",emailAddress="", isRegistered="", PassBase64="", firstName="", lastName="", ipAddr="";
	commcellID = request.getParameter("commcellID");
	seNum = request.getParameter("seNum");
	regCode = request.getParameter("regCode");
	emailAddress = request.getParameter("emailAddress");
	isRegistered = request.getParameter("isRegistered");
	PassBase64 = request.getParameter("PassBase64");
	firstName = request.getParameter("firstName");
	lastName = request.getParameter("lastName");
	ipAddr = request.getParameter("ipAddr");



	JsonObject inputs = new JsonObject();
	inputs.addProperty("ipAddr", ipAddr);
	inputs.addProperty("commcellID", commcellID);
	inputs.addProperty("seNum", seNum);
	inputs.addProperty("regCode", regCode);
	inputs.addProperty("emailAddress", emailAddress);
	inputs.addProperty("isRegistered", isRegistered);
	inputs.addProperty("PassBase64", PassBase64);
	inputs.addProperty("firstName", firstName);
	inputs.addProperty("lastName", lastName);

	logger.info("BASE_URI:"+BASE_URI);
	logger.info(" ***START REGISTRATION ATTEMPT***");
	logger.info(" commcellID: [" + request.getParameter("commcellID") + "]" );
	logger.info(" seNum: [" + request.getParameter("seNum") + "]" );
	logger.info(" regCode: [" + request.getParameter("regCode") + "]" );
	logger.info(" emailAddress: [" + request.getParameter("emailAddress") + "]" );
	logger.info(" isRegistered: [" + request.getParameter("isRegistered") + "]" );
	logger.info(" PassBase64: [" + request.getParameter("PassBase64") + "]" );
	logger.info(" firstName: [" + request.getParameter("firstName") + "]" );
	logger.info(" lastName: [" + request.getParameter("lastName") + "]" );

	//JsonObject data = new JsonObject();
	//data.addProperty("name", "Commcell Registration");
	//data.addProperty("inputs", CVCoreUtil.getJsonForObject(inputs));
	String toPost = "name=Commcell Registration**&inputs="+URLEncoder.encode(CVCoreUtil.getJsonForObject(inputs), "utf-8");
	logger.info(" toPost: [" + toPost + "]" );
	String reply = post_request(BASE_URI + "/runworkflow.do", "POST", toPost);

	logger.info(" Response from workflow: [" + reply + "]");
	logger.info(" ***DONE***");


	out.print(reply);
%>