/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.webproxy;

import commvault.cte.webproxy.WebProxyAccessConstants;
import commvault.cte.webproxy.WebProxyWebService;
import commvault.cte.webproxy.WebProxyWebServiceSoap;
import commvault.cte.webproxy.WebProxyWebServiceSoap12Stub;
import commvault.cte.webproxy.WebProxyWebServiceSoapStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class WebProxyWebServiceLocator
extends Service
implements WebProxyWebService {
    private String webServiceURL;
    private HashSet ports = null;

    public WebProxyWebServiceLocator(String string) {
        this.webServiceURL = string;
    }

    public WebProxyWebServiceLocator(EngineConfiguration engineConfiguration) {
        super(engineConfiguration);
    }

    public WebProxyWebServiceLocator(String string, QName qName) throws ServiceException {
        super(string, qName);
    }

    @Override
    public String getWebProxyWebServiceSoap12Address() {
        return this.webServiceURL;
    }

    public String getDMProxyWebServiceSoap12WSDDServiceName() {
        return WebProxyAccessConstants.WEB_SERVICE_PORT_NAME_12;
    }

    public void setDMProxyWebServiceSoap12WSDDServiceName(String string) {
        WebProxyAccessConstants.WEB_SERVICE_PORT_NAME_12 = string;
    }

    @Override
    public WebProxyWebServiceSoap getWebProxyWebServiceSoap12() throws ServiceException {
        URL uRL;
        try {
            uRL = new URL(this.webServiceURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServiceException((Throwable)malformedURLException);
        }
        return this.getWebProxyWebServiceSoap12(uRL);
    }

    @Override
    public WebProxyWebServiceSoap getWebProxyWebServiceSoap12(URL uRL) throws ServiceException {
        try {
            WebProxyWebServiceSoap12Stub webProxyWebServiceSoap12Stub = new WebProxyWebServiceSoap12Stub(uRL, this);
            webProxyWebServiceSoap12Stub.setPortName(this.getDMProxyWebServiceSoap12WSDDServiceName());
            return webProxyWebServiceSoap12Stub;
        }
        catch (AxisFault axisFault) {
            return null;
        }
    }

    public void setDMProxyWebServiceSoap12EndpointAddress(String string) {
        this.webServiceURL = string;
    }

    @Override
    public String getWebProxyWebServiceSoapAddress() {
        return this.webServiceURL;
    }

    public String getDMProxyWebServiceSoapWSDDServiceName() {
        return WebProxyAccessConstants.WEB_SERVICE_PORT_NAME;
    }

    public void setDMProxyWebServiceSoapWSDDServiceName(String string) {
        WebProxyAccessConstants.WEB_SERVICE_PORT_NAME = string;
    }

    @Override
    public WebProxyWebServiceSoap getWebProxyWebServiceSoap() throws ServiceException {
        URL uRL;
        try {
            uRL = new URL(this.webServiceURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServiceException((Throwable)malformedURLException);
        }
        return this.getWebProxyWebServiceSoap(uRL);
    }

    @Override
    public WebProxyWebServiceSoap getWebProxyWebServiceSoap(URL uRL) throws ServiceException {
        try {
            WebProxyWebServiceSoapStub webProxyWebServiceSoapStub = new WebProxyWebServiceSoapStub(uRL, this);
            webProxyWebServiceSoapStub.setPortName(this.getDMProxyWebServiceSoapWSDDServiceName());
            return webProxyWebServiceSoapStub;
        }
        catch (AxisFault axisFault) {
            return null;
        }
    }

    public void setDMProxyWebServiceSoapEndpointAddress(String string) {
        this.webServiceURL = string;
    }

    public Remote getPort(Class clazz) throws ServiceException {
        try {
            if (WebProxyWebServiceSoap.class.isAssignableFrom(clazz)) {
                WebProxyWebServiceSoap12Stub webProxyWebServiceSoap12Stub = new WebProxyWebServiceSoap12Stub(new URL(this.webServiceURL), this);
                webProxyWebServiceSoap12Stub.setPortName(this.getDMProxyWebServiceSoap12WSDDServiceName());
                return webProxyWebServiceSoap12Stub;
            }
            if (WebProxyWebServiceSoap.class.isAssignableFrom(clazz)) {
                WebProxyWebServiceSoapStub webProxyWebServiceSoapStub = new WebProxyWebServiceSoapStub(new URL(this.webServiceURL), this);
                webProxyWebServiceSoapStub.setPortName(this.getDMProxyWebServiceSoapWSDDServiceName());
                return webProxyWebServiceSoapStub;
            }
        }
        catch (Throwable throwable) {
            throw new ServiceException(throwable);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (clazz == null ? "null" : clazz.getName()));
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        if (qName == null) {
            return this.getPort(clazz);
        }
        String string = qName.getLocalPart();
        if (WebProxyAccessConstants.WEB_SERVICE_PORT_NAME_12.equals(string)) {
            return this.getWebProxyWebServiceSoap12();
        }
        if (WebProxyAccessConstants.WEB_SERVICE_PORT_NAME.equals(string)) {
            return this.getWebProxyWebServiceSoap();
        }
        Remote remote = this.getPort(clazz);
        ((Stub)remote).setPortName(qName);
        return remote;
    }

    public QName getServiceName() {
        return new QName(WebProxyAccessConstants.WEB_SERVICE_NAMESPACE, WebProxyAccessConstants.WEB_SERVICE_SERVICENAME);
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName(WebProxyAccessConstants.WEB_SERVICE_NAMESPACE, WebProxyAccessConstants.WEB_SERVICE_PORT_NAME_12));
            this.ports.add(new QName(WebProxyAccessConstants.WEB_SERVICE_NAMESPACE, WebProxyAccessConstants.WEB_SERVICE_PORT_NAME));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String string, String string2) throws ServiceException {
        if (WebProxyAccessConstants.WEB_SERVICE_PORT_NAME_12.equals(string)) {
            this.setDMProxyWebServiceSoap12EndpointAddress(string2);
        } else if (WebProxyAccessConstants.WEB_SERVICE_PORT_NAME.equals(string)) {
            this.setDMProxyWebServiceSoapEndpointAddress(string2);
        } else {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + string);
        }
    }

    public void setEndpointAddress(QName qName, String string) throws ServiceException {
        this.setEndpointAddress(qName.getLocalPart(), string);
    }
}

