/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.Logger;
import commvault.cte.util.RuntimeContext;
import java.util.Vector;

public final class ThreadPoolManager
implements RuntimeContext.ExitApplicationListener {
    private static ThreadPoolManager sharedInstance = null;
    private static DedicatedGC dedicatedGcThread = new DedicatedGC();
    private Object syncObject = new Object();
    private static Vector workerThreads;
    private int minIdleThreads = 1;

    public static void printOutThreadPoolSize() {
        String string = "printOutThreadPoolSize";
        String string2 = ThreadPoolManager.class.toString();
        Logger.write(Logger.INFO, string2, string, "***********Thread Pool***********");
        Logger.write(Logger.INFO, string2, string, "size() = " + workerThreads.size());
        for (int i = 0; i < workerThreads.size(); ++i) {
            Logger.write(Logger.INFO, string2, string, workerThreads.elementAt(i));
        }
    }

    public ThreadPoolManager() {
        this(1);
    }

    public ThreadPoolManager(int n) {
        this(1, 1);
    }

    public ThreadPoolManager(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial Thread Pool Size should be greater than or equal to 0.");
        }
        this.minIdleThreads = n2;
        RuntimeContext.instance().addExitApplicationListener(this);
        workerThreads = new Vector(n, 3);
        for (int i = n - 1; i >= 0; --i) {
            workerThreads.add(new WorkerThread());
        }
    }

    public static ThreadPoolManager getSharedInstance() {
        return sharedInstance;
    }

    private void removeThreadFromPool(WorkerThread workerThread) {
        workerThreads.remove(workerThread);
    }

    public static WorkerThread runJobInSharedInstance(Runnable runnable) {
        return sharedInstance.runJob(runnable, null);
    }

    public static WorkerThread runJobInSharedInstance(Runnable runnable, Object object) {
        return sharedInstance.runJob(runnable, object);
    }

    public static void gc() {
        if (DedicatedGC.isRunning) {
            return;
        }
        DedicatedGC.isRunning = true;
        ThreadPoolManager.runJobInSharedInstance(dedicatedGcThread);
    }

    public synchronized WorkerThread runJob(Runnable runnable) {
        return this.runJob(runnable, null);
    }

    public synchronized WorkerThread runJob(Runnable runnable, Object object) {
        for (int i = workerThreads.size() - 1; i >= 0; --i) {
            WorkerThread workerThread = (WorkerThread)workerThreads.get(i);
            if (!workerThread.setJob(runnable, object)) continue;
            return workerThread;
        }
        WorkerThread workerThread = new WorkerThread(runnable, object);
        workerThreads.add(workerThread);
        workerThread.start();
        return workerThread;
    }

    public int getNoOfIdleThreads() {
        int n = 0;
        for (int i = workerThreads.size() - 1; i >= 0; --i) {
            if (!((WorkerThread)workerThreads.get(i)).isIdle()) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isKeepThreadAlive(WorkerThread workerThread) {
        Object object = this.syncObject;
        synchronized (object) {
            int n = this.getNoOfIdleThreads();
            if (workerThread.isIdle()) {
                --n;
            }
            if (n >= this.minIdleThreads) {
                this.removeThreadFromPool(workerThread);
                return false;
            }
            return true;
        }
    }

    public int getThreadCount() {
        return workerThreads.size();
    }

    @Override
    public void appExit() {
        workerThreads.clear();
    }

    static {
        sharedInstance = new ThreadPoolManager(3, 3);
    }

    private static class DedicatedGC
    implements Runnable {
        static boolean isRunning = false;

        private DedicatedGC() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
        }
    }

    public class WorkerThread
    extends Thread {
        private boolean isIdle = true;
        private Runnable jobToRun;
        boolean exitThread;
        private boolean run = true;
        private Object lockObject = new Object();
        private Object jobParameter;

        @Override
        public String toString() {
            return super.toString() + "[ isIdle  = " + this.isIdle + "; jobToRun = " + this.jobToRun + "; run = " + this.run + " ]";
        }

        public WorkerThread() {
            this.start();
        }

        public WorkerThread(Runnable runnable, Object object) {
            this.setJob(runnable, object);
        }

        public boolean isIdle() {
            return this.isIdle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setJob(Runnable runnable, Object object) {
            if (this.isIdle) {
                Object object2 = this.lockObject;
                synchronized (object2) {
                    this.jobToRun = runnable;
                    this.jobParameter = object;
                    this.isIdle = false;
                    this.lockObject.notify();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            Object object = this.lockObject;
            synchronized (object) {
                this.lockObject.notify();
            }
        }

        public Runnable getJob() {
            return this.jobToRun;
        }

        public void debugExit() {
            this.exitThread = true;
            this.run = false;
            try {
                this.isIdle = false;
                ThreadPoolManager.this.removeThreadFromPool(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.run) {
                    if (this.exitThread) {
                        return;
                    }
                    if (this.jobToRun != null) {
                        this.isIdle = false;
                        if (this.jobToRun instanceof RunnableJob) {
                            ((RunnableJob)this.jobToRun).run(this.jobParameter);
                        } else {
                            this.jobToRun.run();
                        }
                    }
                    if (this.exitThread) {
                        return;
                    }
                    Object object = this.lockObject;
                    synchronized (object) {
                        boolean bl = ThreadPoolManager.this.isKeepThreadAlive(this);
                        this.isIdle = true;
                        if (this.jobToRun != null && this.jobToRun == dedicatedGcThread) {
                            DedicatedGC.isRunning = false;
                        }
                        this.jobToRun = null;
                        if (!bl) return;
                        this.lockObject.wait();
                    }
                }
                return;
            }
            catch (Exception exception) {
                this.isIdle = false;
                ThreadPoolManager.this.removeThreadFromPool(this);
                exception.printStackTrace();
            }
        }
    }

    public static interface RunnableJob
    extends Runnable {
        public void run(Object var1);
    }
}

