/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.component.ByteDataSizeEnum;
import commvault.cte.component.JSLabel;
import commvault.cte.reports.NetworkFormatter;
import commvault.cte.reports.util.CapacityFormatter;
import commvault.cte.reports.util.CountFormatter;
import commvault.cte.reports.util.DurationFormatter;
import commvault.cte.reports.util.SecondsDurationFormatter;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.text.NumberFormat;
import java.util.Hashtable;

public final class ReportUtilities {
    private static final JSLabel fontMetricsLabel = new JSLabel();
    private static Hashtable<ByteDataSizeEnum, Integer> sizeTable = new Hashtable();
    public static final String DEFAULT_BROWSE_DIRECTORY = ".";
    public static File CURRENT_BROWSE_DIRECTORY = new File(".");
    public static final int START_ZOOM_PERCENTAGE_VALUE = 50;
    public static final int END_ZOOM_PERCENTAGE_VALUE = 100;
    public static final int DEFAULT_SCALE = 100;
    public static int fileCount = 0;
    public static final int DEFAULT_TBL_HDR_FONT_SIZE = 10;
    public static final int DEFAULT_TBL_TXT_FONT_SIZE = 10;
    public static final int DEFAULT_REDUCED_SCALE_FOR_ALL_REPORTS = 70;
    protected int scale = 70;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    private int pageOrientation = 0;
    public static Font FONT_LABEL_PLAIN_DEFAULT;
    public static Font FONT_LABEL_BOLD_DEFAULT;
    public static Font FONT_LABEL_PLAIN_12;
    public static Font FONT_LABEL_BOLD_12;
    public static Font FONT_LABEL_PLAIN_14;
    public static Font FONT_LABEL_BOLD_14;
    public static Font FONT_TABLE_PLAIN_DEFAULT;
    public static Font FONT_TABLE_BOLD_DEFAULT;
    public static Font FONT_TREE_PLAIN_DEFAULT;
    public static Font FONT_TREE_BOLD_DEFAULT;

    public static int getLineWidth(Font font, String string) {
        fontMetricsLabel.setFont(font);
        return ReportUtilities.getFontMetrics(fontMetricsLabel).stringWidth(string);
    }

    public static int getLineWidth(String string) {
        return ReportUtilities.getFontMetrics(fontMetricsLabel).stringWidth(string);
    }

    public static FontMetrics getFontMetrics(Component component) {
        return component.getFontMetrics(component.getFont());
    }

    public static String removeStringHtml(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("<td align=left, valign=top>", "").replaceAll("<TD  NOWRAP ALIGN=LEFT, VALIGN=TOP>", "").replaceAll("<TD ALIGN=LEFT, VALIGN=TOP>", "");
        string = string.replaceAll("<td nowrap align=left, valign=top>", "").replaceAll("<TD  NOWRAP ALIGN=LEFT, VALIGN=TOP>", "");
        string = string.replaceAll("<tr>", "").replaceAll("<TR>", "");
        string = string.replaceAll("<td>", "");
        string = string.replaceAll("<table>", "").replaceAll("<TABLE CELLSPACING=0 CELLPADDING=0>", "");
        string = string.replaceAll("<html>", "").replaceAll("</html>", "").replaceAll("</HTML>", "");
        string = string.replaceAll("<font size=3>", "").replaceAll("</font>", "").replaceAll("</FONT>", "");
        string = string.replaceAll("</tr>", "\n").replaceAll("</TR>", "\n");
        string = string.replaceAll("</table>", "\n").replaceAll("</TABLE>", "\n");
        string = string.replaceAll("<html><font size=4>", "").replaceAll("<HTML><FONT SIZE=4>", "");
        string = string.replaceAll("&#32;", "");
        string = string.replaceAll("<B>", "").replaceAll("<b>", "");
        string = string.replaceAll("</B>", "").replaceAll("</b>", "");
        string = string.replaceAll("</I>", "").replaceAll("</i>", "");
        string = string.replaceAll("<I>", "").replaceAll("<i>", "");
        string = string.replaceAll("<br>", "\n").replaceAll("<BR>", "\n");
        string = string.replaceAll("<p>", "").replaceAll("</p>", " ").replaceAll("<center>", "").replaceAll("</center>", "");
        string = string.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&#39;", "\"");
        string = string.replaceAll("<U>", "").replaceAll("<u>", "");
        string = string.replaceAll("</U>", "").replaceAll("</u>", "");
        string = string.replaceAll("<body>", "").replaceAll("</body>", "").replaceAll("</BODY>", "");
        return string;
    }

    public static String replaceAllCommonHTMLEntities(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("\"", "&quot;");
        string2 = string2.replaceAll("\"", "&#39;");
        return string2;
    }

    public static String getFormattedText(String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = "<html>";
        string = ReportUtilities.replaceAllCommonHTMLEntities(string);
        if (bl) {
            string2 = string2 + "<b>";
        }
        if (bl2) {
            string2 = bl3 ? string2 + "<u><font color=#FF0000>" : string2 + "<u>";
        }
        string2 = string2 + string;
        if (bl2) {
            string2 = bl3 ? string2 + "</u></font>" : string2 + "</u>";
        }
        if (bl) {
            string2 = string2 + "</b>";
        }
        string2 = string2 + "</html>";
        return string2;
    }

    public static String getChartMBString(long l) {
        return ReportUtilities.getSizeString(l, ByteDataSizeEnum.MB);
    }

    public static String getSizeString(float f, ByteDataSizeEnum byteDataSizeEnum) {
        return ReportUtilities.getSizeString(f, byteDataSizeEnum, false, null);
    }

    public static String getSizeString(float f, ByteDataSizeEnum byteDataSizeEnum, boolean bl, ByteDataSizeEnum byteDataSizeEnum2) {
        int n;
        String string = "";
        int n2 = n = sizeTable.get(byteDataSizeEnum).intValue();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(1);
        double d = f;
        if (bl) {
            n2 = sizeTable.get(byteDataSizeEnum2);
            int n3 = Math.abs(n - n2);
            if (n < n2) {
                for (int i = 0; i < n3; ++i) {
                    d /= 1024.0;
                }
            } else if (n > n2) {
                for (int i = 0; i < n3; ++i) {
                    d *= 1024.0;
                }
            }
        } else if (d >= 1.125899906842624E15) {
            d /= 1.125899906842624E15;
            n2 += 5;
        } else if (d >= 1.099511627776E12) {
            d /= 1.099511627776E12;
            n2 += 4;
        } else if (d >= 1.073741824E9) {
            d /= 1.073741824E9;
            n2 += 3;
        } else if (d >= 1048576.0) {
            d /= 1048576.0;
            n2 += 2;
        } else if (d >= 1024.0) {
            d /= 1024.0;
            ++n2;
        }
        if (n == 0) {
            numberFormat.setMinimumFractionDigits(0);
        }
        string = n2 >= ByteDataSizeEnum.values().length ? "-1" : numberFormat.format(d) + " " + ByteDataSizeEnum.values()[n2];
        return string;
    }

    public static File getCurrentBrowseDirectory() {
        return CURRENT_BROWSE_DIRECTORY;
    }

    public static void setCurrentBrowseDirectory(File file) {
        CURRENT_BROWSE_DIRECTORY = file;
    }

    public static int getScaleFromPercentageString(String string) {
        return Integer.parseInt(string.substring(0, string.length() - 1));
    }

    public static boolean isValidFileName(String string) {
        if (string.indexOf(63) != -1 || string.indexOf(42) != -1) {
            return false;
        }
        return !string.matches("[:*?\"<>|]");
    }

    public static long getNumberSpacing(double d, int n) {
        d = n == 5 ? (d *= 0.2) : (n == 10 ? (d *= 0.1) : (d /= (double)n));
        if (d < 1.0) {
            return 1L;
        }
        long l = 1L;
        while (d >= 10.0) {
            d /= 10.0;
            l *= 10L;
        }
        return Math.round(d) * l;
    }

    public static CapacityFormatter getCapacityFormatter(ByteDataSizeEnum byteDataSizeEnum) {
        switch (byteDataSizeEnum) {
            case BYTES: {
                return CapacityFormatter.BYTES;
            }
            case KB: {
                return CapacityFormatter.KBYTES;
            }
            case MB: {
                return CapacityFormatter.MBYTES;
            }
            case GB: {
                return CapacityFormatter.GBYTES;
            }
            case TB: {
                return CapacityFormatter.TBYTES;
            }
            case PB: {
                return CapacityFormatter.PBYTES;
            }
            case EB: {
                return CapacityFormatter.EBYTES;
            }
        }
        return CapacityFormatter.BYTES;
    }

    public static ByteDataSizeEnum getDataSizeUnit(CapacityFormatter capacityFormatter) {
        if (capacityFormatter.equals(CapacityFormatter.BYTES)) {
            return ByteDataSizeEnum.BYTES;
        }
        if (capacityFormatter.equals(CapacityFormatter.KBYTES)) {
            return ByteDataSizeEnum.KB;
        }
        if (capacityFormatter.equals(CapacityFormatter.MBYTES)) {
            return ByteDataSizeEnum.MB;
        }
        if (capacityFormatter.equals(CapacityFormatter.GBYTES)) {
            return ByteDataSizeEnum.GB;
        }
        if (capacityFormatter.equals(CapacityFormatter.TBYTES)) {
            return ByteDataSizeEnum.TB;
        }
        if (capacityFormatter.equals(CapacityFormatter.PBYTES)) {
            return ByteDataSizeEnum.PB;
        }
        if (capacityFormatter.equals(CapacityFormatter.EBYTES)) {
            return ByteDataSizeEnum.EB;
        }
        return ByteDataSizeEnum.GB;
    }

    public static CapacityFormatter getCapacityFormatter(double d) {
        CapacityFormatter capacityFormatter = null;
        for (int i = CapacityFormatter._formats.length - 1; i >= 0; --i) {
            capacityFormatter = CapacityFormatter._formats[i];
            long l = capacityFormatter.getMinFactor();
            if (!(d >= (double)l)) continue;
            return capacityFormatter;
        }
        capacityFormatter = CapacityFormatter._formats[0];
        return capacityFormatter;
    }

    public static CapacityFormatter getCapacityFormatter(double d, boolean bl) {
        if (bl) {
            return ReportUtilities.getCapacityFormatterWithMB(d);
        }
        return ReportUtilities.getCapacityFormatter(d);
    }

    public static CapacityFormatter getCapacityFormatterWithMB(double d) {
        CapacityFormatter capacityFormatter = null;
        for (int i = CapacityFormatter._formatsWithMB.length - 1; i >= 0; --i) {
            capacityFormatter = CapacityFormatter._formatsWithMB[i];
            long l = capacityFormatter.getMinFactor() / 0x100000L;
            if (!(d >= (double)l)) continue;
            return capacityFormatter;
        }
        capacityFormatter = CapacityFormatter._formatsWithMB[0];
        return capacityFormatter;
    }

    public static NetworkFormatter getNetworkFormatter(double d) {
        NetworkFormatter networkFormatter = null;
        for (int i = NetworkFormatter._formats.length - 1; i >= 0; --i) {
            networkFormatter = NetworkFormatter._formats[i];
            long l = networkFormatter.getMinFactor();
            if (!(d >= (double)l)) continue;
            return networkFormatter;
        }
        networkFormatter = NetworkFormatter._formats[0];
        return networkFormatter;
    }

    public static DurationFormatter getDurationFormatter(double d) {
        DurationFormatter durationFormatter = null;
        for (int i = DurationFormatter._formats.length - 1; i >= 0; --i) {
            durationFormatter = DurationFormatter._formats[i];
            long l = durationFormatter.getMinFactor();
            if (!(d >= (double)l)) continue;
            return durationFormatter;
        }
        durationFormatter = DurationFormatter._formats[0];
        return durationFormatter;
    }

    public static SecondsDurationFormatter getSecondsDurationFormatter(double d, boolean bl) {
        SecondsDurationFormatter secondsDurationFormatter = null;
        SecondsDurationFormatter[] secondsDurationFormatterArray = SecondsDurationFormatter._formats;
        if (bl) {
            secondsDurationFormatterArray = SecondsDurationFormatter._microFormats;
        }
        for (int i = secondsDurationFormatterArray.length - 1; i >= 0; --i) {
            secondsDurationFormatter = secondsDurationFormatterArray[i];
            double d2 = secondsDurationFormatter.getMinFactor();
            if (!(d >= d2)) continue;
            return secondsDurationFormatter;
        }
        secondsDurationFormatter = secondsDurationFormatterArray[0];
        return secondsDurationFormatter;
    }

    public static SecondsDurationFormatter getSecondsDurationFormatter(double d) {
        return ReportUtilities.getSecondsDurationFormatter(d, false);
    }

    public static SecondsDurationFormatter getMicroSecondsDurationFormatter(double d) {
        return ReportUtilities.getSecondsDurationFormatter(d, true);
    }

    public static CountFormatter getCountFormatter(double d) {
        CountFormatter countFormatter = null;
        for (int i = CountFormatter._formats.length - 1; i >= 0; --i) {
            countFormatter = CountFormatter._formats[i];
            long l = countFormatter.getUnitValue();
            if (!(d >= (double)l)) continue;
            return countFormatter;
        }
        countFormatter = CountFormatter._formats[0];
        return countFormatter;
    }

    public static CountFormatter getCostFormatter(double d) {
        return CountFormatter.ONES;
    }

    static {
        for (int i = 0; i < ByteDataSizeEnum.values().length; ++i) {
            sizeTable.put(ByteDataSizeEnum.values()[i], new Integer(i));
        }
    }
}

