/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class MfDate {
    private GregorianCalendar _base;
    private static long MILLIS_PER_DAY = 86400000L;

    public MfDate(int n, int n2, int n3) {
        this.initialize(new GregorianCalendar(n, n2, n3));
    }

    public MfDate(GregorianCalendar gregorianCalendar) {
        this.initialize(gregorianCalendar);
    }

    private void initialize(GregorianCalendar gregorianCalendar) {
        this._base = this.trimToDays(gregorianCalendar);
    }

    private GregorianCalendar trimToDays(GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        gregorianCalendar2.set(11, 0);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        gregorianCalendar2.set(14, 0);
        return gregorianCalendar2;
    }

    public GregorianCalendar getCalendar() {
        return this._base;
    }

    public boolean after(MfDate mfDate) {
        return this.getTime().after(mfDate.getTime());
    }

    public boolean before(MfDate mfDate) {
        return this.getTime().before(mfDate.getTime());
    }

    public int compareTo(Object object) {
        MfDate mfDate = (MfDate)object;
        return this.getTime().compareTo(mfDate.getTime());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MfDate)) {
            return false;
        }
        MfDate mfDate = (MfDate)object;
        return this._base.equals(mfDate._base);
    }

    public Date getTime() {
        return this._base.getTime();
    }

    public MfDate addDays(int n) {
        return new MfDate(new GregorianCalendar(this.getYear(), this.getMonth(), this.getDayOfMonth() + n));
    }

    public MfDate minusDays(int n) {
        return this.addDays(-n);
    }

    public MfDate addMonths(int n) {
        return new MfDate(new GregorianCalendar(this.getYear(), this.getMonth() + n, this.getDayOfMonth()));
    }

    public int getYear() {
        return this._base.get(1);
    }

    public int getMonth() {
        return this._base.get(2);
    }

    public int getDayOfMonth() {
        return this._base.get(5);
    }

    public int daysUntil(MfDate mfDate) {
        long l = mfDate.getTime().getTime() - this.getTime().getTime();
        return (int)(l / MILLIS_PER_DAY);
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateInstance();
        return dateFormat.format(this.getTime());
    }

    public MfDate copy() {
        return new MfDate(this.getYear(), this.getMonth(), this.getDayOfMonth());
    }
}

