/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class IntervalTree {
    private StatisticUpdate updater = new IntervalTreeStatisticUpdate();
    private RbTree tree = new RbTree(this.updater);
    private Map intervals;
    private Map max;
    private Map min;
    private Logger logger = Logger.getLogger(this.getClass().toString());

    public IntervalTree() {
        this.intervals = new WeakHashMap();
        this.intervals.put(RbNode.NIL, null);
        this.max = new WeakHashMap();
        this.max.put(RbNode.NIL, new Integer(Integer.MIN_VALUE));
        this.min = new WeakHashMap();
        this.min.put(RbNode.NIL, new Integer(Integer.MAX_VALUE));
    }

    public void insert(Interval interval) {
        RbNode rbNode = new RbNode(interval.getLow());
        this.intervals.put(rbNode, interval);
        this.tree.insert(rbNode);
    }

    public int size() {
        return this.tree.size();
    }

    public Interval search(Interval interval) {
        RbNode rbNode = this.tree.root();
        if (rbNode.isNull()) {
            return null;
        }
        while (!rbNode.isNull() && !this.getInterval(rbNode).overlaps(interval)) {
            if (this.canOverlapOnLeftSide(interval, rbNode)) {
                rbNode = rbNode.left;
                continue;
            }
            if (this.canOverlapOnRightSide(interval, rbNode)) {
                rbNode = rbNode.right;
                continue;
            }
            return null;
        }
        assert (rbNode != null);
        return this.getInterval(rbNode);
    }

    private boolean canOverlapOnLeftSide(Interval interval, RbNode rbNode) {
        return !rbNode.left.isNull() && this.getMax(rbNode.left) >= interval.getLow();
    }

    private boolean canOverlapOnRightSide(Interval interval, RbNode rbNode) {
        return !rbNode.right.isNull() && this.getMin(rbNode.right) <= interval.getHigh();
    }

    public List searchAll(Interval interval) {
        this.logger.fine("Starting search for " + interval);
        if (this.tree.root().isNull()) {
            return new ArrayList();
        }
        return this._searchAll(interval, this.tree.root());
    }

    private List _searchAll(Interval interval, RbNode rbNode) {
        assert (!rbNode.isNull());
        this.logger.fine("Looking at " + this.getInterval(rbNode));
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        if (this.getInterval(rbNode).overlaps(interval)) {
            arrayList.add(this.getInterval(rbNode));
            this.logger.fine("match");
        } else {
            this.logger.fine("mismatch");
        }
        if (this.canOverlapOnLeftSide(interval, rbNode)) {
            arrayList.addAll(this._searchAll(interval, rbNode.left));
        }
        if (this.canOverlapOnRightSide(interval, rbNode)) {
            arrayList.addAll(this._searchAll(interval, rbNode.right));
        }
        return arrayList;
    }

    public Interval getInterval(RbNode rbNode) {
        assert (rbNode != null);
        assert (!rbNode.isNull());
        assert (this.intervals.containsKey(rbNode));
        return (Interval)this.intervals.get(rbNode);
    }

    public int getMax(RbNode rbNode) {
        assert (rbNode != null);
        assert (this.intervals.containsKey(rbNode));
        return (Integer)this.max.get(rbNode);
    }

    private void setMax(RbNode rbNode, int n) {
        this.max.put(rbNode, new Integer(n));
    }

    public int getMin(RbNode rbNode) {
        assert (rbNode != null);
        assert (this.intervals.containsKey(rbNode));
        return (Integer)this.min.get(rbNode);
    }

    private void setMin(RbNode rbNode, int n) {
        this.min.put(rbNode, new Integer(n));
    }

    public boolean isValid() {
        return this.tree.isValid() && this.hasCorrectMaxFields(this.tree.root) && this.hasCorrectMinFields(this.tree.root);
    }

    private boolean hasCorrectMaxFields(RbNode rbNode) {
        if (rbNode.isNull()) {
            return true;
        }
        return this.getRealMax(rbNode) == this.getMax(rbNode) && this.hasCorrectMaxFields(rbNode.left) && this.hasCorrectMaxFields(rbNode.right);
    }

    private boolean hasCorrectMinFields(RbNode rbNode) {
        if (rbNode.isNull()) {
            return true;
        }
        return this.getRealMin(rbNode) == this.getMin(rbNode) && this.hasCorrectMinFields(rbNode.left) && this.hasCorrectMinFields(rbNode.right);
    }

    private int getRealMax(RbNode rbNode) {
        if (rbNode.isNull()) {
            return Integer.MIN_VALUE;
        }
        int n = this.getRealMax(rbNode.left);
        int n2 = this.getRealMax(rbNode.right);
        int n3 = this.getInterval(rbNode).getHigh();
        int n4 = n > n2 ? n : n2;
        return n4 > n3 ? n4 : n3;
    }

    private int getRealMin(RbNode rbNode) {
        if (rbNode.isNull()) {
            return Integer.MAX_VALUE;
        }
        int n = this.getRealMin(rbNode.left);
        int n2 = this.getRealMin(rbNode.right);
        int n3 = this.getInterval(rbNode).getLow();
        int n4 = n < n2 ? n : n2;
        return n4 < n3 ? n4 : n3;
    }

    public static class Interval
    implements Comparable {
        private final int low;
        private final int high;

        public Interval(int n, int n2) {
            assert (n <= n2);
            this.low = n;
            this.high = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.getClass().equals(object.getClass())) {
                Interval interval = (Interval)object;
                return this.low == interval.low && this.high == interval.high;
            }
            return false;
        }

        public int hashCode() {
            return this.low;
        }

        public int compareTo(Object object) {
            Interval interval = (Interval)object;
            if (this.low < interval.low) {
                return -1;
            }
            if (this.low > interval.low) {
                return 1;
            }
            if (this.high < interval.high) {
                return -1;
            }
            if (this.high > interval.high) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "Interval[" + this.low + ", " + this.high + "]";
        }

        public boolean overlaps(Interval interval) {
            return this.low <= interval.high && interval.low <= this.high;
        }

        public int getLow() {
            return this.low;
        }

        public int getHigh() {
            return this.high;
        }
    }

    public static class RbTree {
        RbNode root;
        RbNode NIL;
        StatisticUpdate updater;
        Logger logger;

        public RbTree(StatisticUpdate statisticUpdate) {
            this.root = this.NIL = RbNode.NIL;
            this.updater = statisticUpdate;
            this.logger = Logger.getLogger("RBTree");
        }

        public RbTree() {
            this(null);
        }

        public void insert(RbNode rbNode) {
            assert (rbNode != null);
            assert (!rbNode.isNull());
            this.treeInsert(rbNode);
            rbNode.color = RbNode.RED;
            while (rbNode != this.root && rbNode.parent.color == RbNode.RED) {
                RbNode rbNode2;
                if (rbNode.parent == rbNode.parent.parent.left) {
                    rbNode2 = rbNode.parent.parent.right;
                    if (rbNode2.color == RbNode.RED) {
                        rbNode.parent.color = RbNode.BLACK;
                        rbNode2.color = RbNode.BLACK;
                        rbNode.parent.parent.color = RbNode.RED;
                        rbNode = rbNode.parent.parent;
                        continue;
                    }
                    if (rbNode == rbNode.parent.right) {
                        rbNode = rbNode.parent;
                        this.leftRotate(rbNode);
                    }
                    rbNode.parent.color = RbNode.BLACK;
                    rbNode.parent.parent.color = RbNode.RED;
                    this.rightRotate(rbNode.parent.parent);
                    continue;
                }
                rbNode2 = rbNode.parent.parent.left;
                if (rbNode2.color == RbNode.RED) {
                    rbNode.parent.color = RbNode.BLACK;
                    rbNode2.color = RbNode.BLACK;
                    rbNode.parent.parent.color = RbNode.RED;
                    rbNode = rbNode.parent.parent;
                    continue;
                }
                if (rbNode == rbNode.parent.left) {
                    rbNode = rbNode.parent;
                    this.rightRotate(rbNode);
                }
                rbNode.parent.color = RbNode.BLACK;
                rbNode.parent.parent.color = RbNode.RED;
                this.leftRotate(rbNode.parent.parent);
            }
            this.root.color = RbNode.BLACK;
        }

        public RbNode get(int n) {
            RbNode rbNode = this.root;
            while (rbNode != this.NIL) {
                if (n == rbNode.key) {
                    return rbNode;
                }
                if (n < rbNode.key) {
                    rbNode = rbNode.left;
                    continue;
                }
                rbNode = rbNode.right;
            }
            return this.NIL;
        }

        public RbNode root() {
            return this.root;
        }

        public RbNode minimum(RbNode rbNode) {
            assert (rbNode != null);
            assert (!rbNode.isNull());
            while (!rbNode.left.isNull()) {
                rbNode = rbNode.left;
            }
            return rbNode;
        }

        public RbNode maximum(RbNode rbNode) {
            assert (rbNode != null);
            assert (!rbNode.isNull());
            while (!rbNode.right.isNull()) {
                rbNode = rbNode.right;
            }
            return rbNode;
        }

        public RbNode successor(RbNode rbNode) {
            assert (rbNode != null);
            assert (!rbNode.isNull());
            if (!rbNode.right.isNull()) {
                return this.minimum(rbNode.right);
            }
            RbNode rbNode2 = rbNode.parent;
            while (!rbNode2.isNull() && rbNode == rbNode2.right) {
                rbNode = rbNode2;
                rbNode2 = rbNode2.parent;
            }
            return rbNode2;
        }

        public RbNode predecessor(RbNode rbNode) {
            assert (rbNode != null);
            assert (!rbNode.isNull());
            if (!rbNode.left.isNull()) {
                return this.maximum(rbNode.left);
            }
            RbNode rbNode2 = rbNode.parent;
            while (!rbNode2.isNull() && rbNode == rbNode2.left) {
                rbNode = rbNode2;
                rbNode2 = rbNode2.parent;
            }
            return rbNode2;
        }

        void leftRotate(RbNode rbNode) {
            RbNode rbNode2 = rbNode.right;
            rbNode.right = rbNode2.left;
            if (rbNode2.left != this.NIL) {
                rbNode2.left.parent = rbNode;
            }
            rbNode2.parent = rbNode.parent;
            if (rbNode.parent == this.NIL) {
                this.root = rbNode2;
            } else if (rbNode.parent.left == rbNode) {
                rbNode.parent.left = rbNode2;
            } else {
                rbNode.parent.right = rbNode2;
            }
            rbNode2.left = rbNode;
            rbNode.parent = rbNode2;
            this.applyUpdate(rbNode);
        }

        void rightRotate(RbNode rbNode) {
            RbNode rbNode2 = rbNode.left;
            rbNode.left = rbNode2.right;
            if (rbNode2.right != this.NIL) {
                rbNode2.right.parent = rbNode;
            }
            rbNode2.parent = rbNode.parent;
            if (rbNode.parent == this.NIL) {
                this.root = rbNode2;
            } else if (rbNode.parent.right == rbNode) {
                rbNode.parent.right = rbNode2;
            } else {
                rbNode.parent.left = rbNode2;
            }
            rbNode2.right = rbNode;
            rbNode.parent = rbNode2;
            this.applyUpdate(rbNode);
        }

        void treeInsert(RbNode rbNode) {
            RbNode rbNode2 = this.root;
            RbNode rbNode3 = this.NIL;
            while (rbNode2 != this.NIL) {
                rbNode3 = rbNode2;
                if (rbNode.key <= rbNode2.key) {
                    rbNode2 = rbNode2.left;
                    continue;
                }
                rbNode2 = rbNode2.right;
            }
            rbNode.parent = rbNode3;
            if (rbNode3 == this.NIL) {
                this.root = rbNode;
                rbNode.left = rbNode.right = this.NIL;
            } else if (rbNode.key <= rbNode3.key) {
                rbNode3.left = rbNode;
            } else {
                rbNode3.right = rbNode;
            }
            this.applyUpdate(rbNode);
        }

        private void applyUpdate(RbNode rbNode) {
            if (this.updater == null) {
                return;
            }
            while (!rbNode.isNull()) {
                this.updater.update(rbNode);
                rbNode = rbNode.parent;
            }
        }

        public int size() {
            return this._size(this.root);
        }

        private int _size(RbNode rbNode) {
            if (rbNode.isNull()) {
                return 0;
            }
            return 1 + this._size(rbNode.left) + this._size(rbNode.right);
        }

        public boolean isValid() {
            if (this.root.color != RbNode.BLACK) {
                this.logger.warning("root color is wrong");
                return false;
            }
            if (this.NIL.color != RbNode.BLACK) {
                this.logger.warning("NIL color is wrong");
                return false;
            }
            if (!this.allRedNodesFollowConstraints(this.root)) {
                this.logger.warning("red node doesn't follow constraints");
                return false;
            }
            if (!this.isBalancedBlackHeight(this.root)) {
                this.logger.warning("black height unbalanced");
                return false;
            }
            return true;
        }

        private boolean allRedNodesFollowConstraints(RbNode rbNode) {
            if (rbNode.isNull()) {
                return true;
            }
            if (rbNode.color == RbNode.BLACK) {
                return this.allRedNodesFollowConstraints(rbNode.left) && this.allRedNodesFollowConstraints(rbNode.right);
            }
            return rbNode.left.color == RbNode.BLACK && rbNode.right.color == RbNode.BLACK && this.allRedNodesFollowConstraints(rbNode.left) && this.allRedNodesFollowConstraints(rbNode.right);
        }

        private boolean isBalancedBlackHeight(RbNode rbNode) {
            if (rbNode.isNull()) {
                return true;
            }
            return this.blackHeight(rbNode.left) == this.blackHeight(rbNode.right) && this.isBalancedBlackHeight(rbNode.left) && this.isBalancedBlackHeight(rbNode.right);
        }

        private int blackHeight(RbNode rbNode) {
            if (rbNode.isNull()) {
                return 0;
            }
            int n = this.blackHeight(rbNode.left);
            if (rbNode.color == RbNode.BLACK) {
                return n + 1;
            }
            return n;
        }
    }

    public static class RbNode {
        public int key;
        public boolean color;
        public RbNode parent;
        public RbNode left;
        public RbNode right;
        public static boolean BLACK = false;
        public static boolean RED = true;
        static RbNode NIL = new RbNode();

        private RbNode() {
        }

        public RbNode(int n) {
            this.parent = NIL;
            this.left = NIL;
            this.right = NIL;
            this.key = n;
            this.color = RED;
        }

        public boolean isNull() {
            return this == NIL;
        }

        public String toString() {
            if (this == NIL) {
                return "nil";
            }
            return "(" + this.key + " " + (this.color == RED ? "RED" : "BLACK") + " (" + this.left.toString() + ", " + this.right.toString() + ")";
        }

        static {
            RbNode.NIL.color = BLACK;
            RbNode.NIL.parent = NIL;
            RbNode.NIL.left = NIL;
            RbNode.NIL.right = NIL;
        }
    }

    public static interface StatisticUpdate {
        public void update(RbNode var1);
    }

    private class IntervalTreeStatisticUpdate
    implements StatisticUpdate {
        private IntervalTreeStatisticUpdate() {
        }

        @Override
        public void update(RbNode rbNode) {
            IntervalTree.this.setMax(rbNode, this.max(this.max(IntervalTree.this.getMax(rbNode.left), IntervalTree.this.getMax(rbNode.right)), IntervalTree.this.getInterval(rbNode).getHigh()));
            IntervalTree.this.setMin(rbNode, this.min(this.min(IntervalTree.this.getMin(rbNode.left), IntervalTree.this.getMin(rbNode.right)), IntervalTree.this.getInterval(rbNode).getLow()));
        }

        private int max(int n, int n2) {
            if (n > n2) {
                return n;
            }
            return n2;
        }

        private int min(int n, int n2) {
            if (n < n2) {
                return n;
            }
            return n2;
        }
    }
}

