/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import commvault.cte.util.Application;
import commvault.cte.util.CVMonitorMBean;
import commvault.cte.util.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class CVMonitor
implements CVMonitorMBean {
    private static Process process;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int n) {
        if (n < 1000 || n > 10000) {
            throw new IllegalArgumentException("Invalid start port: " + n);
        }
        ServerSocket serverSocket = null;
        DatagramSocket datagramSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.setReuseAddress(true);
            datagramSocket = new DatagramSocket(n);
            datagramSocket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static int start() throws Exception, InterruptedException {
        System.setProperty("java.rmi.server.randomIDs", "true");
        int n = 1000;
        while (!CVMonitor.available(n)) {
            ++n;
        }
        System.out.println("Create RMI registry on port " + n);
        LocateRegistry.createRegistry(n);
        System.out.println("Get the platform's MBean server");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        mBeanServer.createMBean(CVMonitor.class.getName(), new ObjectName("commvault.cte.util:type=" + CVMonitor.class.getSimpleName()));
        System.out.println("Initialize the environment map");
        HashMap hashMap = new HashMap();
        System.out.println("Create an RMI connector server");
        JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:" + n + "/jmxrmi");
        JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer).start();
        System.out.println("Start the RMI connector server");
        String string = System.getProperty("java.home");
        String string2 = string + File.separator + "bin" + File.separator + "java";
        String string3 = System.getProperty("java.class.path");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(string2, "-cp", string3, "sun.tools.jconsole.JConsole"));
        arrayList.add("localhost:" + n);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        System.out.println(processBuilder.command());
        return 0;
    }

    public static void exit() {
        if (process != null) {
            process.destroy();
        }
    }

    @Override
    public void createThreadDummp() {
        Application.dumpThread();
    }

    @Override
    public void sendLog(String string, String string2) throws Exception {
        File[] fileArray = new File(".").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(Logger.LOG_FILE_NAME);
            }
        });
        Logger.instance().setOutput(Logger.LoggerType.LOG_TO_FILE);
        this.createThreadDummp();
        Properties properties = new Properties();
        properties.put("mail.smtp.host", "mail.commvault.com");
        Session session = Session.getInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        InternetAddress internetAddress = new InternetAddress(string);
        mimeMessage.setFrom((Address)internetAddress);
        mimeMessage.setRecipients(Message.RecipientType.TO, new Address[]{new InternetAddress("dev-gui@commvault.com")});
        mimeMessage.setSubject("GUI Issue reported");
        MimeMultipart mimeMultipart = new MimeMultipart();
        for (File file : fileArray) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.attachFile(file);
            mimeBodyPart.setFileName(file.getName());
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        mimeMessage.setContent((Multipart)mimeMultipart);
        Transport.send((Message)mimeMessage);
    }
}

