/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.util;

import com.jidesoft.docking.event.DockableFrameListener;
import commvault.cte.common.ui.ClientBrowseAction;
import commvault.cte.component.MailParamsDialog;
import commvault.cte.component.table.IPopup;
import commvault.cte.component.table.IPopupActionHandler;
import commvault.cte.util.CVTimezone;
import commvault.cte.util.IconSource;
import commvault.cte.util.Logger;
import commvault.cte.util.PasswordEncoder;
import commvault.cte.util.ThreadPoolManager;
import java.awt.Component;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JFrame;

public class Application {
    public static final int GMT_ID = 35;
    boolean addInGui = false;
    private Map<Integer, TimeZone> timezones = new LinkedHashMap<Integer, TimeZone>();
    private static Application instance = new Application();
    private JFrame applicationFrame = null;
    private IconSource iconSource;
    private ClientBrowseAction clientBrowseAction;
    private IPopupActionHandler popupActionHandler;
    public static TimeZone commServerTimeZone = new SimpleTimeZone(TimeZone.getDefault().getRawOffset(), TimeZone.getDefault().getID());
    public static boolean noExternalise;
    private DockableFrameListener dockTasksListener = null;
    private PasswordEncoder passwordEncoder;
    private boolean webstartGui;

    private Application() {
    }

    public static Application instance() {
        return instance;
    }

    public IconSource getIconSource() {
        return this.iconSource;
    }

    public ClientBrowseAction getClientBrowseActionBean() {
        try {
            Class<?> clazz = Class.forName("commvault.client.clientbrowse.ClientBrowseAction");
            this.clientBrowseAction = (ClientBrowseAction)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.clientBrowseAction;
    }

    public JFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public void setApplicationFrame(JFrame jFrame) {
        this.applicationFrame = jFrame;
    }

    public Map<Integer, TimeZone> getTimezones() {
        return this.timezones;
    }

    public Vector<TimeZone> getTimezoneList() {
        if (this.timezones.isEmpty()) {
            Vector<TimeZone> vector = new Vector<TimeZone>();
            vector.add(commServerTimeZone);
            return vector;
        }
        return new Vector<TimeZone>(this.timezones.values());
    }

    public TimeZone getTimzone(int n) {
        if (this.timezones.get(n) == null) {
            return commServerTimeZone;
        }
        return this.timezones.get(n);
    }

    public IPopupActionHandler getPopupActionHandler() {
        if (this.popupActionHandler == null) {
            return new IPopupActionHandler(){

                @Override
                public void performAction(final String string, final IPopup iPopup, Component component) {
                    ThreadPoolManager.runJobInSharedInstance(new Runnable(){

                        @Override
                        public void run() {
                            iPopup.menuAction(string);
                        }
                    });
                }
            };
        }
        return this.popupActionHandler;
    }

    public void setPopupActionHandler(IPopupActionHandler iPopupActionHandler) {
        this.popupActionHandler = iPopupActionHandler;
    }

    public int getCSTimezoneId() {
        if (!(commServerTimeZone instanceof CVTimezone)) {
            return 0;
        }
        return ((CVTimezone)commServerTimeZone).getTZId();
    }

    public String getCSTimezoneName() {
        if (!(commServerTimeZone instanceof CVTimezone)) {
            return "";
        }
        return ((CVTimezone)commServerTimeZone).getID();
    }

    public TimeZone getGMTTimzone() {
        return this.getTimzone(35);
    }

    public void setIconSource(IconSource iconSource) {
        this.iconSource = iconSource;
    }

    public MailParamsDialog.InitMailData getMailSettings() {
        try {
            return (MailParamsDialog.InitMailData)Class.forName("commvault.components.Utilities").getMethod("buildInitMailData", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnsupportedOperationException("This method is hack implementation, need to reimplement");
        }
    }

    public DockableFrameListener getDockTasksListener() {
        return this.dockTasksListener;
    }

    public void setDockTasksListener(DockableFrameListener dockableFrameListener) {
        this.dockTasksListener = dockableFrameListener;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public boolean isAddInGui() {
        return this.addInGui;
    }

    public void setAddInGui(boolean bl) {
        this.addInGui = bl;
    }

    public static void dumpThread() {
        if (!Logger.instance().isLogging()) {
            return;
        }
        try {
            long[] lArray = ManagementFactory.getThreadMXBean().getAllThreadIds();
            StringBuffer stringBuffer = new StringBuffer();
            for (long l : lArray) {
                if (!Application.checkValid(ManagementFactory.getThreadMXBean().getThreadInfo(l))) continue;
                stringBuffer.append(l);
                stringBuffer.append("\n");
            }
            Logger.instance();
            Logger.write(Logger.INFO, "Application", "dumpThread", stringBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean checkValid(ThreadInfo threadInfo) {
        if (threadInfo.getThreadId() == Thread.currentThread().getId()) {
            return false;
        }
        if (threadInfo.getThreadName().startsWith("RMI") || threadInfo.getThreadName().startsWith("JMX")) {
            return false;
        }
        return threadInfo.getStackTrace().length != 0;
    }

    public boolean isWebstartGui() {
        return this.webstartGui;
    }

    public void setWebstartGui(boolean bl) {
        this.webstartGui = bl;
    }

    public static class XTimeZoneItem {
        public int ds_flags;
        public int tz_offset;
        public int ds_bias;
        public int ds_month;
        public int ds_weekNo;
        public int ds_dayOfWeek;
        public int ds_minutes;
        public int std_month;
        public int std_weekNo;
        public int std_dayOfWeek;
        public int std_minutes;
        public String tz_name;
        public String tz_stdName;
        public int id;
    }
}

