/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.tools;

import commvault.cte.component.SComboBox;
import commvault.cte.component.Utilities;
import commvault.cte.component.table.NTable;
import commvault.cte.component.table.SortedTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ResourceBundleTool
extends JFrame {
    String oldVersion;
    String newVersion;
    NTable table;
    String[] actions = new String[]{"Copy Resources from First Resoucebundle to Second Resourcebundle where Second resource string is empty", "Copy Resources from Second Resoucebundle to First Resourcebundle where First resource string is empty", "Copy selected resources from First to second resource bundle", "Copy selected resources from Second to first resource bundle", "Save first bundle", "Save second bundle", "Save missing resource sting in first bundle", "Save missing resource string in second bundle"};
    TableCellRenderer renderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Object object2 = jTable.getValueAt(n, 0);
            jTable.getValueAt(n, 1);
            Object object3 = jTable.getValueAt(n, 2);
            jTable.getValueAt(n, 3);
            if (object2 == null || object2.equals("") && n2 <= 1) {
                component.setBackground(Color.gray);
            } else if (object2 == null || object2.equals("") && n2 > 1) {
                component.setBackground(Color.green);
            } else if (object3 == null || object3.equals("") && n2 <= 1) {
                component.setBackground(Color.blue);
            } else if (object3 == null || object3.equals("") && n2 > 1) {
                component.setBackground(Color.gray);
            } else if (bl) {
                super.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                super.setForeground(jTable.getForeground());
                super.setBackground(jTable.getBackground());
            }
            return component;
        }
    };

    public ResourceBundleTool(String string, String string2) throws Exception {
        Object e;
        Serializable serializable;
        Properties properties = new Properties();
        properties.load(new FileInputStream(string));
        Properties properties2 = new Properties();
        properties2.load(new FileInputStream(string2));
        HashSet<Object> hashSet = new HashSet<Object>(properties.keySet());
        HashSet<Object> hashSet2 = new HashSet<Object>(properties2.keySet());
        HashSet<Object> hashSet3 = new HashSet<Object>(hashSet);
        hashSet3.retainAll(hashSet2);
        hashSet.removeAll(hashSet3);
        hashSet2.removeAll(hashSet3);
        Vector<Serializable> vector = new Vector<Serializable>();
        Iterator iterator = hashSet3.iterator();
        while (iterator.hasNext()) {
            serializable = new Vector<Object>();
            e = iterator.next();
            ((Vector)serializable).add(e);
            ((Vector)serializable).add(properties.get(e));
            ((Vector)serializable).add(e);
            ((Vector)serializable).add(properties2.get(e));
            vector.add(serializable);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            serializable = new Vector();
            e = iterator.next();
            ((Vector)serializable).add(e);
            ((Vector)serializable).add(properties.get(e));
            ((Vector)serializable).add(null);
            ((Vector)serializable).add(null);
            vector.add(serializable);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            serializable = new Vector();
            e = iterator.next();
            ((Vector)serializable).add(null);
            ((Vector)serializable).add(null);
            ((Vector)serializable).add(e);
            ((Vector)serializable).add(properties2.get(e));
            vector.add(serializable);
        }
        serializable = new SortedTableModel(new NTableModel(vector, new Vector(){
            {
                this.add("Keys");
                this.add("Values");
                this.add("Keys");
                this.add("Values");
            }
        }));
        this.table = new NTable((TableModel)((Object)serializable));
        this.initGUI();
    }

    private void initGUI() {
        JOptionPane.showInputDialog(null, (Object)"Please Input the directory or file on which you want to run this tool");
        this.getContentPane().setLayout(new GridBagLayout());
        final SComboBox sComboBox = new SComboBox(this.actions);
        JButton jButton = new JButton("Run");
        Utilities.addRow(this.getContentPane(), (JComponent)sComboBox, (JComponent)jButton);
        Utilities.fillRemaining(this.getContentPane(), this.table);
        JTable jTable = this.table.getTable();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(this.renderer);
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResourceBundleTool.this.executeCommand(sComboBox.getSelectedIndex());
            }
        });
        this.setSize(400, 400);
        this.setVisible(true);
    }

    private void copyStrings(boolean bl, int[] nArray) {
        if (nArray == null) {
            return;
        }
        TableModel tableModel = this.table.getTableModel();
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            Object object2;
            if (bl) {
                object2 = tableModel.getValueAt(nArray[i], 0);
                object = tableModel.getValueAt(nArray[i], 1);
                tableModel.setValueAt(object2, nArray[i], 2);
                tableModel.setValueAt(object, nArray[i], 3);
                continue;
            }
            object2 = tableModel.getValueAt(nArray[i], 2);
            object = tableModel.getValueAt(nArray[i], 3);
            tableModel.setValueAt(object2, nArray[i], 0);
            tableModel.setValueAt(object, nArray[i], 1);
        }
        ((NTableModel)((SortedTableModel)tableModel).getModel()).updateUI();
    }

    private int[] getRowsWithEmptyKeys(boolean bl) {
        TableModel tableModel = this.table.getTableModel();
        int n = tableModel.getRowCount();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < n; ++i) {
            if (tableModel.getValueAt(i, bl ? 0 : 2) != null && !tableModel.getValueAt(i, bl ? 0 : 2).toString().trim().equals("")) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private void executeCommand(int n) {
        switch (n) {
            case 0: {
                this.copyStrings(true, this.getRowsWithEmptyKeys(false));
                break;
            }
            case 1: {
                this.copyStrings(false, this.getRowsWithEmptyKeys(true));
                break;
            }
            case 2: {
                this.copyStrings(true, this.table.getTable().getSelectedRows());
                break;
            }
            case 3: {
                this.copyStrings(false, this.table.getTable().getSelectedRows());
                break;
            }
            case 4: {
                this.saveBundle(true);
                break;
            }
            case 5: {
                this.saveBundle(false);
                break;
            }
            case 6: {
                this.saveStrings(false, this.getRowsWithEmptyKeys(true));
                break;
            }
            case 7: {
                this.saveStrings(true, this.getRowsWithEmptyKeys(false));
            }
        }
    }

    private void saveStrings(boolean bl, int[] nArray) {
        if (nArray == null) {
            return;
        }
        Properties properties = new Properties();
        TableModel tableModel = this.table.getTableModel();
        for (int i = 0; i < nArray.length; ++i) {
            Object object = tableModel.getValueAt(nArray[i], bl ? 0 : 2);
            if (object == null) continue;
            properties.put(object, tableModel.getValueAt(nArray[i], bl ? 1 : 3));
        }
        this.saveRB(properties);
    }

    private void saveRB(Properties properties) {
        FindResourceFiles findResourceFiles = new FindResourceFiles(true);
        JOptionPane.showMessageDialog(this, findResourceFiles, "Where you want to save ?", -1);
        String string = findResourceFiles.firstSource.getText().trim();
        File file = new File(string);
        try {
            if (!file.createNewFile()) {
                JOptionPane.showMessageDialog(this, "Could not save");
                this.printRCFile(System.out, properties);
                return;
            }
            this.printRCFile(new PrintStream(new FileOutputStream(file)), properties);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Could not save");
            this.printRCFile(System.out, properties);
        }
    }

    private void printRCFile(PrintStream printStream, Properties properties) {
        TreeSet<Object> treeSet = new TreeSet<Object>(properties.keySet());
        for (String string : treeSet) {
            String string2 = (String)properties.get(string);
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printStream.println(string + " = " + string2);
        }
    }

    private void saveBundle(boolean bl) {
        int[] nArray = new int[this.table.getTableModel().getRowCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.saveStrings(bl, nArray);
    }

    private static FindResourceFiles getSources() {
        FindResourceFiles findResourceFiles = new FindResourceFiles();
        JOptionPane.showMessageDialog(null, findResourceFiles, "Get two resource bundles", -1);
        return findResourceFiles;
    }

    public static final void main(String[] stringArray) throws Exception {
        FindResourceFiles findResourceFiles = ResourceBundleTool.getSources();
        new ResourceBundleTool(findResourceFiles.firstSource.getText(), findResourceFiles.secondSource.getText()).setVisible(true);
    }

    class NTableModel
    extends DefaultTableModel {
        public NTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Vector vector = (Vector)this.dataVector.elementAt(n);
            vector.setElementAt(object, n2);
        }

        public void updateUI() {
            this.fireTableDataChanged();
        }
    }

    private static class FindResourceFiles
    extends JPanel {
        JTextField firstSource = new JTextField(30);
        JTextField secondSource = new JTextField(30);
        private boolean singlePath;

        public FindResourceFiles() {
            this(false);
        }

        public FindResourceFiles(boolean bl) {
            super(new GridBagLayout());
            this.singlePath = bl;
            Utilities.addRow((Container)this, (JComponent)new JLabel(bl ? "ResourceBundle Path" : "First Resource Bundle"), (JComponent)this.firstSource, true);
            JButton jButton = new JButton("Browse");
            Utilities.addRow((Container)this, null, (JComponent)jButton, 13);
            Utilities.addRow((Container)this, (JComponent)new JLabel("Second Resource Bundle"), (JComponent)this.secondSource, true);
            JButton jButton2 = new JButton("Browse");
            Utilities.addRow((Container)this, null, (JComponent)jButton2, 13);
            Utilities.addRow((JPanel)this, null, (JComponent)new JSeparator(0));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    firstSource.setText(this.getResourcePath());
                }
            });
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    secondSource.setText(this.getResourcePath());
                }
            });
            Utilities.fillRemaining(this);
        }

        private String getResourcePath() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.getPath().endsWith(".properties") && !singlePath) {
                        return true;
                    }
                    return file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "ResourceFiles";
                }
            });
            if (!this.singlePath) {
                jFileChooser.showOpenDialog(this);
            } else {
                jFileChooser.showSaveDialog(this);
            }
            File file = jFileChooser.getSelectedFile();
            return file == null ? null : file.getPath();
        }
    }
}

