/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.reports;

import commvault.cte.util.ChartUnitConverter;

public final class NetworkFormatter
implements ChartUnitConverter {
    private static final long MULTIPLIER = 1024L;
    public static final NetworkFormatter BPS = new NetworkFormatter(0, "bps");
    public static final NetworkFormatter KBPS = new NetworkFormatter(1, "Kbps");
    public static final NetworkFormatter MBPS = new NetworkFormatter(2, "Mbps");
    public static final NetworkFormatter GBPS = new NetworkFormatter(3, "Gbps");
    public static final NetworkFormatter TBPS = new NetworkFormatter(4, "Tbps");
    public static final NetworkFormatter PBPS = new NetworkFormatter(5, "Pbps");
    public static final NetworkFormatter EBPS = new NetworkFormatter(6, "Xbps");
    public static final NetworkFormatter[] _formats = new NetworkFormatter[]{BPS, KBPS, MBPS, GBPS, TBPS, PBPS, EBPS};
    private long _minfactor = 1L;
    private final String _units;

    public NetworkFormatter(int n, String string) {
        this._minfactor = (long)Math.pow(1024.0, n);
        this._units = string;
    }

    public long getMinFactor() {
        return this._minfactor;
    }

    public String getUnits() {
        return this._units;
    }

    public String toString() {
        return this._units;
    }

    @Override
    public String getDisplayName() {
        return this._units;
    }

    @Override
    public String getUnitString() {
        return this._units;
    }

    @Override
    public long getUnitValue() {
        return this._minfactor;
    }
}

