/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class CTEDBXml
extends CTEDBColumn {
    public CTEDBXml(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public CTEDBXml(String string, int n, boolean bl, boolean bl2) {
        super(string, n, bl, bl2);
    }

    public Element get() {
        try {
            return this.parseXml(this.getString());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getString() {
        return (String)this.getValue();
    }

    public void set(Element element) {
        this.set(this.toString(element));
    }

    public void set(String string) {
        this.setValue(string);
    }

    public Element parseXml(String string) throws Exception {
        if (string != null && string.length() > 0) {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build((Reader)new StringReader(string));
            return document.getRootElement();
        }
        return null;
    }

    private String toString(Element element) {
        if (element == null) {
            return null;
        }
        try {
            XMLOutputter xMLOutputter = new XMLOutputter();
            xMLOutputter.getFormat().setOmitDeclaration(true);
            StringWriter stringWriter = new StringWriter();
            xMLOutputter.output(element, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void fromResult(ResultSet resultSet) throws CTEDBException {
        try {
            this.set(resultSet.getString(this.getColumnName()));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving string value from result set for column [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void fromResult(ResultSet resultSet, int n) throws CTEDBException {
        try {
            this.set(resultSet.getString(n));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving string value from result set for column index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void setParameter(PreparedStatement preparedStatement, int n) throws CTEDBException {
        try {
            preparedStatement.setString(n, this.getString());
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error adding string parameter [" + this.get() + "] for index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void zero() {
        this.setNull();
    }
}

