/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBConnection;
import commvault.cte.db.CTEDBException;
import commvault.cte.db.CTEDBReservation;
import commvault.cte.db.CTEDBStorage;
import commvault.cte.db.CTEDBStorageType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class CTEDBTableRow
extends CTEDBStorage {
    private static final int MAX_ATTEMPTS = 3;
    protected final CTEDBConnection m_conn;

    public CTEDBTableRow(CTEDBConnection cTEDBConnection) {
        this.m_conn = cTEDBConnection;
    }

    public abstract CTEDBStorage newInstance();

    public CTEDBConnection getConnection() {
        return this.m_conn;
    }

    public void zero() {
        for (CTEDBColumn cTEDBColumn : this.m_columns.getAllColumns()) {
            cTEDBColumn.zero();
        }
    }

    public List executeSelect() throws CTEDBException {
        return this.executeSelect(null, null);
    }

    public List executeSelect(String string) throws CTEDBException {
        return this.executeSelect(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeSelect(String string, String string2) throws CTEDBException {
        if (this.getType() == CTEDBStorageType.CTEDB_PROCEDURE) {
            throw new CTEDBException("cannot fill storage row of type [" + this.getType().toString() + "]");
        }
        ResultSet resultSet = null;
        int n = 1;
        String string3 = this.createSelectStatement(string, string2);
        while (true) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.initialize();
            CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
            try {
                Object object;
                resultSet = cTEDBReservation.executeQuery(string3);
                while (resultSet.next()) {
                    object = this.newInstance();
                    ((CTEDBStorage)object).populate(resultSet);
                    arrayList.add(object);
                }
                object = arrayList;
                return object;
            }
            catch (SQLException sQLException) {
                if (n <= 3 && sQLException.getMessage().contains("deadlocked")) {
                    ++n;
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CTEDBException("error reading result set from table [" + this.getName() + "]", sQLException);
                    }
                }
                throw new CTEDBException("error reading result set from table [" + this.getName() + "]", sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                    resultSet = null;
                }
                cTEDBReservation.close();
                continue;
            }
            break;
        }
    }

    public boolean fill(String string) throws CTEDBException {
        return this.fill(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fill(String string, String string2) throws CTEDBException {
        if (this.getType() == CTEDBStorageType.CTEDB_PROCEDURE) {
            throw new CTEDBException("cannot fill storage row of type [" + this.getType().toString() + "]");
        }
        this.initialize();
        CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            String string3 = this.createSelectStatement(string, string2);
            resultSet = cTEDBReservation.executeQuery(string3);
            try {
                if (resultSet.next()) {
                    this.populate(resultSet);
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error reading result set from table [" + this.getName() + "]", sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            cTEDBReservation.close();
        }
        if (bl) {
            this.m_bound = true;
            this.resetModfiedFlag();
        }
        return bl;
    }

    protected String createSelectStatement(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        for (int i = 0; i < this.getColumnStorage().getAllColumns().size(); ++i) {
            if (!this.getColumnStorage().getAllColumns().get(i).isSelectable()) continue;
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("[");
            stringBuilder.append(this.getColumnStorage().getAllColumns().get(i).getColumnName());
            stringBuilder.append("]");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.getName());
        if (this.appendNoLock()) {
            stringBuilder.append(" with(nolock)");
        }
        if (string != null && string.length() > 0) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(string);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" ORDER BY ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    public boolean appendNoLock() {
        return true;
    }

    public synchronized boolean save() throws CTEDBException {
        if (this.getType() != CTEDBStorageType.CTEDB_TABLE) {
            throw new CTEDBException("cannot save storage row of type [" + this.getType().toString() + "]");
        }
        if (this.m_bound) {
            return this.update();
        }
        return this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert() throws CTEDBException {
        block27: {
            int n;
            Vector<CTEDBColumn> vector = this.getColumnStorage().getInsertColumns();
            if (vector.size() == 0) {
                throw new CTEDBException("nothing to insert for table [" + this.getName() + "]");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("INSERT INTO ");
            stringBuilder.append(this.getName());
            stringBuilder.append("(");
            for (n = 0; n < vector.size(); ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("[");
                stringBuilder.append(vector.get(n).getColumnName());
                stringBuilder.append("]");
            }
            stringBuilder.append(") VALUES (");
            for (n = 0; n < vector.size(); ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("?");
            }
            stringBuilder.append(")");
            CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
            Statement statement = null;
            try {
                ResultSet resultSet;
                int n2;
                statement = cTEDBReservation.createStatement(stringBuilder.toString(), this.getColumnStorage().isIdentity());
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    vector.get(n2).setParameter((PreparedStatement)statement, n2 + 1);
                }
                try {
                    n2 = statement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    throw new CTEDBException("error executing sql statement [" + stringBuilder.toString() + "]", sQLException);
                }
                if (n2 <= 0) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.getColumnStorage().isIdentity()) break block27;
                try {
                    resultSet = statement.getGeneratedKeys();
                }
                catch (SQLException sQLException) {
                    throw new CTEDBException("error retrieving generated keys from table [" + this.getName() + "]", sQLException);
                }
                if (resultSet == null) break block27;
                try {
                    if (resultSet.next()) {
                        this.getColumnStorage().getIdentity().set(resultSet, 1);
                    }
                }
                catch (SQLException sQLException) {
                    throw new CTEDBException("error reading generated keys result set for table [" + this.getName() + "]", sQLException);
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                cTEDBReservation.close();
            }
        }
        this.m_bound = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update() throws CTEDBException {
        int n;
        Vector<CTEDBColumn> vector = this.getColumnStorage().getUpdateColumns();
        if (vector.size() == 0) {
            return false;
        }
        if (this.getColumnStorage().getKeyColumns().size() == 0) {
            throw new CTEDBException("cannot update row with no primary key columns");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" SET ");
        for (n = 0; n < vector.size(); n += 1) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("[");
            stringBuilder.append(vector.get(n).getColumnName());
            stringBuilder.append("]");
            stringBuilder.append("=?");
        }
        stringBuilder.append(" WHERE ");
        for (n = 0; n < this.getColumnStorage().getKeyColumns().size(); n += 1) {
            if (n > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.getColumnStorage().getKeyColumns().get(n).getColumnName());
            stringBuilder.append("=?");
        }
        n = 0;
        CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = cTEDBReservation.createStatement(stringBuilder.toString());
            int n3 = 1;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                vector.get(n2).setParameter(preparedStatement, n3);
                ++n3;
            }
            for (n2 = 0; n2 < this.getColumnStorage().getKeyColumns().size(); ++n2) {
                this.getColumnStorage().getKeyColumns().get(n2).setParameter(preparedStatement, n3);
                ++n3;
            }
            try {
                n = preparedStatement.executeUpdate() > 0 ? 1 : 0;
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error executing sql update [" + stringBuilder.toString() + "]", sQLException);
            }
            if (n) {
                this.resetModfiedFlag();
            }
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            cTEDBReservation.close();
        }
        if (n) {
            this.resetModfiedFlag();
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() throws CTEDBException {
        if (this.getType() != CTEDBStorageType.CTEDB_TABLE) {
            throw new CTEDBException("cannot delete storage row of type [" + this.getType().toString() + "]");
        }
        if (!this.m_bound) {
            return true;
        }
        if (this.getColumnStorage().getKeyColumns().size() == 0) {
            throw new CTEDBException("cannot delete row with no primary key columns");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" WHERE ");
        for (int i = 0; i < this.getColumnStorage().getKeyColumns().size(); ++i) {
            if (i > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("[");
            stringBuilder.append(this.getColumnStorage().getKeyColumns().get(i).getColumnName());
            stringBuilder.append("]");
            stringBuilder.append("=?");
        }
        CTEDBReservation cTEDBReservation = this.m_conn.createReservation();
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        try {
            preparedStatement = cTEDBReservation.createStatement(stringBuilder.toString());
            for (int i = 0; i < this.getColumnStorage().getKeyColumns().size(); ++i) {
                this.getColumnStorage().getKeyColumns().get(i).setParameter(preparedStatement, i + 1);
            }
            try {
                bl = preparedStatement.executeUpdate() > 0;
            }
            catch (SQLException sQLException) {
                throw new CTEDBException("error executing delete statement [" + stringBuilder.toString() + "]", sQLException);
            }
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            cTEDBReservation.close();
        }
        if (bl) {
            this.m_bound = false;
        }
        return bl;
    }

    protected void setValues(CTEDBTableRow cTEDBTableRow) {
        for (CTEDBColumn cTEDBColumn : this.getColumnStorage().getAllColumns()) {
            CTEDBColumn cTEDBColumn2;
            if (cTEDBColumn.isIdentity() || (cTEDBColumn2 = cTEDBTableRow.getColumnStorage().getColumn(cTEDBColumn.getColumnName())) == null) continue;
            cTEDBColumn.setValue(cTEDBColumn2.getValue());
        }
    }
}

