/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import commvault.cte.db.CTEDBException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CTEDBDouble
extends CTEDBColumn {
    public CTEDBDouble(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public CTEDBDouble(String string, int n, boolean bl, boolean bl2) {
        super(string, n, bl, bl2);
    }

    public Double get() {
        return (Double)this.getValue();
    }

    public void set(Double d) {
        this.setValue(d);
    }

    @Override
    protected void fromResult(ResultSet resultSet) throws CTEDBException {
        try {
            this.set(resultSet.getDouble(this.getColumnName()));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving double value from result set for column [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void fromResult(ResultSet resultSet, int n) throws CTEDBException {
        try {
            this.set(resultSet.getDouble(n));
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error retrieving double value from result set for column index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void setParameter(PreparedStatement preparedStatement, int n) throws CTEDBException {
        try {
            if (this.get() == null) {
                preparedStatement.setNull(n, 8);
            } else {
                preparedStatement.setDouble(n, this.get());
            }
        }
        catch (SQLException sQLException) {
            throw new CTEDBException("error adding double parameter [" + this.get() + "] for index [" + n + "], col [" + this.getColumnName() + "]", sQLException);
        }
    }

    @Override
    protected void zero() {
        this.set(0.0);
    }
}

