/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.db;

import commvault.cte.db.CTEDBColumn;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CTEDBColumnStorage {
    private final Map<String, CTEDBColumn> namedMap = new HashMap<String, CTEDBColumn>();
    private final Vector<CTEDBColumn> columns = new Vector();
    private final Vector<CTEDBColumn> keyColumns = new Vector();
    private CTEDBColumn identity;

    public void clear() {
        this.namedMap.clear();
        this.columns.clear();
        this.keyColumns.clear();
        this.identity = null;
    }

    public void add(CTEDBColumn cTEDBColumn) {
        if (this.namedMap.containsKey(cTEDBColumn.getColumnName())) {
            throw new Error("duplicate column [" + cTEDBColumn.getColumnName() + "]");
        }
        this.namedMap.put(cTEDBColumn.getColumnName(), cTEDBColumn);
        this.columns.add(cTEDBColumn);
        if (cTEDBColumn.isPrimaryKey()) {
            this.keyColumns.add(cTEDBColumn);
        }
        if (cTEDBColumn.isIdentity()) {
            this.identity = cTEDBColumn;
        }
    }

    public CTEDBColumn getColumn(String string) {
        return this.namedMap.get(string);
    }

    public Vector<CTEDBColumn> getAllColumns() {
        return this.columns;
    }

    protected Vector<CTEDBColumn> getInsertColumns() {
        Vector<CTEDBColumn> vector = new Vector<CTEDBColumn>();
        for (CTEDBColumn cTEDBColumn : this.columns) {
            if (cTEDBColumn.isIdentity() || cTEDBColumn.isNull()) continue;
            vector.add(cTEDBColumn);
        }
        return vector;
    }

    protected Vector<CTEDBColumn> getUpdateColumns() {
        Vector<CTEDBColumn> vector = new Vector<CTEDBColumn>();
        for (CTEDBColumn cTEDBColumn : this.columns) {
            if (cTEDBColumn.isIdentity() || !cTEDBColumn.isModified()) continue;
            vector.add(cTEDBColumn);
        }
        return vector;
    }

    protected Vector<CTEDBColumn> getKeyColumns() {
        return this.keyColumns;
    }

    public CTEDBColumn getIdentity() {
        return this.identity;
    }

    public boolean isIdentity() {
        return this.identity != null;
    }
}

