/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import commvault.cte.component.tree.Entity;
import commvault.cte.component.tree.NodeType;
import commvault.cte.net.IdNameItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityImpl
implements Entity,
Comparable<EntityImpl> {
    private int id;
    private Entity parent;
    private NodeType nodeType;
    private String nodeName;
    private boolean visible = true;
    private boolean selected;
    private boolean excluded;
    Map<Integer, Entity> children = null;
    private boolean restricted;
    private boolean levelVisible = true;
    private int propFlag;
    private boolean associationSelectionState = false;
    private String displayName = null;

    public EntityImpl(IdNameItem idNameItem, NodeType nodeType, Entity entity) {
        this.id = idNameItem.getId();
        this.nodeName = idNameItem.getName();
        this.nodeType = nodeType;
        this.parent = entity;
        if (entity instanceof EntityImpl) {
            ((EntityImpl)this.parent).addChild(this);
        }
    }

    public EntityImpl(NodeType nodeType) {
        this.nodeName = "Root";
        this.nodeType = nodeType;
    }

    @Override
    public List<Entity> getChildren() {
        if (this.children != null) {
            return new ArrayList<Entity>(this.children.values());
        }
        return null;
    }

    @Override
    public Map<Integer, Entity> getChildrens() {
        return this.children;
    }

    public Map<Integer, Entity> getChildrenMap() {
        if (this.children != null) {
            return new HashMap<Integer, Entity>(this.children);
        }
        return this.children;
    }

    void addChild(Entity entity) {
        if (this.children == null) {
            this.children = new HashMap<Integer, Entity>();
        }
        this.children.put(entity.getId(), entity);
    }

    @Override
    public Entity getParentEntity() {
        return this.parent;
    }

    public void setParentEntity(Entity entity) {
        this.parent = entity;
        if (entity instanceof EntityImpl) {
            ((EntityImpl)this.parent).addChild(this);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public boolean isLevelVisible() {
        return this.levelVisible;
    }

    public void setLevelVisible(boolean bl) {
        this.levelVisible = bl;
    }

    public String toString() {
        return this.nodeName;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public int compareTo(EntityImpl entityImpl) {
        if (this.nodeName != null) {
            return this.nodeName.compareTo(entityImpl.getNodeName());
        }
        return 0;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean bl) {
        this.restricted = bl;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public int getFlags() {
        return this.propFlag;
    }

    public void setFlags(int n) {
        this.propFlag = n;
    }

    public static void selectLeafNode(Entity entity) {
        EntityImpl.selectLeafNode(entity, false);
    }

    public static void selectLeafNode(Entity entity, boolean bl) {
        if (entity.getChildren() == null || entity.getChildren().size() == 0) {
            entity.setAssociationSelectionState(bl);
            entity.setSelected(true);
            return;
        }
        for (Entity entity2 : entity.getChildren()) {
            EntityImpl.selectLeafNode(entity2, bl);
        }
    }

    public static Entity getChildEntity(Entity entity, int n) {
        Map<Integer, Entity> map = entity.getChildrens();
        if (map != null && map.size() > 0 && map.containsKey(n)) {
            return map.get(n);
        }
        return null;
    }

    public void setName(String string) {
        this.nodeName = string;
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public void setExcluded(boolean bl) {
        this.excluded = bl;
    }

    @Override
    public void setAssociationSelectionState(boolean bl) {
        this.associationSelectionState = bl;
    }

    @Override
    public boolean getAssociationSelectionState() {
        return this.associationSelectionState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }
}

