/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tree;

import commvault.cte.component.Utilities;
import commvault.cte.component.tree.CommNetTreeNode;
import commvault.cte.component.tree.UnselectedChildrenHidable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class CommNetBrowseBaseNode
extends CommNetTreeNode
implements UnselectedChildrenHidable {
    public static final byte TRISTATE_NOSELECTION = 0;
    public static final byte TRISTATE_FULLSELECTION = 2;
    public static final byte TRISTATE_PARTSELECTION = 1;
    public static final byte TRISTATE_NOTRISTATE = 3;
    public static final byte TRISTATE_NONE = -1;
    protected int triState = -1;
    protected int noStateCnt = 0;
    protected int fullStateCnt = 0;
    protected int noTriStateCnt = 0;
    protected boolean isLeaf = false;
    public boolean isClick = false;
    public static final byte NODE_NOSELECTION = 0;
    public static final byte NODE_SELECTED = 1;
    public static final byte NODE_CHILDSELECTED = 2;
    public static final byte NODE_PARENTSELECTED = 3;
    protected int nodeSelectedType = 0;
    public static final Icon EMPTY_ICON = Utilities.getIcon("16px_empty.png");
    public static final Icon EMPTY_DISABLED_ICON = Utilities.getIcon("16px_emptydisabled.png");
    public static final Icon FULL_ICON = Utilities.getIcon("full.GIF");
    public static final Icon FULL_DISABLED_ICON = Utilities.getIcon("FullDisabled.GIF");
    private static final Icon FULL_NEW_ICON = Utilities.getIcon("fullnew.gif");
    public static final Icon HALF_ICON = Utilities.getIcon("half.GIF");
    public static final Icon HALF_DISABLED_ICON = Utilities.getIcon("HalfDisabled.gif");
    public static final Icon PART_DISABLED_ICON = Utilities.getIcon("16px_partialselectionlight.png");
    protected List<Integer> selectedChildIndex;
    protected WeakReference treeObject = null;

    public boolean isClick() {
        return this.isClick;
    }

    public CommNetBrowseBaseNode(int n, String string, boolean bl) {
        super(n, string, bl);
        this.setTreeIcon(EMPTY_ICON);
    }

    public CommNetBrowseBaseNode(int n, String string) {
        super(n, string, true);
        if (this.isLeafNode()) {
            this.setAllowsChildren(false);
            this.isLeaf = true;
        }
        this.isClick = false;
        this.setTreeIcon(EMPTY_ICON);
    }

    public boolean isLeafNode() {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean bl) {
        this.isLeaf = bl;
    }

    public int getNodeSelectedType() {
        return this.nodeSelectedType;
    }

    public void setNodeSelectedType(int n) {
        this.nodeSelectedType = n;
    }

    public int getTriState() {
        return this.triState;
    }

    public void addChild(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        this.addTreeNodeChildOnly(commNetBrowseBaseNode);
        commNetBrowseBaseNode.setParent(this);
    }

    public void setTriState(int n) {
        if (this.triState == n) {
            return;
        }
        CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)this.getParent();
        boolean bl = commNetBrowseBaseNode != null ? commNetBrowseBaseNode.isSelected() : false;
        this.nodeSelectedType = 1;
        this.applyState(n);
        this.applyStateOnChildren(n);
        this.notifyParent();
        if (n == 0) {
            this.resetNodeSelectionType((CommNetBrowseBaseNode)this.getRoot());
            if (bl) {
                for (int i = 0; i < commNetBrowseBaseNode.getChildCount(); ++i) {
                    CommNetBrowseBaseNode commNetBrowseBaseNode2 = (CommNetBrowseBaseNode)commNetBrowseBaseNode.getChildAt(i);
                    if (commNetBrowseBaseNode2 == this) continue;
                    commNetBrowseBaseNode2.isClick = true;
                }
            }
        }
    }

    @Override
    public void removeAllChildren() {
        if (this.getTriState() == 2 && this.getNodeSelectedType() == 2) {
            this.toggleSelection();
        } else if (this.getTriState() == 1) {
            this.setTriState(0);
            this.isClick = false;
        }
        super.removeAllChildren();
    }

    public void remove(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        if (commNetBrowseBaseNode.getTriState() == 2 && (commNetBrowseBaseNode.getNodeSelectedType() == 2 || commNetBrowseBaseNode.getNodeSelectedType() == 1)) {
            commNetBrowseBaseNode.toggleSelection();
        } else if (commNetBrowseBaseNode.getTriState() == 1) {
            commNetBrowseBaseNode.setTriState(0);
            commNetBrowseBaseNode.isClick = false;
        }
        super.remove(commNetBrowseBaseNode);
    }

    @Override
    public void removeAll() {
    }

    public void applyStateFromParent(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        if (commNetBrowseBaseNode != null) {
            if (commNetBrowseBaseNode.getTriState() == 2 && commNetBrowseBaseNode.getNodeSelectedType() == 2) {
                commNetBrowseBaseNode.applyState(1);
                this.applyState(0);
            } else if (commNetBrowseBaseNode.getTriState() == 2 && (commNetBrowseBaseNode.getNodeSelectedType() == 1 || commNetBrowseBaseNode.getNodeSelectedType() == 3)) {
                this.applyState(2);
                this.setNodeSelectedType(3);
            } else if (commNetBrowseBaseNode.getTriState() == 0 || commNetBrowseBaseNode.getTriState() == 1 || commNetBrowseBaseNode.getTriState() == -1) {
                this.applyState(0);
            }
            this.isClick = false;
        }
    }

    public boolean isParentNodeSelected() {
        if (this.getParent() != null) {
            CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)this.getParent();
            if (commNetBrowseBaseNode.getNodeSelectedType() == 1) {
                return true;
            }
            return commNetBrowseBaseNode.isParentNodeSelected();
        }
        return false;
    }

    public void resetNodeSelectionType(CommNetBrowseBaseNode commNetBrowseBaseNode) {
        if (!commNetBrowseBaseNode.equals(this.getRoot()) && commNetBrowseBaseNode.getTriState() == 2) {
            if (commNetBrowseBaseNode.getNodeSelectedType() == 1) {
                return;
            }
            if (!commNetBrowseBaseNode.isParentNodeSelected()) {
                commNetBrowseBaseNode.nodeSelectedType = 1;
                commNetBrowseBaseNode.applyState();
            }
        }
        for (int i = 0; i < commNetBrowseBaseNode.getChildCount(); ++i) {
            this.resetNodeSelectionType((CommNetBrowseBaseNode)commNetBrowseBaseNode.getChildAt(i));
        }
    }

    @Override
    public void populate() {
        if (!this.isVirgin()) {
            return;
        }
        this.setVirgin(false);
        this.loadChildren();
    }

    protected void notificationFromChild() {
        int n = this.getRowCount2();
        int n2 = 0;
        if (this.fullStateCnt == n - this.noTriStateCnt) {
            n2 = 2;
            this.nodeSelectedType = n2 == 2 ? 2 : 0;
        } else if (this.noStateCnt == n - this.noTriStateCnt) {
            n2 = 0;
            this.nodeSelectedType = 0;
            this.isClick = false;
        } else {
            n2 = 1;
            this.nodeSelectedType = 0;
            this.isClick = false;
        }
        if (n2 != this.triState) {
            this.applyState(n2);
            if (this.getParent() != null) {
                ((CommNetBrowseBaseNode)this.getParent()).notificationFromChild();
            }
        }
    }

    public int getRowCount2() {
        return this.getChildCount();
    }

    public void toggleSelection() {
        if (this.getTriState() == 0 || this.getTriState() == 1 || this.getTriState() == -1) {
            this.isClick = true;
            this.setTriState(2);
            this.nodeSelectedType = 1;
        } else {
            this.setTriState(0);
            this.nodeSelectedType = 0;
            this.isClick = false;
        }
        if (this.getParent() instanceof UnselectedChildrenHidable) {
            ((UnselectedChildrenHidable)((Object)this.getParent())).resetSelectedIndex();
        }
    }

    protected void applyStateOnChildren(int n) {
        int n2 = this.getChildCount();
        while (--n2 >= 0) {
            CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)this.getChildAt(n2);
            commNetBrowseBaseNode.nodeSelectedType = n == 2 ? 3 : 0;
            commNetBrowseBaseNode.applyState(n);
            commNetBrowseBaseNode.applyStateOnChildren(n);
        }
    }

    public void applyState() {
        if (this.triState == 0) {
            this.setTreeIcon(EMPTY_ICON);
        } else if (this.triState == 2) {
            if (this.nodeSelectedType == 2 || this.nodeSelectedType == 1) {
                this.setTreeIcon(FULL_ICON);
            } else {
                this.setTreeIcon(FULL_NEW_ICON);
            }
        } else if (this.triState == 1) {
            this.setTreeIcon(HALF_ICON);
        } else {
            this.setTreeIcon(EMPTY_ICON);
        }
    }

    private void setState(int n) {
        if (this.triState == n || n == -1) {
            return;
        }
        TreeNode treeNode = this.getParent();
        if (treeNode == null) {
            this.triState = n;
            return;
        }
        if (!(treeNode instanceof CommNetBrowseBaseNode)) {
            return;
        }
        CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)treeNode;
        switch (n) {
            case 0: {
                ++commNetBrowseBaseNode.noStateCnt;
                break;
            }
            case 2: {
                ++commNetBrowseBaseNode.fullStateCnt;
                break;
            }
            case 3: {
                ++commNetBrowseBaseNode.noTriStateCnt;
            }
        }
        switch (this.triState) {
            case 0: {
                --commNetBrowseBaseNode.noStateCnt;
                break;
            }
            case 2: {
                --commNetBrowseBaseNode.fullStateCnt;
                break;
            }
            case 3: {
                --commNetBrowseBaseNode.noTriStateCnt;
            }
        }
        this.triState = n;
    }

    public void applyState(int n) {
        this.setState(n);
        this.applyState();
    }

    private void notifyParent() {
        CommNetBrowseBaseNode commNetBrowseBaseNode = (CommNetBrowseBaseNode)this.getParent();
        if (commNetBrowseBaseNode != null) {
            commNetBrowseBaseNode.notificationFromChild();
        }
    }

    public void updateView() {
        CommNetBrowseBaseNode commNetBrowseBaseNode;
        JTree jTree = this.getTree();
        if (jTree != null) {
            jTree.repaint();
        }
        if ((commNetBrowseBaseNode = (CommNetBrowseBaseNode)this.getParent()) != null) {
            commNetBrowseBaseNode.updateView();
        }
    }

    public JTree getTree() {
        if (this.treeObject != null) {
            return (JTree)this.treeObject.get();
        }
        TreeNode treeNode = this.getRoot();
        if (treeNode instanceof CommNetBrowseBaseNode && treeNode != this) {
            return ((CommNetBrowseBaseNode)this.getRoot()).getTree();
        }
        return null;
    }

    public void setTree(JTree jTree) {
        this.treeObject = new WeakReference<JTree>(jTree);
    }

    @Override
    public void setTreeIcon(Icon icon) {
        super.setTreeIcon(icon);
        this.updateView();
    }

    public boolean isSelected() {
        return this.getNodeSelectedType() == 1;
    }

    public boolean isChildSelected() {
        if (this.getChildCount() == 0) {
            return false;
        }
        return this.getTriState() == 1 || this.getTriState() == 2;
    }

    public void setSelected(boolean bl) {
        if (this.isSelected() != bl) {
            this.toggleSelection();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getIndexOfSelectedChild(Object object) {
        if (object == null) {
            return -1;
        }
        if (this.selectedChildIndex == null) {
            this.reconstructSelectedIndex();
        }
        for (int i = 0; i < this.selectedChildIndex.size(); ++i) {
            if (object != this.selectedChildIndex.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getSelectedChildAt(int n) {
        if (this.selectedChildIndex == null) {
            this.reconstructSelectedIndex();
        }
        return this.getChildAt(this.selectedChildIndex.get(n));
    }

    @Override
    public int getSelectedChildCount() {
        if (this.selectedChildIndex == null) {
            this.reconstructSelectedIndex();
        }
        return this.selectedChildIndex.size();
    }

    @Override
    public void resetSelectedIndex() {
        this.selectedChildIndex = null;
    }

    protected void reconstructSelectedIndex() {
        this.selectedChildIndex = new ArrayList<Integer>();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = this.getChildAt(i);
            if (!(treeNode instanceof CommNetBrowseBaseNode) || ((CommNetBrowseBaseNode)treeNode).getTriState() != 2 && ((CommNetBrowseBaseNode)treeNode).getTriState() != 1) continue;
            this.selectedChildIndex.add(i);
        }
    }
}

