/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tooolbar;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DefaultDockableBarDockableHolder;
import com.jidesoft.action.DockableBar;
import commvault.cte.component.CVFrame;
import commvault.cte.component.tooolbar.AnimatedLayout;
import commvault.cte.component.tooolbar.CustomizedToolbarOptions;
import commvault.cte.component.tooolbar.FakeSheetWindowListener;
import commvault.cte.component.tooolbar.MacToolbarSeparatorUI;
import commvault.cte.component.tooolbar.MockComponent;
import commvault.cte.component.tooolbar.MockComponentTransferable;
import commvault.cte.component.tooolbar.SpaceComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class CustomizedToolbar
extends CommandBar {
    public static final String CALCULATE_MIN_WIDTH = "calculateMinWidth";
    private static final long serialVersionUID = 1L;
    protected static final String DIALOG_ACTIVE = "customizeDialogActive";
    public static ToolbarPrefrences prefs = new ToolbarPrefrences();
    private Runnable updateContentsRunnable = new Runnable(){

        @Override
        public void run() {
            CustomizedToolbar.this.updateContents();
        }
    };
    private PreferenceChangeListener prefListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            SwingUtilities.invokeLater(CustomizedToolbar.this.updateContentsRunnable);
        }
    };
    JComponent[] componentList;
    String draggingComponent;
    boolean draggingFromToolbar;
    boolean draggingDefaults;
    int minimumHeight;
    private static final boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    Insets componentInsets = new Insets(2, 2, 2, 2);
    protected static boolean hideActiveComponents = DragSource.isDragImageSupported();
    private static DragSource dragSource = DragSource.getDefaultDragSource();
    private DragSourceListener dragSourceListener = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            CustomizedToolbar.this.endDrag(dragSourceDropEvent);
        }
    };
    String[] defaultContents;
    private DragGestureListener dragGestureListener = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            int n;
            Point point = dragGestureEvent.getDragOrigin();
            Component component = dragGestureEvent.getComponent();
            JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(component);
            point = SwingUtilities.convertPoint(component, point, jFrame);
            for (n = 0; n < CustomizedToolbar.this.componentList.length; ++n) {
                if (!this.triggerDrag(jFrame, point, dragGestureEvent, CustomizedToolbar.this.componentList[n])) continue;
                return;
            }
            for (n = 0; n < CustomizedToolbar.this.getComponentCount(); ++n) {
                if (!this.triggerDrag(jFrame, point, dragGestureEvent, (JComponent)CustomizedToolbar.this.getComponent(n))) continue;
                return;
            }
        }

        private boolean triggerDrag(JFrame jFrame, Point point, DragGestureEvent dragGestureEvent, JComponent jComponent) {
            Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if ((rectangle = SwingUtilities.convertRectangle(jComponent, rectangle, jFrame)).contains(point)) {
                CustomizedToolbar.this.draggingFromToolbar = true;
                CustomizedToolbar.this.draggingDefaults = false;
                CustomizedToolbar.this.draggingComponent = jComponent.getName();
                MockComponent mockComponent = new MockComponent(jComponent);
                MockComponentTransferable mockComponentTransferable = new MockComponentTransferable(mockComponent);
                BufferedImage bufferedImage = mockComponent.getBufferedImage();
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, bufferedImage, new Point(rectangle.x - point.x, rectangle.y - point.y), mockComponentTransferable, CustomizedToolbar.this.dragSourceListener);
                return true;
            }
            return false;
        }
    };
    private DropTargetListener dropTargetListener = new DropTargetListener(){

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.dragOver(dropTargetDragEvent);
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (CustomizedToolbar.this.draggingDefaults) {
                return;
            }
            CustomizedToolbar.this.updateContents(CustomizedToolbar.this.getContents(new Point(-1000, -1000)));
            if (CustomizedToolbar.this.draggingComponent != null) {
                JComponent jComponent = CustomizedToolbar.this.getComponent(CustomizedToolbar.this.draggingComponent);
                Rectangle rectangle = (Rectangle)jComponent.getClientProperty("AnimatedLayout.destinationRect");
                if (rectangle != null) {
                    jComponent.setBounds(rectangle);
                }
                if (hideActiveComponents) {
                    jComponent.setVisible(true);
                }
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (CustomizedToolbar.this.draggingComponent == null) {
                dropTargetDragEvent.rejectDrag();
            } else {
                Point point = dropTargetDragEvent.getLocation();
                point = SwingUtilities.convertPoint(((DropTarget)dropTargetDragEvent.getSource()).getComponent(), point, (Component)((Object)CustomizedToolbar.this));
                String[] stringArray = CustomizedToolbar.this.getContents(point);
                CustomizedToolbar.this.updateContents(stringArray);
                dropTargetDragEvent.acceptDrag(2);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (CustomizedToolbar.this.draggingComponent == null) {
                dropTargetDropEvent.rejectDrop();
            } else if (CustomizedToolbar.this.draggingDefaults) {
                CustomizedToolbar.this.setContents(CustomizedToolbar.this.getDefaultContents());
            } else {
                Point point = dropTargetDropEvent.getLocation();
                point = SwingUtilities.convertPoint(((DropTarget)dropTargetDropEvent.getSource()).getComponent(), point, (Component)((Object)CustomizedToolbar.this));
                String[] stringArray = CustomizedToolbar.this.getContents(point);
                CustomizedToolbar.this.setContents(stringArray);
                dropTargetDropEvent.acceptDrop(2);
                JComponent jComponent = CustomizedToolbar.this.getComponent(CustomizedToolbar.this.draggingComponent);
                Rectangle rectangle = (Rectangle)jComponent.getClientProperty("AnimatedLayout.destinationRect");
                if (rectangle != null) {
                    jComponent.setBounds(rectangle);
                }
                if (hideActiveComponents) {
                    jComponent.setVisible(true);
                }
            }
            dropTargetDropEvent.dropComplete(true);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    };
    private boolean updatedWhileShowing = false;

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel((String)object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        object = new JButton("Customize...");
        JComponent[] jComponentArray = new JComponent[]{object, new JCheckBox("Check box"), new JLabel("Label"), new JButton("Button"), new JSlider()};
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setName("" + i);
            jComponentArray[i].setOpaque(false);
        }
        JMenu jMenu = new JMenu("View");
        JMenuItem jMenuItem = new JMenuItem("Customize Toolbar...");
        jMenu.add(jMenuItem);
        final CustomizedToolbar customizedToolbar = new CustomizedToolbar(jComponentArray, new String[]{"0", "\t", "1"}, "toolbar demo");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                customizedToolbar.displayDialog(isMac ? 350 : 280);
            }
        };
        ((AbstractButton)object).addActionListener(actionListener);
        jMenuItem.addActionListener(actionListener);
        DefaultDockableBarDockableHolder defaultDockableBarDockableHolder = new DefaultDockableBarDockableHolder();
        defaultDockableBarDockableHolder.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        CommandBar commandBar = new CommandBar("menubar");
        commandBar.setMenuBar(true);
        commandBar.add(jMenu);
        defaultDockableBarDockableHolder.getDockableBarManager().addDockableBar((DockableBar)commandBar);
        defaultDockableBarDockableHolder.getDockableBarManager().addDockableBar((DockableBar)customizedToolbar);
        defaultDockableBarDockableHolder.getLayoutPersistence().loadLayoutData();
    }

    public static void resetPreferences(String string) {
        String string2 = string + ".component";
        int n = 0;
        String string3 = string2 + n;
        while (prefs.get(string3, null) != null) {
            prefs.remove(string3);
            string3 = string2 + ++n;
        }
    }

    public static void resetAllPreferences() {
        prefs.clear();
    }

    private String[] getContents(Point point) {
        if (this.draggingComponent == null || this.draggingDefaults) {
            return this.getContents();
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        boolean bl = point.y >= 0 && point.y <= rectangle.height;
        Object[] objectArray = this.getContents();
        if (!bl && !this.draggingFromToolbar) {
            return objectArray;
        }
        int n = 0;
        JComponent jComponent = this.getComponent(this.draggingComponent);
        if (hideActiveComponents) {
            ((Component)jComponent).setVisible(false);
        }
        while (n < objectArray.length) {
            if (objectArray[n].equals(this.draggingComponent)) {
                objectArray = (String[])CustomizedToolbar.remove(objectArray, n);
                continue;
            }
            ++n;
        }
        if (!bl && this.draggingFromToolbar) {
            return objectArray;
        }
        for (n = 0; n < objectArray.length; ++n) {
            JComponent jComponent2 = this.getComponent((String)objectArray[n]);
            Rectangle rectangle2 = jComponent2.getBounds();
            if (point.x >= rectangle2.x + rectangle2.width / 2) continue;
            objectArray = (String[])CustomizedToolbar.insert(objectArray, this.draggingComponent, n);
            return objectArray;
        }
        objectArray = (String[])CustomizedToolbar.insert(objectArray, this.draggingComponent, objectArray.length);
        return objectArray;
    }

    private static Object[] clone(Object[] objectArray) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    private static Object[] remove(Object[] objectArray, int n) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length - 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - n - 1);
        return objectArray2;
    }

    private static Object[] insert(Object[] objectArray, Object object, int n) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length + 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = object;
        System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
        return objectArray2;
    }

    public CustomizedToolbar(JComponent[] jComponentArray, String[] stringArray, String string) {
        super("Tool Bar");
        this.setLayout(new AnimatedLayout(false));
        this.setInitSide(1);
        this.setInitMode(2);
        this.setInitIndex(1);
        this.setOpaque(false);
        this.setRearrangable(false);
        this.setFloatable(false);
        this.setHidable(false);
        this.setPaintBackground(false);
        this.setTitle("");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].equals("-")) {
                stringArray[i] = "-" + n;
                ++n;
                continue;
            }
            if (stringArray[i].equals(" ")) {
                stringArray[i] = " " + n2;
                ++n2;
                continue;
            }
            if (!stringArray[i].equals("\t")) continue;
            stringArray[i] = "\t" + n3;
            ++n3;
        }
        this.defaultContents = (String[])CustomizedToolbar.clone(stringArray);
        this.minimumHeight = CustomizedToolbar.getMinimumHeight(jComponentArray);
        this.setName(string);
        if (this.isEmpty()) {
            String string2 = this.getName() + ".component";
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    throw new NullPointerException("defaults[" + i + "] is null");
                }
                prefs.put(string2 + i, stringArray[i]);
            }
        }
        this.componentList = new JComponent[jComponentArray.length];
        System.arraycopy(jComponentArray, 0, this.componentList, 0, jComponentArray.length);
        prefs.addPreferenceChangeListener(this.prefListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CustomizedToolbar.this.updateContents();
            }
        });
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateContentsRunnable.run();
        } else {
            SwingUtilities.invokeLater(this.updateContentsRunnable);
        }
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (CustomizedToolbar.this.updatedWhileShowing) {
                    return;
                }
                CustomizedToolbar.this.updateContents();
            }
        });
    }

    protected String[] getDefaultContents() {
        return (String[])CustomizedToolbar.clone(this.defaultContents);
    }

    private static int getMinimumHeight(JComponent[] jComponentArray) {
        int n = 0;
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].putClientProperty(CALCULATE_MIN_WIDTH, true);
            n = Math.max(jComponentArray[i].getPreferredSize().height, n);
            n = Math.max(jComponentArray[i].getHeight(), n);
            jComponentArray[i].putClientProperty(CALCULATE_MIN_WIDTH, null);
        }
        return n;
    }

    public JComponent[] getPossibleComponents() {
        JComponent[] jComponentArray = new JComponent[this.componentList.length];
        System.arraycopy(this.componentList, 0, jComponentArray, 0, this.componentList.length);
        return jComponentArray;
    }

    protected void endDrag(DragSourceDropEvent dragSourceDropEvent) {
        if (this.draggingComponent != null) {
            Point point = dragSourceDropEvent.getLocation();
            SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
            if (!this.contains(point)) {
                this.setContents(this.getContents(new Point(-1000, -1000)));
            }
        }
        this.draggingComponent = null;
    }

    private boolean isEmpty() {
        String string = this.getName() + ".component";
        String string2 = prefs.get(string + "0", null);
        return string2 == null;
    }

    public void updateContents() {
        this.updateContents(this.getContents());
    }

    private String[] getContents() {
        Vector<String> vector = new Vector<String>();
        String string = this.getName() + ".component";
        String string2 = null;
        int n = 0;
        while ((string2 = prefs.get(string + n, null)) != null) {
            if (!string2.equals("-0")) {
                vector.add(string2);
            }
            ++n;
        }
        return vector.toArray(new String[vector.size()]);
    }

    private void setContents(String[] stringArray) {
        int n;
        String string = this.getName() + ".component";
        for (n = 0; n < stringArray.length; ++n) {
            prefs.put(string + n, stringArray[n]);
        }
        n = stringArray.length;
        while (prefs.get(string + n, null) != null) {
            prefs.remove(string + n);
            ++n;
        }
    }

    private void updateContents(String[] stringArray) {
        int n;
        Serializable serializable;
        int n2;
        int n3;
        if (!this.isShowing()) {
            return;
        }
        this.updatedWhileShowing = true;
        int n4 = 0;
        Component[] componentArray = this.getComponents();
        for (n3 = 0; n3 < componentArray.length; ++n3) {
            JComponent jComponent = (JComponent)componentArray[n3];
            jComponent.putClientProperty("legitimate", Boolean.FALSE);
        }
        n3 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            try {
                if (stringArray[n2].length() > 0 && stringArray[n2].charAt(0) == '\t') {
                    ++n3;
                    continue;
                }
                JComponent jComponent = this.getComponent(stringArray[n2]);
                serializable = jComponent.getPreferredSize();
                n5 += ((Dimension)serializable).width;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n2 = this.getWidth() - (this.componentInsets.left + this.componentInsets.right) * stringArray.length - n5;
        if (n2 < 0) {
            n2 = 0;
        }
        for (n = 0; n < stringArray.length; ++n) {
            try {
                boolean bl;
                Dimension dimension;
                int n6;
                serializable = this.getComponent(stringArray[n]);
                if (stringArray[n].length() > 0 && stringArray[n].charAt(0) == '\t') {
                    n6 = n2 / n3;
                    n2 -= n6;
                    --n3;
                    dimension = new Dimension(n6, this.minimumHeight);
                } else {
                    dimension = ((JComponent)serializable).getPreferredSize();
                }
                if (serializable instanceof JSeparator) {
                    dimension.height = this.minimumHeight;
                }
                n6 = 0;
                for (bl = false; bl < componentArray.length && n6 == 0; bl += 1) {
                    if (componentArray[bl] != serializable) continue;
                    n6 = 1;
                }
                if (n6 == 0) {
                    if (this.draggingComponent != null && hideActiveComponents) {
                        bl = !((Component)serializable).getName().equals(this.draggingComponent);
                        ((JComponent)serializable).setVisible(bl);
                    }
                    this.add((Component)serializable);
                }
                Rectangle rectangle = new Rectangle(n4 + this.componentInsets.left, this.componentInsets.top + this.minimumHeight / 2 - dimension.height / 2, dimension.width, dimension.height);
                if (((JComponent)serializable).getClientProperty("AnimatedLayout.destinationRect") == null || n6 == 0) {
                    ((Component)serializable).setBounds(rectangle);
                }
                ((JComponent)serializable).putClientProperty("AnimatedLayout.destinationRect", rectangle);
                n4 += dimension.width + this.componentInsets.left + this.componentInsets.right;
                ((JComponent)serializable).putClientProperty("legitimate", Boolean.TRUE);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (n = 0; n < componentArray.length; ++n) {
            serializable = (JComponent)componentArray[n];
            if (!((JComponent)serializable).getClientProperty("legitimate").equals(Boolean.FALSE)) continue;
            this.remove((Component)serializable);
            this.repaint();
        }
    }

    protected Insets getComponentInsets() {
        return (Insets)this.componentInsets.clone();
    }

    protected String getNewSeparatorName() {
        int n = 0;
        while (true) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                String string = this.getComponent(i).getName();
                if (!string.equals("-" + n)) continue;
                ++n;
            }
            break;
        }
        return "-" + n;
    }

    protected String getNewSpaceName() {
        int n = 0;
        while (true) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                String string = this.getComponent(i).getName();
                if (!string.equals(" " + n)) continue;
                ++n;
            }
            break;
        }
        return " " + n;
    }

    protected String getNewFlexibleSpaceName() {
        int n = 0;
        while (true) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                String string = this.getComponent(i).getName();
                if (!string.equals("\t" + n)) continue;
                ++n;
            }
            break;
        }
        return "\t" + n;
    }

    protected JComponent getComponent(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException();
        }
        for (n = 0; n < this.componentList.length; ++n) {
            if (!this.componentList[n].getName().equals(string)) continue;
            return this.componentList[n];
        }
        for (n = 0; n < this.getComponentCount(); ++n) {
            if (this.getComponent(n).getName() == null || !this.getComponent(n).getName().equals(string)) continue;
            return (JComponent)this.getComponent(n);
        }
        if (string.length() > 0 && string.charAt(0) == '-') {
            JSeparator jSeparator = new JSeparator(1);
            if (isMac) {
                jSeparator.setUI(new MacToolbarSeparatorUI());
            }
            jSeparator.setName(string);
            return jSeparator;
        }
        if (string.length() > 0 && string.charAt(0) == ' ') {
            SpaceComponent spaceComponent = new SpaceComponent(this, false);
            spaceComponent.setName(string);
            return spaceComponent;
        }
        if (string.length() > 0 && string.charAt(0) == '\t') {
            SpaceComponent spaceComponent = new SpaceComponent(this, true);
            spaceComponent.setName(string);
            return spaceComponent;
        }
        throw new NullPointerException("No component \"" + string + "\"");
    }

    public void displayDialog(int n) {
        JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (jFrame == null) {
            throw new NullPointerException("the dialog cannot be shown if the parent frame is null.");
        }
        this.putClientProperty(DIALOG_ACTIVE, Boolean.TRUE);
        CustomizedToolbarOptions customizedToolbarOptions = new CustomizedToolbarOptions(this, n);
        final JComponent jComponent = new JComponent(){
            private static final long serialVersionUID = 1L;
        };
        dragSource.createDefaultDragGestureRecognizer(jComponent, 3, this.dragGestureListener);
        new DropTarget(jComponent, this.dropTargetListener);
        jComponent.addMouseListener(new MouseAdapter(){});
        Dimension dimension = jFrame.getSize();
        jComponent.setSize(dimension);
        final JLayeredPane jLayeredPane = jFrame.getLayeredPane();
        jLayeredPane.add(jComponent);
        final JDialog jDialog = new JDialog((Frame)jFrame, false);
        jDialog.getContentPane().add(customizedToolbarOptions);
        jDialog.setUndecorated(true);
        if (!isMac) {
            customizedToolbarOptions.setBorder(new LineBorder(Color.gray));
        }
        jDialog.pack();
        jLayeredPane.setLayer(jComponent, JLayeredPane.MODAL_LAYER);
        FakeSheetWindowListener fakeSheetWindowListener = new FakeSheetWindowListener(jFrame, jDialog, (JComponent)((Object)this), jComponent);
        jFrame.addComponentListener(fakeSheetWindowListener);
        jDialog.getRootPane().setDefaultButton(customizedToolbarOptions.done);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        };
        fakeSheetWindowListener.repositionDialog();
        customizedToolbarOptions.done.addActionListener(abstractAction);
        jDialog.setFocusableWindowState(false);
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
        jDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                jLayeredPane.remove(jComponent);
                CustomizedToolbar.this.putClientProperty(CustomizedToolbar.DIALOG_ACTIVE, Boolean.FALSE);
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jDialog.getRootPane().getInputMap(2).put(keyStroke, keyStroke);
        jDialog.getRootPane().getActionMap().put(keyStroke, abstractAction);
    }

    public Dimension getPreferredSize() {
        return new Dimension(CVFrame.instance() == null ? 400 : CVFrame.instance().getWidth(), this.minimumHeight + this.componentInsets.top + this.componentInsets.bottom);
    }

    public Dimension getMinimumSize() {
        return new Dimension(400, this.minimumHeight + this.componentInsets.top + this.componentInsets.bottom);
    }

    public Dimension getMaximumSize() {
        return super.getMaximumSize();
    }

    public static class ToolbarPrefrences {
        PreferenceChangeListener listener = null;
        HashMap<String, String> map = new HashMap();

        public void clear() {
            this.map.clear();
            this.fireChanged();
        }

        public void remove(String string) {
            this.map.remove(string);
            this.fireChanged();
        }

        public String get(String string, Object object) {
            return this.map.get(string);
        }

        public void put(String string, String string2) {
            this.map.put(string, string2);
            this.fireChanged();
        }

        private void fireChanged() {
            if (this.listener != null) {
                this.listener.preferenceChange(null);
            }
        }

        public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
            this.listener = preferenceChangeListener;
        }

        public Map<String, String> getMap() {
            return this.map;
        }

        public void setMap(Map<String, String> map) {
            if (map.size() > 0) {
                this.clear();
            }
            for (String string : map.keySet()) {
                this.put(string, map.get(string));
            }
        }
    }
}

