/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.tooolbar;

import commvault.cte.component.tooolbar.CustomizedToolbar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnimatedLayout
implements LayoutManager2 {
    public static int DELAY = 35;
    private boolean calculateMinimumSize = false;
    private static String PROPERTY_LAST_DX = "AnimatedLayout.lastDX";
    private static String PROPERTY_LAST_DY = "AnimatedLayout.lastDY";
    private static String PROPERTY_LAST_DW = "AnimatedLayout.lastDW";
    private static String PROPERTY_LAST_DH = "AnimatedLayout.lastDH";
    private static PropertyChangeListener destinationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            JComponent jComponent2 = (JComponent)jComponent.getParent();
            if (jComponent2 != null) {
                AnimatedLayout.runLayout(jComponent2);
            }
        }
    };
    public static final String DESTINATION = "AnimatedLayout.destinationRect";
    private static final String LAYOUT_TIMER = "AnimatedLayout.thread";

    public AnimatedLayout(boolean bl) {
        this.calculateMinimumSize = bl;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    private static double sign(double d) {
        if (d < 0.0) {
            return -1.0;
        }
        if (d > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    private static double getDouble(JComponent jComponent, String string, double d) {
        Double d2 = (Double)jComponent.getClientProperty(string);
        if (d2 == null) {
            return d;
        }
        return d2;
    }

    private static double limit(double d, double d2) {
        if (d2 < 0.0) {
            return Math.max(d2, d);
        }
        return Math.min(d2, d);
    }

    protected static boolean nudge(JComponent jComponent, Rectangle rectangle) {
        Rectangle rectangle2 = jComponent.getBounds();
        double d = AnimatedLayout.getDouble(jComponent, PROPERTY_LAST_DX, 0.0);
        double d2 = AnimatedLayout.getDouble(jComponent, PROPERTY_LAST_DY, 0.0);
        double d3 = AnimatedLayout.getDouble(jComponent, PROPERTY_LAST_DW, 0.0);
        double d4 = AnimatedLayout.getDouble(jComponent, PROPERTY_LAST_DH, 0.0);
        double d5 = rectangle.x - rectangle2.x;
        double d6 = rectangle.y - rectangle2.y;
        double d7 = rectangle.width - rectangle2.width;
        double d8 = rectangle.height - rectangle2.height;
        d5 = AnimatedLayout.limit(0.5 * AnimatedLayout.sign(d5) * Math.sqrt(Math.abs(d5)) + 0.5 * d, d5);
        d6 = AnimatedLayout.limit(0.5 * AnimatedLayout.sign(d6) * Math.sqrt(Math.abs(d6)) + 0.5 * d2, d6);
        d7 = AnimatedLayout.limit(0.5 * AnimatedLayout.sign(d7) * Math.sqrt(Math.abs(d7)) + 0.5 * d3, d7);
        d8 = AnimatedLayout.limit(0.5 * AnimatedLayout.sign(d8) * Math.sqrt(Math.abs(d8)) + 0.5 * d4, d8);
        jComponent.putClientProperty(PROPERTY_LAST_DX, new Double(d5));
        jComponent.putClientProperty(PROPERTY_LAST_DY, new Double(d6));
        jComponent.putClientProperty(PROPERTY_LAST_DW, new Double(d7));
        jComponent.putClientProperty(PROPERTY_LAST_DH, new Double(d8));
        if (Math.abs(d5) < 1.2 && Math.abs(d6) < 1.2 && Math.abs(d7) < 1.2 && Math.abs(d8) < 1.2) {
            jComponent.setBounds(rectangle);
            return true;
        }
        rectangle2.x += (int)(d5 + 0.5);
        rectangle2.y += (int)(d6 + 0.5);
        rectangle2.width += (int)(d7 + 0.5);
        rectangle2.height += (int)(d8 + 0.5);
        jComponent.setBounds(rectangle2);
        return false;
    }

    @Override
    public void layoutContainer(Container container) {
        CustomizedToolbar customizedToolbar = (CustomizedToolbar)((Object)container);
        customizedToolbar.setChevronAlwaysVisible(false);
        customizedToolbar.setOpaque(false);
        customizedToolbar.setRearrangable(false);
        customizedToolbar.setFloatable(false);
        customizedToolbar.setHidable(false);
        customizedToolbar.setPaintBackground(false);
        customizedToolbar.setTitle(" ");
        customizedToolbar.setBorder(BorderFactory.createEmptyBorder());
        AnimatedLayout.runLayout((JComponent)container);
        AnimatedLayout.registerContainer(container);
        container.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerContainer(Container container) {
        Class<AnimatedLayout> clazz = AnimatedLayout.class;
        synchronized (AnimatedLayout.class) {
            ContainerListener containerListener = (ContainerListener)((JComponent)container).getClientProperty("animatedLayout.containerListener");
            if (containerListener == null) {
                containerListener = new ContainerListener(){

                    @Override
                    public void componentAdded(ContainerEvent containerEvent) {
                        JComponent jComponent = (JComponent)containerEvent.getComponent();
                        AnimatedLayout.registerChildren(jComponent);
                    }

                    @Override
                    public void componentRemoved(ContainerEvent containerEvent) {
                    }
                };
                ((JComponent)container).putClientProperty("animatedLayout.containerListener", containerListener);
                container.addContainerListener(containerListener);
                AnimatedLayout.registerChildren((JComponent)container);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void registerChildren(JComponent jComponent) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i);
            if (jComponent2.getClientProperty("animatedLayout.propertyListener") != null) continue;
            jComponent2.putClientProperty("aniamtedLayout.propertyListener", destinationListener);
            jComponent2.addPropertyChangeListener(DESTINATION, destinationListener);
        }
    }

    protected static void runLayout(final JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnimatedLayout.runLayout(jComponent);
                }
            });
            return;
        }
        Timer timer = (Timer)jComponent.getClientProperty(LAYOUT_TIMER);
        if (timer == null) {
            timer = new Timer(DELAY, new AdjustListener(jComponent));
            jComponent.putClientProperty(LAYOUT_TIMER, timer);
        }
        timer.start();
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (!this.calculateMinimumSize) {
            return new Dimension(5, 5);
        }
        Rectangle rectangle = null;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            JComponent jComponent = (JComponent)container.getComponent(i);
            Rectangle rectangle2 = (Rectangle)jComponent.getClientProperty(DESTINATION);
            if (rectangle2 == null) {
                Dimension dimension = jComponent.getPreferredSize();
                rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
            }
            rectangle = rectangle == null ? (Rectangle)rectangle2.clone() : rectangle.union(rectangle2);
        }
        if (rectangle == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(rectangle.width, rectangle.height);
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    static class AdjustListener
    implements ActionListener {
        JComponent container;

        public AdjustListener(JComponent jComponent) {
            this.container = jComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Timer timer = (Timer)actionEvent.getSource();
            boolean bl = false;
            for (int i = 0; i < this.container.getComponentCount(); ++i) {
                JComponent jComponent = (JComponent)this.container.getComponent(i);
                Rectangle rectangle = (Rectangle)jComponent.getClientProperty(AnimatedLayout.DESTINATION);
                if (rectangle == null) {
                    Dimension dimension = jComponent.getPreferredSize();
                    rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                }
                if (AnimatedLayout.nudge(jComponent, rectangle)) continue;
                bl = true;
            }
            this.container.repaint();
            if (!bl) {
                timer.stop();
            }
        }
    }
}

