/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.table;

import commvault.cte.component.table.TableModelAdapter;
import commvault.cte.net.NamedObject;
import commvault.cte.net.SortedIdNameItem;
import commvault.cte.util.Logger;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortedTableModel
extends TableModelAdapter {
    public static final int TABLE_DATA_CHANGED_ONLY = -1000;
    int[] indexes;
    int[] rIndexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    boolean bCaseInsensitiveSort = false;
    int compares;
    private boolean sortOnTableChange = true;
    SorterMouseListener mListener = null;
    private boolean disposed = false;

    public SortedTableModel(TableModel tableModel) {
        super(tableModel);
    }

    public void setCaseInsensitiveSort(boolean bl) {
        this.bCaseInsensitiveSort = bl;
    }

    public boolean isCaseInsensitiveSort() {
        return this.bCaseInsensitiveSort;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void clearup() {
        this.disposed = true;
        this.indexes = null;
        this.rIndexes = null;
        this.sortingColumns.removeAllElements();
        this.sortingColumns = null;
        super.clearup();
    }

    public int[] getUnsortedIndexs(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        try {
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.indexes[nArray[i]];
            }
        }
        catch (Exception exception) {
            Logger.write(Logger.INFO, this, "getUnsortedIndexs", exception);
            return new int[0];
        }
        return nArray2;
    }

    public int getUnsortedIndex(int n) {
        if (this.indexes == null || n < 0) {
            return -1;
        }
        try {
            return this.indexes[n];
        }
        catch (Exception exception) {
            Logger.write(Logger.INFO, this, "getUnsortedIndex", exception);
            return -1;
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.reallocateIndexes();
        this.tableChanged(new TableModelEvent(tableModel, -1));
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        int n4 = n3;
        Class<?> clazz = this.model.getColumnClass(n4);
        TableModel tableModel = this.model;
        Object object = tableModel.getValueAt(n, n4);
        Object object2 = tableModel.getValueAt(n2, n4);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == Number.class || clazz == Number.class) {
            Number number;
            double d;
            Number number2 = (Number)tableModel.getValueAt(n, n4);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)tableModel.getValueAt(n2, n4)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == NamedObject.class) {
            NamedObject namedObject = (NamedObject)tableModel.getValueAt(n, n4);
            String string = namedObject.getName();
            NamedObject namedObject2 = (NamedObject)tableModel.getValueAt(n2, n4);
            Object t = namedObject2.getObject();
            String string2 = namedObject2.getName();
            Object t2 = namedObject.getObject();
            if (t2 instanceof Boolean) {
                if (t2 == t) {
                    int n5 = string.compareTo(string2);
                    if (n5 < 0) {
                        return -1;
                    }
                    if (n5 > 0) {
                        return 1;
                    }
                    return 0;
                }
                if (t != null || ((Boolean)t).booleanValue()) {
                    return 1;
                }
                return -1;
            }
            return string.compareTo(string);
        }
        if (clazz == Date.class) {
            Date date;
            long l;
            Date date2 = (Date)tableModel.getValueAt(n, n4);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)tableModel.getValueAt(n2, n4)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == String.class) {
            String string = (String)tableModel.getValueAt(n, n4);
            String string3 = (String)tableModel.getValueAt(n2, n4);
            int n6 = string.toLowerCase().compareTo(string3.toLowerCase());
            if (n6 < 0) {
                return -1;
            }
            if (n6 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == Boolean.class) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)tableModel.getValueAt(n, n4);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)tableModel.getValueAt(n2, n4)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        if (clazz == SortedIdNameItem.class) {
            SortedIdNameItem sortedIdNameItem;
            int n7;
            SortedIdNameItem sortedIdNameItem2 = (SortedIdNameItem)tableModel.getValueAt(n, n4);
            int n8 = sortedIdNameItem2.getId();
            if (n8 < (n7 = (sortedIdNameItem = (SortedIdNameItem)tableModel.getValueAt(n2, n4)).getId())) {
                return -1;
            }
            if (n8 > n7) {
                return 1;
            }
            return sortedIdNameItem2.toString().compareTo(sortedIdNameItem.toString());
        }
        if (Comparable.class.isAssignableFrom(clazz)) {
            Comparable comparable = (Comparable)object;
            Comparable comparable2 = (Comparable)object2;
            return comparable.compareTo(comparable2);
        }
        Object object3 = tableModel.getValueAt(n, n4);
        String string = object3.toString();
        Object object4 = tableModel.getValueAt(n2, n4);
        String string4 = object4.toString();
        int n9 = 0;
        n9 = this.isCaseInsensitiveSort() ? string.toLowerCase().compareTo(string4.toLowerCase()) : string.compareTo(string4);
        if (n9 < 0) {
            return -1;
        }
        if (n9 > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        ++this.compares;
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Integer n3 = (Integer)this.sortingColumns.elementAt(i);
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 == 0) continue;
            return this.ascending ? n4 : -n4;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int n = this.getRowCount();
        if (n >= 0) {
            this.indexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.indexes[i] = i;
            }
            this.setRIndexes(this.indexes);
        }
    }

    private void insertIndexes(int n, int n2) {
        int n3;
        if (this.indexes == null) {
            this.indexes = new int[1 + n2 - n];
            for (int i = n; i <= n2; ++i) {
                this.indexes[i] = i;
            }
            this.setRIndexes(this.indexes);
            return;
        }
        int[] nArray = (int[])this.indexes.clone();
        int n4 = this.indexes.length;
        int n5 = 1 + n2 - n;
        if (n == 0) {
            this.indexes = new int[n4 + n5];
            for (n3 = 0; n3 < n5; ++n3) {
                this.indexes[n3] = n3;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                this.indexes[n3 + n5] = nArray[n3] + n5;
            }
        }
        if (n == n4) {
            this.indexes = new int[n4 + n5];
            for (n3 = 0; n3 < n4; ++n3) {
                this.indexes[n3] = nArray[n3];
            }
            for (n3 = n4; n3 < n4 + n5; ++n3) {
                this.indexes[n3] = n3;
            }
        }
        this.setRIndexes(this.indexes);
    }

    private void deleteIndex(int n) {
        int[] nArray = (int[])this.indexes.clone();
        int n2 = this.indexes.length - 1;
        int n3 = this.rIndexes[n];
        this.indexes = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.indexes[i] = i < n3 ? nArray[i] : nArray[i + 1];
            if (this.indexes[i] <= n) continue;
            int n4 = i;
            this.indexes[n4] = this.indexes[n4] - 1;
        }
        this.setRIndexes(this.indexes);
    }

    private void deleteIndexes(int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2 + 1; ++n3) {
            int n4 = this.rIndexes[n3];
            this.indexes[n4] = -1;
        }
        n3 = n2 - n + 1;
        int[] nArray = new int[this.indexes.length - n3];
        int n5 = 1 + n2 - n;
        int n6 = 0;
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == -1) continue;
            try {
                nArray[n6] = this.indexes[i];
            }
            catch (Exception exception) {
                Logger.write(Logger.INFO, this, "deleteIndexes", exception);
            }
            if (nArray[++n6] <= n) continue;
            int n7 = i;
            nArray[n7] = nArray[n7] - n5;
        }
        this.indexes = nArray;
        this.setRIndexes(this.indexes);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getType();
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n == -1000) {
            this.fireTableDataChanged();
        } else if (n == 0 && (n2 != n3 || n2 == -1)) {
            this.fireTableDataChanged();
        } else if (n == 1) {
            this.insertIndexes(n2, n3);
            this.fireTableRowsInserted(n2, n3);
        } else {
            int n4 = this.rIndexes[n2];
            if (n == -1) {
                if (n2 == n3) {
                    this.deleteIndex(n2);
                } else {
                    this.deleteIndexes(n2, n3);
                }
                this.fireTableRowsDeleted(n4, n4);
            }
            if (n == 0) {
                this.fireTableRowsUpdated(n4, n4);
            }
        }
        if (this.isSortOnTableChange()) {
            this.sort(this);
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    public void updateTableButKeepMap() {
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void updateTableContents() {
        this.reallocateIndexes();
        this.fireTableDataChanged();
    }

    public void sort(Object object) {
        this.compares = 0;
        if (this.indexes == null) {
            return;
        }
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        this.setRIndexes(this.indexes);
    }

    private void setRIndexes(int[] nArray) {
        this.rIndexes = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = 0;
            n = 0;
            while (nArray[n] != i) {
                ++n;
            }
            this.rIndexes[i] = n;
        }
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            if (this.indexes.length != this.getRowCount()) {
                Logger.write(Logger.INFO, this, "getValueAt", "Sorter row count: " + this.indexes.length);
                Logger.write(Logger.INFO, this, "getValueAt", "Real row count: " + this.getRowCount());
            }
            return super.getValueAt(this.indexes[n], n2);
        }
        catch (Exception exception) {
            Logger.write(Logger.INFO, this, "getValueAt", exception);
            return "";
        }
    }

    void sortByColumn(int n) {
        this.ascending = !this.ascending;
        this.sortByColumn(n, this.ascending);
    }

    void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public List getSortingColumns() {
        return Collections.unmodifiableList(this.sortingColumns);
    }

    public boolean getSortAscending() {
        return this.ascending;
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (this.mListener == null) {
            this.mListener = new SorterMouseListener(jTable);
        }
        jTableHeader.addMouseListener(this.mListener);
    }

    public int getModelRow(int n) {
        return this.indexes[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            return;
        }
        super.setValueAt(object, this.indexes[n], n2);
    }

    public boolean isSortOnTableChange() {
        return this.sortOnTableChange;
    }

    public void setSortOnTableChange(boolean bl) {
        this.sortOnTableChange = bl;
    }

    class SorterMouseListener
    extends MouseAdapter {
        JTable tableView = null;

        public SorterMouseListener(JTable jTable) {
            this.tableView = jTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            SorterMouseListener sorterMouseListener = this;
            synchronized (sorterMouseListener) {
                TableColumnModel tableColumnModel = this.tableView.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = this.tableView.convertColumnIndexToModel(n);
                int[] nArray = SortedTableModel.this.getUnsortedIndexs(this.tableView.getSelectedRows());
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    SortedTableModel.this.sortByColumn(n2);
                    for (int i = 0; i < nArray.length; ++i) {
                        int n3 = SortedTableModel.this.rIndexes[nArray[i]];
                        this.tableView.setRowSelectionInterval(n3, n3);
                    }
                }
            }
        }
    }
}

