/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.progressbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class CVProgressTimer {
    private int id = 0;
    private int lastId;
    private Map<Integer, Boolean> running = new Hashtable<Integer, Boolean>();
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private long delay;
    private long initialDelay;
    private boolean repeats = true;
    private boolean coalesce = true;
    private boolean useEventDispatchThread = true;
    private String actionCommand = "";
    private Thread exec = null;

    public CVProgressTimer(long l) {
        this(l, null);
    }

    public CVProgressTimer(long l, long l2) {
        this(l, l2, null);
    }

    public CVProgressTimer(long l, ActionListener actionListener) {
        this(l, l, actionListener);
    }

    public CVProgressTimer(long l, long l2, ActionListener actionListener) {
        this.setDelay(l);
        this.setInitialDelay(l2);
        this.addActionListener(actionListener);
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid initial delay: " + l);
        }
        this.initialDelay = l;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid delay: " + l);
        }
        this.delay = l;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public void setRepeats(boolean bl) {
        this.repeats = bl;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public boolean isUseEventDispatchThread() {
        return this.useEventDispatchThread;
    }

    public void setUseEventDispatchThread(boolean bl) {
        this.useEventDispatchThread = bl;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.remove(actionListener);
        }
    }

    public List<ActionListener> getListeners() {
        return this.listeners;
    }

    public boolean isRunning() {
        return this.running.values().contains(true);
    }

    public void start() {
        this.startExec();
    }

    public void stop() {
        this.stopExec();
    }

    public void restart() {
        this.stopExec();
        this.startExec();
    }

    private synchronized void startExec() {
        if (this.isRunning()) {
            return;
        }
        final int n = this.lastId = this.id++;
        this.exec = new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    CVProgressTimer.this.running.put(n, true);
                    try {
                        Thread.sleep(CVProgressTimer.this.initialDelay);
                        if (CVProgressTimer.this.repeats) {
                            while (this.shouldContinue()) {
                                CVProgressTimer.this.fireEvent();
                                if (this.shouldContinue()) {
                                    Thread.sleep(CVProgressTimer.this.delay);
                                    continue;
                                }
                                break block5;
                            }
                            break block5;
                        }
                        CVProgressTimer.this.fireEvent();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                CVProgressTimer.this.running.remove(n);
            }

            private boolean shouldContinue() {
                return (Boolean)CVProgressTimer.this.running.get(n) != false && !Thread.currentThread().isInterrupted();
            }
        });
        this.exec.start();
    }

    private synchronized void stopExec() {
        if (this.exec != null) {
            this.exec.interrupt();
            this.running.put(this.lastId, false);
        }
    }

    private void fireEvent() {
        block6: {
            if (this.listeners.size() <= 0) break block6;
            final ActionEvent actionEvent = new ActionEvent(this, 0, this.actionCommand, System.currentTimeMillis(), 0);
            final ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>();
            arrayList.addAll(this.listeners);
            if (this.useEventDispatchThread) {
                if (this.coalesce) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (ActionListener actionListener : arrayList) {
                                actionListener.actionPerformed(actionEvent);
                            }
                        }
                    });
                } else {
                    for (final ActionListener actionListener : arrayList) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                actionListener.actionPerformed(actionEvent);
                            }
                        });
                    }
                }
            } else {
                for (ActionListener actionListener : arrayList) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        }
    }
}

