/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.progressbar;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class CVProgressBarUtils {
    public static int animationFps = 24;
    public static Color shadeColor = new Color(210, 210, 210);
    public static final Color transparent = new Color(255, 255, 255, 0);
    public static Color disabledTextColor = new Color(160, 160, 160);

    public static Shape intersectClip(Graphics graphics, Shape shape) {
        return CVProgressBarUtils.intersectClip(graphics, shape, true);
    }

    public static Shape intersectClip(Graphics graphics, Shape shape, boolean bl) {
        if (bl && shape != null) {
            Shape shape2 = graphics.getClip();
            Area area = new Area(shape);
            area.intersect(new Area(shape2));
            graphics.setClip(area);
            return shape2;
        }
        return null;
    }

    public static Shape subtractClip(Graphics graphics, Shape shape) {
        return CVProgressBarUtils.subtractClip(graphics, shape, true);
    }

    public static Shape subtractClip(Graphics graphics, Shape shape, boolean bl) {
        if (bl && shape != null) {
            Shape shape2 = graphics.getClip();
            Area area = new Area(shape2);
            area.subtract(new Area(shape));
            graphics.setClip(area);
            return shape2;
        }
        return null;
    }

    public static void restoreClip(Graphics graphics, Shape shape) {
        CVProgressBarUtils.restoreClip(graphics, shape, true);
    }

    public static void restoreClip(Graphics graphics, Shape shape, boolean bl) {
        if (bl && shape != null) {
            graphics.setClip(shape);
        }
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n) {
        CVProgressBarUtils.drawShade(graphics2D, shape, color, n, null, true);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n, Shape shape2) {
        CVProgressBarUtils.drawShade(graphics2D, shape, color, n, shape2, true);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n, boolean bl) {
        CVProgressBarUtils.drawShade(graphics2D, shape, color, n, null, bl);
    }

    public static void drawShade(Graphics2D graphics2D, Shape shape, Color color, int n, Shape shape2, boolean bl) {
        if (n <= 0) {
            return;
        }
        Shape shape3 = CVProgressBarUtils.intersectClip(graphics2D, shape2);
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite) {
            f = ((AlphaComposite)composite).getAlpha();
        }
        Stroke stroke = graphics2D.getStroke();
        for (int i = n *= 2; i >= 2; i -= 2) {
            float f2 = (float)(n - i) / (float)(n - 1);
            graphics2D.setColor(color);
            graphics2D.setComposite(AlphaComposite.getInstance(3, f2 * f));
            graphics2D.setStroke(new BasicStroke(i, bl ? 1 : 0, 1));
            graphics2D.draw(shape);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setComposite(composite);
        CVProgressBarUtils.restoreClip(graphics2D, shape3);
    }

    public static Shape getWebBorderShape(JComponent jComponent, int n, int n2) {
        if (n2 > 0) {
            return new RoundRectangle2D.Double(n, n, jComponent.getWidth() - n * 2 - 1, jComponent.getHeight() - n * 2 - 1, n2 * 2, n2 * 2);
        }
        return new Rectangle2D.Double(n, n, jComponent.getWidth() - n * 2 - 1, jComponent.getHeight() - n * 2 - 1);
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

